/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;

public class PersistenceExceptionTranslationInterceptor
implements MethodInterceptor,
InitializingBean {
    private PersistenceExceptionTranslator persistenceExceptionTranslator;

    public PersistenceExceptionTranslationInterceptor() {
    }

    public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.setPersistenceExceptionTranslator(persistenceExceptionTranslator);
    }

    public final void setPersistenceExceptionTranslator(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        Assert.notNull(persistenceExceptionTranslator, "PersistenceExceptionTranslator must not be null");
        this.persistenceExceptionTranslator = persistenceExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("persistenceExceptionTranslator is required");
        }
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (RuntimeException ex) {
            Class<?>[] declaredExceptions = mi.getMethod().getExceptionTypes();
            for (int i = 0; i < declaredExceptions.length; ++i) {
                if (!declaredExceptions[i].isInstance(ex)) continue;
                throw ex;
            }
            throw DataAccessUtils.translateIfNecessary(ex, this.persistenceExceptionTranslator);
        }
    }
}

