/*
 * Decompiled with CFR 0.152.
 */
package omero.importer.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import layout.TableLayout;
import ome.formats.importer.Main;

public class GuiCommonElements {
    public boolean lafOpaque = true;
    public boolean offsetButtons = false;
    public boolean motif = false;

    public GuiCommonElements() {
        String laf = UIManager.getLookAndFeel().getClass().getName();
        if (laf.equals("apple.laf.AquaLookAndFeel") || laf.equals("ch.randelshofer.quaqua.QuaquaLookAndFeel")) {
            this.lafOpaque = false;
            this.offsetButtons = true;
        }
        if (laf.equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            this.motif = true;
        }
    }

    public JPanel addMainPanel(Container container, double[][] tableSize, int margin_top, int margin_left, int margin_bottom, int margin_right, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder(margin_top, margin_left, margin_bottom, margin_right));
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public JPanel addBorderedPanel(Container container, double[][] tableSize, String name, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createTitledBorder(name));
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public JPanel addPlanePanel(Container container, double[][] tableSize, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        TableLayout layout = new TableLayout(tableSize);
        panel.setLayout((LayoutManager)layout);
        panel.setBorder(BorderFactory.createEmptyBorder());
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        return panel;
    }

    public WholeNumberField addWholeNumberField(Container container, String prefexStr, String initialValue, String suffexStr, int mnemonic, String tooltip, int maxChars, int fieldWidth, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] table = new double[][]{{-2.0, fieldWidth, 5.0, -2.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])table);
        panel.setLayout((LayoutManager)layout);
        JLabel prefex = new JLabel(prefexStr);
        prefex.setDisplayedMnemonic(mnemonic);
        panel.add((Component)prefex, "0,0");
        WholeNumberField result = new WholeNumberField(0, maxChars);
        result.setHorizontalAlignment(0);
        prefex.setLabelFor(result);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)result, "1,0");
        JLabel suffex = new JLabel(suffexStr);
        panel.add((Component)suffex, "3,0");
        container.add((Component)panel, placement);
        return result;
    }

    public JTextPane addTextPane(Container container, String text, String placement, boolean debug) {
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException e) {
            System.err.println("BadLocationException inserting text to document.");
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        container.add((Component)textPane, placement);
        if (debug) {
            textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), textPane.getBorder()));
        }
        return textPane;
    }

    public JTextPane addTextPane(Container container, String text, String placement, StyleContext context, Style style, boolean debug) {
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        try {
            document.insertString(document.getLength(), text, style);
        }
        catch (BadLocationException e) {
            System.err.println("BadLocationException inserting text to document.");
        }
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setFocusable(false);
        container.add((Component)textPane, placement);
        if (debug) {
            textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), textPane.getBorder()));
        }
        return textPane;
    }

    public JTextField addTextField(Container container, String name, String initialValue, int mnemonic, String tooltip, String suffix, double labelWidth, String placement, boolean debug) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = suffix == "" ? (Object)new double[][]{{labelWidth, -1.0}, {30.0}} : (Object)new double[][]{{labelWidth, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(name);
        label.setDisplayedMnemonic(mnemonic);
        JTextField result = new JTextField(20);
        label.setLabelFor(result);
        label.setOpaque(false);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)result, "1, 0, f, c");
        if (suffix.length() != 0) {
            JLabel suffixLabel = new JLabel(" " + suffix);
            panel.add((Component)suffixLabel, "2,0, l, c");
        }
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        container.add((Component)panel, placement);
        return result;
    }

    public JPasswordField addPasswordField(Container container, String name, String initialValue, int mnemonic, String tooltip, String suffix, double labelWidth, String placement, boolean debug) {
        Object size = null;
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        size = suffix == "" ? (Object)new double[][]{{labelWidth, -1.0}, {30.0}} : (Object)new double[][]{{labelWidth, -1.0, -2.0}, {30.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel label = new JLabel(name);
        label.setDisplayedMnemonic(mnemonic);
        JPasswordField result = new JPasswordField(20);
        label.setLabelFor(result);
        label.setOpaque(false);
        result.setToolTipText(tooltip);
        if (initialValue != null) {
            result.setText(initialValue);
        }
        panel.add((Component)label, "0, 0, r, c");
        panel.add((Component)result, "1, 0, f, c");
        if (suffix.length() != 0) {
            JLabel suffixLabel = new JLabel(" " + suffix);
            panel.add((Component)suffixLabel, "2,0, l, c");
        }
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        container.add((Component)panel, placement);
        return result;
    }

    public JTextArea addTextArea(Container container, String name, String text, int mnemonic, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JTextArea textArea = new JTextArea();
        textArea.setLineWrap(true);
        textArea.setOpaque(true);
        JScrollPane areaScrollPane = new JScrollPane(textArea);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        if (name != "") {
            JLabel label = new JLabel(name);
            label.setOpaque(false);
            label.setDisplayedMnemonic(mnemonic);
            panel.add((Component)label, "0, 0, l, c");
            panel.add((Component)areaScrollPane, "0, 1, f, f");
        } else {
            panel.add((Component)areaScrollPane, "0, 0, 0, 1");
        }
        container.add((Component)panel, placement);
        return textArea;
    }

    public JTextPane addTextPane(Container container, String name, String text, int mnemonic, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{-1.0}, {20.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        StyleContext context = new StyleContext();
        DefaultStyledDocument document = new DefaultStyledDocument(context);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        ArrayList<TabStop> list = new ArrayList<TabStop>();
        float pos = 15.0f;
        int align = 0;
        int leader = 0;
        TabStop tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 1;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 2;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        pos = 15.0f;
        align = 4;
        leader = 0;
        tstop = new TabStop(pos, align, leader);
        list.add(tstop);
        TabStop[] tstops = list.toArray(new TabStop[0]);
        TabSet tabs = new TabSet(tstops);
        Style style = textPane.getLogicalStyle();
        StyleConstants.setTabSet(style, tabs);
        textPane.setLogicalStyle(style);
        JScrollPane areaScrollPane = new JScrollPane(textPane);
        areaScrollPane.setVerticalScrollBarPolicy(20);
        if (debug) {
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), panel.getBorder()));
        }
        if (name != "") {
            JLabel label = new JLabel(name);
            label.setDisplayedMnemonic(mnemonic);
            panel.add((Component)label, "0, 0, l, c");
            panel.add((Component)areaScrollPane, "0, 1, f, f");
        } else {
            panel.add((Component)areaScrollPane, "0, 0, 0, 1");
        }
        container.add((Component)panel, placement);
        return textPane;
    }

    public void appendTextToDocument(StyledDocument doc, Style style, String text) {
        try {
            doc.insertString(doc.getLength(), text, style);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public JButton addButton(Container container, String label, int mnemonic, String tooltip, String placement, boolean debug) {
        JButton button = new JButton(label);
        button.setMnemonic(mnemonic);
        button.setOpaque(this.lafOpaque);
        container.add((Component)button, placement);
        if (debug) {
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), button.getBorder()));
        }
        return button;
    }

    public JButton addIconButton(Container container, String label, String image, Integer width, Integer height, Integer mnemonic, String tooltip, String placement, boolean debug) {
        JButton button = null;
        if (image == null) {
            button = new JButton(label);
        } else {
            URL imgURL = Main.class.getResource(image);
            if (imgURL != null) {
                button = new JButton(null, new ImageIcon(imgURL));
            } else {
                button = new JButton(label);
                System.err.println("Couldn't find icon: " + image);
            }
        }
        button.setMaximumSize(new Dimension(height, width));
        button.setPreferredSize(new Dimension(height, width));
        button.setMinimumSize(new Dimension(height, width));
        button.setSize(new Dimension(height, width));
        if (mnemonic != null) {
            button.setMnemonic(mnemonic);
        }
        button.setOpaque(this.lafOpaque);
        container.add((Component)button, placement);
        if (this.motif) {
            Border b = BorderFactory.createLineBorder(Color.gray);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setBorder(b);
        }
        if (debug) {
            button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), button.getBorder()));
        }
        return button;
    }

    public JComboBox addComboBox(Container container, String label, Object[] initialValues, int mnemonic, String tooltip, double labelWidth, String placement, boolean debug) {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        double[][] size = new double[][]{{labelWidth, -1.0}, {-2.0}};
        TableLayout layout = new TableLayout((double[][])size);
        panel.setLayout((LayoutManager)layout);
        JLabel labelTxt = new JLabel(label);
        labelTxt.setDisplayedMnemonic(mnemonic);
        panel.add((Component)labelTxt, "0,0,l,c");
        JComboBox<Object> result = null;
        result = initialValues != null ? new JComboBox<Object>(initialValues) : new JComboBox();
        labelTxt.setLabelFor(result);
        result.setToolTipText(tooltip);
        panel.add(result, "1,0,f,c");
        container.add((Component)panel, placement);
        return result;
    }

    public JRadioButton addRadioButton(Container container, String label, int mnemonic, String tooltip, String placement, boolean debug) {
        JRadioButton button = new JRadioButton(label);
        container.add((Component)button, placement);
        return button;
    }

    public JCheckBox addCheckBox(Container container, String string, String placement, boolean debug) {
        JCheckBox checkBox = new JCheckBox(string);
        container.add((Component)checkBox, placement);
        return checkBox;
    }

    public void enterPressesWhenFocused(JButton button) {
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        button.registerKeyboardAction(button.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public ImageIcon getImageIcon(String path) {
        URL imgURL = Main.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find icon: " + imgURL);
        return null;
    }

    public class WholeNumberField
    extends JTextField {
        private Toolkit toolkit;
        private NumberFormat integerFormatter;

        public WholeNumberField(int value, int columns) {
            super(columns);
            this.toolkit = Toolkit.getDefaultToolkit();
            this.integerFormatter = NumberFormat.getNumberInstance(Locale.US);
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(value);
        }

        public int getValue() {
            int retVal = 0;
            try {
                retVal = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException e) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                int i = 0;
                while (i < result.length) {
                    if (Character.isDigit(source[i])) {
                        result[j++] = source[i];
                    } else {
                        WholeNumberField.this.toolkit.beep();
                    }
                    ++i;
                }
                super.insertString(offs, new String(result, 0, j), a);
            }
        }
    }
}

