/*
 * Decompiled with CFR 0.152.
 */
package omero.importer.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.importer.Main;
import omero.importer.gui.FileQModel_JTable;
import omero.importer.gui.FileQView_JTableCellCenter;
import omero.importer.gui.FileQView_JTableHeader;
import omero.importer.gui.FileQView_JTableLeftDot;
import omero.importer.gui.FileQView_JTableSelectionListener;
import omero.importer.thirdparty.ETable;

public class FileQView_JTable
extends JPanel
implements ActionListener {
    public FileQModel_JTable model = null;
    public ETable view = new ETable();
    private static final long serialVersionUID = -4239932269937114120L;
    JButton refreshBtn;
    JButton addBtn;
    JButton removeBtn;
    JButton importBtn;
    JButton clearDoneBtn;
    JButton clearFailedBtn;
    public boolean cancel = false;
    public boolean importing = false;

    public FileQView_JTable(FileQModel_JTable model) {
        this.model = model;
        this.view.setModel(model);
        Boolean debugBorders = false;
        int buttonSize = 40;
        String addIcon = "gfx/add.png";
        String removeIcon = "gfx/remove.png";
        int statusWidth = 100;
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(6, 5, 9, 8));
        JPanel buttonPanel = new JPanel();
        if (debugBorders.booleanValue()) {
            buttonPanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        this.addBtn = FileQView_JTable.addButton(">>", addIcon, null);
        this.addBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setActionCommand("add");
        this.addBtn.addActionListener(this);
        this.removeBtn = FileQView_JTable.addButton("<<", removeIcon, null);
        this.removeBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setActionCommand("remove");
        this.removeBtn.addActionListener(this);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(this.addBtn);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.removeBtn);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        this.add(buttonPanel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel queuePanel = new JPanel();
        if (debugBorders.booleanValue()) {
            queuePanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        queuePanel.setLayout(new BoxLayout(queuePanel, 3));
        queuePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        JLabel label = new JLabel("Import Queue:");
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        queuePanel.add(labelPanel);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        TableColumnModel cModel = this.view.getColumnModel();
        FileQView_JTableHeader tableHeader = new FileQView_JTableHeader();
        cModel.getColumn(0).setHeaderRenderer(tableHeader);
        cModel.getColumn(1).setHeaderRenderer(tableHeader);
        cModel.getColumn(2).setHeaderRenderer(tableHeader);
        cModel.getColumn(0).setCellRenderer(new FileQView_JTableLeftDot(this.view));
        cModel.getColumn(1).setCellRenderer(new FileQView_JTableCellCenter(this.view));
        cModel.getColumn(2).setCellRenderer(new FileQView_JTableCellCenter(this.view));
        TableColumn statusColumn = this.view.getColumnModel().getColumn(2);
        statusColumn.setPreferredWidth(statusWidth);
        statusColumn.setMaxWidth(statusWidth);
        statusColumn.setMinWidth(statusWidth);
        FileQView_JTableSelectionListener listener = new FileQView_JTableSelectionListener(this.view);
        this.view.getSelectionModel().addListSelectionListener(listener);
        TableColumnModel tcm = this.view.getColumnModel();
        int remove = 7;
        while (remove >= 3) {
            TableColumn removeColumn = tcm.getColumn(remove);
            tcm.removeColumn(removeColumn);
            --remove;
        }
        JScrollPane scrollPane = new JScrollPane(this.view);
        queuePanel.add(scrollPane);
        JPanel importPanel = new JPanel();
        importPanel.setLayout(new BoxLayout(importPanel, 2));
        this.clearDoneBtn = FileQView_JTable.addButton("Clear Done", null, null);
        this.clearFailedBtn = FileQView_JTable.addButton("Clear Failed", null, null);
        this.importBtn = FileQView_JTable.addButton("Import", null, null);
        importPanel.add(Box.createHorizontalGlue());
        importPanel.add(this.clearDoneBtn);
        this.clearDoneBtn.setEnabled(false);
        this.clearDoneBtn.setActionCommand("clear_done");
        this.clearDoneBtn.addActionListener(this);
        importPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        importPanel.add(this.clearFailedBtn);
        this.clearFailedBtn.setEnabled(false);
        this.clearFailedBtn.setActionCommand("clear_failed");
        this.clearFailedBtn.addActionListener(this);
        importPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        importPanel.add(this.importBtn);
        this.importBtn.setEnabled(false);
        this.importBtn.setActionCommand("import");
        this.importBtn.addActionListener(this);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        queuePanel.add(importPanel);
        this.add(queuePanel);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addBtn) {
            this.firePropertyChange("add", false, true);
        }
        if (src == this.removeBtn) {
            this.firePropertyChange("remove", false, true);
        }
        if (src == this.clearDoneBtn) {
            this.firePropertyChange("clear_done", false, true);
        }
        if (src == this.clearDoneBtn) {
            this.firePropertyChange("clear_failed", false, true);
        }
        if (src == this.importBtn) {
            this.view.clearSelection();
            this.firePropertyChange("import", false, true);
        }
    }

    static JButton addButton(String name, String image, String tooltip) {
        JButton button = null;
        if (image == null) {
            button = new JButton(name);
        } else {
            URL imgURL = Main.class.getResource(image);
            if (imgURL != null) {
                button = new JButton(null, new ImageIcon(imgURL));
            } else {
                button = new JButton(name);
                System.err.println("Couldn't find icon: " + image);
            }
        }
        return button;
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        FileQModel_JTable model = new FileQModel_JTable();
        FileQView_JTable q = new FileQView_JTable(model);
        JFrame f = new JFrame();
        f.getContentPane().add(q);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }
}

