/*
 * Decompiled with CFR 0.152.
 */
package omero.importer.engine;

import java.io.File;
import java.util.Vector;
import ome.model.containers.Dataset;
import ome.model.containers.Project;

public class FileQRow
extends Vector {
    private static final long serialVersionUID = 1L;
    File filePath;
    String omeroName;
    Project project;
    Dataset dataset;
    Status status;
    Boolean archived;

    public FileQRow(File filePath, String omeroName, Project project, Dataset dataset, Status status, Boolean archived) {
        if (filePath == null) {
            throw new NullPointerException("filePath cannot be null");
        }
        if (omeroName == null) {
            throw new NullPointerException("omeroName cannot be null");
        }
        if (project == null) {
            throw new NullPointerException("project cannot be null");
        }
        if (dataset == null) {
            throw new NullPointerException("dataset cannot be null");
        }
        if (status == null) {
            throw new NullPointerException("status cannot be null");
        }
        if (archived == null) {
            throw new NullPointerException("archived cannot be null");
        }
        this.filePath = filePath;
        this.omeroName = omeroName;
        this.project = project;
        this.dataset = dataset;
        this.status = status;
        this.archived = archived;
        String statusStr = this.getStatusString(status);
        String pdDisplayName = this.getPDdisplayName(project, dataset);
        this.add(omeroName);
        this.add(pdDisplayName);
        this.add(statusStr);
        this.add(filePath);
        this.add(project);
        this.add(dataset);
        this.add(archived);
        this.add(status);
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getOmeroName() {
        return this.omeroName;
    }

    public Project getProject() {
        return this.project;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Status getStatus() {
        return this.status;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public String getStatusString(Status status) {
        String statusStr = null;
        switch (status) {
            case ADDED: {
                statusStr = "Added";
                break;
            }
            case PENDING: {
                statusStr = "Pending";
                break;
            }
            case ACTIVE: {
                statusStr = "Added";
                break;
            }
            case FAILED: {
                statusStr = "Failed";
                break;
            }
            case DONE: {
                statusStr = "Done";
                break;
            }
            default: {
                statusStr = "Unknown";
            }
        }
        return statusStr;
    }

    public String getPDdisplayName(Project project, Dataset dataset) {
        String pdDisplayName = null;
        if (project != null && dataset != null) {
            pdDisplayName = String.valueOf(project.getName()) + "/" + dataset.getName();
        }
        return pdDisplayName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ADDED,
        PENDING,
        ACTIVE,
        FAILED,
        DONE;

    }
}

