/*
 * Decompiled with CFR 0.152.
 */
package omero.importer.engine;

import java.util.ArrayList;
import omero.importer.engine.FileQRow;
import omero.importer.engine.IObservable;
import omero.importer.engine.IObserver;

public class FileQModel
implements IObservable {
    private static final long serialVersionUID = -6300693803659305281L;
    boolean changed = false;
    ArrayList<IObserver> observers = new ArrayList();
    ArrayList fileQArrayList = null;

    public FileQModel(ArrayList fileQ) {
        this.fileQArrayList = fileQ;
    }

    public void addRow(FileQRow row) {
        this.fileQArrayList.add(row);
        this.notifyObservers("Row added, table size: " + this.getSize());
    }

    public void deleteRow(int index) {
        this.fileQArrayList.remove(index);
        this.notifyObservers("Row deleted, table size: " + this.getSize());
    }

    public FileQRow getRow(int index) {
        FileQRow fileQRow = (FileQRow)this.fileQArrayList.get(index);
        this.notifyObservers("Row '" + fileQRow.omeroName + "' retrieved.");
        return fileQRow;
    }

    public Integer getSize() {
        return this.fileQArrayList.size();
    }

    public boolean addObserver(IObserver object) {
        return this.observers.add(object);
    }

    public boolean deleteObserver(IObserver object) {
        return this.observers.remove(object);
    }

    public void notifyObservers(Object message) {
        for (IObserver observer : this.observers) {
            observer.update(this, message);
        }
    }
}

