/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.formats.FormatTools;

public class Plane2D {
    private ByteBuffer data;
    private int bytesPerPixel;
    private int type;
    private int sizeX;
    private int sizeY;

    Plane2D(ByteBuffer data, int type, boolean isLittleEndian, int sizeX, int sizeY) {
        this.type = type;
        this.data = data;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.data.order(isLittleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        this.bytesPerPixel = FormatTools.getBytesPerPixel(type);
    }

    public double getPixelValue(int x, int y) {
        int offset = (this.sizeX * y + x) * this.bytesPerPixel;
        switch (this.type) {
            case 0: {
                return this.data.get(offset);
            }
            case 2: {
                return this.data.getShort(offset);
            }
            case 4: {
                return this.data.getInt(offset);
            }
            case 6: {
                return this.data.getFloat(offset);
            }
            case 7: {
                return this.data.getDouble(offset);
            }
            case 1: {
                return (short)(this.data.get(offset) & 0xFF);
            }
            case 3: {
                return this.data.getShort(offset) & 0xFFFF;
            }
            case 5: {
                return (long)this.data.getInt(offset) & 0xFFFFFFFFL;
            }
        }
        throw new RuntimeException("Woah nelly! Something is very wrong.");
    }

    public ByteBuffer getData() {
        return this.data;
    }
}

