/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.test;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import ome.formats.test.Plane2D;
import ome.model.core.Pixels;

public class Main {
    private String filename = "/workspace/Test Images/Leicas (.lei)/050627-leica/050628-leica.lei";
    private ImageReader iReader;
    private ChannelSeparator separator;
    private MinMaxCalculator reader;
    private Pixels pixels;
    private int sizeC;
    private int sizeT;
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private int zSize;
    private int tSize;
    private int wSize;

    private Main() throws Exception {
        try {
            this.iReader = new ImageReader(new ClassList("readers.txt", IFormatReader.class));
            this.separator = new ChannelSeparator(this.iReader);
            this.reader = new MinMaxCalculator(this.separator);
            this.reader.close();
            this.reader.setId(this.filename);
            System.err.println("Series count: " + this.reader.getSeriesCount() + "\n");
            int i = 1;
            try {
                int bytesPerPixel = this.getBytesPerPixel(this.reader.getPixelType());
                byte[] arrayBuf = new byte[this.sizeX * this.sizeY * bytesPerPixel];
                int t = 0;
                while (t < this.sizeT) {
                    int c = 0;
                    while (c < this.sizeC) {
                        int z = 0;
                        while (z < this.sizeZ) {
                            int planeNumber = this.getTotalOffset(z, c, t);
                            ByteBuffer buf = this.openPlane2D(this.filename, planeNumber, arrayBuf).getData();
                            arrayBuf = this.swapIfRequired(buf, this.filename);
                            ++i;
                            ++z;
                        }
                        ++c;
                    }
                    ++t;
                }
                Double[] preGlobalMin = null;
                Double[] preGlobalMax = null;
                Double[] preKnownMin = null;
                Double[] preKnownMax = null;
                preGlobalMin = new Double[this.sizeC];
                preGlobalMax = new Double[this.sizeC];
                preKnownMin = new Double[this.sizeC];
                preKnownMax = new Double[this.sizeC];
                int c = 0;
                while (c < this.sizeC) {
                    preGlobalMin[c] = this.reader.getChannelGlobalMinimum(c);
                    preGlobalMax[c] = this.reader.getChannelGlobalMaximum(c);
                    System.err.println("preGlobalMin: " + preGlobalMin[c]);
                    System.err.println("preGlobalMax: " + preGlobalMax[c]);
                    preKnownMin[c] = this.reader.getChannelKnownMinimum(c);
                    preKnownMax[c] = this.reader.getChannelKnownMaximum(c);
                    System.err.println("preKnownMin: " + preKnownMin[c]);
                    System.err.println("preKnownMax: " + preKnownMax[c]);
                    ++c;
                }
            }
            catch (FormatException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception();
        }
    }

    private Plane2D openPlane2D(String id, int no, byte[] buf) throws FormatException, IOException {
        ByteBuffer plane = this.separator.getReader().isRGB() ? ByteBuffer.wrap(this.reader.openBytes(no)) : ByteBuffer.wrap(this.reader.openBytes(no, buf));
        return new Plane2D(plane, this.reader.getPixelType(), this.reader.isLittleEndian(), this.reader.getSizeX(), this.reader.getSizeY());
    }

    private int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private byte[] swapIfRequired(ByteBuffer buffer, String fileName) throws FormatException, IOException {
        int pixelType = this.reader.getPixelType();
        int bytesPerPixel = this.getBytesPerPixel(pixelType);
        if (pixelType == 6 || pixelType == 7 || bytesPerPixel == 1) {
            return buffer.array();
        }
        if (this.reader.isLittleEndian()) {
            if (bytesPerPixel == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int i = 0;
                while (i < buffer.capacity() / 2) {
                    buf.put(i, DataTools.swap(buf.get(i)));
                    ++i;
                }
            } else if (bytesPerPixel == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int i = 0;
                while (i < buffer.capacity() / 4) {
                    buf.put(i, DataTools.swap(buf.get(i)));
                    ++i;
                }
            } else {
                throw new FormatException("Unsupported sample bit width: '" + bytesPerPixel + "'");
            }
        }
        return buffer.array();
    }

    public static void main(String[] args) throws Exception {
        new Main();
    }
}

