/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.io.InputStreamReader;
import java.util.Map;
import ome.formats.importer.util.HtmlMessengerException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMessenger {
    HttpClient client = null;
    PostMethod method = null;

    public HtmlMessenger(String url, Map<String, String> postHashMap) throws HtmlMessengerException {
        try {
            this.client = new HttpClient();
            this.method = new PostMethod(url);
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Error creating client/method", e);
        }
        try {
            for (String key : postHashMap.keySet()) {
                String value = postHashMap.get(key);
                this.method.addParameter(key, value);
            }
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Error creating post parameters", e);
        }
    }

    public String executePost() throws HtmlMessengerException {
        String serverReply = "";
        try {
            int statusCode = this.client.executeMethod((HttpMethod)this.method);
            if (statusCode != -1) {
                int n;
                InputStreamReader reader = new InputStreamReader(this.method.getResponseBodyAsStream(), this.method.getRequestCharSet());
                char[] buf = new char[32678];
                StringBuilder str = new StringBuilder();
                while ((n = reader.read(buf)) != -1) {
                    str.append(buf, 0, n);
                }
                this.method.releaseConnection();
                serverReply = str.toString();
            }
            return serverReply;
        }
        catch (Exception e) {
            throw new HtmlMessengerException("Cannot Connect", e);
        }
    }
}

