/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import layout.TableLayout;
import layout.TableLayoutConstraints;

public final class Grid
extends Component {
    private static final long serialVersionUID = 1L;
    private static Color gridColor = Color.BLACK;
    private static Color fillColor = null;

    public static void main(String[] args) {
        Grid.setFillColor(Color.BLUE);
        String className = "ome.formats.importer.DebugMessenger";
        if (args.length == 1) {
            className = args[0];
        }
        try {
            Class<?> cls = Class.forName(className);
            Class[] parameterType = new Class[]{args.getClass()};
            Object[] parameter = new Object[]{new String[0]};
            Method method = cls.getMethod("main", parameterType);
            method.invoke(null, parameter);
            Frame[] frame = Frame.getFrames();
            if (frame.length == 1) {
                if (frame[0] instanceof JFrame) {
                    Grid.showGrid(((JFrame)frame[0]).getContentPane());
                } else {
                    Grid.showGrid(frame[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showGrid(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Parameter container cannot be null");
        }
        LayoutManager l = container.getLayout();
        if (!(l instanceof TableLayout)) {
            throw new IllegalArgumentException("Container is not using TableLayout");
        }
        TableLayout layout = (TableLayout)l;
        Grid.showGrid(container, layout);
        container.invalidate();
        container.validate();
        container.repaint();
    }

    private static void showGrid(Container container, TableLayout layout) {
        int numRow = layout.getNumRow();
        int numCol = layout.getNumColumn();
        int y = 0;
        while (y < numRow) {
            int x = 0;
            while (x < numCol) {
                Grid g = new Grid();
                container.add(g, new TableLayoutConstraints(x, y, x, y, 2, 2), 0);
                ++x;
            }
            ++y;
        }
    }

    public static Color getGridColor() {
        return gridColor;
    }

    public static void setGridColor(Color color) {
        gridColor = color;
    }

    public static Color getFillColor() {
        return fillColor;
    }

    public static void setFillColor(Color color) {
        fillColor = color;
    }

    private Grid() {
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (gridColor != null) {
            g.setColor(gridColor);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
        if (fillColor != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setComposite(AlphaComposite.getInstance(3, 0.25f));
            g2d.setPaint(fillColor);
            g2d.fill(new Rectangle(1, 1, d.width - 1, d.height - 1));
        }
    }
}

