/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import ome.formats.importer.Main;

public class StatusBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JLabel status;

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.status = new JLabel();
        this.status.setFont(this.getFont().deriveFont(11.0f));
    }

    private void buildUI() {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 15));
        this.setPreferredSize(new Dimension(10, 28));
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, -2, -2, -2), compoundBorder));
        this.add(this.status);
        this.add(this.buildComponentPanelRight(this.progressBar));
    }

    public StatusBar() {
        this.initComponents();
        this.buildUI();
    }

    public void setStatus(String s) {
        this.status.setText(s);
    }

    public void setProgress(boolean visible, int perc, String string) {
        this.progressBar.setVisible(visible);
        this.progressBar.setFont(this.getFont().deriveFont(11.0f));
        this.progressBar.setPreferredSize(new Dimension(220, 20));
        if (perc < 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(perc);
        }
        if (string.length() > 0) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("   " + string + "   ");
        }
    }

    public void setProgressMaximum(int max) {
        this.progressBar.setMaximum(max);
    }

    public void setProgressValue(int val) {
        this.progressBar.setValue(val);
    }

    public JPanel buildComponentPanelRight(JComponent component) {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        p.add(component);
        return p;
    }

    protected void setStatusIcon(String path, String description) {
        if (path != null) {
            URL imgURL = Main.class.getResource(path);
            if (imgURL != null) {
                this.status.setIcon(new ImageIcon(imgURL, description));
            } else {
                System.err.println("Couldn't find icon: " + path);
            }
        } else {
            this.status.setIcon(null);
        }
        this.status.setText(description);
    }
}

