/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JFrame;
import ome.formats.importer.DebugMessenger;
import ome.formats.importer.util.GuiCommonElements;

public class SplashWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static SplashWindow instance;
    private Image image;
    private boolean paintCalled = false;
    private GuiCommonElements gui = new GuiCommonElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SplashWindow(Frame parent, Image image, boolean clickable) {
        this.image = image;
        this.setResizable(false);
        this.setUndecorated(true);
        this.setTitle("OMERO.importer");
        this.setIconImage(this.gui.getImageIcon("gfx/icon.png").getImage());
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (mt.isErrorID(0)) {
            this.setSize(0, 0);
            System.err.println("Warning: SplashWindow couldn't load splash image.");
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.paintCalled = true;
                this.notifyAll();
            }
            return;
        }
        int imgWidth = image.getWidth(this);
        int imgHeight = image.getHeight(this);
        this.setSize(imgWidth, imgHeight);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenDim.width - imgWidth) / 2, (screenDim.height - imgHeight) / 2);
        if (clickable) {
            MouseAdapter disposeOnClick = new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseClicked(MouseEvent evt) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        SplashWindow.this.paintCalled = true;
                        this.notifyAll();
                    }
                    SplashWindow.this.dispose();
                }
            };
            this.addMouseListener(disposeOnClick);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SplashWindow splash(Image image) {
        if (instance != null) return instance;
        if (image == null) return instance;
        JFrame f = new JFrame();
        instance = new SplashWindow(f, image, false);
        instance.setVisible(true);
        if (EventQueue.isDispatchThread()) return instance;
        if (Runtime.getRuntime().availableProcessors() != 1) return instance;
        SplashWindow splashWindow = instance;
        synchronized (splashWindow) {
            while (true) {
                if (SplashWindow.instance.paintCalled) {
                    return instance;
                }
                try {
                    instance.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static SplashWindow splash(URL imageURL) {
        if (imageURL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
        }
        return instance;
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.setVisible(false);
            instance.dispose();
            instance = null;
        }
    }

    public static void invokeMain(String className, String[] args) {
        try {
            Class.forName(className).getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            new DebugMessenger(null, "Error Dialog", (Boolean)true, e);
        }
    }
}

