/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import loci.formats.ChannelSeparator;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.in.LeicaReader;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.Plane2D;
import ome.model.core.Channel;
import ome.model.core.Pixels;

public class OMEROWrapper
extends MinMaxCalculator {
    private ChannelSeparator separator;
    public Boolean minMaxSet = null;
    private ImageReader iReader;

    public OMEROWrapper() {
        try {
            this.iReader = new ImageReader(new ClassList("readers.txt", IFormatReader.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load readers.txt.");
        }
        this.separator = new ChannelSeparator(this.iReader);
        this.reader = this.separator;
    }

    public Plane2D openPlane2D(String id, int planeNumber, byte[] buf) throws FormatException, IOException {
        ByteBuffer plane;
        if (this.separator.getReader().isRGB() || this.isLeicaReader()) {
            byte[] bytePlane = this.openBytes(planeNumber);
            plane = ByteBuffer.wrap(bytePlane);
        } else {
            plane = ByteBuffer.wrap(this.openBytes(planeNumber, buf));
        }
        return new Plane2D(plane, this.getPixelType(), this.isLittleEndian(), this.getSizeX(), this.getSizeY());
    }

    public boolean isLeicaReader() {
        return this.iReader.getReader() instanceof LeicaReader;
    }

    public String getImageName(int series) {
        if (this.reader.getSeriesCount() > 1) {
            List p = (List)this.iReader.getMetadataStoreRoot();
            String name = ((Pixels)p.get(series)).getImage().getName();
            return name == null ? "" + series : name;
        }
        return null;
    }

    public void setChannelGlobalMinMax(String id) throws FormatException, IOException {
        int c = 0;
        while (c < this.getSizeC()) {
            double gMin = Double.MIN_VALUE;
            double gMax = Double.MAX_VALUE;
            double cMin = this.getChannelGlobalMinimum(c);
            double cMax = this.getChannelGlobalMaximum(c);
            gMin = cMin;
            gMax = cMax;
            this.getMetadataStore().setChannelGlobalMinMax(c, gMin, gMax, new Integer(this.getSeries()));
            ++c;
        }
    }

    public void finalizeMetadataStore(String id) throws FormatException, IOException {
        if (this.getChannelGlobalMinimum(this.getSizeC() - 1) == null || this.getChannelGlobalMaximum(this.getSizeC() - 1) == null) {
            this.setChannelGlobalMinMax(id);
        }
    }

    public boolean isMinMaxSet() throws FormatException, IOException {
        if (this.minMaxSet == null) {
            int series;
            OMEROMetadataStore store = (OMEROMetadataStore)this.separator.getMetadataStore();
            ArrayList p = (ArrayList)store.getRoot();
            List channels = ((Pixels)p.get(series = this.reader.getSeries())).getChannels();
            this.minMaxSet = ((Channel)channels.get(this.getSizeC() - 1)).getStatsInfo() == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        return this.minMaxSet;
    }

    protected void updateMinMax(BufferedImage b, int ndx) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(b, ndx);
        }
    }

    protected void updateMinMax(byte[] b, int ndx) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            super.updateMinMax(b, ndx);
        }
    }

    public void populateMinMax(Long id, Integer i) throws FormatException, IOException {
        if (!this.isMinMaxSet()) {
            OMEROMetadataStore store = (OMEROMetadataStore)this.separator.getMetadataStore();
            store.populateMinMax(id, i);
        }
    }

    public void close() throws IOException {
        this.minMaxSet = null;
        super.close();
    }
}

