/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import ome.formats.importer.About;
import ome.formats.importer.CommentMessenger;
import ome.formats.importer.FileQueueHandler;
import ome.formats.importer.LogAppender;
import ome.formats.importer.LoginHandler;
import ome.formats.importer.Splasher;
import ome.formats.importer.StatusBar;
import ome.formats.importer.util.GuiCommonElements;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1228000122345370913L;
    public static String versionText = "Beta 2.1";
    public static String releaseDate = "2007-08-08 10:18:13 +0100 (Wed, 08 Aug 2007)";
    public static String revision = "$LastChangedRevision: 1737 $";
    public static String revisionDate = "$LastChangedDate: 2007-08-08 10:18:13 +0100 (Wed, 08 Aug 2007) $";
    private static Log log = LogFactory.getLog(Main.class);
    public static Point splashLocation = Splasher.location;
    public static final String TITLE = "OMERO.importer";
    public static final String splash = "gfx/importer_splash.png";
    private static final boolean useSplashScreenAbout = false;
    private static final int width = 980;
    private static final int height = 580;
    public static final String ICON = "gfx/icon.png";
    public LoginHandler loginHandler;
    public StatusBar statusBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem login;
    public Boolean loggedIn;
    private JTextPane outputTextPane;
    private JTextPane debugTextPane;
    private String username;
    private String password;
    private String server;
    private String port;

    public Main() {
        super(TITLE);
        GuiCommonElements gui = new GuiCommonElements();
        this.setDefaultCloseOperation(0);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.setContentPane(pane);
        this.setPreferredSize(new Dimension(980, 580));
        this.pack();
        this.setLocationRelativeTo(null);
        this.addWindowListener(this);
        this.setTitle(TITLE);
        this.setIconImage(gui.getImageIcon(ICON).getImage());
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        this.fileMenu = new JMenu("File");
        menubar.add(this.fileMenu);
        this.login = new JMenuItem("Login to the server...");
        this.login.setActionCommand("login");
        this.login.addActionListener(this);
        this.fileMenu.add(this.login);
        JMenuItem fileQuit = new JMenuItem("Quit");
        fileQuit.setActionCommand("quit");
        fileQuit.addActionListener(this);
        this.fileMenu.add(fileQuit);
        this.helpMenu = new JMenu("Help");
        menubar.add(this.helpMenu);
        JMenuItem helpComment = new JMenuItem("Send a Comment...");
        helpComment.setActionCommand("comment");
        helpComment.addActionListener(this);
        JMenuItem helpAbout = new JMenuItem("About the Importer...");
        helpAbout.setActionCommand("about");
        helpAbout.addActionListener(this);
        this.helpMenu.add(helpComment);
        this.helpMenu.add(helpAbout);
        JTabbedPane tPane = new JTabbedPane();
        tPane.setOpaque(false);
        JPanel filePanel = new JPanel(new BorderLayout());
        FileQueueHandler fileQueueHandler = new FileQueueHandler(this);
        filePanel.add((Component)fileQueueHandler, "Center");
        tPane.addTab("File Viewer", null, filePanel, "Add and delete images here to the import queue.");
        tPane.setMnemonicAt(0, 49);
        JPanel outputPanel = new JPanel();
        outputPanel.setLayout(new BorderLayout());
        this.outputTextPane = new JTextPane();
        this.outputTextPane.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane();
        outputScrollPane.getViewport().add(this.outputTextPane);
        outputScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Main.this.outputTextPane.setCaretPosition(Main.this.outputTextPane.getDocument().getLength());
            }
        });
        outputPanel.add((Component)outputScrollPane, "Center");
        tPane.addTab("Output Text", null, outputPanel, "Standard output text goes here.");
        tPane.setMnemonicAt(0, 50);
        JPanel debugPanel = new JPanel();
        debugPanel.setLayout(new BorderLayout());
        this.debugTextPane = new JTextPane();
        this.debugTextPane.setEditable(false);
        JScrollPane debugScrollPane = new JScrollPane();
        debugScrollPane.getViewport().add(this.debugTextPane);
        debugScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                Main.this.debugTextPane.setCaretPosition(Main.this.debugTextPane.getDocument().getLength());
            }
        });
        debugPanel.add((Component)debugScrollPane, "Center");
        tPane.addTab("Debug Text", null, debugPanel, "Debug messages are displayed here.");
        tPane.setMnemonicAt(0, 51);
        tPane.setSelectedIndex(0);
        this.add(tPane);
        this.statusBar = new StatusBar();
        this.statusBar.setStatusIcon("gfx/server_disconn16.png", "Server disconnected.");
        this.statusBar.setProgress(false, 0, "");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.setVisible(false);
        LogAppender.getInstance().setTextArea(this.debugTextPane);
        this.appendToOutputLn("> Starting the importer (revision " + Main.getPrintableKeyword(revision) + ").");
        this.appendToOutputLn("> Build date: " + Main.getPrintableKeyword(revisionDate));
        this.appendToOutputLn("> Release date: " + releaseDate);
        this.loginHandler = new LoginHandler(this, false, false);
    }

    public void appendToOutput(String s) {
        try {
            StyledDocument doc = (StyledDocument)this.outputTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 100000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToOutputLn(String s) {
        this.appendToOutput(String.valueOf(s) + "\n");
    }

    public void appendToDebug(String s) {
        try {
            StyledDocument doc = (StyledDocument)this.debugTextPane.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, Color.black);
            StyleConstants.setFontFamily(style, "SansSerif");
            StyleConstants.setFontSize(style, 12);
            StyleConstants.setBold(style, false);
            doc.insertString(doc.getLength(), s, style);
            int maxChars = 100000;
            if (doc.getLength() > maxChars) {
                doc.remove(0, doc.getLength() - maxChars);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendToDebugLn(String s) {
        this.appendToDebug(String.valueOf(s) + "\n");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("login".equals(cmd)) {
            if (this.loggedIn.booleanValue()) {
                this.setImportEnabled(false);
                this.loggedIn = false;
                this.appendToOutputLn("> Logged out.");
                this.statusBar.setStatusIcon("gfx/server_disconn16.png", "Logged out.");
                this.loginHandler = null;
            } else {
                this.loginHandler = new LoginHandler(this, true, true);
            }
        } else if ("quit".equals(cmd)) {
            if (this.quitConfirmed(this)) {
                System.exit(0);
            }
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            About.show(this.getContentPane(), false);
        } else if ("comment".equals(cmd)) {
            new CommentMessenger(this, "Comment Dialog", (Boolean)true);
        }
    }

    public static String getPrintableKeyword(String keyword) {
        int begin = keyword.indexOf(" ") + 1;
        int end = keyword.lastIndexOf(" ");
        return keyword.substring(begin, end);
    }

    public void waitCursor(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    public void setImportEnabled(boolean toggle) {
        if (toggle) {
            this.login.setText("Logout of the server...");
        } else {
            this.login.setText("Login to the server...");
        }
    }

    public void onlyAllowExit() {
        this.fileMenu.setEnabled(true);
        this.helpMenu.setEnabled(true);
    }

    public void enableMenus(boolean toggle) {
        this.fileMenu.setEnabled(toggle);
        this.helpMenu.setEnabled(toggle);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private boolean quitConfirmed(JFrame frame) {
        String s1 = "Quit";
        String s2 = "Don't Quit";
        Object[] options = new Object[]{s1, s2};
        int n = JOptionPane.showOptionDialog(frame, "Do you really want to quit?\nDoing so will cancel any running imports.", "Quit Confirmation", 0, 3, null, options, s1);
        return n == 0;
    }

    public void windowClosing(WindowEvent e) {
        if (this.quitConfirmed(this)) {
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        new Main();
    }

    public static Point getSplashLocation() {
        return splashLocation;
    }
}

