/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.ejb.EJBAccessException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.LoginDialog;
import ome.formats.importer.LoginFrame;
import ome.formats.importer.Main;
import ome.formats.importer.SplashWindow;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginHandler
implements PropertyChangeListener {
    public volatile JFrame f;
    private boolean center;
    private String username;
    private String password;
    private String port;
    private String server;
    private Main viewer;
    private static Log log = LogFactory.getLog(LoginHandler.class);
    private Preferences userPrefs = Preferences.userNodeForPackage(LoginHandler.class);
    private OMEROMetadataStore store;
    public LoginDialog dialog;
    public LoginFrame frame;
    private boolean modal;

    LoginHandler(Main viewer, boolean modal, boolean center) {
        this.viewer = viewer;
        this.center = center;
        this.modal = modal;
        viewer.enableMenus(false);
        boolean cancelled = this.displayLoginDialog(viewer, modal);
        if (modal && cancelled) {
            this.loginCancelled();
        }
        if (modal && !cancelled) {
            this.tryLogin();
        }
    }

    public void tryLogin() {
        new Thread(){

            public void run() {
                SplashWindow.disposeSplash();
                LoginHandler.this.viewer.setVisible(true);
                if (!LoginHandler.this.modal) {
                    LoginHandler.this.username = LoginHandler.this.frame.username;
                    LoginHandler.this.password = LoginHandler.this.frame.password;
                    LoginHandler.this.server = LoginHandler.this.frame.currentServer;
                    LoginHandler.this.port = LoginHandler.this.frame.port;
                    LoginHandler.this.frame.updateServerList(LoginHandler.this.server);
                } else {
                    LoginHandler.this.username = LoginHandler.this.dialog.username;
                    LoginHandler.this.password = LoginHandler.this.dialog.password;
                    LoginHandler.this.server = LoginHandler.this.dialog.currentServer;
                    LoginHandler.this.port = LoginHandler.this.dialog.port;
                    LoginHandler.this.dialog.updateServerList(LoginHandler.this.server);
                }
                LoginHandler.this.userPrefs.put("username", LoginHandler.this.username);
                LoginHandler.this.userPrefs.put("server", LoginHandler.this.server);
                LoginHandler.this.userPrefs.put("port", LoginHandler.this.port);
                ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_trying16.png", "Trying to connect to " + LoginHandler.this.server);
                ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(true, -1, "connecting....");
                try {
                    if (!LoginHandler.this.isValidLogin()) {
                        ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                        ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/error_msg16.png", "Incorrect username/password. Server login failed, please try to log in again.");
                        JOptionPane.showMessageDialog(LoginHandler.this.viewer, "Incorrect username/password. Server login \nfailed, please try to log in again.");
                        LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                        LoginHandler.this.viewer.enableMenus(true);
                        ((LoginHandler)LoginHandler.this).viewer.loggedIn = false;
                        return;
                    }
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    log.info((Object)sw);
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/error_msg16.png", "Server connection to " + LoginHandler.this.server + " failed. " + "Please try again.");
                    JOptionPane.showMessageDialog(LoginHandler.this.viewer, "\nThe application failed to log in. The hostname may be wrong or \nthe server may be offline.\n\nPlease try again.");
                    LoginHandler.this.viewer.appendToOutput("> Login failed. Try to relog.\n");
                    LoginHandler.this.viewer.enableMenus(true);
                    ((LoginHandler)LoginHandler.this).viewer.loggedIn = false;
                    return;
                }
                ((LoginHandler)LoginHandler.this).viewer.statusBar.setProgress(false, 0, "");
                LoginHandler.this.viewer.appendToOutput("> Login Successful.\n");
                LoginHandler.this.viewer.enableMenus(true);
                LoginHandler.this.viewer.setImportEnabled(true);
                ((LoginHandler)LoginHandler.this).viewer.loggedIn = true;
                try {
                    long freeSpace = LoginHandler.this.store.getRepositorySpace();
                    NumberFormat formatter = NumberFormat.getInstance(Locale.US);
                    String freeMB = formatter.format(freeSpace / 1000L);
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_connect16.png", "Connected to " + LoginHandler.this.server + ". Free space: " + freeMB + " MB.");
                }
                catch (Exception e) {
                    ((LoginHandler)LoginHandler.this).viewer.statusBar.setStatusIcon("gfx/server_connect16.png", "Connected to " + LoginHandler.this.server + ".");
                }
            }
        }.start();
    }

    void loginCancelled() {
        this.viewer.loggedIn = false;
        this.viewer.enableMenus(true);
        SplashWindow.disposeSplash();
        this.viewer.setVisible(true);
    }

    private boolean displayLoginDialog(Main viewer, boolean modal) {
        if (modal) {
            this.dialog = new LoginDialog(viewer, viewer, "Login", modal, this.center);
            this.dialog.setAlwaysOnTop(true);
            if (this.dialog.cancelled) {
                return true;
            }
        } else {
            this.frame = new LoginFrame(viewer, viewer, "Login", modal, this.center);
            this.frame.addPropertyChangeListener(this);
        }
        return false;
    }

    private boolean isValidLogin() throws Exception {
        try {
            this.store = new OMEROMetadataStore(this.username, this.password, this.server, this.port);
            this.store.getProjects();
        }
        catch (EJBAccessException e) {
            return false;
        }
        return true;
    }

    public OMEROMetadataStore getMetadataStore() {
        return this.store;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        if (prop.equals("login")) {
            this.tryLogin();
        }
        if (prop.equals("login_cancelled")) {
            this.loginCancelled();
        }
    }
}

