/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import loci.formats.DataTools;
import loci.formats.FormatException;
import ome.conditions.ApiUsageException;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.OMEROWrapper;
import ome.model.containers.Dataset;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportLibrary {
    private static Log log = LogFactory.getLog(ImportLibrary.class);
    private Dataset dataset;
    private OMEROMetadataStore store;
    private OMEROWrapper reader;
    private ImportContainer[] fads;
    private int sizeZ;
    private int sizeT;
    private int sizeC;
    private int sizeX;
    private int sizeY;
    private int zSize;
    private int tSize;
    private int wSize;

    public ImportLibrary(OMEROMetadataStore store, OMEROWrapper reader, ImportContainer[] fads) {
        this.store = store;
        this.reader = reader;
        this.fads = fads;
        if (store == null || reader == null || fads == null || fads.length == 0) {
            throw new ApiUsageException("All arguments to ImportLibrary() must be non-null.");
        }
    }

    public void setDataset(Dataset dataset) {
        if (dataset == null) {
            throw new ApiUsageException("Dataset name cannot be null.");
        }
        this.dataset = dataset;
    }

    public Dataset getDataset() {
        if (this.dataset == null) {
            throw new ApiUsageException("The dataset has not been set. Please call setDataset(String).");
        }
        return this.dataset;
    }

    public ImportContainer[] getFilesAndDatasets() {
        return this.fads;
    }

    public List<Pixels> getRoot() {
        return (List)this.store.getRoot();
    }

    public void open(String fileName) throws IOException, FormatException {
        this.reader.close();
        this.reader.setMetadataStore(this.store);
        this.reader.setId(fileName);
        log.debug((Object)("Image Count: " + this.reader.getImageCount()));
    }

    public int calculateImageCount(String fileName, Integer series) {
        List<Pixels> pixelsList = this.getRoot();
        Pixels pixels = pixelsList.get(series);
        this.sizeZ = pixels.getSizeZ();
        this.sizeC = pixels.getSizeC();
        this.sizeT = pixels.getSizeT();
        this.sizeX = pixels.getSizeX();
        this.sizeY = pixels.getSizeY();
        int imageCount = this.sizeZ * this.sizeC * this.sizeT;
        this.setOffsetInfo(fileName);
        return imageCount;
    }

    public List<Pixels> importMetadata(String imageName) throws FormatException, IOException {
        ArrayList<Pixels> pixelsArray = (ArrayList<Pixels>)this.store.getRoot();
        int series = 0;
        for (Pixels pix : pixelsArray) {
            String name = imageName;
            String seriesName = this.reader.getImageName(series);
            if (seriesName != null) {
                name = String.valueOf(name) + " [" + seriesName + "]";
            }
            pix.getImage().setName(name);
            if (pix.getPixelsDimensions() == null) {
                PixelsDimensions pixDims = new PixelsDimensions();
                pixDims.setSizeX(Float.valueOf(1.0f));
                pixDims.setSizeY(Float.valueOf(1.0f));
                pixDims.setSizeZ(Float.valueOf(1.0f));
                pix.setPixelsDimensions(pixDims);
            }
            ++series;
        }
        pixelsArray = this.store.saveToDB();
        for (Pixels pix : pixelsArray) {
            this.store.addPixelsToDataset(pix.getId(), this.dataset);
        }
        return pixelsArray;
    }

    private int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }

    public void importData(Long pixId, String fileName, int series, Step step) {
        int i = 1;
        try {
            int bytesPerPixel = this.getBytesPerPixel(this.reader.getPixelType());
            byte[] arrayBuf = new byte[this.sizeX * this.sizeY * bytesPerPixel];
            this.reader.setSeries(series);
            int t = 0;
            while (t < this.sizeT) {
                int c = 0;
                while (c < this.sizeC) {
                    int z = 0;
                    while (z < this.sizeZ) {
                        int planeNumber = this.reader.getIndex(z, c, t);
                        ByteBuffer buf = this.reader.openPlane2D(fileName, planeNumber, arrayBuf).getData();
                        arrayBuf = this.swapIfRequired(buf, fileName);
                        step.step(series, i);
                        this.store.setPlane(pixId, arrayBuf, z, c, t);
                        ++i;
                        ++z;
                    }
                    ++c;
                }
                ++t;
            }
            this.reader.populateMinMax(pixId, series);
        }
        catch (FormatException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.info((Object)sw);
            return;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            log.info((Object)sw);
            return;
        }
    }

    private void setOffsetInfo(String fileName) {
        int order = 0;
        order = this.getSequenceNumber(this.reader.getDimensionOrder());
        this.setOffsetInfo(order, this.sizeZ, this.sizeC, this.sizeT);
    }

    private void setOffsetInfo(int imgSequence, int numZSections, int numWaves, int numTimes) {
        int smallOffset = 1;
        switch (imgSequence) {
            case 0: {
                this.zSize = smallOffset;
                this.tSize = this.zSize * numZSections;
                this.wSize = this.tSize * numTimes;
                break;
            }
            case 1: {
                this.wSize = smallOffset;
                this.zSize = this.wSize * numWaves;
                this.tSize = this.zSize * numZSections;
                break;
            }
            case 2: {
                this.zSize = smallOffset;
                this.wSize = this.zSize * numZSections;
                this.tSize = this.wSize * numWaves;
                break;
            }
            case 3: {
                this.tSize = smallOffset;
                this.wSize = this.tSize * numTimes;
                this.zSize = this.wSize * numWaves;
                break;
            }
            case 4: {
                this.wSize = smallOffset;
                this.tSize = this.wSize * numWaves;
                this.zSize = this.tSize * numTimes;
            }
        }
    }

    private int getTotalOffset(int currentZ, int currentW, int currentT) {
        return this.zSize * currentZ + this.wSize * currentW + this.tSize * currentT;
    }

    private int getSequenceNumber(String dimOrder) {
        if (dimOrder.equals("XYZTC")) {
            return 0;
        }
        if (dimOrder.equals("XYCZT")) {
            return 1;
        }
        if (dimOrder.equals("XYZCT")) {
            return 2;
        }
        if (dimOrder.equals("XYTCZ")) {
            return 3;
        }
        if (dimOrder.equals("XYCTZ")) {
            return 4;
        }
        throw new RuntimeException(String.valueOf(dimOrder) + " not represented in " + "getSequenceNumber");
    }

    public boolean isLittleEndian(String fileName) throws FormatException, IOException {
        return this.reader.isLittleEndian();
    }

    private byte[] swapIfRequired(ByteBuffer buffer, String fileName) throws FormatException, IOException {
        int pixelType = this.reader.getPixelType();
        int bytesPerPixel = this.getBytesPerPixel(pixelType);
        if (pixelType == 6 || pixelType == 7 || bytesPerPixel == 1) {
            return buffer.array();
        }
        if (this.isLittleEndian(fileName)) {
            if (bytesPerPixel == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int i = 0;
                while (i < buffer.capacity() / 2) {
                    buf.put(i, DataTools.swap(buf.get(i)));
                    ++i;
                }
            } else if (bytesPerPixel == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int i = 0;
                while (i < buffer.capacity() / 4) {
                    buf.put(i, DataTools.swap(buf.get(i)));
                    ++i;
                }
            } else {
                throw new FormatException("Unsupported sample bit width: '" + bytesPerPixel + "'");
            }
        }
        return buffer.array();
    }

    public static abstract class Step {
        public abstract void step(int var1, int var2);
    }
}

