/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import loci.formats.FormatException;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.DebugMessenger;
import ome.formats.importer.FileQueueTable;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.Main;
import ome.formats.importer.OMEROWrapper;
import ome.model.core.Pixels;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportHandler {
    private ImportLibrary library;
    private OMEROWrapper reader;
    private Main viewer;
    private static boolean runState = false;
    private Thread runThread;
    private FileQueueTable qTable;
    private static Log log = LogFactory.getLog(ImportHandler.class);
    private OMEROMetadataStore store;

    public ImportHandler(Main viewer, FileQueueTable qTable, OMEROMetadataStore store, OMEROWrapper reader, ImportContainer[] fads) {
        if (runState) {
            log.error((Object)"ImportHandler running twice");
            if (this.runThread != null) {
                log.error((Object)this.runThread);
            }
            throw new RuntimeException("ImportHandler running twice");
        }
        runState = true;
        try {
            this.viewer = viewer;
            this.store = store;
            this.qTable = qTable;
            this.reader = reader;
            this.library = new ImportLibrary(store, reader, fads);
            this.runThread = new Thread(){

                public void run() {
                    try {
                        ImportHandler.this.importImages();
                    }
                    catch (Exception e) {
                        new DebugMessenger(null, "Error Dialog", (Boolean)true, e);
                    }
                }
            };
            this.runThread.start();
        }
        finally {
            runState = false;
        }
    }

    private void importImages() {
        Date date = null;
        long timestampIn = System.currentTimeMillis();
        date = new Date(timestampIn);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String myDate = formatter.format(date);
        this.viewer.appendToOutputLn("> Starting import at: " + myDate + "\n");
        this.viewer.statusBar.setStatusIcon("gfx/import_icon_16.png", "Now importing.");
        this.viewer.statusBar.setProgressMaximum(this.library.getFilesAndDatasets().length);
        ImportContainer[] fads = this.library.getFilesAndDatasets();
        this.qTable.importBtn.setText("Cancel");
        this.qTable.importing = true;
        int i = 0;
        while (i < fads.length) {
            this.qTable.setProgressPending(i);
            ++i;
        }
        int j = 0;
        while (j < fads.length) {
            if (this.qTable.table.getValueAt(j, 2).equals("pending") && !this.qTable.cancel) {
                String filename = fads[j].file.getAbsolutePath();
                this.viewer.appendToOutputLn("> [" + j + "] Importing \"" + filename + "\"");
                this.library.setDataset(fads[j].dataset);
                try {
                    this.importImage(fads[j].file, j, this.library.getFilesAndDatasets().length, fads[j].imageName, fads[j].archive);
                }
                catch (FormatException fe) {
                    this.qTable.setProgressUnknown(j);
                    this.viewer.appendToOutputLn("> [" + j + "] Unknown format.");
                }
                catch (Exception e) {
                    this.qTable.setProgressFailed(j);
                    this.viewer.appendToOutputLn("> [" + j + "] Failure importing.");
                    new DebugMessenger(null, "Error Dialog", (Boolean)true, e);
                }
            }
            ++j;
        }
        this.qTable.importBtn.setText("Import");
        this.qTable.importBtn.setEnabled(true);
        this.qTable.queue.setRowSelectionAllowed(true);
        this.qTable.removeBtn.setEnabled(true);
        if (this.qTable.failedFiles) {
            this.qTable.clearFailedBtn.setEnabled(true);
        }
        if (this.qTable.doneFiles) {
            this.qTable.clearDoneBtn.setEnabled(true);
        }
        this.qTable.importing = false;
        this.qTable.cancel = false;
        this.viewer.statusBar.setProgress(false, 0, "");
        this.viewer.statusBar.setStatusIcon("gfx/import_done_16.png", "Import complete.");
        long timestampOut = System.currentTimeMillis();
        long timestampDiff = timestampOut - timestampIn;
        long timeInSeconds = timestampDiff / 1000L;
        long hours = timeInSeconds / 3600L;
        long minutes = (timeInSeconds -= hours * 3600L) / 60L;
        long seconds = timeInSeconds -= minutes * 60L;
        this.viewer.appendToOutputLn("> Total import time: " + hours + " hour(s), " + minutes + " minute(s), " + seconds + " second(s).");
        this.viewer.appendToOutputLn("> Image import completed!");
    }

    private List<Pixels> importImage(File file, int index, int total, String imageName, boolean archive) throws FormatException, IOException {
        String fileName = file.getAbsolutePath();
        String shortName = file.getName();
        this.viewer.appendToOutput("> [" + index + "] Loading image \"" + shortName + "\"...");
        this.library.open(file.getAbsolutePath());
        this.viewer.appendToOutput(" Succesfully loaded.\n");
        this.viewer.statusBar.setProgress(true, 0, "Importing file " + (index + 1) + " of " + total);
        this.viewer.statusBar.setProgressValue(index);
        this.viewer.appendToOutput("> [" + index + "] Importing metadata for " + "image \"" + shortName + "\"... ");
        this.qTable.setProgressPrepping(index);
        String[] fileNameList = this.reader.getUsedFiles();
        File[] files = new File[fileNameList.length];
        int i = 0;
        while (i < fileNameList.length) {
            files[i] = new File(fileNameList[i]);
            ++i;
        }
        if (archive) {
            this.store.setOriginalFiles(files);
        }
        this.reader.getUsedFiles();
        List<Pixels> pixList = this.library.importMetadata(imageName);
        int seriesCount = this.reader.getSeriesCount();
        int series = 0;
        while (series < seriesCount) {
            int count = this.library.calculateImageCount(fileName, series);
            Long pixId = pixList.get(series).getId();
            this.viewer.appendToOutputLn("Successfully stored to dataset \"" + this.library.getDataset() + "\" with id \"" + pixId + "\".");
            this.viewer.appendToOutputLn("> [" + index + "] Importing pixel data for " + "image \"" + shortName + "\"... ");
            this.qTable.setProgressInfo(index, count);
            this.library.importData(pixId, fileName, series, new ImportLibrary.Step(){

                public void step(int series, int step) {
                    if (step <= ImportHandler.this.qTable.getMaximum()) {
                        ImportHandler.this.qTable.setImportProgress(ImportHandler.this.reader.getSeriesCount(), series, step);
                    }
                }
            });
            this.viewer.appendToOutputLn("> Successfully stored with pixels id \"" + pixId + "\".");
            this.viewer.appendToOutputLn("> [" + index + "] Image imported successfully!");
            if (archive) {
                this.qTable.setProgressArchiving(index);
                int i2 = 0;
                while (i2 < fileNameList.length) {
                    files[i2] = new File(fileNameList[i2]);
                    this.store.writeFilesToFileStore(files, pixId);
                    ++i2;
                }
            }
            ++series;
        }
        this.qTable.setProgressDone(index);
        return pixList;
    }
}

