/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.conditions.ApiUsageException;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.ImportLibrary;
import ome.formats.importer.OMEROWrapper;
import ome.model.containers.Dataset;
import ome.model.core.Pixels;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportFixture {
    Log log = LogFactory.getLog(ImportFixture.class);
    private String user;
    private String pass;
    private String host;
    private String port;
    private OMEROMetadataStore store;
    private OMEROWrapper reader;
    private ImportLibrary library;
    private Map<File, Dataset> fads = new HashMap<File, Dataset>();

    public ImportFixture(OMEROMetadataStore store) {
        this(store, new OMEROWrapper());
    }

    public ImportFixture(OMEROMetadataStore store, OMEROWrapper reader) {
        this.store = store;
        this.reader = reader;
    }

    public ImportFixture put(File file, Dataset ds) {
        if (file == null || ds == null) {
            throw new ApiUsageException("Arguments cannot be null.");
        }
        this.fads.put(file, ds);
        return this;
    }

    public ImportFixture putAll(Map<File, Dataset> map) {
        for (File f : map.keySet()) {
            this.put(f, map.get(f));
        }
        return this;
    }

    public void setUp() throws Exception {
        this.library = new ImportLibrary(this.store, this.reader, this.fadMap(this.fads));
    }

    public void tearDown() {
        this.fads = null;
        this.store = null;
        this.library = null;
        try {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.reader = null;
        }
    }

    public void doImport(ImportLibrary.Step step) throws Exception {
        if (step == null) {
            throw new ApiUsageException("Step may not be null.");
        }
        for (File file : this.fads.keySet()) {
            String fileName = file.getAbsolutePath();
            this.library.setDataset(this.fads.get(file));
            this.library.open(fileName);
            this.library.calculateImageCount(fileName, 0);
            List<Pixels> pixId = this.library.importMetadata(file.getAbsolutePath());
            this.library.importData(pixId.get(0).getId(), fileName, 0, step);
        }
    }

    public void doImport() throws Exception {
        this.doImport(new ImportLibrary.Step(){

            public void step(int series, int n) {
            }
        });
    }

    private ImportContainer[] fadMap(Map<File, Dataset> map) {
        int size = map.keySet().size();
        ImportContainer[] fads = new ImportContainer[size];
        File[] files = map.keySet().toArray(new File[size]);
        int i = 0;
        while (i < fads.length) {
            fads[i] = new ImportContainer(files[i], map.get(files[i]), files[i].toString(), false);
            ++i;
        }
        return fads;
    }
}

