/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.AddDatasetDialog;
import ome.formats.importer.AddProjectDialog;
import ome.formats.importer.DatasetItem;
import ome.formats.importer.ProjectItem;
import ome.formats.importer.util.GuiCommonElements;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private GuiCommonElements gui;
    private Integer dialogHeight = 350;
    private Integer dialogWidth = 400;
    private JPanel mainPanel;
    private JPanel pdPanel;
    private JPanel namedPanel;
    private JPanel numOfDirPanel;
    private JTextPane instructions;
    String addIcon = "gfx/add_text.png";
    private int buttonSize = 34;
    private JRadioButton fullPathButton;
    private JRadioButton partPathButton;
    private GuiCommonElements.WholeNumberField numOfDirectoriesField;
    public JCheckBox archiveImage;
    private JButton addProjectBtn;
    private JButton addDatasetBtn;
    private JButton cancelBtn;
    private JButton importBtn;
    private JComboBox pbox;
    private JComboBox dbox;
    public Dataset dataset;
    public Project project;
    public Project newProject;
    public DatasetItem[] datasetItems = null;
    public ProjectItem[] projectItems = null;
    public boolean cancelled = true;
    private static Log log = LogFactory.getLog(ImportDialog.class);
    public OMEROMetadataStore store;
    private Preferences userPrefs = Preferences.userNodeForPackage(ImportDialog.class);
    private Long savedProject = this.userPrefs.getLong("savedProject", 0L);
    private Long savedDataset = this.userPrefs.getLong("savedDataset", 0L);
    public Boolean useFullPath = this.userPrefs.getBoolean("savedFileNaming", true);
    public Integer numOfDirectories = this.userPrefs.getInt("savedNumOfDirs", 0);

    ImportDialog(JFrame owner, String title, boolean modal, OMEROMetadataStore store) {
        super(owner);
        this.store = store;
        if (store != null) {
            this.projectItems = ProjectItem.createProjectItems(store.getProjects());
            this.datasetItems = DatasetItem.createEmptyDataset();
        }
        this.setLocation(200, 200);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(false);
        this.setSize(new Dimension(this.dialogWidth, this.dialogHeight));
        this.setLocationRelativeTo(owner);
        this.gui = new GuiCommonElements();
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, -1.0}, {-2.0, 10.0, -2.0, -1.0, 40.0, 30.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 20, 10, 20, this.debug);
        String message = "Import these images into which dataset?";
        this.instructions = this.gui.addTextPane(this.mainPanel, message, "0, 0, 4, 0", this.debug);
        double[][] pdTable = new double[][]{{-1.0, 5.0, 40.0}, {35.0, 35.0}};
        this.pdPanel = this.gui.addMainPanel(this.mainPanel, pdTable, 0, 0, 0, 0, this.debug);
        this.pbox = this.gui.addComboBox(this.pdPanel, "Project: ", this.projectItems, 80, "Select dataset to use for this import.", 60.0, "0,0,f,c", this.debug);
        String offsetButtons = ",c";
        this.addProjectBtn = this.gui.addIconButton(this.pdPanel, "", this.addIcon, 20, 60, null, null, "2,0,f" + offsetButtons, this.debug);
        this.addProjectBtn.addActionListener(this);
        this.dbox = this.gui.addComboBox(this.pdPanel, "Dataset: ", this.datasetItems, 68, "Select dataset to use for this import.", 60.0, "0,1,f,c", this.debug);
        this.dbox.setEnabled(false);
        this.addDatasetBtn = this.gui.addIconButton(this.pdPanel, "", this.addIcon, 20, 60, null, null, "2,1,f" + offsetButtons, this.debug);
        this.addDatasetBtn.addActionListener(this);
        this.addDatasetBtn.setEnabled(false);
        this.mainPanel.add((Component)this.pdPanel, "0, 2, 4, 2");
        double[][] namedTable = new double[][]{{-1.0}, {24.0, -2.0, -2.0, -1.0}};
        this.namedPanel = this.gui.addBorderedPanel(this.mainPanel, namedTable, "File Naming", this.debug);
        message = "The imported file name on the server should include:";
        this.instructions = this.gui.addTextPane(this.namedPanel, message, "0, 0", this.debug);
        String fullPathTooltip = "This will use the full path and file name for the file. For example: \"c:/myfolder/mysubfolder/myfile.dv\"";
        String partPathTooltip = "This will use a partial path and file name for the file. For example: \"mysubfolder/myfile.dv\"";
        this.fullPathButton = this.gui.addRadioButton(this.namedPanel, "the full path and file name from you local system", 117, fullPathTooltip, "0,1", this.debug);
        this.partPathButton = this.gui.addRadioButton(this.namedPanel, "a partial path which includes the file name and...", 117, partPathTooltip, "0,2", this.debug);
        this.numOfDirectoriesField = this.gui.addWholeNumberField(this.namedPanel, "      ", "0", "of the directories immediately before it.", 0, "Add this number of directories to the file names", 3, 40, "0,3,l,c", this.debug);
        this.numOfDirectoriesField.setText(this.numOfDirectories.toString());
        this.numOfDirectoriesField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImportDialog.this.partPathButton.setSelected(true);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.fullPathButton);
        group.add(this.partPathButton);
        if (this.useFullPath.booleanValue()) {
            group.setSelected(this.fullPathButton.getModel(), true);
        } else {
            group.setSelected(this.partPathButton.getModel(), true);
        }
        this.mainPanel.add((Component)this.namedPanel, "0, 3, 4, 2");
        this.cancelBtn = this.gui.addButton(this.mainPanel, "Cancel", 76, "Cancel", "1, 5, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.importBtn = this.gui.addButton(this.mainPanel, "Add to Q", 81, "Import", "3, 5, f, c", this.debug);
        this.importBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.gui.enterPressesWhenFocused(this.importBtn);
        this.archiveImage = this.gui.addCheckBox(this.mainPanel, "Archive the original imported file(s) to the server.", "0,4,4,t", this.debug);
        this.archiveImage.setSelected(false);
        this.archiveImage.setVisible(true);
        this.add(this.mainPanel);
        this.importBtn.setEnabled(false);
        this.getRootPane().setDefaultButton(this.importBtn);
        this.fullPathButton.addActionListener(this);
        this.partPathButton.addActionListener(this);
        this.numOfDirectoriesField.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.importBtn.addActionListener(this);
        this.pbox.addActionListener(this);
        this.buildProjectsAndDatasets();
        this.setVisible(true);
    }

    private void buildProjectsAndDatasets() {
        if (this.savedProject != 0L && this.projectItems != null) {
            int i = 0;
            while (i < this.projectItems.length) {
                Long pId = this.projectItems[i].getId();
                if (pId != null && pId.equals(this.savedProject)) {
                    this.pbox.setSelectedIndex(i);
                    Project p = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
                    this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
                    this.dbox.removeAllItems();
                    if (this.datasetItems.length == 0 || this.pbox.getSelectedIndex() == 0) {
                        this.datasetItems = DatasetItem.createEmptyDataset();
                        this.dbox.addItem(this.datasetItems[0]);
                        this.dbox.setEnabled(false);
                        this.addDatasetBtn.setEnabled(false);
                        this.importBtn.setEnabled(false);
                    } else {
                        int k = 0;
                        while (k < this.datasetItems.length) {
                            Long dId = this.datasetItems[k].getId();
                            this.dbox.setEnabled(true);
                            this.addDatasetBtn.setEnabled(true);
                            this.importBtn.setEnabled(true);
                            this.dbox.addItem(this.datasetItems[k]);
                            if (dId != null && dId.equals(this.savedDataset)) {
                                this.dbox.setSelectedIndex(k);
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void refreshAndSetProject() {
        if (this.store != null) {
            this.projectItems = ProjectItem.createProjectItems(this.store.getProjects());
            this.savedProject = this.userPrefs.getLong("savedProject", 0L);
            int k = 0;
            while (k < this.projectItems.length) {
                Long pId = this.projectItems[k].getId();
                if (pId != null && pId.equals(this.savedProject)) {
                    this.pbox.addItem(this.projectItems[k]);
                    this.pbox.setSelectedIndex(k);
                }
                ++k;
            }
            this.datasetItems = DatasetItem.createEmptyDataset();
            this.buildProjectsAndDatasets();
            this.addDatasetBtn.setEnabled(true);
        }
    }

    private void refreshAndSetDataset(Project p) {
        this.savedDataset = this.userPrefs.getLong("savedDataset", 0L);
        this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
        this.dbox.removeAllItems();
        int k = 0;
        while (k < this.datasetItems.length) {
            Long dId = this.datasetItems[k].getId();
            this.dbox.setEnabled(true);
            this.addDatasetBtn.setEnabled(true);
            this.importBtn.setEnabled(true);
            this.dbox.addItem(this.datasetItems[k]);
            if (dId != null && dId.equals(this.savedDataset)) {
                this.dbox.setSelectedIndex(k);
            }
            ++k;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addProjectBtn) {
            new AddProjectDialog((Window)this, "Add a new Project", (Boolean)true, this.store);
            this.refreshAndSetProject();
        }
        if (e.getSource() == this.addDatasetBtn) {
            this.project = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
            new AddDatasetDialog(this, "Add a new Dataset to: " + this.project.getName(), true, this.project, this.store);
            this.refreshAndSetDataset(this.project);
        }
        if (e.getSource() == this.fullPathButton) {
            this.useFullPath = true;
        }
        if (e.getSource() == this.partPathButton) {
            this.useFullPath = false;
        }
        if (e.getSource() == this.cancelBtn) {
            this.cancelled = true;
            this.dispose();
        }
        if (e.getSource() == this.importBtn) {
            this.cancelled = false;
            this.importBtn.requestFocus();
            this.numOfDirectories = this.numOfDirectoriesField.getValue();
            this.dataset = ((DatasetItem)this.dbox.getSelectedItem()).getDataset();
            this.project = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
            this.userPrefs.putLong("savedProject", ((ProjectItem)this.pbox.getSelectedItem()).getId());
            this.userPrefs.putLong("savedDataset", this.dataset.getId());
            if (this.fullPathButton.isSelected()) {
                this.userPrefs.putBoolean("savedFileNaming", true);
            } else {
                this.userPrefs.putBoolean("savedFileNaming", false);
            }
            this.userPrefs.putInt("savedNumOfDirs", this.numOfDirectoriesField.getValue());
            this.dispose();
        }
        if (e.getSource() == this.pbox) {
            this.cancelled = false;
            if (this.pbox.getSelectedIndex() == 0) {
                this.dbox.setEnabled(false);
                this.addDatasetBtn.setEnabled(false);
            } else {
                Project p = ((ProjectItem)this.pbox.getSelectedItem()).getProject();
                this.datasetItems = DatasetItem.createDatasetItems(this.store.getDatasets(p));
                this.addDatasetBtn.setEnabled(true);
            }
            this.dbox.removeAllItems();
            if (this.datasetItems.length == 0 || this.pbox.getSelectedIndex() == 0) {
                this.datasetItems = DatasetItem.createEmptyDataset();
                this.dbox.addItem(this.datasetItems[0]);
                this.dbox.setEnabled(false);
                this.importBtn.setEnabled(false);
            } else {
                int i = 0;
                while (i < this.datasetItems.length) {
                    this.dbox.setEnabled(true);
                    this.importBtn.setEnabled(true);
                    this.dbox.addItem(this.datasetItems[i]);
                    ++i;
                }
            }
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        ImportDialog dialog = new ImportDialog(null, "Import Dialog", true, null);
        if (dialog != null) {
            System.exit(0);
        }
    }
}

