/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.Main;
import ome.formats.importer.util.ETable;
import ome.model.containers.Dataset;

public class FileQueueTable
extends JPanel
implements ActionListener {
    public QueueTableModel table = new QueueTableModel();
    public ETable queue = new ETable(this.table);
    private static final long serialVersionUID = -4239932269937114120L;
    JButton refreshBtn;
    JButton addBtn;
    JButton removeBtn;
    JButton importBtn;
    JButton clearDoneBtn;
    JButton clearFailedBtn;
    private int row;
    private int maxPlanes;
    public boolean cancel = false;
    public boolean importing = false;
    public boolean failedFiles;
    public boolean doneFiles;

    FileQueueTable() {
        Boolean debugBorders = false;
        int buttonSize = 40;
        String addIcon = "gfx/add.png";
        String removeIcon = "gfx/remove.png";
        int statusWidth = 100;
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createEmptyBorder(6, 5, 9, 8));
        JPanel buttonPanel = new JPanel();
        if (debugBorders.booleanValue()) {
            buttonPanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        this.addBtn = FileQueueTable.addButton(">>", addIcon, null);
        this.addBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.addBtn.setActionCommand("add");
        this.addBtn.addActionListener(this);
        this.removeBtn = FileQueueTable.addButton("<<", removeIcon, null);
        this.removeBtn.setMaximumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setPreferredSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setMinimumSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setSize(new Dimension(buttonSize, buttonSize));
        this.removeBtn.setActionCommand("remove");
        this.removeBtn.addActionListener(this);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(this.addBtn);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        buttonPanel.add(this.removeBtn);
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 60)));
        this.add(buttonPanel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel queuePanel = new JPanel();
        if (debugBorders.booleanValue()) {
            queuePanel.setBorder(BorderFactory.createLineBorder(Color.red, 1));
        }
        queuePanel.setLayout(new BoxLayout(queuePanel, 3));
        queuePanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 2));
        JLabel label = new JLabel("Import Queue:");
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        queuePanel.add(labelPanel);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        TableColumnModel cModel = this.queue.getColumnModel();
        MyTableHeaderRenderer myHeader = new MyTableHeaderRenderer();
        cModel.getColumn(0).setHeaderRenderer(myHeader);
        cModel.getColumn(1).setHeaderRenderer(myHeader);
        cModel.getColumn(2).setHeaderRenderer(myHeader);
        cModel.getColumn(0).setCellRenderer(new LeftDotRenderer());
        cModel.getColumn(1).setCellRenderer(new TextCellCenter());
        cModel.getColumn(2).setCellRenderer(new TextCellCenter());
        TableColumn statusColumn = this.queue.getColumnModel().getColumn(2);
        statusColumn.setPreferredWidth(statusWidth);
        statusColumn.setMaxWidth(statusWidth);
        statusColumn.setMinWidth(statusWidth);
        SelectionListener listener = new SelectionListener(this.queue);
        this.queue.getSelectionModel().addListSelectionListener(listener);
        TableColumnModel tcm = this.queue.getColumnModel();
        TableColumn datasetColumn = tcm.getColumn(3);
        tcm.removeColumn(datasetColumn);
        TableColumn pathColumn = tcm.getColumn(3);
        tcm.removeColumn(pathColumn);
        TableColumn archiveColumn = tcm.getColumn(3);
        tcm.removeColumn(archiveColumn);
        JScrollPane scrollPane = new JScrollPane(this.queue);
        queuePanel.add(scrollPane);
        JPanel importPanel = new JPanel();
        importPanel.setLayout(new BoxLayout(importPanel, 2));
        this.clearDoneBtn = FileQueueTable.addButton("Clear Done", null, null);
        this.clearFailedBtn = FileQueueTable.addButton("Clear Failed", null, null);
        this.importBtn = FileQueueTable.addButton("Import", null, null);
        importPanel.add(Box.createHorizontalGlue());
        importPanel.add(this.clearDoneBtn);
        this.clearDoneBtn.setEnabled(false);
        this.clearDoneBtn.setActionCommand("clear_done");
        this.clearDoneBtn.addActionListener(this);
        importPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        importPanel.add(this.clearFailedBtn);
        this.clearFailedBtn.setEnabled(false);
        this.clearFailedBtn.setActionCommand("clear_failed");
        this.clearFailedBtn.addActionListener(this);
        importPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        importPanel.add(this.importBtn);
        this.importBtn.setEnabled(false);
        this.importBtn.setActionCommand("import");
        this.importBtn.addActionListener(this);
        queuePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        queuePanel.add(importPanel);
        this.add(queuePanel);
    }

    public void setProgressInfo(int row, int maxPlanes) {
        this.row = row;
        this.maxPlanes = maxPlanes;
    }

    public void setProgressPending(int row) {
        if (this.table.getValueAt(row, 2).equals("added")) {
            this.table.setValueAt("pending", row, 2);
        }
    }

    public void setProgressInvalid(int row) {
        if (this.table.getValueAt(row, 2).equals("added")) {
            this.table.setValueAt("invalid format", row, 2);
        }
    }

    public void setImportProgress(int count, int series, int step) {
        String text = count > 1 ? String.valueOf(series + 1) + "/" + count + ": " + step + "/" + this.maxPlanes : String.valueOf(step) + "/" + this.maxPlanes;
        this.table.setValueAt(text, this.row, 2);
    }

    public void setProgressFailed(int row) {
        this.table.setValueAt("failed", row, 2);
        this.failedFiles = true;
        this.table.fireTableDataChanged();
    }

    public void setProgressUnknown(int row) {
        this.table.setValueAt("unknown format", row, 2);
        this.failedFiles = true;
        this.table.fireTableDataChanged();
    }

    public void setProgressPrepping(int row) {
        this.table.setValueAt("importing", row, 2);
    }

    public void setProgressDone(int row) {
        this.table.setValueAt("done", row, 2);
        this.doneFiles = true;
        this.table.fireTableDataChanged();
    }

    public void setProgressArchiving(int row) {
        this.table.setValueAt("archiving", row, 2);
    }

    public int getMaximum() {
        return this.maxPlanes;
    }

    static JButton addButton(String name, String image, String tooltip) {
        JButton button = null;
        if (image == null) {
            button = new JButton(name);
        } else {
            URL imgURL = Main.class.getResource(image);
            if (imgURL != null) {
                button = new JButton(null, new ImageIcon(imgURL));
            } else {
                button = new JButton(name);
                System.err.println("Couldn't find icon: " + image);
            }
        }
        return button;
    }

    public ImportContainer[] getFilesAndDataset() {
        int num = this.table.getRowCount();
        ImportContainer[] fads = new ImportContainer[num];
        int i = 0;
        while (i < num) {
            try {
                boolean archive = (Boolean)this.table.getValueAt(i, 5);
                File file = new File(this.table.getValueAt(i, 4).toString());
                Dataset dataset = (Dataset)this.table.getValueAt(i, 3);
                String imageName = this.table.getValueAt(i, 0).toString();
                fads[i] = new ImportContainer(file, dataset, imageName, archive);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return fads;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addBtn) {
            this.firePropertyChange("add", false, true);
        }
        if (src == this.removeBtn) {
            this.firePropertyChange("remove", false, true);
        }
        if (src == this.clearDoneBtn) {
            this.firePropertyChange("clear_done", false, true);
        }
        if (src == this.clearDoneBtn) {
            this.firePropertyChange("clear_failed", false, true);
        }
        if (src == this.importBtn) {
            this.queue.clearSelection();
            this.firePropertyChange("import", false, true);
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        FileQueueTable q = new FileQueueTable();
        JFrame f = new JFrame();
        f.getContentPane().add(q);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }

    class QueueTableModel
    extends DefaultTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 1L;
        private String[] columnNames = new String[]{"Files in Queue", "Project/Dataset", "Status", "DatasetNum", "Path", "Archive"};

        QueueTableModel() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public boolean rowSelectionAllowed() {
            return true;
        }
    }

    public class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBorder(BorderFactory.createLineBorder(new Color(0xE0E0E0)));
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
            this.setFont(UIManager.getFont("TableHeader.font"));
            this.setFont(this.getFont().deriveFont(1));
            this.setHorizontalAlignment(0);
            this.setText(value.toString());
            this.setOpaque(true);
            this.setToolTipText((String)value);
            this.setEnabled(table == null || table.isEnabled());
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    class LeftDotRenderer
    extends DefaultTableCellRenderer {
        LeftDotRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int availableWidth = table.getColumnModel().getColumn(column).getWidth();
            availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
            Insets borderInsets = this.getBorder().getBorderInsets(this);
            String cellText = this.getText();
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                String dots = "...";
                int textWidth = fm.stringWidth(dots);
                int nChars = cellText.length() - 1;
                while (nChars > 0) {
                    if ((textWidth += fm.charWidth(cellText.charAt(nChars))) > availableWidth) break;
                    --nChars;
                }
                this.setText(String.valueOf(dots) + cellText.substring(nChars + 1));
            }
            this.setFont(UIManager.getFont("TableCell.font"));
            if (FileQueueTable.this.queue.getValueAt(row, 2).equals("done")) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    public class TextCellCenter
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(UIManager.getFont("TableCell.font"));
            this.setHorizontalAlignment(0);
            this.setToolTipText((String)value);
            if (FileQueueTable.this.queue.getValueAt(row, 2).equals("done") || FileQueueTable.this.queue.getValueAt(row, 2).equals("failed")) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return this;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                this.dselectRows();
            }
        }

        private void dselectRows() {
            int rows = FileQueueTable.this.queue.getRowCount();
            int i = 0;
            while (i < rows) {
                try {
                    if (!FileQueueTable.this.queue.getValueAt(i, 2).equals("added") && !FileQueueTable.this.queue.getValueAt(i, 2).equals("pending") && this.table.getSelectionModel().isSelectedIndex(i)) {
                        this.table.getSelectionModel().removeSelectionInterval(i, i);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

