/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import loci.formats.ChannelSeparator;
import loci.formats.ImageReader;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.FileQueueChooser;
import ome.formats.importer.FileQueueTable;
import ome.formats.importer.ImportDialog;
import ome.formats.importer.ImportHandler;
import ome.formats.importer.Main;
import ome.formats.importer.OMEROWrapper;
import ome.model.containers.Dataset;

public class FileQueueHandler
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private Preferences userPrefs = Preferences.userNodeForPackage(Main.class);
    private String savedDirectory = this.userPrefs.get("savedDirectory", "");
    private ImportHandler importHandler;
    private OMEROMetadataStore store;
    public ImageReader iReader;
    public ChannelSeparator separator;
    private OMEROWrapper reader;
    private Main viewer;
    FileQueueChooser fileChooser = null;
    FileQueueTable qTable = null;
    File[] files = null;
    File file = null;
    int[] rows = null;

    FileQueueHandler(Main viewer) {
        this.viewer = viewer;
        this.reader = new OMEROWrapper();
        this.setLayout(new BorderLayout());
        this.fileChooser = new FileQueueChooser();
        this.fileChooser.addActionListener(this);
        this.fileChooser.addPropertyChangeListener(this);
        this.qTable = new FileQueueTable();
        this.qTable.addPropertyChangeListener(this);
        JSplitPane splitPane = new JSplitPane(1, this.fileChooser, this.qTable);
        this.add((Component)splitPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("ApproveSelection")) {
            this.file = this.fileChooser.getSelectedFile();
            this.store = this.viewer.loginHandler.getMetadataStore();
            if (this.store != null) {
                ImportDialog dialog = new ImportDialog(this.viewer, "Import", true, this.store);
                if (dialog.cancelled || dialog.dataset == null) {
                    return;
                }
                this.addFileToQueue(this.file, dialog.dataset, dialog.dataset.getName(), dialog.project.getName(), dialog.useFullPath, dialog.numOfDirectories, dialog.archiveImage.isSelected());
            } else {
                JOptionPane.showMessageDialog(this.viewer, "Due to an error the application is unable to \nretrieve an OMEROMetadataStore and cannot continue.The most likely cause for this error is that youare not logged in. Please try to login again.");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChange(PropertyChangeEvent e) {
        block25: {
            prop = e.getPropertyName();
            if (prop.equals("add")) {
                this.files = this.fileChooser.getSelectedFiles();
                this.store = this.viewer.loginHandler.getMetadataStore();
                fileSelected = false;
                var7_8 = this.files;
                var5_10 = 0;
                var6_12 = var7_8.length;
                while (var5_10 < var6_12) {
                    f = var7_8[var5_10];
                    if (f.isFile() && this.reader.isThisType(f.getName())) {
                        fileSelected = true;
                    }
                    ++var5_10;
                }
                if (!fileSelected.booleanValue()) {
                    JOptionPane.showMessageDialog(this.viewer, "You must select at least one importable file to\nadd to the import queue. Choose an image in the\nleft-hand panel first before continuing.");
                    return;
                }
                if (fileSelected.booleanValue() && this.store != null) {
                    dialog = new ImportDialog(this.viewer, "Import", true, this.store);
                    if (dialog.cancelled || dialog.dataset == null) {
                        return;
                    }
                    var8_16 = this.files;
                    var6_12 = 0;
                    var7_9 = var8_16.length;
                    while (var6_12 < var7_9) {
                        f = var8_16[var6_12];
                        if (f.isFile() && this.reader.isThisType(f.getName())) {
                            this.addFileToQueue(f, dialog.dataset, dialog.dataset.getName(), dialog.project.getName(), dialog.useFullPath, dialog.numOfDirectories, dialog.archiveImage.isSelected());
                        }
                        ++var6_12;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.viewer, "Due to an error the application is unable to \nretrieve an OMEROMetadataStore and cannot continue.The most likely cause for this error is that youare not logged in. Please try to login again.");
                }
            }
            if (!prop.equals("remove")) break block25;
            this.rows = this.qTable.queue.getSelectedRows();
            if (this.rows.length != 0) ** GOTO lbl41
            JOptionPane.showMessageDialog(this.viewer, "You must select at least one file in the queue to\nremove. Choose an image in the right-hand panel \nfirst before removing.");
            return;
lbl-1000:
            // 1 sources

            {
                if (this.qTable.queue.getValueAt(this.rows[0], 2) != "added" && this.qTable.queue.getValueAt(this.rows[0], 2) != "pending") continue;
                this.removeFileFromQueue(this.rows[0]);
                this.rows = this.qTable.queue.getSelectedRows();
lbl41:
                // 3 sources

                ** while (this.rows.length > 0)
            }
        }
        if (prop.equals("clear_done")) {
            numRows = this.qTable.queue.getRowCount();
            i = numRows - 1;
            while (i >= 0) {
                if (this.qTable.queue.getValueAt(i, 2) == "done") {
                    this.removeFileFromQueue(i);
                }
                --i;
            }
            this.qTable.clearDoneBtn.setEnabled(false);
        }
        if (prop.equals("clear_failed")) {
            numRows = this.qTable.queue.getRowCount();
            i = numRows - 1;
            while (i >= 0) {
                if (this.qTable.queue.getValueAt(i, 2) == "failed") {
                    this.removeFileFromQueue(i);
                }
                --i;
            }
            this.qTable.clearFailedBtn.setEnabled(false);
        }
        if (prop.equals("import")) {
            this.qTable.clearDoneBtn.setEnabled(false);
            this.qTable.clearFailedBtn.setEnabled(false);
            try {
                if (!this.qTable.importing) {
                    fads = this.qTable.getFilesAndDataset();
                    if (fads != null) {
                        this.store = this.viewer.loginHandler.getMetadataStore();
                        if (this.store != null) {
                            this.importHandler = new ImportHandler(this.viewer, this.qTable, this.store, this.reader, fads);
                        }
                    }
                    this.qTable.importing = true;
                    this.qTable.queue.setRowSelectionAllowed(false);
                    this.qTable.removeBtn.setEnabled(false);
                } else {
                    this.qTable.cancel = true;
                    this.qTable.importing = false;
                    this.qTable.importBtn.setText("Wait...");
                    this.qTable.importBtn.setEnabled(false);
                    this.viewer.statusBar.setStatusIcon("gfx/import_cancelling_16.png", "Cancelling import... please wait.");
                    JOptionPane.showMessageDialog(this.viewer, "You import will be cancelled after the current file has finished importing.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (prop.equals("directoryChanged")) {
            this.savedDirectory = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            this.userPrefs.put("savedDirectory", this.savedDirectory);
        }
        if (prop.equals("refresh")) {
            this.fileChooser.setVisible(false);
            this.fileChooser.rescanCurrentDirectory();
            this.fileChooser.setVisible(true);
        }
    }

    private void addFileToQueue(File file, Dataset dataset, String dName, String project, Boolean useFullPath, int numOfDirectories, boolean archiveImage) {
        Vector<Object> row = new Vector<Object>();
        String imageName = this.getImageName(file, useFullPath, numOfDirectories);
        row.add(imageName);
        row.add(String.valueOf(project) + "/" + dName);
        row.add("added");
        row.add(dataset);
        row.add(file);
        row.add(archiveImage);
        this.qTable.table.addRow(row);
        if (this.qTable.table.getRowCount() == 1) {
            this.qTable.importBtn.setEnabled(true);
        }
    }

    private String getImageName(File file, Boolean useFullPath, int numOfDirectories) {
        String path = file.getAbsolutePath().replace('\\', '/');
        if (useFullPath.booleanValue()) {
            return path;
        }
        if (numOfDirectories == 0) {
            return file.getName();
        }
        String[] directories = this.splitDirectories(path);
        if (numOfDirectories > directories.length - 1) {
            numOfDirectories = directories.length - 1;
        }
        int start = directories.length - numOfDirectories - 1;
        String fileName = "";
        int i = start;
        while (i < directories.length - 1) {
            if (directories[i].length() != 0) {
                fileName = i == start ? directories[i] : String.valueOf(fileName) + "/" + directories[i];
            }
            ++i;
        }
        fileName = String.valueOf(fileName) + "/" + file.getName();
        return fileName;
    }

    private String[] splitDirectories(String path) {
        String[] fields = path.split("/");
        Integer length = fields.length;
        return fields;
    }

    private void removeFileFromQueue(int row) {
        this.qTable.table.removeRow(row);
        if (this.qTable.table.getRowCount() == 0) {
            this.qTable.importBtn.setEnabled(false);
        }
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        FileQueueHandler fqh = new FileQueueHandler(null);
        JFrame f = new JFrame();
        f.getContentPane().add(fqh);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }
}

