/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import layout.TableLayout;
import loci.formats.ImageReader;
import loci.formats.gui.ComboFileFilter;
import loci.formats.gui.GUITools;
import ome.formats.importer.Main;

public class FileQueueChooser
extends JFileChooser
implements ActionListener {
    boolean DEBUG = false;
    private static final long serialVersionUID = 1L;
    private Preferences userPrefs = Preferences.userNodeForPackage(Main.class);
    private String savedDirectory = this.userPrefs.get("savedDirectory", "");
    private String laf = UIManager.getLookAndFeel().getClass().getName();
    private Component[] fileListObjects;
    private Component fileList = null;
    ImageReader reader = new ImageReader();
    JButton refreshBtn;

    FileQueueChooser() {
        try {
            JPanel fp = null;
            JToolBar tb = null;
            String refreshIcon = "gfx/recycled12.png";
            this.refreshBtn = FileQueueChooser.addButton("Refresh ", refreshIcon, null);
            this.refreshBtn.setActionCommand("refresh");
            this.refreshBtn.addActionListener(this);
            JPanel panel = new JPanel();
            double[][] mainTable = new double[][]{{10.0, -1.0, -2.0, -1.0, 10.0}, {-2.0}};
            TableLayout tl = new TableLayout((double[][])mainTable);
            panel.setLayout((LayoutManager)tl);
            if (this.DEBUG) {
                try {
                    Component[] components = this.getComponents();
                    Component component = null;
                    System.err.println("Components: " + components.length);
                    int i = 0;
                    while (i < components.length) {
                        component = components[i];
                        System.err.println("Component " + i + " = " + component.getClass());
                        ++i;
                    }
                }
                catch (Exception components) {
                    // empty catch block
                }
            }
            if (this.laf.contains("AquaLookAndFeel")) {
                fp = (JPanel)this.getComponent(1);
                fp.setLayout(new BoxLayout(fp, 0));
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("QuaquaLookAndFeel")) {
                fp = (JPanel)this.getComponent(1);
                panel.add((Component)this.refreshBtn, "1,0,c,c");
                panel.add(fp.getComponent(0), "2,0,c,c");
                fp.add((Component)panel, "North");
            } else if (this.laf.contains("Windows")) {
                try {
                    tb = (JToolBar)this.getComponent(1);
                    this.refreshBtn.setToolTipText("Refresh");
                    this.refreshBtn.setText(null);
                    tb.add((Component)this.refreshBtn, 8);
                }
                catch (Exception components) {}
            } else if (this.laf.contains("MetalLookAndFeel")) {
                JPanel prefp = (JPanel)this.getComponent(0);
                fp = (JPanel)prefp.getComponent(0);
                this.refreshBtn.setToolTipText("Refresh");
                this.refreshBtn.setText(null);
                Dimension size = new Dimension(24, 24);
                this.refreshBtn.setMaximumSize(size);
                this.refreshBtn.setPreferredSize(size);
                this.refreshBtn.setMinimumSize(size);
                this.refreshBtn.setSize(size);
                fp.add(Box.createRigidArea(new Dimension(5, 0)));
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("GTKLookAndFeel")) {
                fp = (JPanel)this.getComponent(0);
                this.refreshBtn.setIcon(null);
                fp.add(this.refreshBtn);
            } else if (this.laf.contains("MotifLookAndFeel")) {
                fp = (JPanel)this.getComponent(0);
                fp.add(this.refreshBtn);
            }
            if (fp != null && this.DEBUG) {
                fp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), fp.getBorder()));
                System.err.println(fp.getLayout());
            }
            if (tb != null && this.DEBUG) {
                tb.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), tb.getBorder()));
                System.err.println(tb.getLayout());
            }
        }
        catch (ArrayIndexOutOfBoundsException fp) {
            // empty catch block
        }
        if (this.savedDirectory.equals("") || !new File(this.savedDirectory).exists()) {
            this.setCurrentDirectory(this.getFileSystemView().getHomeDirectory());
        } else {
            this.setCurrentDirectory(new File(this.savedDirectory));
        }
        this.setControlButtonsAreShown(false);
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(true);
        this.setDragEnabled(true);
        int readerFFSize = GUITools.buildFileFilters(this.reader).length;
        this.setAcceptAllFileFilterUsed(false);
        FileFilter[] ff = new FileFilter[readerFFSize + 6];
        System.arraycopy(ComboFileFilter.sortFilters(GUITools.buildFileFilters(this.reader)), 0, ff, 0, readerFFSize);
        ff[readerFFSize] = new DashFileFilter();
        ff[readerFFSize + 1] = new R3DNewFileFilter();
        ff[readerFFSize + 2] = new R3DOldFileFilter();
        ff[readerFFSize + 3] = new D3DNewFileFilter();
        ff[readerFFSize + 4] = new D3DOldFileFilter();
        ff[readerFFSize + 5] = new D3DNPrjFileFilter();
        FileFilter[] comboFF = new FileFilter[readerFFSize];
        System.arraycopy(ComboFileFilter.sortFilters(GUITools.buildFileFilters(this.reader)), 0, comboFF, 0, readerFFSize);
        ComboFileFilter combo = null;
        if (comboFF.length > 1) {
            combo = new ComboFileFilter(comboFF, "All supported file types");
            this.addChoosableFileFilter(combo);
        }
        int i = 0;
        while (i < ff.length) {
            this.addChoosableFileFilter(ff[i]);
            ++i;
        }
        if (combo != null) {
            this.setFileFilter(combo);
        }
        this.fileListObjects = this.getFileListObjects(this);
        if (this.fileListObjects.length > 0 && !this.laf.contains("Windows")) {
            this.fileList = this.fileListObjects[0];
            MouseCommand mc = new MouseCommand();
            this.fileList.addMouseListener(mc);
        }
    }

    protected Component[] getFileListObjects(JFileChooser fc) {
        Vector<Component> v = new Vector<Component>();
        Stack<Component> s = new Stack<Component>();
        s.push(fc);
        while (!s.isEmpty()) {
            Component c = (Component)s.pop();
            if (!(c instanceof Container)) continue;
            Container d = (Container)c;
            int i = 0;
            while (i < d.getComponentCount()) {
                if (d.getComponent(i) instanceof JTable) {
                    v.add(d.getComponent(i));
                } else {
                    s.push(d.getComponent(i));
                }
                ++i;
            }
        }
        Component[] arr = new Component[v.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = (Component)v.get(i);
            ++i;
        }
        return arr;
    }

    static JButton addButton(String name, String image, String tooltip) {
        JButton button = null;
        if (image == null) {
            button = new JButton(name);
        } else {
            URL imgURL = Main.class.getResource(image);
            if (imgURL != null) {
                button = new JButton(name, new ImageIcon(imgURL));
            } else {
                button = new JButton(name);
                System.err.println("Couldn't find icon: " + image);
            }
        }
        return button;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshBtn) {
            this.setVisible(false);
        }
        this.rescanCurrentDirectory();
        this.setVisible(true);
    }

    public static void main(String[] args) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        System.err.println(laf);
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            System.err.println(String.valueOf(laf) + " not supported.");
        }
        System.err.println("laf: " + UIManager.getLookAndFeel());
        FileQueueChooser c = new FileQueueChooser();
        JFrame f = new JFrame();
        c.setMultiSelectionEnabled(true);
        f.getContentPane().add(c);
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
        f.pack();
    }

    class MouseCommand
    implements MouseListener {
        MouseCommand() {
        }

        public void mousePressed(MouseEvent evt) {
            Object src = evt.getSource();
            if (src == FileQueueChooser.this.fileList) {
                if (evt.getModifiers() != 16) {
                    return;
                }
                File[] arr = FileQueueChooser.this.getSelectedFiles();
                if (evt.getClickCount() > 1 && arr.length == 1 && arr[0].isFile()) {
                    FileQueueChooser.this.approveSelection();
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }
    }

    class DashFileFilter
    extends FileFilter {
        DashFileFilter() {
        }

        public boolean accept(File f) {
            return true;
        }

        public String getDescription() {
            return "-------------------------";
        }
    }

    class R3DNewFileFilter
    extends FileFilter {
        R3DNewFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("r3d.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Raw (*R3D.dv)";
        }
    }

    class D3DNewFileFilter
    extends FileFilter {
        D3DNewFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("r3d_d3d.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Decon'd (*r3d_d3d.dv)";
        }
    }

    class R3DOldFileFilter
    extends FileFilter {
        R3DOldFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".r3d");
        }

        public String getDescription() {
            return "Deltavision Files - Raw (*.r3d)";
        }
    }

    class D3DOldFileFilter
    extends FileFilter {
        D3DOldFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".r3d_d3d");
        }

        public String getDescription() {
            return "Deltavision Files - Decon'd (*.r3d_d3d)";
        }
    }

    class D3DNPrjFileFilter
    extends FileFilter {
        D3DNPrjFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("_prj.dv");
        }

        public String getDescription() {
            return "Deltavision Files - Projected (*_prj.dv)";
        }
    }
}

