/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import ome.formats.importer.util.GuiCommonElements;
import ome.formats.importer.util.HtmlMessenger;

public class CommentMessenger
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -894653530593047377L;
    boolean debug = false;
    String url = "http://users.openmicroscopy.org.uk/~brain/omero/commentcollector.php";
    GuiCommonElements gui = new GuiCommonElements();
    JPanel mainPanel;
    JPanel commentPanel;
    JPanel debugPanel;
    JButton sendBtn;
    JButton cancelBtn;
    JButton copyBtn;
    JTextField emailTextField;
    String emailText = "";
    JTextArea commentTextArea;
    String commentText = "";

    CommentMessenger(JFrame owner, String title, Boolean modal) {
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(680, 400));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = this.gui.addButton(this.mainPanel, "Cancel", 67, "Cancel your message", "1, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.sendBtn = this.gui.addButton(this.mainPanel, "Send", 83, "Send your comment to the development team", "3, 1, f, c", this.debug);
        this.sendBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.sendBtn);
        this.gui.enterPressesWhenFocused(this.sendBtn);
        Icon questionIcon = UIManager.getIcon("OptionPane.questionIcon");
        int iconSpace = 0;
        if (questionIcon != null) {
            iconSpace = questionIcon.getIconWidth() + 20;
        }
        double[][] commentTable = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {90.0, 30.0, -1.0}};
        this.commentPanel = this.gui.addMainPanel(this, commentTable, 10, 10, 10, 10, this.debug);
        String message = "Thank you for taking the time to send us your comments. \n\nYour feedback will be used to futher the developmment of the importer and improve our software. Any personal details you provide are purely optional, and will only be used for development purposes.";
        JLabel iconLabel = new JLabel(questionIcon);
        this.commentPanel.add((Component)iconLabel, "0,0, l, c");
        JTextPane instructions = this.gui.addTextPane(this.commentPanel, message, "1,0,2,0", this.debug);
        this.emailTextField = this.gui.addTextField(this.commentPanel, "Email: ", this.emailText, 69, "Input tyour email address here.", "(Optional)", -2.0, "0, 1, 2, 1", this.debug);
        this.commentTextArea = this.gui.addTextArea(this.commentPanel, "Comment:", "", 87, "0, 2, 2, 2", this.debug);
        this.mainPanel.add((Component)this.commentPanel, "0, 0, 4, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.sendBtn) {
            this.emailText = this.emailTextField.getText();
            this.commentText = this.commentTextArea.getText();
            this.sendRequest(this.emailText, this.commentText, "Extra data goes here.");
        }
        if (source == this.cancelBtn) {
            this.dispose();
        }
    }

    private void sendRequest(String email, String comment, String extra) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        map.put("comment", comment);
        map.put("extra", extra);
        map.put("type", "importer_comments");
        map.put("java_version", System.getProperty("java.version"));
        map.put("java_class_path", System.getProperty("java.class.path"));
        map.put("os_name", System.getProperty("os.name"));
        map.put("os_arch", System.getProperty("os.arch"));
        map.put("os_version", System.getProperty("os.version"));
        try {
            HtmlMessenger messenger = new HtmlMessenger(this.url, map);
            String serverReply = messenger.executePost();
            JOptionPane.showMessageDialog(this, serverReply);
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Sorry, but due to an error we were not able to automatically \nsend your comment information. \n\nYou can still send us your comments by emailing us at \ncomments@openmicroscopy.org.uk.");
        }
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        new CommentMessenger(null, "Comment Dialog Test", (Boolean)true);
    }
}

