/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import ome.api.IUpdate;
import ome.formats.OMEROMetadataStore;
import ome.formats.importer.ImportDialog;
import ome.formats.importer.util.GuiCommonElements;
import ome.model.IObject;
import ome.model.containers.Project;

public class AddProjectDialog
extends JDialog
implements ActionListener {
    boolean debug = false;
    private Preferences userPrefs = Preferences.userNodeForPackage(ImportDialog.class);
    GuiCommonElements gui;
    Window owner;
    JPanel mainPanel;
    JPanel internalPanel;
    JButton OKBtn;
    JButton cancelBtn;
    JTextField nameField;
    JTextArea descriptionArea;
    String projectName;
    String projectDescription;
    Project project;
    OMEROMetadataStore store;

    AddProjectDialog(Window owner, String title, Boolean modal, OMEROMetadataStore store) {
        this.store = store;
        this.owner = owner;
        this.gui = new GuiCommonElements();
        this.setDefaultCloseOperation(2);
        this.setTitle(title);
        this.setModal(modal);
        this.setResizable(true);
        this.setSize(new Dimension(480, 300));
        this.setLocationRelativeTo(owner);
        double[][] mainTable = new double[][]{{-1.0, 100.0, 5.0, 100.0, 10.0}, {-1.0, 40.0}};
        this.mainPanel = this.gui.addMainPanel(this, mainTable, 10, 10, 10, 10, this.debug);
        this.cancelBtn = this.gui.addButton(this.mainPanel, "Cancel", 67, "Cancel adding a project", "1, 1, f, c", this.debug);
        this.cancelBtn.addActionListener(this);
        this.OKBtn = this.gui.addButton(this.mainPanel, "OK", 79, "Accept your new project", "3, 1, f, c", this.debug);
        this.OKBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.OKBtn);
        this.gui.enterPressesWhenFocused(this.OKBtn);
        double[][] internalTable = new double[][]{{160.0, -1.0}, {30.0, 30.0, -1.0}};
        this.internalPanel = this.gui.addMainPanel(this, internalTable, 10, 10, 10, 10, this.debug);
        String message = "Please enter your project name and an optional description below.";
        JTextPane instructions = this.gui.addTextPane(this.internalPanel, message, "0,0,1,0", this.debug);
        this.nameField = this.gui.addTextField(this.internalPanel, "Project Name: ", "", 69, "Input tyour email address here.", "", -2.0, "0, 1, 1, 1", this.debug);
        this.descriptionArea = this.gui.addTextArea(this.internalPanel, "Description: (optional)", "", 87, "0, 2, 1, 2", this.debug);
        this.mainPanel.add((Component)this.internalPanel, "0, 0, 4, 0");
        this.add((Component)this.mainPanel, "Center");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.OKBtn) {
            this.projectName = this.nameField.getText();
            this.projectDescription = this.descriptionArea.getText();
            if (this.projectName.trim().length() > 0) {
                this.project = this.addProject(this.projectName, this.projectDescription);
                this.userPrefs.putLong("savedProject", this.project.getId());
                this.dispose();
            } else {
                JOptionPane.showMessageDialog(this.owner, "The project's name can not be blank.");
            }
        }
        if (source == this.cancelBtn) {
            this.dispose();
        }
    }

    private Project addProject(String name, String description) {
        this.project = new Project();
        if (name.length() != 0) {
            this.project.setName(name);
        }
        if (description.length() != 0) {
            this.project.setDescription(description);
        }
        Project storedProject = null;
        if (this.store != null) {
            IUpdate iUpdate = this.store.getIUpdate();
            storedProject = (Project)iUpdate.saveAndReturnObject((IObject)this.project);
            return storedProject;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String laf = UIManager.getSystemLookAndFeelClassName();
        if (laf.equals("apple.laf.AquaLookAndFeel")) {
            System.setProperty("Quaqua.design", "panther");
            try {
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        } else {
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (Exception e) {
                System.err.println(String.valueOf(laf) + " not supported.");
            }
        }
        new AddProjectDialog(null, "Add a Project", (Boolean)true, null);
    }
}

