/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import ome.formats.importer.SplashWindow;
import ome.formats.importer.Splasher;

public abstract class About {
    private static String title;
    private static String msg;

    public static void show(Component c, boolean useSplashScreen) {
        if (useSplashScreen) {
            SplashWindow.splash(Splasher.class.getResource("gfx/importer_splash.png"));
        } else {
            if (title == null) {
                StringBuffer sb = new StringBuffer();
                try {
                    InputStream is = About.class.getResourceAsStream("about.txt");
                    if (is == null) {
                        title = "About";
                        msg = "Error: version information not found";
                    } else {
                        String line;
                        BufferedReader in = new BufferedReader(new InputStreamReader(is));
                        while ((line = in.readLine()) != null) {
                            if (title == null) {
                                title = "About " + line;
                            } else {
                                sb.append("\n");
                            }
                            sb.append(line);
                        }
                        in.close();
                        msg = sb.toString();
                    }
                }
                catch (IOException exc) {
                    if (title == null) {
                        title = "About";
                    }
                    msg = "Error: could not read version information";
                }
            }
            if ("OMERO.importer" != null) {
                title = "About OMERO.importer";
            }
            JOptionPane.showMessageDialog(c, msg, title, 1);
        }
    }

    public static void main(String[] args) {
        About.show(null, false);
        System.exit(0);
    }
}

