/*
 * Decompiled with CFR 0.152.
 */
package ome.formats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import loci.formats.MetadataStore;
import loci.formats.MetadataStoreException;
import ome.api.IQuery;
import ome.api.IRepositoryInfo;
import ome.api.IUpdate;
import ome.api.RawFileStore;
import ome.api.RawPixelsStore;
import ome.formats.EnumerationException;
import ome.model.IObject;
import ome.model.acquisition.StageLabel;
import ome.model.containers.Dataset;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.Project;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import ome.model.core.PlaneInfo;
import ome.model.enums.AcquisitionMode;
import ome.model.enums.DimensionOrder;
import ome.model.enums.Format;
import ome.model.enums.PhotometricInterpretation;
import ome.model.enums.PixelsType;
import ome.model.meta.Experimenter;
import ome.model.stats.StatsInfo;
import ome.parameters.Parameters;
import ome.system.Login;
import ome.system.Server;
import ome.system.ServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMEROMetadataStore
implements MetadataStore {
    private static Log log = LogFactory.getLog(OMEROMetadataStore.class);
    private ServiceFactory sf;
    private RawPixelsStore pservice;
    private IQuery iQuery;
    private IUpdate iUpdate;
    private IRepositoryInfo iInfo;
    private ArrayList<Pixels> pixelsList = new ArrayList();
    private Experimenter exp;
    private RawFileStore rawFileStore;

    public OMEROMetadataStore(String username, String password, String host, String port) throws MetadataStoreException {
        String maskedPswd = "";
        if (password == null) {
            password = new String("");
        }
        maskedPswd = password.length() > 0 ? "<" + password.length() + "chars>" : "<empty>";
        log.debug((Object)String.format("Initializing store: %s/%s %s:%s", username, maskedPswd, host, port));
        try {
            Server server = new Server(host, Integer.parseInt(port));
            Login login = new Login(username, password);
            this.sf = new ServiceFactory(server, login);
            this.iQuery = this.sf.getQueryService();
            this.iUpdate = this.sf.getUpdateService();
            this.pservice = this.sf.createRawPixelsStore();
            this.rawFileStore = this.sf.createRawFileStore();
            this.iInfo = this.sf.getRepositoryInfoService();
            this.exp = (Experimenter)this.iQuery.findByString(Experimenter.class, "omeName", username);
        }
        catch (Throwable t) {
            throw new MetadataStoreException(t);
        }
    }

    public OMEROMetadataStore(ServiceFactory factory) throws MetadataStoreException {
        if (factory == null) {
            throw new MetadataStoreException("Factory argument cannot be null.");
        }
        this.sf = factory;
        try {
            this.iQuery = this.sf.getQueryService();
            this.iUpdate = this.sf.getUpdateService();
            this.pservice = this.sf.createRawPixelsStore();
        }
        catch (Throwable t) {
            throw new MetadataStoreException(t);
        }
    }

    @Override
    public Object getRoot() {
        return this.pixelsList;
    }

    public Pixels getPixels(Integer series) {
        if (series == null) {
            series = 0;
        }
        this.resizePixelsArray(series);
        Pixels p = this.pixelsList.get(series);
        if (p == null) {
            p = new Pixels();
            this.pixelsList.set(series, p);
        }
        return p;
    }

    @Override
    public void setRoot(Object root) throws IllegalArgumentException {
        if (!(root instanceof List)) {
            throw new IllegalArgumentException("'root' object of type '" + root.getClass() + "' must be of type 'ome.model.core.Pixels'");
        }
        this.pixelsList = (ArrayList)root;
    }

    @Override
    public void createRoot() {
        this.pixelsList = new ArrayList();
    }

    private IObject getEnumeration(Class<? extends IObject> klass, String value) {
        if (klass == null) {
            throw new NullPointerException("Expecting not-null klass.");
        }
        if (value == null) {
            return null;
        }
        IObject enumeration = this.iQuery.findByString(klass, "value", value);
        if (enumeration == null) {
            throw new EnumerationException("Problem finding enumeration: ", klass, value);
        }
        return enumeration;
    }

    @Override
    public void setImage(String name, String creationDate, String description, Integer series) {
        log.debug((Object)String.format("Setting Image: name (%s), creationDate (%s), description (%s)", name, creationDate, description));
        Image image = new Image();
        image.setName(name);
        image.setDescription(description);
        this.getPixels(series).setImage(image);
    }

    @Override
    public void setExperimenter(String firstName, String lastName, String email, String institution, String dataDirectory, Object group, Integer i) {
    }

    @Override
    public void setGroup(String name, Object leader, Object contact, Integer i) {
    }

    @Override
    public void setInstrument(String manufacturer, String model, String serialNumber, String type, Integer i) {
    }

    @Override
    public void setDimensions(Float pixelSizeX, Float pixelSizeY, Float pixelSizeZ, Float pixelSizeC, Float pixelSizeT, Integer i) {
        log.debug((Object)String.format("Setting Dimensions: pixelSizeX (%f), pixelSizeY (%f), pixelSizeZ (%f), pixelSizeC (%f), pixelSizeT (%f)", pixelSizeX, pixelSizeY, pixelSizeZ, pixelSizeC, pixelSizeT));
        PixelsDimensions dimensions = new PixelsDimensions();
        if (pixelSizeX == null || pixelSizeX.floatValue() <= 0.0f) {
            log.warn((Object)"pixelSizeX is <= 0.0f, setting to 1.0f");
            pixelSizeX = Float.valueOf(1.0f);
        }
        if (pixelSizeY == null || pixelSizeY.floatValue() <= 0.0f) {
            log.warn((Object)"pixelSizeY is <= 0.0f, setting to 1.0f");
            pixelSizeY = Float.valueOf(1.0f);
        }
        if (pixelSizeZ == null || pixelSizeZ.floatValue() <= 0.0f) {
            log.warn((Object)"pixelSizeZ is <= 0.0f, setting to 1.0f");
            pixelSizeZ = Float.valueOf(1.0f);
        }
        dimensions.setSizeX(pixelSizeX);
        dimensions.setSizeY(pixelSizeY);
        dimensions.setSizeZ(pixelSizeZ);
        this.getPixels(i).setPixelsDimensions(dimensions);
    }

    @Override
    public void setDisplayROI(Integer x0, Integer y0, Integer z0, Integer x1, Integer y1, Integer z1, Integer t0, Integer t1, Object displayOptions, Integer i) {
    }

    @Override
    public void setPixels(Integer sizeX, Integer sizeY, Integer sizeZ, Integer sizeC, Integer sizeT, Integer pixelType, Boolean bigEndian, String dimensionOrder, Integer imageIndex, Integer pixelsIndex) {
        PixelsType type = null;
        String pixTypeString = "";
        switch (pixelType) {
            case 0: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "int8");
                pixTypeString = "int8";
                break;
            }
            case 1: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "uint8");
                pixTypeString = "uint8";
                break;
            }
            case 2: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "int16");
                pixTypeString = "int16";
                break;
            }
            case 3: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "uint16");
                pixTypeString = "uint16";
                break;
            }
            case 4: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "int32");
                pixTypeString = "int32";
                break;
            }
            case 5: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "uint32");
                pixTypeString = "uint32";
                break;
            }
            case 6: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "float");
                pixTypeString = "float";
                break;
            }
            case 7: {
                type = (PixelsType)this.getEnumeration(PixelsType.class, "double");
                pixTypeString = "double";
                break;
            }
            default: {
                new RuntimeException("Unknown pixelType enumeration: " + pixelType);
            }
        }
        log.debug((Object)String.format("Setting Pixels: x (%d), y (%d), z (%d), c (%d), t (%d), PixelType (%s), BigEndian? (%b), dimemsionOrder (%s)", sizeX, sizeY, sizeZ, sizeC, sizeT, pixTypeString, bigEndian, dimensionOrder));
        DimensionOrder order = (DimensionOrder)this.getEnumeration(DimensionOrder.class, dimensionOrder);
        Pixels pixels = this.getPixels(imageIndex);
        pixels.setSha1("foo");
        pixels.setSizeX(sizeX);
        pixels.setSizeY(sizeY);
        pixels.setSizeZ(sizeZ);
        pixels.setSizeC(sizeC);
        pixels.setSizeT(sizeT);
        pixels.setPixelsType(type);
        pixels.setDimensionOrder(order);
        pixels.setDefaultPixels(Boolean.TRUE);
    }

    private void resizePixelsArray(int series) {
        int currentSize = this.pixelsList.size();
        if (series + 1 > currentSize) {
            int i = 0;
            while (i < series + 1 - currentSize) {
                this.pixelsList.add(null);
                ++i;
            }
        }
    }

    @Override
    public void setStageLabel(String name, Float x, Float y, Float z, Integer i) {
        log.debug((Object)String.format("Setting StageLabel: name (%s), x (%f), y (%f), z (%f)", name, x, y, z));
        if (name == null || x == null || y == null || z == null) {
            log.warn((Object)String.format("StageLabel has null value(s): name (%s), x (%f), y (%f), z (%f)", name, x, y, z));
            return;
        }
        StageLabel stageLabel = new StageLabel();
        stageLabel.setName(name);
        stageLabel.setPositionX(x);
        stageLabel.setPositionY(y);
        stageLabel.setPositionZ(z);
        this.getPixels(i).getImage().setPosition(stageLabel);
    }

    @Override
    public void setLogicalChannel(int channelIdx, String name, Float ndFilter, Integer emWave, Integer exWave, String photometricInterpretation, String mode, Integer series) {
        log.debug((Object)String.format("Setting LogicalChannel: channelIdx (%d), name (%s), ndFilter (%f), emWave (%d), exWave (%d), photometicInterpretation (%s), mode (%s)", channelIdx, name, ndFilter, emWave, exWave, photometricInterpretation, mode));
        PhotometricInterpretation pi = (PhotometricInterpretation)this.getEnumeration(PhotometricInterpretation.class, photometricInterpretation);
        AcquisitionMode acquisitionMode = (AcquisitionMode)this.getEnumeration(AcquisitionMode.class, mode);
        Pixels pixels = this.getPixels(series);
        List<Channel> channels = pixels.getChannels();
        Channel channel = new Channel();
        if (channels.size() == 0) {
            channels = this.initChannels(series);
        } else if (channels.size() != pixels.getSizeC().intValue()) {
            log.warn((Object)String.format("channels.size() (%d) is not equal to pixels.getChannels().size() (%d) Resetting channel array.", channels.size(), pixels.getSizeC()));
            channels = this.initChannels(series);
        }
        channels.set(channelIdx, channel);
        LogicalChannel lchannel = new LogicalChannel();
        lchannel.setEmissionWave(emWave);
        lchannel.setExcitationWave(exWave);
        lchannel.setName(name);
        lchannel.setNdFilter(ndFilter);
        lchannel.setPhotometricInterpretation(pi);
        lchannel.setMode(acquisitionMode);
        channel.setLogicalChannel(lchannel);
        pixels.setChannels(channels);
    }

    private List<Channel> initChannels(Integer i) {
        Pixels pixels = this.getPixels(i);
        ArrayList<Channel> channels = new ArrayList<Channel>(pixels.getSizeC());
        int j = 0;
        while (j < pixels.getSizeC()) {
            channels.add(null);
            ++j;
        }
        return channels;
    }

    @Override
    public void setChannelGlobalMinMax(int channelIdx, Double globalMin, Double globalMax, Integer i) {
        List channels;
        log.debug((Object)String.format("Setting GlobalMin: '%f' GlobalMax: '%f' for channel: '%d'", globalMin, globalMax, channelIdx));
        if (globalMin != null) {
            globalMin = new Double(Math.floor(globalMin));
        }
        if (globalMax != null) {
            globalMax = new Double(Math.ceil(globalMax));
        }
        if ((channels = this.getPixels(i).getChannels()).size() < channelIdx) {
            throw new IndexOutOfBoundsException("No such channel index: " + channelIdx);
        }
        Channel channel = (Channel)channels.get(channelIdx);
        StatsInfo statsInfo = new StatsInfo();
        statsInfo.setGlobalMin(globalMin);
        statsInfo.setGlobalMax(globalMax);
        channel.setStatsInfo(statsInfo);
    }

    @Override
    public void setPlaneInfo(int z, int c, int t, Float timestamp, Float exposureTime, Integer i) {
        PlaneInfo pi = new PlaneInfo();
        pi.setTheZ(Integer.valueOf(z));
        pi.setTheC(Integer.valueOf(c));
        pi.setTheT(Integer.valueOf(t));
        pi.setTimestamp(timestamp);
        pi.setExposureTime(exposureTime);
        this.getPixels(i).addPlaneInfo(pi);
    }

    @Override
    public void setDefaultDisplaySettings(Integer i) {
    }

    public void setPlane(Long id, byte[] pixels, int theZ, int theC, int theT) {
        if (this.pservice == null) {
            this.pservice = this.sf.createRawPixelsStore();
        }
        this.pservice.setPixelsId(id.longValue());
        this.pservice.setPlane(pixels, Integer.valueOf(theZ), Integer.valueOf(theC), Integer.valueOf(theT));
    }

    public void setStack(Long id, byte[] pixels, int theC, int theT) {
        if (this.pservice == null) {
            this.pservice = this.sf.createRawPixelsStore();
        }
        this.pservice.setPixelsId(id.longValue());
        this.pservice.setStack(pixels, Integer.valueOf(theT), Integer.valueOf(theC), Integer.valueOf(theT));
    }

    public void addPixelsToDataset(Long pixId, Dataset dataset) {
        Pixels pixels = (Pixels)this.iQuery.get(Pixels.class, pixId.longValue());
        Image unloadedImage = new Image(pixels.getImage().getId());
        unloadedImage.unload();
        Dataset unloadedDataset = new Dataset(dataset.getId());
        unloadedDataset.unload();
        DatasetImageLink link = new DatasetImageLink();
        link.setParent((IObject)unloadedDataset);
        link.setChild((IObject)unloadedImage);
        this.iUpdate.saveObject((IObject)link);
    }

    public List<Dataset> getDatasets(Project project) {
        List l = this.iQuery.findAllByQuery("from Dataset where id in (select link.child.id from ProjectDatasetLink link where link.parent.id = :id)", new Parameters().addId(project.getId()));
        return l;
    }

    public List<Project> getProjects() {
        List l = this.iQuery.findAllByQuery("from Project as p left join fetch p.datasetLinks where p.details.owner.id = :id", new Parameters().addId(this.exp.getId()));
        return l;
    }

    public ArrayList<Pixels> saveToDB() {
        IUpdate update = this.sf.getUpdateService();
        Pixels[] pixelsArray = this.pixelsList.toArray(new Pixels[this.pixelsList.size()]);
        IObject[] o = update.saveAndReturnArray((IObject[])pixelsArray);
        int i = 0;
        while (i < o.length) {
            this.pixelsList.set(i, (Pixels)o[i]);
            ++i;
        }
        return this.pixelsList;
    }

    public ServiceFactory getSF() {
        return this.sf;
    }

    public IUpdate getIUpdate() {
        return this.iUpdate;
    }

    public void setOriginalFiles(File[] files) {
        File[] fileArray = files;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File file = fileArray[n];
            Format f = (Format)this.iQuery.findByString(Format.class, "value", "DV");
            OriginalFile oFile = new OriginalFile();
            oFile.setName(file.getName());
            oFile.setPath(file.getAbsolutePath());
            oFile.setSize(Long.valueOf(file.length()));
            oFile.setSha1("pending");
            oFile.setFormat(f);
            for (Pixels pixels : this.pixelsList) {
                pixels.linkOriginalFile(oFile);
            }
            ++n;
        }
    }

    public void writeFilesToFileStore(File[] files, long pixelsId) {
        try {
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                int rlen;
                File file = fileArray[n];
                Parameters p = new Parameters();
                p.addId(Long.valueOf(pixelsId));
                p.addString("path", file.getAbsolutePath());
                OriginalFile o = (OriginalFile)this.iQuery.findByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id and ofile.path =:path", p);
                if (o == null) {
                    throw new FileNotFoundException("Unable to look up originalFile");
                }
                this.rawFileStore.setFileId(o.getId().longValue());
                byte[] buf = new byte[262144];
                FileInputStream stream = new FileInputStream(file);
                long time = System.currentTimeMillis();
                long pos = 0L;
                while ((rlen = stream.read(buf)) > 0) {
                    this.rawFileStore.write(buf, pos, rlen);
                    pos += (long)rlen;
                    ByteBuffer nioBuffer = ByteBuffer.wrap(buf);
                    nioBuffer.limit(rlen);
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setArc(String type, Float power, Integer lightNdx, Integer arcNdx) {
    }

    @Override
    public void setDetector(String manufacturer, String model, String serialNumber, String type, Float gain, Float voltage, Float offset, Integer instrumentNdx, Integer detectorNdx) {
    }

    @Override
    public void setDichroic(String manufacturer, String model, String lotNumber, Integer dichroicNdx) {
    }

    @Override
    public void setDisplayChannel(Integer channelNumber, Double blackLevel, Double whiteLevel, Float gamma, Integer i) {
    }

    @Override
    public void setDisplayOptions(Float zoom, Boolean redChannelOn, Boolean greenChannelOn, Boolean blueChannelOn, Boolean displayRGB, String colorMap, Integer zstart, Integer zstop, Integer tstart, Integer tstop, Integer imageNdx, Integer pixelsNdx, Integer redChannel, Integer greenChannel, Integer blueChannel, Integer grayChannel) {
    }

    @Override
    public void setEmissionFilter(String manufacturer, String model, String lotNumber, String type, Integer filterNdx) {
    }

    @Override
    public void setExcitationFilter(String manufacturer, String model, String lotNumber, String type, Integer filterNdx) {
    }

    @Override
    public void setFilament(String type, Float power, Integer lightNdx, Integer filamentNdx) {
    }

    @Override
    public void setFilterSet(String manufacturer, String model, String lotNumber, Integer filterSetNdx, Integer filterNdx) {
    }

    @Override
    public void setImagingEnvironment(Float temperature, Float airPressure, Float humidity, Float co2Percent, Integer i) {
    }

    @Override
    public void setLaser(String type, String medium, Integer wavelength, Boolean frequencyDoubled, Boolean tunable, String pulse, Float power, Integer instrumentNdx, Integer lightNdx, Integer pumpNdx, Integer laserNdx) {
    }

    @Override
    public void setLightSource(String manufacturer, String model, String serialNumber, Integer instrumentIndex, Integer lightIndex) {
    }

    @Override
    public void setOTF(Integer sizeX, Integer sizeY, String pixelType, String path, Boolean opticalAxisAverage, Integer instrumentNdx, Integer otfNdx, Integer filterNdx, Integer objectiveNdx) {
    }

    @Override
    public void setObjective(String manufacturer, String model, String serialNumber, Float lensNA, Float magnification, Integer instrumentNdx, Integer objectiveNdx) {
    }

    public void populateMinMax(Long id, Integer i) {
        Pixels p = (Pixels)this.iQuery.findByQuery("select p from Pixels as p left join fetch p.channels where p.id = :id", new Parameters().addId(id));
        List channels = p.getChannels();
        List readerChannels = this.getPixels(i).getChannels();
        int j = 0;
        while (j < channels.size()) {
            ((Channel)channels.get(j)).setStatsInfo(((Channel)readerChannels.get(j)).getStatsInfo());
            ++j;
        }
        this.iUpdate.saveObject((IObject)p);
    }

    public IRepositoryInfo getRepositoryInfo() {
        return this.iInfo;
    }

    public long getRepositorySpace() {
        return this.iInfo.getFreeSpaceInKilobytes();
    }
}

