/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.test;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import loci.formats.FilePattern;
import loci.formats.FileStitcher;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.Log;
import loci.formats.LogTools;
import loci.formats.RandomAccessStream;
import loci.formats.ome.OMEXMLMetadataStore;
import loci.formats.test.ConfigurationFiles;

public class ReaderTest {
    private boolean isFirstTime = true;
    private static Vector toTest;
    private static Vector configFiles;
    private static ConfigurationFiles config;
    private static FileWriter logFile;

    static {
        configFiles = new Vector();
        config = ConfigurationFiles.newInstance();
    }

    public Object[][] createData() {
        if (this.isFirstTime) {
            toTest = new Vector();
            ReaderTest.getFiles(System.getProperty("testng.directory"), toTest);
            this.isFirstTime = false;
        }
        String[] o = toTest.toArray(new String[0]);
        Object[][] rtn = new String[o.length][1];
        int i = 0;
        while (i < o.length) {
            rtn[i][0] = o[i];
            ++i;
        }
        return rtn;
    }

    public void testBufferedImageDimensions(String file) {
        block6: {
            try {
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                boolean success = true;
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    int x = reader.getSizeX();
                    int y = reader.getSizeY();
                    int c = reader.getRGBChannelCount();
                    int type = reader.getPixelType();
                    int j = 0;
                    while (j < reader.getImageCount()) {
                        BufferedImage b = reader.openImage(j);
                        boolean failX = b.getWidth() != x;
                        boolean failY = b.getHeight() != y;
                        boolean failC = b.getRaster().getNumBands() <= c;
                        boolean failType = ImageTools.getPixelType(b) != type;
                        boolean bl = success = failX || failY || failC || failType;
                        if (!success) {
                            ReaderTest.writeLog(String.valueOf(file) + " failed BufferedImage test");
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed BufferedImage test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testByteArrayDimensions(String file) {
        block7: {
            try {
                boolean success = true;
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    int x = reader.getSizeX();
                    int y = reader.getSizeY();
                    int c = reader.getRGBChannelCount();
                    int bytes = FormatTools.getBytesPerPixel(reader.getPixelType());
                    int expected = x * y * c * bytes;
                    int j = 0;
                    while (j < reader.getImageCount()) {
                        byte[] b = reader.openBytes(j);
                        if (b.length < expected) {
                            success = false;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!success) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed byte array test");
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed byte array test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void testThumbnailImageDimensions(String file) {
        block6: {
            try {
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                boolean success = true;
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    int x = reader.getThumbSizeX();
                    int y = reader.getThumbSizeY();
                    int c = reader.getRGBChannelCount();
                    int type = reader.getPixelType();
                    int j = 0;
                    while (j < reader.getImageCount()) {
                        BufferedImage b = reader.openThumbImage(j);
                        boolean failX = b.getWidth() != x;
                        boolean failY = b.getHeight() != y;
                        boolean failC = b.getRaster().getNumBands() <= c;
                        boolean failType = ImageTools.getPixelType(b) != type;
                        boolean bl = success = failX || failY || failC || failType;
                        if (!success) {
                            ReaderTest.writeLog(String.valueOf(file) + " failed thumbnail BufferedImage test");
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed thumbnail BufferedImage test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testThumbnailByteArrayDimensions(String file) {
        block7: {
            try {
                boolean success = true;
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    int x = reader.getThumbSizeX();
                    int y = reader.getThumbSizeY();
                    int c = reader.getRGBChannelCount();
                    int bytes = FormatTools.getBytesPerPixel(reader.getPixelType());
                    int expected = x * y * c * bytes;
                    int j = 0;
                    while (j < reader.getImageCount()) {
                        byte[] b = reader.openThumbBytes(j);
                        if (b.length < expected) {
                            success = false;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!success) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed thumbnail byte array test");
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed thumbnail byte array test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void testImageCount(String file) {
        block6: {
            try {
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                boolean success = true;
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    int imageCount = reader.getImageCount();
                    int z = reader.getSizeZ();
                    int c = reader.getEffectiveSizeC();
                    int t = reader.getSizeT();
                    if (imageCount != z * c * t) {
                        success = false;
                        break;
                    }
                    ++i;
                }
                reader.close();
                if (!success) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed image count test");
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed image count test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testOMEXML(String file) {
        block6: {
            try {
                OMEXMLMetadataStore store = new OMEXMLMetadataStore();
                store.createRoot();
                FileStitcher reader = new FileStitcher();
                reader.setMetadataStore(store);
                reader.setId(file);
                store = (OMEXMLMetadataStore)reader.getMetadataStore();
                boolean success = true;
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    boolean failType;
                    reader.setSeries(i);
                    Integer ii = new Integer(i);
                    String type = FormatTools.getPixelTypeString(reader.getPixelType());
                    boolean failX = reader.getSizeX() != store.getSizeX(ii).intValue();
                    boolean failY = reader.getSizeY() != store.getSizeY(ii).intValue();
                    boolean failZ = reader.getSizeZ() != store.getSizeZ(ii).intValue();
                    boolean failC = reader.getSizeC() != store.getSizeC(ii).intValue();
                    boolean failT = reader.getSizeT() != store.getSizeT(ii).intValue();
                    boolean failBE = reader.isLittleEndian() == store.getBigEndian(ii).booleanValue();
                    boolean failDE = !reader.getDimensionOrder().equals(store.getDimensionOrder(ii));
                    boolean bl = failType = !type.equalsIgnoreCase(store.getPixelType(ii));
                    if (success) {
                        boolean bl2 = success = !failX && !failY && !failZ && !failC && !failT && !failBE && !failDE && !failType;
                    }
                    if (!success) break;
                    ++i;
                }
                if (!success) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed OME-XML sanity test");
                }
                assert (success);
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed OME-XML sanity test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testConsistent(String file) {
        block7: {
            try {
                boolean failSeries;
                FileStitcher r = new FileStitcher();
                r.setId(file);
                boolean success = true;
                boolean bl = failSeries = r.getSeriesCount() != config.getNumSeries(file);
                if (failSeries) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed consistent metadata (wrong series count)");
                    assert (false);
                    return;
                }
                int i = 0;
                while (i < r.getSeriesCount()) {
                    r.setSeries(i);
                    config.setSeries(file, i);
                    boolean failX = config.getWidth(file) != r.getSizeX();
                    boolean failY = config.getHeight(file) != r.getSizeY();
                    boolean failZ = config.getZ(file) != r.getSizeZ();
                    boolean failC = config.getC(file) != r.getSizeC();
                    boolean failT = config.getT(file) != r.getSizeT();
                    boolean failDim = !config.getDimOrder(file).equals(r.getDimensionOrder());
                    boolean failInt = config.isInterleaved(file) ^ r.isInterleaved();
                    boolean failRGB = config.isRGB(file) ^ r.isRGB();
                    boolean failType = config.getPixelType(file) != r.getPixelType();
                    boolean failEndian = config.isLittleEndian(file) ^ r.isLittleEndian();
                    boolean bl2 = success = !failX && !failY && !failZ && !failC && !failT && !failDim && !failInt && !failRGB && !failType && !failEndian;
                    if (!success) {
                        ReaderTest.writeLog(String.valueOf(file) + " failed consistent metadata test");
                        assert (false);
                        return;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed consistent metadata test");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void testMemoryUsage(String file) {
        block8: {
            try {
                int maxMemory;
                Runtime r = Runtime.getRuntime();
                int initialMemory = maxMemory = (int)(r.totalMemory() - r.freeMemory() >> 20);
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                int mem = (int)(r.totalMemory() - r.freeMemory() >> 20);
                if (mem > maxMemory) {
                    maxMemory = mem;
                }
                int i = 0;
                while (i < reader.getImageCount()) {
                    BufferedImage b = reader.openImage(i);
                    mem = (int)(r.totalMemory() - r.freeMemory() >> 20);
                    if (mem > maxMemory) {
                        maxMemory = mem;
                    }
                    ++i;
                }
                int finalMemory = (int)(r.totalMemory() - r.freeMemory() >> 20);
                boolean success = true;
                if (maxMemory - initialMemory > 2 * (config.getFileSize(file) + 1)) {
                    success = false;
                    ReaderTest.writeLog(String.valueOf(file) + " failed memory test (used " + (maxMemory - initialMemory) + "MB; expected <= " + (2 * config.getFileSize(file) + 1) + "MB)");
                }
                if (finalMemory - initialMemory > 10) {
                    success = false;
                    ReaderTest.writeLog(String.valueOf(file) + " failed memory leak test (" + (finalMemory - initialMemory) + "MB leaked)");
                }
                assert (success);
            }
            catch (Exception e) {
                ReaderTest.writeLog(String.valueOf(file) + " failed memory test");
                ReaderTest.writeLog(e);
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
    }

    public void testAccessTime(String file) {
        block5: {
            try {
                float timeMultiplier = Float.parseFloat(System.getProperty("testng.multiplier"));
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                long l1 = System.currentTimeMillis();
                int i = 0;
                while (i < reader.getImageCount()) {
                    reader.openImage(i);
                    ++i;
                }
                long l2 = System.currentTimeMillis();
                if ((double)((float)((l2 - l1) / (long)reader.getImageCount()) - timeMultiplier * config.getTimePerPlane(file)) > 20.0) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed consistent access time test (got " + (l2 - l1) / (long)reader.getImageCount() + " ms, expected " + config.getTimePerPlane(file) + " ms)");
                    assert (false);
                    return;
                }
            }
            catch (Exception e) {
                ReaderTest.writeLog(String.valueOf(file) + " failed consistent access time test");
                ReaderTest.writeLog(e);
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public void testSaneUsedFiles(String file) {
        block6: {
            try {
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                Object[] base = reader.getUsedFiles();
                Arrays.sort(base);
                int i = 0;
                while (i < base.length) {
                    reader.setId((String)base[i]);
                    Object[] comp = reader.getUsedFiles();
                    Arrays.sort(comp);
                    int j = 0;
                    while (j < comp.length) {
                        if (!((String)comp[j]).equals(base[j])) {
                            ReaderTest.writeLog(String.valueOf(file) + " failed sane used files test (" + (String)base[i] + ")");
                            assert (false);
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
                reader.close();
            }
            catch (Exception e) {
                ReaderTest.writeLog(String.valueOf(file) + " failed sane used files test");
                ReaderTest.writeLog(e);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void testValidXML(String file) {
        block4: {
            try {
                OMEXMLMetadataStore store = new OMEXMLMetadataStore();
                store.createRoot();
                FileStitcher reader = new FileStitcher();
                reader.setMetadataStore(store);
                reader.setId(file);
                String xml = ((OMEXMLMetadataStore)reader.getMetadataStore()).dumpXML();
                if (xml == null) {
                    ReaderTest.writeLog(String.valueOf(file) + " failed OME-XML validation");
                }
                reader.close();
                assert (xml != null);
            }
            catch (Exception e) {
                ReaderTest.writeLog(String.valueOf(file) + " failed OME-XML validation");
                ReaderTest.writeLog(e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public void testPixelsHashes(String file) {
        boolean success;
        block6: {
            success = true;
            try {
                FileStitcher reader = new FileStitcher();
                reader.setId(file);
                int i = 0;
                while (i < reader.getSeriesCount()) {
                    reader.setSeries(i);
                    config.setSeries(file, i);
                    String md5 = ReaderTest.md5(reader.openBytes(0));
                    if (!md5.equals(config.getMD5(file))) {
                        ReaderTest.writeLog(String.valueOf(file) + " failed pixels consistency (series " + i + ")");
                        success = false;
                        assert (success);
                        return;
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                ReaderTest.writeLog(String.valueOf(file) + " failed pixels consistency");
                ReaderTest.writeLog(exc);
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        assert (success);
    }

    public void writeConfigFiles(String file) {
        try {
            FileStitcher reader = new FileStitcher();
            reader.setId(file);
            StringBuffer line = new StringBuffer();
            line.append("\"");
            line.append(new Location(file).getName());
            line.append("\" total_series=");
            line.append(reader.getSeriesCount());
            long start = System.currentTimeMillis();
            int total = 0;
            int i = 0;
            while (i < reader.getSeriesCount()) {
                reader.setSeries(i);
                line.append(" [series=");
                line.append(i);
                line.append(" x=" + reader.getSizeX());
                line.append(" y=" + reader.getSizeY());
                line.append(" z=" + reader.getSizeZ());
                line.append(" c=" + reader.getSizeC());
                line.append(" t=" + reader.getSizeT());
                line.append(" order=" + reader.getDimensionOrder());
                line.append(" interleave=" + reader.isInterleaved());
                line.append(" rgb=" + reader.isRGB());
                line.append(" thumbx=" + reader.getThumbSizeX());
                line.append(" thumby=" + reader.getThumbSizeY());
                line.append(" type=" + FormatTools.getPixelTypeString(reader.getPixelType()));
                line.append(" little=" + reader.isLittleEndian());
                line.append(" md5=" + ReaderTest.md5(reader.openBytes(0)));
                line.append("]");
                total += reader.getImageCount();
                int j = 1;
                while (j < reader.getImageCount()) {
                    reader.openImage(j);
                    ++j;
                }
                ++i;
            }
            long end = System.currentTimeMillis();
            line.append(" access=");
            line.append((end - start) / (long)total);
            line.append(" mem=");
            line.append(new RandomAccessStream(file).length());
            line.append(" test=true\n");
            File f = new File(new Location(file).getParent(), ".bioformats");
            BufferedWriter w = new BufferedWriter(new FileWriter(f, true));
            w.write(line.toString());
            w.close();
        }
        catch (Exception e) {
            try {
                File f = new File(new Location(file).getParent(), ".bioformats");
                BufferedWriter w = new BufferedWriter(new FileWriter(f, true));
                w.write("\"" + file + "\" test=false\n");
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String md5(byte[] b) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(b);
            byte[] digest = md.digest();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                String a = Integer.toHexString(0xFF & digest[i]);
                if (a.length() == 1) {
                    a = "0" + a;
                }
                sb.append(a);
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            ReaderTest.writeLog(e);
            return null;
        }
    }

    private static void writeLog(String s) {
        if (logFile == null) {
            ReaderTest.createLogFile();
        }
        LogTools.println(s);
        try {
            logFile.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeLog(Exception e) {
        if (logFile == null) {
            ReaderTest.createLogFile();
        }
        LogTools.trace(e);
        try {
            logFile.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void createLogFile() {
        try {
            String date = new Date().toString().replaceAll(":", "-");
            logFile = new FileWriter("bio-formats-test-" + date + ".log");
            logFile.flush();
            TestLogger log = new TestLogger(logFile);
            LogTools.setLog(log);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void getFiles(String root, Vector files) {
        Location f = new Location(root);
        Object[] subs = f.list();
        if (subs == null) {
            subs = new String[]{};
        }
        Arrays.sort(subs);
        int i = 0;
        while (i < subs.length) {
            if (((String)subs[i]).endsWith(".bioformats") && i != 0) {
                Object tmp = subs[0];
                subs[0] = subs[i];
                subs[i] = tmp;
                break;
            }
            ++i;
        }
        if (subs == null) {
            LogTools.println("Invalid directory: " + root);
            return;
        }
        ImageReader ir = new ImageReader();
        Vector<String> similarFiles = new Vector<String>();
        int i2 = 0;
        while (i2 < subs.length) {
            LogTools.println("Checking file " + (String)subs[i2]);
            subs[i2] = new Location(root, (String)subs[i2]).getAbsolutePath();
            if (ReaderTest.isBadFile((String)subs[i2]) || similarFiles.contains(subs[i2])) {
                LogTools.println(String.valueOf(subs[i2]) + " is a bad file");
                String[] matching = new FilePattern((String)subs[i2]).getFiles();
                int j = 0;
                while (j < matching.length) {
                    similarFiles.add(new Location(root, matching[j]).getAbsolutePath());
                    ++j;
                }
            } else {
                Location file = new Location((String)subs[i2]);
                if (file.isDirectory()) {
                    ReaderTest.getFiles((String)subs[i2], files);
                } else if (file.getName().equals(".bioformats")) {
                    configFiles.add(file.getAbsolutePath());
                } else if (ir.isThisType((String)subs[i2])) {
                    LogTools.println("Adding " + (String)subs[i2]);
                    files.add(file.getAbsolutePath());
                } else {
                    LogTools.println(String.valueOf(subs[i2]) + " has invalid type");
                }
                file = null;
            }
            ++i2;
        }
    }

    private static boolean isBadFile(String file) {
        int i = 0;
        while (i < configFiles.size()) {
            try {
                String s = (String)configFiles.get(i);
                if (!config.isParsed(s)) {
                    config.addFile(s);
                }
            }
            catch (IOException exc) {
                LogTools.trace(exc);
            }
            ++i;
        }
        return !config.testFile(file) && !file.endsWith(".bioformats");
    }

    public static class TestLogger
    extends Log {
        private FileWriter writer;

        public TestLogger(FileWriter writer) {
            this.writer = writer;
        }

        public void print(String x) {
            try {
                if (this.writer != null) {
                    this.writer.write(x);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

