/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import loci.formats.ImageTools;
import loci.formats.LogTools;

public class ImageTester
extends JPanel
implements WindowListener {
    private BufferedImage[][] img;

    public ImageTester(BufferedImage[][] img) {
        this.img = img;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        int xoff = 0;
        int yoff = 0;
        int y = 0;
        while (y < this.img.length) {
            int maxh = 0;
            int x = 0;
            while (x < this.img[y].length) {
                int w = this.img[y][x].getWidth();
                int h = this.img[y][x].getHeight();
                g.drawImage(this.img[y][x], xoff, yoff, this);
                xoff += w;
                if (h > maxh) {
                    maxh = h;
                }
                ++x;
            }
            xoff = 0;
            yoff += maxh;
            ++y;
        }
    }

    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        int y = 0;
        while (y < this.img.length) {
            int wsum = 0;
            int maxh = 0;
            int x = 0;
            while (x < this.img[y].length) {
                int w = this.img[y][x].getWidth();
                int h = this.img[y][x].getHeight();
                wsum += w;
                if (h > maxh) {
                    maxh = h;
                }
                ++x;
            }
            if (wsum > width) {
                width = wsum;
            }
            height += maxh;
            ++y;
        }
        return new Dimension(width, height);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        int[] chan = new int[]{1, 3, 4};
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int wpad = 50;
        int hpad = 100;
        int w = (screen.width - wpad) / chan.length;
        int h = (screen.height - hpad) / 6;
        LogTools.println("Using images of size " + w + " x " + h);
        int size = w * h;
        BufferedImage[] bimg1 = new BufferedImage[chan.length];
        BufferedImage[] bimg2 = new BufferedImage[chan.length];
        BufferedImage[] bimg3 = new BufferedImage[chan.length];
        BufferedImage[] simg1 = new BufferedImage[chan.length];
        BufferedImage[] simg2 = new BufferedImage[chan.length];
        BufferedImage[] simg3 = new BufferedImage[chan.length];
        int q = 0;
        while (q < chan.length) {
            int c = chan[q];
            LogTools.println("Building c=" + c + " images");
            byte[][] bdata1 = new byte[c][size];
            byte[] bdata2 = new byte[c * size];
            byte[] bdata3 = new byte[c * size];
            short[][] sdata1 = new short[c][size];
            short[] sdata2 = new short[c * size];
            short[] sdata3 = new short[c * size];
            int i = 0;
            while (i < c) {
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        int ndx1 = w * y + x;
                        int ndx2 = c * ndx1 + i;
                        int ndx3 = i * size + ndx1;
                        float val = i == 0 ? (float)(x + y) / (float)(w + h) : (i == 1 ? (float)(x - y + h - 1) / (float)(w + h) : (i == 2 ? (float)(y - x + w - 1) / (float)(w + h) : (i == 3 ? (float)(x * y) / (float)size : (float)Math.random())));
                        int bval = (int)(256.0f * val);
                        int sval = (int)(65536.0f * val);
                        bdata1[i][ndx1] = (byte)bval;
                        bdata2[ndx2] = (byte)bval;
                        bdata3[ndx3] = (byte)bval;
                        sdata1[i][ndx1] = (short)sval;
                        sdata2[ndx2] = (short)sval;
                        sdata3[ndx3] = (short)sval;
                        ++x;
                    }
                    ++y;
                }
                ++i;
            }
            bimg1[q] = ImageTools.makeImage(bdata1, w, h);
            bimg2[q] = ImageTools.makeImage(bdata2, w, h, c, true);
            bimg3[q] = ImageTools.makeImage(bdata3, w, h, c, false);
            simg1[q] = ImageTools.makeImage(sdata1, w, h);
            simg2[q] = ImageTools.makeImage(sdata2, w, h, c, true);
            simg3[q] = ImageTools.makeImage(sdata3, w, h, c, false);
            ++q;
        }
        LogTools.println("Rows are: byte[][], byte[] (interleaved), byte[] (sequential)");
        LogTools.println("  short[][], short[] (interleaved), short[] (sequential)");
        LogTools.print("Columns are:");
        q = 0;
        while (q < chan.length) {
            if (q > 0) {
                LogTools.print(",");
            }
            LogTools.print(" c=" + chan[q]);
            ++q;
        }
        LogTools.println();
        JFrame frame = new JFrame("ImageTester");
        BufferedImage[][] img = new BufferedImage[][]{bimg1, bimg2, bimg3, simg1, simg2, simg3};
        ImageTester pane = new ImageTester(img);
        frame.addWindowListener(pane);
        frame.setContentPane(pane);
        frame.pack();
        frame.setVisible(true);
    }
}

