/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.test;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.RandomAccessStream;

public class ConfigurationFiles {
    private Hashtable entries = new Hashtable();
    private Vector parsedFiles = new Vector();
    private int currentSeries = 0;

    public static ConfigurationFiles newInstance() {
        return new ConfigurationFiles();
    }

    public int numFiles() {
        return this.entries.size();
    }

    public boolean isParsed(String file) {
        return this.parsedFiles.contains(file);
    }

    public boolean initialized(String id) {
        return this.entries.containsKey(id) && this.currentSeries <= this.getNumSeries(id);
    }

    public void addFile(String id) throws IOException {
        RandomAccessStream ras = new RandomAccessStream(id);
        Location l = new Location(id);
        if (this.parsedFiles.contains(l.getAbsolutePath())) {
            return;
        }
        this.parsedFiles.add(l.getAbsolutePath());
        byte[] b = new byte[(int)ras.length()];
        ras.read(b);
        ras.close();
        StringTokenizer st = new StringTokenizer(new String(b), "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith("#") || line.trim().length() <= 0) continue;
            ConfigEntry entry = new ConfigEntry();
            String file = line.substring(1, line.lastIndexOf("\""));
            Location newLocation = new Location(l.getParent(), file);
            file = newLocation.getAbsolutePath();
            newLocation = null;
            String testValue = (line = line.substring(line.lastIndexOf("\"") + 2)).substring(line.indexOf("test=") + 5).trim();
            if (testValue.equals("false")) {
                entry.test = false;
            } else {
                entry.test = true;
                int ndx = line.indexOf("total_series=") + 13;
                int nSeries = Integer.parseInt(line.substring(ndx, line.indexOf(" ", ndx)));
                entry.numSeries = nSeries;
                entry.dimensions = new int[nSeries][5];
                entry.orders = new String[nSeries];
                entry.interleaved = new boolean[nSeries];
                entry.rgb = new boolean[nSeries];
                entry.thumbs = new int[nSeries][2];
                entry.type = new int[nSeries];
                entry.littleEndian = new boolean[nSeries];
                entry.md5 = new String[nSeries];
                int i = 0;
                while (i < nSeries) {
                    ndx = line.indexOf("[series=" + i);
                    String s = line.substring(ndx, line.indexOf("]", ndx));
                    ndx = s.indexOf("x") + 2;
                    ((ConfigEntry)entry).dimensions[i][0] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("y") + 2;
                    ((ConfigEntry)entry).dimensions[i][1] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("z") + 2;
                    ((ConfigEntry)entry).dimensions[i][2] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("c") + 2;
                    ((ConfigEntry)entry).dimensions[i][3] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("t") + 2;
                    ((ConfigEntry)entry).dimensions[i][4] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("order") + 6;
                    ((ConfigEntry)entry).orders[i] = s.substring(ndx, s.indexOf(" ", ndx));
                    ndx = s.indexOf("interleave") + 11;
                    ((ConfigEntry)entry).interleaved[i] = s.substring(ndx, s.indexOf(" ", ndx)).equals("true");
                    ndx = s.indexOf("rgb") + 4;
                    ((ConfigEntry)entry).rgb[i] = s.substring(ndx, s.indexOf(" ", ndx)).equals("true");
                    ndx = s.indexOf("thumbx") + 7;
                    ((ConfigEntry)entry).thumbs[i][0] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("thumby") + 7;
                    ((ConfigEntry)entry).thumbs[i][1] = Integer.parseInt(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("type") + 5;
                    ((ConfigEntry)entry).type[i] = FormatTools.pixelTypeFromString(s.substring(ndx, s.indexOf(" ", ndx)));
                    ndx = s.indexOf("little") + 7;
                    ((ConfigEntry)entry).littleEndian[i] = s.substring(ndx, s.indexOf(" ", ndx)).equals("true");
                    ndx = s.indexOf("md5") + 4;
                    ((ConfigEntry)entry).md5[i] = s.substring(ndx);
                    ++i;
                }
                ndx = line.indexOf("access=") + 7;
                entry.access = Float.parseFloat(line.substring(ndx, line.indexOf(" ", ndx)));
                ndx = line.indexOf("mem=") + 4;
                entry.mem = (int)(Long.parseLong(line.substring(ndx, line.indexOf(" ", ndx))) >> 20);
            }
            this.entries.put(file, entry);
        }
        l = null;
        System.gc();
    }

    public void setSeries(String id, int no) {
        if (no < this.getNumSeries(id)) {
            this.currentSeries = no;
        }
    }

    public int getNumSeries(String id) {
        if (!this.entries.containsKey(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).numSeries;
    }

    public int getWidth(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).dimensions[this.currentSeries][0];
    }

    public int getHeight(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).dimensions[this.currentSeries][1];
    }

    public int getZ(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).dimensions[this.currentSeries][2];
    }

    public int getC(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).dimensions[this.currentSeries][3];
    }

    public int getT(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).dimensions[this.currentSeries][4];
    }

    public String getDimOrder(String id) {
        if (!this.initialized(id)) {
            return null;
        }
        return ((ConfigEntry)this.entries.get(id)).orders[this.currentSeries];
    }

    public boolean isInterleaved(String id) {
        if (!this.initialized(id)) {
            return false;
        }
        return ((ConfigEntry)this.entries.get(id)).interleaved[this.currentSeries];
    }

    public boolean isRGB(String id) {
        if (!this.initialized(id)) {
            return false;
        }
        return ((ConfigEntry)this.entries.get(id)).rgb[this.currentSeries];
    }

    public int getThumbX(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).thumbs[this.currentSeries][0];
    }

    public int getThumbY(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).thumbs[this.currentSeries][1];
    }

    public int getPixelType(String id) {
        if (!this.initialized(id)) {
            return -1;
        }
        return ((ConfigEntry)this.entries.get(id)).type[this.currentSeries];
    }

    public boolean isLittleEndian(String id) {
        if (!this.initialized(id)) {
            return false;
        }
        return ((ConfigEntry)this.entries.get(id)).littleEndian[this.currentSeries];
    }

    public String getMD5(String id) {
        if (!this.initialized(id)) {
            return null;
        }
        return ((ConfigEntry)this.entries.get(id)).md5[this.currentSeries];
    }

    public float getTimePerPlane(String id) {
        if (!this.initialized(id)) {
            return 0.0f;
        }
        return ((ConfigEntry)this.entries.get(id)).access;
    }

    public int getFileSize(String id) {
        if (!this.initialized(id)) {
            return 0;
        }
        return ((ConfigEntry)this.entries.get(id)).mem;
    }

    public boolean testFile(String id) {
        if (!this.entries.containsKey(id)) {
            return true;
        }
        return ((ConfigEntry)this.entries.get(id)).test;
    }

    public class ConfigEntry {
        private int numSeries;
        private int[][] dimensions;
        private String[] orders;
        private boolean[] interleaved;
        private boolean[] rgb;
        private int[][] thumbs;
        private int[] type;
        private boolean[] littleEndian;
        private String[] md5;
        private float access;
        private int mem;
        private boolean test;
    }
}

