/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;

public class TiffWriter
extends FormatWriter {
    private int lastOffset = 0;
    private BufferedOutputStream out;

    public TiffWriter() {
        super("Tagged Image File Format", new String[]{"tif", "tiff"});
        this.compressionTypes = new String[]{"Uncompressed", "LZW"};
    }

    public void saveImage(Image image, Hashtable ifd, boolean last) throws IOException, FormatException {
        if (!this.initialized) {
            this.initialized = true;
            this.out = new BufferedOutputStream(new FileOutputStream(this.currentId, true), 4096);
            RandomAccessStream tmp = new RandomAccessStream(this.currentId);
            if (tmp.length() == 0L) {
                DataOutputStream dataOut = new DataOutputStream(this.out);
                dataOut.writeByte(77);
                dataOut.writeByte(77);
                dataOut.writeShort(42);
                dataOut.writeInt(8);
                this.lastOffset = 8;
            } else {
                TiffTools.checkHeader(tmp);
                long offset = TiffTools.getFirstOffset(tmp);
                long ifdMax = (tmp.length() - 8L) / 18L;
                long ifdNum = 0L;
                while (ifdNum < ifdMax) {
                    TiffTools.getIFD(tmp, ifdNum, offset);
                    offset = tmp.readInt();
                    if (offset <= 0L || offset >= tmp.length()) break;
                    ++ifdNum;
                }
                this.lastOffset = (int)offset;
            }
            tmp.close();
        }
        BufferedImage img = this.cm == null ? ImageTools.makeBuffered(image) : ImageTools.makeBuffered(image, this.cm);
        this.lastOffset = (int)((long)this.lastOffset + TiffTools.writeImage(img, ifd, this.out, this.lastOffset, last));
        if (last) {
            this.close();
        }
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        Hashtable<Integer, Integer> h = new Hashtable<Integer, Integer>();
        if (this.compression == null) {
            this.compression = "";
        }
        h.put(new Integer(259), this.compression.equals("LZW") ? new Integer(5) : new Integer(1));
        this.saveImage(image, h, last);
    }

    public boolean canDoStacks() {
        return true;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.currentId = null;
        this.initialized = false;
        this.lastOffset = 0;
    }

    public void saveImage(String id, Image image, Hashtable ifd, boolean last) throws IOException, FormatException {
        this.setId(id);
        this.saveImage(image, ifd, last);
    }
}

