/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.ImageTools;
import loci.formats.out.LegacyQTWriter;

public class QTWriter
extends FormatWriter {
    public static final int CODEC_MOTION_JPEG_B = 1835692130;
    public static final int CODEC_CINEPAK = 1668704612;
    public static final int CODEC_ANIMATION = 1919706400;
    public static final int CODEC_H_263 = 1748121139;
    public static final int CODEC_SORENSON = 1398165809;
    public static final int CODEC_SORENSON_3 = 1398165811;
    public static final int CODEC_MPEG_4 = 1836070006;
    public static final int CODEC_RAW = 0;
    public static final int QUALITY_LOW = 256;
    public static final int QUALITY_NORMAL = 512;
    public static final int QUALITY_HIGH = 768;
    public static final int QUALITY_MAXIMUM = 1023;
    protected RandomAccessFile out;
    protected int codec = 0;
    protected int quality = 512;
    protected int numWritten;
    protected long byteCountOffset;
    protected int numBytes;
    protected Vector offsets;
    protected int created;
    protected boolean needLegacy = false;
    protected LegacyQTWriter legacy;

    public QTWriter() {
        super("QuickTime", "mov");
        this.compressionTypes = new String[]{"Uncompressed", "Motion JPEG-B", "Cinepak", "Animation", "H.263", "Sorenson", "Sorenson 3", "MPEG 4"};
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void saveImage(Image image, boolean last) throws FormatException, IOException {
        int i;
        int k;
        if (image == null) {
            throw new FormatException("Image is null");
        }
        if (this.legacy == null) {
            this.legacy = new LegacyQTWriter();
        }
        if (this.needLegacy) {
            this.legacy.setId(this.currentId);
            this.legacy.saveImage(image, last);
            return;
        }
        BufferedImage img = this.cm == null ? ImageTools.makeBuffered(image) : ImageTools.makeBuffered(image, this.cm);
        int width = img.getWidth();
        int height = img.getHeight();
        byte[][] byteData = ImageTools.getPixelBytes(img, false);
        int pad = width % 4;
        pad = (4 - pad) % 4;
        int bytesPerPixel = byteData[0].length / (width * height);
        if (bytesPerPixel > 1) {
            throw new FormatException("Unsupported bits per pixel : " + 8 * bytesPerPixel + ".");
        }
        byte[][] temp = byteData;
        byteData = new byte[temp.length][temp[0].length + height * (pad *= bytesPerPixel)];
        int rowLength = width * bytesPerPixel;
        int oldScanline = 0;
        while (oldScanline < height) {
            k = 0;
            while (k < temp.length) {
                System.arraycopy(temp[k], oldScanline * rowLength, byteData[k], oldScanline * (rowLength + pad), rowLength);
                ++k;
            }
            ++oldScanline;
        }
        if (byteData.length == 1 && bytesPerPixel == 1) {
            i = 0;
            while (i < byteData.length) {
                k = 0;
                while (k < byteData[0].length) {
                    byteData[i][k] = (byte)(255 - byteData[i][k]);
                    ++k;
                }
                ++i;
            }
        }
        if (!this.initialized) {
            this.initialized = true;
            this.setCodec();
            if (this.codec != 0) {
                this.needLegacy = true;
                this.legacy.setCodec(this.codec);
                this.legacy.setId(this.currentId);
                this.legacy.saveImage(image, last);
                return;
            }
            this.offsets = new Vector();
            this.out = new RandomAccessFile(this.currentId, "rw");
            this.created = (int)System.currentTimeMillis();
            this.numWritten = 0;
            this.numBytes = byteData.length * byteData[0].length;
            this.byteCountOffset = 8L;
            if (this.out.length() == 0L) {
                DataTools.writeInt(this.out, 8, false);
                DataTools.writeString(this.out, "wide");
                DataTools.writeInt(this.out, this.numBytes + 8, false);
                DataTools.writeString(this.out, "mdat");
            } else {
                this.out.seek(this.byteCountOffset);
                this.numBytes = (int)DataTools.read4UnsignedBytes(this.out, false) - 8;
                this.numWritten = this.numBytes / (byteData[0].length * byteData.length);
                this.numBytes += byteData.length * byteData[0].length;
                this.out.seek(this.byteCountOffset);
                DataTools.writeInt(this.out, this.numBytes + 8, false);
                i = 0;
                while (i < this.numWritten) {
                    this.offsets.add(new Integer(16 + i * byteData.length * byteData[0].length));
                    ++i;
                }
                this.out.seek(this.out.length());
            }
            this.offsets.add(new Integer((int)this.out.length()));
            ++this.numWritten;
            i = 0;
            while (i < byteData.length) {
                this.out.write(byteData[i]);
                ++i;
            }
        } else {
            int planeOffset = this.numBytes;
            this.numBytes += byteData.length * byteData[0].length;
            this.out.seek(this.byteCountOffset);
            DataTools.writeInt(this.out, this.numBytes + 8, false);
            this.out.seek(this.out.length());
            int i2 = 0;
            while (i2 < byteData.length) {
                this.out.write(byteData[i2]);
                ++i2;
            }
            this.offsets.add(new Integer(planeOffset + 16));
            ++this.numWritten;
        }
        if (last) {
            int timeScale = 100;
            int duration = this.numWritten * (timeScale / this.fps);
            int bitsPerPixel = byteData.length > 1 ? bytesPerPixel * 24 : bytesPerPixel * 8 + 32;
            int channels = bitsPerPixel >= 40 ? 1 : 3;
            int atomLength = 685 + 8 * this.numWritten;
            DataTools.writeInt(this.out, atomLength, false);
            DataTools.writeString(this.out, "moov");
            DataTools.writeInt(this.out, 108, false);
            DataTools.writeString(this.out, "mvhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, timeScale, false);
            DataTools.writeInt(this.out, duration, false);
            byte[] byArray = new byte[4];
            byArray[1] = 1;
            this.out.write(byArray);
            byte[] byArray2 = new byte[10];
            byArray2[1] = -1;
            this.out.write(byArray2);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 16384, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 2, false);
            DataTools.writeInt(this.out, atomLength -= 116, false);
            DataTools.writeString(this.out, "trak");
            DataTools.writeInt(this.out, 92, false);
            DataTools.writeString(this.out, "tkhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 15, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 16384, false);
            DataTools.writeInt(this.out, width, false);
            DataTools.writeInt(this.out, height, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 36, false);
            DataTools.writeString(this.out, "edts");
            DataTools.writeInt(this.out, 28, false);
            DataTools.writeString(this.out, "elst");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, atomLength -= 136, false);
            DataTools.writeString(this.out, "mdia");
            DataTools.writeInt(this.out, 32, false);
            DataTools.writeString(this.out, "mdhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.created, false);
            DataTools.writeInt(this.out, (int)System.currentTimeMillis(), false);
            DataTools.writeInt(this.out, timeScale, false);
            DataTools.writeInt(this.out, duration, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 58, false);
            DataTools.writeString(this.out, "hdlr");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeString(this.out, "mhlr");
            DataTools.writeString(this.out, "vide");
            DataTools.writeString(this.out, "appl");
            byte[] byArray3 = new byte[9];
            byArray3[0] = 16;
            byArray3[5] = 1;
            byArray3[6] = 1;
            byArray3[7] = 11;
            byArray3[8] = 25;
            this.out.write(byArray3);
            DataTools.writeString(this.out, "Apple Video Media Handler");
            DataTools.writeInt(this.out, atomLength -= 98, false);
            DataTools.writeString(this.out, "minf");
            DataTools.writeInt(this.out, 20, false);
            DataTools.writeString(this.out, "vmhd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 64, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeShort(this.out, 32768, false);
            DataTools.writeInt(this.out, 57, false);
            DataTools.writeString(this.out, "hdlr");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeString(this.out, "dhlr");
            DataTools.writeString(this.out, "alis");
            DataTools.writeString(this.out, "appl");
            byte[] byArray4 = new byte[9];
            byArray4[0] = 16;
            byArray4[3] = 1;
            byArray4[5] = 1;
            byArray4[6] = 1;
            byArray4[7] = 31;
            byArray4[8] = 24;
            this.out.write(byArray4);
            DataTools.writeString(this.out, "Apple Alias Data Handler");
            DataTools.writeInt(this.out, 36, false);
            DataTools.writeString(this.out, "dinf");
            DataTools.writeInt(this.out, 28, false);
            DataTools.writeString(this.out, "dref");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            byte[] byArray5 = new byte[4];
            byArray5[3] = 12;
            this.out.write(byArray5);
            DataTools.writeString(this.out, "alis");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeInt(this.out, atomLength -= 121, false);
            DataTools.writeString(this.out, "stbl");
            DataTools.writeInt(this.out, 118, false);
            DataTools.writeString(this.out, "stsd");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            byte[] byArray6 = new byte[4];
            byArray6[3] = 102;
            this.out.write(byArray6);
            DataTools.writeString(this.out, "raw ");
            this.out.write(new byte[6]);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeString(this.out, "appl");
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, 768, false);
            DataTools.writeShort(this.out, width, false);
            DataTools.writeShort(this.out, height, false);
            byte[] byArray7 = new byte[4];
            byArray7[1] = 72;
            this.out.write(byArray7);
            byte[] byArray8 = new byte[4];
            byArray8[1] = 72;
            this.out.write(byArray8);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeShort(this.out, 1, false);
            DataTools.writeShort(this.out, 12, false);
            DataTools.writeString(this.out, "Uncompressed");
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, bitsPerPixel, false);
            DataTools.writeShort(this.out, bitsPerPixel, false);
            DataTools.writeInt(this.out, 65535, false);
            this.out.write(new byte[]{12, 103, 97, 108});
            byte[] byArray9 = new byte[8];
            byArray9[0] = 97;
            byArray9[1] = 1;
            byArray9[2] = -52;
            byArray9[3] = -52;
            this.out.write(byArray9);
            DataTools.writeInt(this.out, 24, false);
            DataTools.writeString(this.out, "stts");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            DataTools.writeInt(this.out, timeScale / this.fps, false);
            DataTools.writeInt(this.out, 28, false);
            DataTools.writeString(this.out, "stsc");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 1, false);
            DataTools.writeInt(this.out, 20 + 4 * this.numWritten, false);
            DataTools.writeString(this.out, "stsz");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, 0, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            int i3 = 0;
            while (i3 < this.numWritten) {
                DataTools.writeInt(this.out, channels * height * (width + pad) * bytesPerPixel, false);
                ++i3;
            }
            DataTools.writeInt(this.out, 16 + 4 * this.numWritten, false);
            DataTools.writeString(this.out, "stco");
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeShort(this.out, 0, false);
            DataTools.writeInt(this.out, this.numWritten, false);
            i3 = 0;
            while (i3 < this.numWritten) {
                DataTools.writeInt(this.out, (Integer)this.offsets.get(i3), false);
                ++i3;
            }
            this.out.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{1, 3};
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        this.numWritten = 0;
        this.byteCountOffset = 0L;
        this.numBytes = 0;
        this.created = 0;
        this.offsets = null;
        this.currentId = null;
        this.initialized = false;
    }

    private void setCodec() {
        if (this.compression == null) {
            this.compression = "Uncompressed";
        }
        if (this.compression.equals("Uncompressed")) {
            this.codec = 0;
        } else if (this.compression.equals("Motion JPEG-B")) {
            this.codec = 1835692130;
        } else if (this.compression.equals("Cinepak")) {
            this.codec = 1668704612;
        } else if (this.compression.equals("Animation")) {
            this.codec = 1919706400;
        } else if (this.compression.equals("H.263")) {
            this.codec = 1748121139;
        } else if (this.compression.equals("Sorenson")) {
            this.codec = 1398165809;
        } else if (this.compression.equals("Sorenson 3")) {
            this.codec = 1398165811;
        } else if (this.compression.equals("MPEG 4")) {
            this.codec = 1836070006;
        }
    }
}

