/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.in.LegacyZVIReader;

public class ZeissZVIReader
extends FormatReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read ZVI files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private LegacyZVIReader legacy = new LegacyZVIReader();
    private static boolean noPOI = false;
    private static ReflectedUniverse r = ZeissZVIReader.createReflectedUniverse();
    private boolean needLegacy = false;
    private int bpp;
    private int thumbWidth;
    private int thumbHeight;
    private Hashtable pixels;
    private Hashtable names;
    private Vector zIndices;
    private Vector cIndices;
    private Vector tIndices;
    private int[] validBits;
    private Hashtable offsets;
    private int zIndex = -1;
    private int cIndex = -1;
    private int tIndex = -1;

    private static ReflectedUniverse createReflectedUniverse() {
        block2: {
            r = null;
            try {
                r = new ReflectedUniverse();
                r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
                r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
                r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
                r.exec("import java.util.Iterator");
            }
            catch (Throwable t) {
                noPOI = true;
                if (!debug) break block2;
                LogTools.trace(t);
            }
        }
        return r;
    }

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        super.setMetadataStore(store);
        if (noPOI || this.needLegacy) {
            this.legacy.setMetadataStore(store);
        }
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]) * this.getRGBChannelCount()];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPOI || this.needLegacy) {
            return this.legacy.openBytes(no, buf);
        }
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]) * this.getRGBChannelCount()) {
            throw new FormatException("Buffer too small.");
        }
        try {
            Integer ii = new Integer(no);
            Object directory = this.pixels.get(ii);
            String name = (String)this.names.get(ii);
            r.setVar("dir", directory);
            r.setVar("entryName", name);
            r.exec("document = dir.getEntry(entryName)");
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            r.setVar("skipBytes", ((Integer)this.offsets.get(ii)).longValue());
            r.exec("blah = dis.skip(skipBytes)");
            r.setVar("data", buf);
            r.exec("dis.read(data)");
            if (this.bpp > 6) {
                this.bpp = 1;
            }
            if (this.bpp == 3) {
                int i = 0;
                while (i < buf.length) {
                    byte b = buf[i + 2];
                    buf[i + 2] = buf[i];
                    buf[i] = b;
                    i += 3;
                }
            }
            return buf;
        }
        catch (ReflectException e) {
            this.needLegacy = true;
            return this.openBytes(no, buf);
        }
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.getRGBChannelCount(), true, this.bpp == 3 ? 1 : this.bpp, true, this.validBits);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (this.legacy != null) {
                this.legacy.close(fileOnly);
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        super.close();
        this.needLegacy = false;
        if (this.legacy != null) {
            this.legacy.close();
        }
        this.pixels = null;
        this.names = null;
        this.offsets = null;
        String[] vars = new String[]{"dirName", "root", "dir", "document", "dis", "numBytes", "data", "fis", "fs", "iter", "isInstance", "isDocument", "entry", "documentName", "entryName"};
        int i = 0;
        while (i < vars.length) {
            r.setVar(vars[i], null);
            ++i;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        block23: {
            if (debug) {
                this.debug("ZeissZVIReader.initFile(" + id + ")");
            }
            if (noPOI || this.needLegacy) {
                this.legacy.setId(id);
                this.core = this.legacy.getCoreMetadata();
                return;
            }
            super.initFile(id);
            this.pixels = new Hashtable();
            this.names = new Hashtable();
            this.offsets = new Hashtable();
            this.zIndices = new Vector();
            this.cIndices = new Vector();
            this.tIndices = new Vector();
            try {
                this.in = new RandomAccessStream(id);
                r.setVar("fis", this.in);
                r.exec("fs = new POIFSFileSystem(fis)");
                r.exec("dir = fs.getRoot()");
                this.parseDir(0, r.getVar("dir"));
                this.status("Populating metadata");
                this.core.rgb[0] = this.core.sizeC[0] > 1 && this.core.sizeZ[0] * this.core.sizeC[0] * this.core.sizeT[0] != this.core.imageCount[0];
                this.core.littleEndian[0] = true;
                this.core.interleaved[0] = false;
                this.core.sizeZ[0] = this.zIndices.size();
                this.core.sizeT[0] = this.tIndices.size();
                if (this.core.sizeC[0] != this.cIndices.size()) {
                    this.core.sizeC[0] = this.core.sizeC[0] * this.cIndices.size();
                }
                this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0] * this.getEffectiveSizeC();
                String s = (String)this.getMeta("Acquisition Bit Depth");
                if (s != null && s.trim().length() > 0) {
                    this.validBits = new int[this.core.sizeC[0]];
                    if (this.core.sizeC[0] == 2) {
                        this.validBits = new int[3];
                    }
                    int i = 0;
                    while (i < this.core.sizeC[0]) {
                        this.validBits[i] = Integer.parseInt(s.trim());
                        ++i;
                    }
                } else {
                    this.validBits = null;
                }
                if (this.cIndex != -1) {
                    int[] dims = new int[]{this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]};
                    int max = 0;
                    int min = Integer.MAX_VALUE;
                    int maxNdx = 0;
                    int minNdx = 0;
                    String[] axes = new String[]{"Z", "C", "T"};
                    int i = 0;
                    while (i < dims.length) {
                        if (dims[i] > max) {
                            max = dims[i];
                            maxNdx = i;
                        }
                        if (dims[i] < min) {
                            min = dims[i];
                            minNdx = i;
                        }
                        ++i;
                    }
                    int medNdx = 0;
                    int i2 = 0;
                    while (i2 < 3) {
                        if (i2 != maxNdx && i2 != minNdx) {
                            medNdx = i2;
                        }
                        ++i2;
                    }
                    this.core.currentOrder[0] = "XY" + axes[maxNdx] + axes[medNdx] + axes[minNdx];
                    int num = this.core.sizeZ[0] * this.core.sizeT[0] - this.core.sizeC[0];
                    if (this.zIndex != -1 && this.tIndex != -1 && this.zIndex != num && this.tIndex != num && this.zIndex != this.core.sizeZ[0]) {
                        this.core.currentOrder[0] = this.core.sizeZ[0] != 1 ? String.valueOf(this.core.currentOrder[0].replaceAll("Z", "")) + "Z" : String.valueOf(this.core.currentOrder[0].replaceAll("T", "")) + "T";
                    }
                    if (this.core.sizeZ[0] == this.core.sizeC[0] && this.core.sizeC[0] == this.core.sizeT[0]) {
                        this.legacy.setId(id);
                        this.core.currentOrder[0] = this.legacy.getDimensionOrder();
                    }
                } else {
                    this.core.currentOrder[0] = this.core.rgb[0] ? (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYCZT" : "XYCTZ") : (this.metadata.get("MultiChannelEnabled") != null ? (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYCZT" : "XYCTZ") : (this.core.sizeZ[0] > this.core.sizeT[0] ? "XYZTC" : "XYTZC"));
                }
            }
            catch (ReflectException exc) {
                this.needLegacy = true;
                if (debug) {
                    this.trace(exc);
                }
                this.initFile(id);
            }
            try {
                this.initMetadata();
            }
            catch (FormatException exc) {
                if (debug) {
                    this.trace(exc);
                }
            }
            catch (IOException exc) {
                if (!debug) break block23;
                this.trace(exc);
            }
        }
    }

    private void initMetadata() throws FormatException, IOException {
        MetadataStore store = this.getMetadataStore();
        store.setImage((String)this.getMeta("Title"), null, null, null);
        if (this.bpp == 1 || this.bpp == 3) {
            this.core.pixelType[0] = 1;
        } else if (this.bpp == 2 || this.bpp == 6) {
            this.core.pixelType[0] = 3;
        }
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.FALSE, this.core.currentOrder[0], null, null);
        String pixX = (String)this.getMeta("Scale Factor for X");
        String pixY = (String)this.getMeta("Scale Factor for Y");
        String pixZ = (String)this.getMeta("Scale Factor for Z");
        store.setDimensions(pixX == null ? null : new Float(pixX), pixY == null ? null : new Float(pixY), pixZ == null ? null : new Float(pixZ), null, null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }

    protected void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            byte[] data;
            block26: {
                r.setVar("entry", iter.next());
                r.exec("isInstance = entry.isDirectoryEntry()");
                r.exec("isDocument = entry.isDocumentEntry()");
                boolean isInstance = (Boolean)r.getVar("isInstance");
                boolean isDocument = (Boolean)r.getVar("isDocument");
                r.setVar("dir", dir);
                r.exec("dirName = dir.getName()");
                if (isInstance) {
                    this.status("Parsing embedded folder (" + (depth + 1) + ")");
                    this.parseDir(depth + 1, r.getVar("entry"));
                    continue;
                }
                if (!isDocument) continue;
                this.status("Parsing embedded file (" + depth + ")");
                r.exec("entryName = entry.getName()");
                if (debug) {
                    this.print(depth + 1, "Found document: " + r.getVar("entryName"));
                }
                r.exec("dis = new DocumentInputStream(entry)");
                r.exec("numBytes = dis.available()");
                int numbytes = (Integer)r.getVar("numBytes");
                data = new byte[numbytes + 4];
                r.setVar("data", data);
                try {
                    r.exec("dis.read(data)");
                }
                catch (ReflectException exc) {
                    if (!debug) break block26;
                    this.trace(exc);
                }
            }
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            boolean isContents = entryName.toUpperCase().equals("CONTENTS");
            Object directory = r.getVar("dir");
            RandomAccessStream s = new RandomAccessStream(data);
            s.order(true);
            if (dirName.toUpperCase().equals("ROOT ENTRY") || dirName.toUpperCase().equals("ROOTENTRY")) {
                if (entryName.equals("Tags")) {
                    this.parseTags(s);
                }
            } else if (dirName.equals("Tags") && isContents) {
                this.parseTags(s);
            } else if (isContents && (dirName.equals("Image") || dirName.toUpperCase().indexOf("ITEM") != -1) && data.length > this.core.sizeX[0] * this.core.sizeY[0]) {
                s.skipBytes(6);
                short vt = s.readShort();
                if (vt == 3) {
                    s.skipBytes(6);
                } else if (vt == 8) {
                    short l = s.readShort();
                    s.skipBytes(l + 2);
                }
                int len = s.readShort();
                if (s.readShort() != 0) {
                    s.seek(s.getFilePointer() - 2L);
                }
                String typeDescription = "";
                if (s.getFilePointer() + (long)len > s.length()) break;
                typeDescription = s.readString(len);
                vt = s.readShort();
                if (vt == 8) {
                    len = s.readInt();
                    s.skipBytes(len + 2);
                }
                int tw = s.readInt();
                if (this.core.sizeX[0] == 0 || tw < this.core.sizeX[0] && tw > 0) {
                    this.core.sizeX[0] = tw;
                }
                s.skipBytes(2);
                int th = s.readInt();
                if (this.core.sizeY[0] == 0 || th < this.core.sizeY[0] && th > 0) {
                    this.core.sizeY[0] = th;
                }
                s.skipBytes(2);
                int zDepth = s.readInt();
                s.skipBytes(2);
                int pixelFormat = s.readInt();
                s.skipBytes(2);
                int numImageContainers = s.readInt();
                s.skipBytes(2);
                int validBitsPerPixel = s.readInt();
                while (s.readShort() != 65) {
                }
                len = s.readInt();
                s.skipBytes(len);
                s.skipBytes(2);
                long old = s.getFilePointer();
                len = s.readInt();
                s.skipBytes(8);
                int tidx = s.readInt();
                int cidx = s.readInt();
                int zidx = s.readInt();
                Integer zndx = new Integer(zidx);
                Integer cndx = new Integer(cidx);
                Integer tndx = new Integer(tidx);
                if (!this.zIndices.contains(zndx)) {
                    this.zIndices.add(zndx);
                }
                if (!this.cIndices.contains(cndx)) {
                    this.cIndices.add(cndx);
                }
                if (!this.tIndices.contains(tndx)) {
                    this.tIndices.add(tndx);
                }
                s.seek(old + (long)len + 4L);
                boolean foundWidth = s.readInt() == this.core.sizeX[0];
                boolean foundHeight = s.readInt() == this.core.sizeY[0];
                boolean findFailed = false;
                while (!(foundWidth && foundHeight || s.getFilePointer() + 1L >= s.length())) {
                    s.seek(s.getFilePointer() - 7L);
                    foundWidth = s.readInt() == this.core.sizeX[0];
                    boolean bl = foundHeight = s.readInt() == this.core.sizeY[0];
                }
                s.seek(s.getFilePointer() - 16L);
                boolean bl = findFailed = !foundWidth && !foundHeight;
                if (dirName.toUpperCase().indexOf("ITEM") != -1 || dirName.equals("Image") && numImageContainers == 0) {
                    if (findFailed) {
                        s.seek(old + (long)len + 92L);
                    }
                    long fp = s.getFilePointer();
                    byte[] o = new byte[(int)(s.length() - fp)];
                    s.read(o);
                    int imageNum = 0;
                    if (dirName.toUpperCase().indexOf("ITEM") != -1) {
                        String num = dirName.substring(5);
                        num = num.substring(0, num.length() - 1);
                        imageNum = Integer.parseInt(num);
                    }
                    this.offsets.put(new Integer(imageNum), new Integer((int)fp + 32));
                    this.parsePlane(o, imageNum, directory, entryName);
                }
            }
            s.close();
            data = null;
            r.exec("dis.close()");
        }
    }

    protected void print(int depth, String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append("  ");
            ++i;
        }
        sb.append(s);
        this.debug(sb.toString());
    }

    private void parsePlane(byte[] data, int num, Object directory, String entry) throws IOException {
        RandomAccessStream s = new RandomAccessStream(data);
        s.order(true);
        s.skipBytes(8);
        this.core.sizeX[0] = s.readInt();
        this.core.sizeY[0] = s.readInt();
        int depth = s.readInt();
        this.bpp = s.readInt();
        int pixelFormat = s.readInt();
        int validBitsPerPixel = s.readInt();
        this.pixels.put(new Integer(num), directory);
        this.names.put(new Integer(num), entry);
        this.core.imageCount[0] = this.core.imageCount[0] + 1;
        this.core.sizeC[0] = this.bpp % 3 == 0 ? 3 : 1;
    }

    private void parseTags(RandomAccessStream s) throws IOException {
        s.skipBytes(24);
        int count = s.readInt();
        if (count > 4096) {
            count = 4096;
        }
        int i = 0;
        while (i < count) {
            if (s.getFilePointer() + 2L >= s.length()) break;
            short type = s.readShort();
            String value = "";
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    value = "" + s.readShort();
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    value = "" + s.readInt();
                    break;
                }
                case 4: {
                    value = "" + s.readFloat();
                    break;
                }
                case 5: {
                    value = "" + s.readDouble();
                    break;
                }
                case 7: 
                case 20: 
                case 21: {
                    value = "" + s.readLong();
                    break;
                }
                case 8: 
                case 69: {
                    int len = s.readInt();
                    if (s.getFilePointer() + (long)len < s.length()) {
                        value = s.readString(len);
                        break;
                    }
                    return;
                }
                case 66: {
                    short l = s.readShort();
                    s.seek(s.getFilePointer() - 2L);
                    value = s.readString(l + 2);
                    break;
                }
                default: {
                    long old = s.getFilePointer();
                    while (s.readShort() != 3 && s.getFilePointer() + 2L < s.length()) {
                    }
                    long fp = s.getFilePointer() - 2L;
                    s.seek(old - 2L);
                    value = s.readString((int)(fp - old + 2L));
                }
            }
            s.skipBytes(2);
            int tagID = 0;
            int attribute = 0;
            try {
                tagID = s.readInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            s.skipBytes(2);
            try {
                attribute = s.readInt();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.parseTag(value, tagID, attribute);
            if (this.metadata.get("ImageWidth") != null) {
                try {
                    if (this.core.sizeX[0] == 0) {
                        this.core.sizeX[0] = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.metadata.get("ImageHeight") != null) {
                try {
                    if (this.core.sizeY[0] == 0) {
                        this.core.sizeY[0] = Integer.parseInt(value);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void parseTag(String data, int tagID, int attribute) {
        if (data == null || data.length() == 0) {
            return;
        }
        switch (tagID) {
            case 222: {
                this.addMeta("Compression", data);
                break;
            }
            case 258: {
                this.addMeta("BlackValue", data);
                break;
            }
            case 259: {
                this.addMeta("WhiteValue", data);
                break;
            }
            case 260: {
                this.addMeta("ImageDataMappingAutoRange", data);
                break;
            }
            case 261: {
                this.addMeta("Thumbnail", data);
                break;
            }
            case 262: {
                this.addMeta("GammaValue", data);
                break;
            }
            case 264: {
                this.addMeta("ImageOverExposure", data);
                break;
            }
            case 265: {
                this.addMeta("ImageRelativeTime1", data);
                break;
            }
            case 266: {
                this.addMeta("ImageRelativeTime2", data);
                break;
            }
            case 267: {
                this.addMeta("ImageRelativeTime3", data);
                break;
            }
            case 268: {
                this.addMeta("ImageRelativeTime4", data);
                break;
            }
            case 333: {
                this.addMeta("RelFocusPosition1", data);
                break;
            }
            case 334: {
                this.addMeta("RelFocusPosition2", data);
                break;
            }
            case 513: {
                this.addMeta("ObjectType", data);
                break;
            }
            case 515: {
                this.addMeta("ImageWidth", data);
                break;
            }
            case 516: {
                this.addMeta("ImageHeight", data);
                break;
            }
            case 517: {
                this.addMeta("Number Raw Count", data);
                break;
            }
            case 518: {
                this.addMeta("PixelType", data);
                break;
            }
            case 519: {
                this.addMeta("NumberOfRawImages", data);
                break;
            }
            case 520: {
                this.addMeta("ImageSize", data);
                break;
            }
            case 523: {
                this.addMeta("Acquisition pause annotation", data);
                break;
            }
            case 530: {
                this.addMeta("Document Subtype", data);
                break;
            }
            case 531: {
                this.addMeta("Acquisition Bit Depth", data);
                break;
            }
            case 532: {
                this.addMeta("Image Memory Usage (RAM)", data);
                break;
            }
            case 534: {
                this.addMeta("Z-Stack single representative", data);
                break;
            }
            case 769: {
                this.addMeta("Scale Factor for X", data);
                break;
            }
            case 770: {
                this.addMeta("Scale Unit for X", data);
                break;
            }
            case 771: {
                this.addMeta("Scale Width", data);
                break;
            }
            case 772: {
                this.addMeta("Scale Factor for Y", data);
                break;
            }
            case 773: {
                this.addMeta("Scale Unit for Y", data);
                break;
            }
            case 774: {
                this.addMeta("Scale Height", data);
                break;
            }
            case 775: {
                this.addMeta("Scale Factor for Z", data);
                break;
            }
            case 776: {
                this.addMeta("Scale Unit for Z", data);
                break;
            }
            case 777: {
                this.addMeta("Scale Depth", data);
                break;
            }
            case 778: {
                this.addMeta("Scaling Parent", data);
                break;
            }
            case 1001: {
                this.addMeta("Date", data);
                break;
            }
            case 1002: {
                this.addMeta("code", data);
                break;
            }
            case 1003: {
                this.addMeta("Source", data);
                break;
            }
            case 1004: {
                this.addMeta("Message", data);
                break;
            }
            case 1025: {
                this.addMeta("Acquisition Date", data);
                break;
            }
            case 1026: {
                this.addMeta("8-bit acquisition", data);
                break;
            }
            case 1027: {
                this.addMeta("Camera Bit Depth", data);
                break;
            }
            case 1029: {
                this.addMeta("MonoReferenceLow", data);
                break;
            }
            case 1030: {
                this.addMeta("MonoReferenceHigh", data);
                break;
            }
            case 1031: {
                this.addMeta("RedReferenceLow", data);
                break;
            }
            case 1032: {
                this.addMeta("RedReferenceHigh", data);
                break;
            }
            case 1033: {
                this.addMeta("GreenReferenceLow", data);
                break;
            }
            case 1034: {
                this.addMeta("GreenReferenceHigh", data);
                break;
            }
            case 1035: {
                this.addMeta("BlueReferenceLow", data);
                break;
            }
            case 1036: {
                this.addMeta("BlueReferenceHigh", data);
                break;
            }
            case 1041: {
                this.addMeta("FrameGrabber Name", data);
                break;
            }
            case 1042: {
                this.addMeta("Camera", data);
                break;
            }
            case 1044: {
                this.addMeta("CameraTriggerSignalType", data);
                break;
            }
            case 1045: {
                this.addMeta("CameraTriggerEnable", data);
                break;
            }
            case 1046: {
                this.addMeta("GrabberTimeout", data);
                break;
            }
            case 1281: {
                this.addMeta("MultiChannelEnabled", data);
                break;
            }
            case 1282: {
                this.addMeta("MultiChannel Color", data);
                break;
            }
            case 1283: {
                this.addMeta("MultiChannel Weight", data);
                break;
            }
            case 1284: {
                this.addMeta("Channel Name", data);
                break;
            }
            case 1536: {
                this.addMeta("DocumentInformationGroup", data);
                break;
            }
            case 1537: {
                this.addMeta("Title", data);
                break;
            }
            case 1538: {
                this.addMeta("Author", data);
                break;
            }
            case 1539: {
                this.addMeta("Keywords", data);
                break;
            }
            case 1540: {
                this.addMeta("Comments", data);
                break;
            }
            case 1541: {
                this.addMeta("SampleID", data);
                break;
            }
            case 1542: {
                this.addMeta("Subject", data);
                break;
            }
            case 1543: {
                this.addMeta("RevisionNumber", data);
                break;
            }
            case 1544: {
                this.addMeta("Save Folder", data);
                break;
            }
            case 1545: {
                this.addMeta("FileLink", data);
                break;
            }
            case 1546: {
                this.addMeta("Document Type", data);
                break;
            }
            case 1547: {
                this.addMeta("Storage Media", data);
                break;
            }
            case 1548: {
                this.addMeta("File ID", data);
                break;
            }
            case 1549: {
                this.addMeta("Reference", data);
                break;
            }
            case 1550: {
                this.addMeta("File Date", data);
                break;
            }
            case 1551: {
                this.addMeta("File Size", data);
                break;
            }
            case 1553: {
                this.addMeta("Filename", data);
                break;
            }
            case 1792: {
                this.addMeta("ProjectGroup", data);
                break;
            }
            case 1793: {
                this.addMeta("Acquisition Date", data);
                break;
            }
            case 1794: {
                this.addMeta("Last modified by", data);
                break;
            }
            case 1795: {
                this.addMeta("User company", data);
                break;
            }
            case 1796: {
                this.addMeta("User company logo", data);
                break;
            }
            case 1797: {
                this.addMeta("Image", data);
                break;
            }
            case 1800: {
                this.addMeta("User ID", data);
                break;
            }
            case 1801: {
                this.addMeta("User Name", data);
                break;
            }
            case 1802: {
                this.addMeta("User City", data);
                break;
            }
            case 1803: {
                this.addMeta("User Address", data);
                break;
            }
            case 1804: {
                this.addMeta("User Country", data);
                break;
            }
            case 1805: {
                this.addMeta("User Phone", data);
                break;
            }
            case 1806: {
                this.addMeta("User Fax", data);
                break;
            }
            case 2049: {
                this.addMeta("Objective Name", data);
                break;
            }
            case 2050: {
                this.addMeta("Optovar", data);
                break;
            }
            case 2051: {
                this.addMeta("Reflector", data);
                break;
            }
            case 2052: {
                this.addMeta("Condenser Contrast", data);
                break;
            }
            case 2053: {
                this.addMeta("Transmitted Light Filter 1", data);
                break;
            }
            case 2054: {
                this.addMeta("Transmitted Light Filter 2", data);
                break;
            }
            case 2055: {
                this.addMeta("Reflected Light Shutter", data);
                break;
            }
            case 2056: {
                this.addMeta("Condenser Front Lens", data);
                break;
            }
            case 2057: {
                this.addMeta("Excitation Filter Name", data);
                break;
            }
            case 2060: {
                this.addMeta("Transmitted Light Fieldstop Aperture", data);
                break;
            }
            case 2061: {
                this.addMeta("Reflected Light Aperture", data);
                break;
            }
            case 2062: {
                this.addMeta("Condenser N.A.", data);
                break;
            }
            case 2063: {
                this.addMeta("Light Path", data);
                break;
            }
            case 2064: {
                this.addMeta("HalogenLampOn", data);
                break;
            }
            case 2065: {
                this.addMeta("Halogen Lamp Mode", data);
                break;
            }
            case 2066: {
                this.addMeta("Halogen Lamp Voltage", data);
                break;
            }
            case 2068: {
                this.addMeta("Fluorescence Lamp Level", data);
                break;
            }
            case 2069: {
                this.addMeta("Fluorescence Lamp Intensity", data);
                break;
            }
            case 2070: {
                this.addMeta("LightManagerEnabled", data);
                break;
            }
            case 2071: {
                this.addMeta("tag_ID_2071", data);
                break;
            }
            case 2072: {
                this.addMeta("Focus Position", data);
                break;
            }
            case 2073: {
                this.addMeta("Stage Position X", data);
                break;
            }
            case 2074: {
                this.addMeta("Stage Position Y", data);
                break;
            }
            case 2075: {
                this.addMeta("Microscope Name", data);
                break;
            }
            case 2076: {
                this.addMeta("Objective Magnification", data);
                break;
            }
            case 2077: {
                this.addMeta("Objective N.A.", data);
                break;
            }
            case 2078: {
                this.addMeta("MicroscopeIllumination", data);
                break;
            }
            case 2079: {
                this.addMeta("External Shutter 1", data);
                break;
            }
            case 2080: {
                this.addMeta("External Shutter 2", data);
                break;
            }
            case 2081: {
                this.addMeta("External Shutter 3", data);
                break;
            }
            case 2082: {
                this.addMeta("External Filter Wheel 1 Name", data);
                break;
            }
            case 2083: {
                this.addMeta("External Filter Wheel 2 Name", data);
                break;
            }
            case 2084: {
                this.addMeta("Parfocal Correction", data);
                break;
            }
            case 2086: {
                this.addMeta("External Shutter 4", data);
                break;
            }
            case 2087: {
                this.addMeta("External Shutter 5", data);
                break;
            }
            case 2088: {
                this.addMeta("External Shutter 6", data);
                break;
            }
            case 2089: {
                this.addMeta("External Filter Wheel 3 Name", data);
                break;
            }
            case 2090: {
                this.addMeta("External Filter Wheel 4 Name", data);
                break;
            }
            case 2103: {
                this.addMeta("Objective Turret Position", data);
                break;
            }
            case 2104: {
                this.addMeta("Objective Contrast Method", data);
                break;
            }
            case 2105: {
                this.addMeta("Objective Immersion Type", data);
                break;
            }
            case 2107: {
                this.addMeta("Reflector Position", data);
                break;
            }
            case 2109: {
                this.addMeta("Transmitted Light Filter 1 Position", data);
                break;
            }
            case 2110: {
                this.addMeta("Transmitted Light Filter 2 Position", data);
                break;
            }
            case 2112: {
                this.addMeta("Excitation Filter Position", data);
                break;
            }
            case 2113: {
                this.addMeta("Lamp Mirror Position", data);
                break;
            }
            case 2114: {
                this.addMeta("External Filter Wheel 1 Position", data);
                break;
            }
            case 2115: {
                this.addMeta("External Filter Wheel 2 Position", data);
                break;
            }
            case 2116: {
                this.addMeta("External Filter Wheel 3 Position", data);
                break;
            }
            case 2117: {
                this.addMeta("External Filter Wheel 4 Position", data);
                break;
            }
            case 2118: {
                this.addMeta("Lightmanager Mode", data);
                break;
            }
            case 2119: {
                this.addMeta("Halogen Lamp Calibration", data);
                break;
            }
            case 2120: {
                this.addMeta("CondenserNAGoSpeed", data);
                break;
            }
            case 2121: {
                this.addMeta("TransmittedLightFieldstopGoSpeed", data);
                break;
            }
            case 2122: {
                this.addMeta("OptovarGoSpeed", data);
                break;
            }
            case 2123: {
                this.addMeta("Focus calibrated", data);
                break;
            }
            case 2124: {
                this.addMeta("FocusBasicPosition", data);
                break;
            }
            case 2125: {
                this.addMeta("FocusPower", data);
                break;
            }
            case 2126: {
                this.addMeta("FocusBacklash", data);
                break;
            }
            case 2127: {
                this.addMeta("FocusMeasurementOrigin", data);
                break;
            }
            case 2128: {
                this.addMeta("FocusMeasurementDistance", data);
                break;
            }
            case 2129: {
                this.addMeta("FocusSpeed", data);
                break;
            }
            case 2130: {
                this.addMeta("FocusGoSpeed", data);
                break;
            }
            case 2131: {
                this.addMeta("FocusDistance", data);
                break;
            }
            case 2132: {
                this.addMeta("FocusInitPosition", data);
                break;
            }
            case 2133: {
                this.addMeta("Stage calibrated", data);
                break;
            }
            case 2134: {
                this.addMeta("StagePower", data);
                break;
            }
            case 2135: {
                this.addMeta("StageXBacklash", data);
                break;
            }
            case 2136: {
                this.addMeta("StageYBacklash", data);
                break;
            }
            case 2137: {
                this.addMeta("StageSpeedX", data);
                break;
            }
            case 2138: {
                this.addMeta("StageSpeedY", data);
                break;
            }
            case 2139: {
                this.addMeta("StageSpeed", data);
                break;
            }
            case 2140: {
                this.addMeta("StageGoSpeedX", data);
                break;
            }
            case 2141: {
                this.addMeta("StageGoSpeedY", data);
                break;
            }
            case 2142: {
                this.addMeta("StageStepDistanceX", data);
                break;
            }
            case 2143: {
                this.addMeta("StageStepDistanceY", data);
                break;
            }
            case 2144: {
                this.addMeta("StageInitialisationPositionX", data);
                break;
            }
            case 2145: {
                this.addMeta("StageInitialisationPositionY", data);
                break;
            }
            case 2146: {
                this.addMeta("MicroscopeMagnification", data);
                break;
            }
            case 2147: {
                this.addMeta("ReflectorMagnification", data);
                break;
            }
            case 2148: {
                this.addMeta("LampMirrorPosition", data);
                break;
            }
            case 2149: {
                this.addMeta("FocusDepth", data);
                break;
            }
            case 2150: {
                this.addMeta("MicroscopeType", data);
                break;
            }
            case 2151: {
                this.addMeta("Objective Working Distance", data);
                break;
            }
            case 2152: {
                this.addMeta("ReflectedLightApertureGoSpeed", data);
                break;
            }
            case 2153: {
                this.addMeta("External Shutter", data);
                break;
            }
            case 2154: {
                this.addMeta("ObjectiveImmersionStop", data);
                break;
            }
            case 2155: {
                this.addMeta("Focus Start Speed", data);
                break;
            }
            case 2156: {
                this.addMeta("Focus Acceleration", data);
                break;
            }
            case 2157: {
                this.addMeta("ReflectedLightFieldstop", data);
                break;
            }
            case 2158: {
                this.addMeta("ReflectedLightFieldstopGoSpeed", data);
                break;
            }
            case 2159: {
                this.addMeta("ReflectedLightFilter 1", data);
                break;
            }
            case 2160: {
                this.addMeta("ReflectedLightFilter 2", data);
                break;
            }
            case 2161: {
                this.addMeta("ReflectedLightFilter1Position", data);
                break;
            }
            case 2162: {
                this.addMeta("ReflectedLightFilter2Position", data);
                break;
            }
            case 2163: {
                this.addMeta("TransmittedLightAttenuator", data);
                break;
            }
            case 2164: {
                this.addMeta("ReflectedLightAttenuator", data);
                break;
            }
            case 2165: {
                this.addMeta("Transmitted Light Shutter", data);
                break;
            }
            case 2166: {
                this.addMeta("TransmittedLightAttenuatorGoSpeed", data);
                break;
            }
            case 2167: {
                this.addMeta("ReflectedLightAttenuatorGoSpeed", data);
                break;
            }
            case 2176: {
                this.addMeta("TransmittedLightVirtualFilterPosition", data);
                break;
            }
            case 2177: {
                this.addMeta("TransmittedLightVirtualFilter", data);
                break;
            }
            case 2178: {
                this.addMeta("ReflectedLightVirtualFilterPosition", data);
                break;
            }
            case 2179: {
                this.addMeta("ReflectedLightVirtualFilter", data);
                break;
            }
            case 2180: {
                this.addMeta("ReflectedLightHalogenLampMode", data);
                break;
            }
            case 2181: {
                this.addMeta("ReflectedLightHalogenLampVoltage", data);
                break;
            }
            case 2182: {
                this.addMeta("ReflectedLightHalogenLampColorTemperature", data);
                break;
            }
            case 2183: {
                this.addMeta("ContrastManagerMode", data);
                break;
            }
            case 2184: {
                this.addMeta("Dazzle Protection Active", data);
                break;
            }
            case 2195: {
                this.addMeta("Zoom", data);
                break;
            }
            case 2196: {
                this.addMeta("ZoomGoSpeed", data);
                break;
            }
            case 2197: {
                this.addMeta("LightZoom", data);
                break;
            }
            case 2198: {
                this.addMeta("LightZoomGoSpeed", data);
                break;
            }
            case 2199: {
                this.addMeta("LightZoomCoupled", data);
                break;
            }
            case 2200: {
                this.addMeta("TransmittedLightHalogenLampMode", data);
                break;
            }
            case 2201: {
                this.addMeta("TransmittedLightHalogenLampVoltage", data);
                break;
            }
            case 2202: {
                this.addMeta("TransmittedLightHalogenLampColorTemperature", data);
                break;
            }
            case 2203: {
                this.addMeta("Reflected Coldlight Mode", data);
                break;
            }
            case 2204: {
                this.addMeta("Reflected Coldlight Intensity", data);
                break;
            }
            case 2205: {
                this.addMeta("Reflected Coldlight Color Temperature", data);
                break;
            }
            case 2206: {
                this.addMeta("Transmitted Coldlight Mode", data);
                break;
            }
            case 2207: {
                this.addMeta("Transmitted Coldlight Intensity", data);
                break;
            }
            case 2208: {
                this.addMeta("Transmitted Coldlight Color Temperature", data);
                break;
            }
            case 2209: {
                this.addMeta("Infinityspace Portchanger Position", data);
                break;
            }
            case 2210: {
                this.addMeta("Beamsplitter Infinity Space", data);
                break;
            }
            case 2211: {
                this.addMeta("TwoTv VisCamChanger Position", data);
                break;
            }
            case 2212: {
                this.addMeta("Beamsplitter Ocular", data);
                break;
            }
            case 2213: {
                this.addMeta("TwoTv CamerasChanger Position", data);
                break;
            }
            case 2214: {
                this.addMeta("Beamsplitter Cameras", data);
                break;
            }
            case 2215: {
                this.addMeta("Ocular Shutter", data);
                break;
            }
            case 2216: {
                this.addMeta("TwoTv CamerasChangerCube", data);
                break;
            }
            case 2218: {
                this.addMeta("Ocular Magnification", data);
                break;
            }
            case 2219: {
                this.addMeta("Camera Adapter Magnification", data);
                break;
            }
            case 2220: {
                this.addMeta("Microscope Port", data);
                break;
            }
            case 2221: {
                this.addMeta("Ocular Total Magnification", data);
                break;
            }
            case 2222: {
                this.addMeta("Field of View", data);
                break;
            }
            case 2223: {
                this.addMeta("Ocular", data);
                break;
            }
            case 2224: {
                this.addMeta("CameraAdapter", data);
                break;
            }
            case 2225: {
                this.addMeta("StageJoystickEnabled", data);
                break;
            }
            case 2226: {
                this.addMeta("ContrastManager Contrast Method", data);
                break;
            }
            case 2229: {
                this.addMeta("CamerasChanger Beamsplitter Type", data);
                break;
            }
            case 2235: {
                this.addMeta("Rearport Slider Position", data);
                break;
            }
            case 2236: {
                this.addMeta("Rearport Source", data);
                break;
            }
            case 2237: {
                this.addMeta("Beamsplitter Type Infinity Space", data);
                break;
            }
            case 2238: {
                this.addMeta("Fluorescence Attenuator", data);
                break;
            }
            case 2239: {
                this.addMeta("Fluorescence Attenuator Position", data);
                break;
            }
            case 2261: {
                this.addMeta("Objective ID", data);
                break;
            }
            case 2262: {
                this.addMeta("Reflector ID", data);
                break;
            }
            case 2307: {
                this.addMeta("Camera Framestart Left", data);
                break;
            }
            case 2308: {
                this.addMeta("Camera Framestart Top", data);
                break;
            }
            case 2309: {
                this.addMeta("Camera Frame Width", data);
                break;
            }
            case 2310: {
                this.addMeta("Camera Frame Height", data);
                break;
            }
            case 2311: {
                this.addMeta("Camera Binning", data);
                break;
            }
            case 2312: {
                this.addMeta("CameraFrameFull", data);
                break;
            }
            case 2313: {
                this.addMeta("CameraFramePixelDistance", data);
                break;
            }
            case 2318: {
                this.addMeta("DataFormatUseScaling", data);
                break;
            }
            case 2319: {
                this.addMeta("CameraFrameImageOrientation", data);
                break;
            }
            case 2320: {
                this.addMeta("VideoMonochromeSignalType", data);
                break;
            }
            case 2321: {
                this.addMeta("VideoColorSignalType", data);
                break;
            }
            case 2322: {
                this.addMeta("MeteorChannelInput", data);
                break;
            }
            case 2323: {
                this.addMeta("MeteorChannelSync", data);
                break;
            }
            case 2324: {
                this.addMeta("WhiteBalanceEnabled", data);
                break;
            }
            case 2325: {
                this.addMeta("CameraWhiteBalanceRed", data);
                break;
            }
            case 2326: {
                this.addMeta("CameraWhiteBalanceGreen", data);
                break;
            }
            case 2327: {
                this.addMeta("CameraWhiteBalanceBlue", data);
                break;
            }
            case 2331: {
                this.addMeta("CameraFrameScalingFactor", data);
                break;
            }
            case 2562: {
                this.addMeta("Meteor Camera Type", data);
                break;
            }
            case 2564: {
                this.addMeta("Exposure Time [ms]", data);
                break;
            }
            case 2568: {
                this.addMeta("CameraExposureTimeAutoCalculate", data);
                break;
            }
            case 2569: {
                this.addMeta("Meteor Gain Value", data);
                break;
            }
            case 2571: {
                this.addMeta("Meteor Gain Automatic", data);
                break;
            }
            case 2572: {
                this.addMeta("MeteorAdjustHue", data);
                break;
            }
            case 2573: {
                this.addMeta("MeteorAdjustSaturation", data);
                break;
            }
            case 2574: {
                this.addMeta("MeteorAdjustRedLow", data);
                break;
            }
            case 2575: {
                this.addMeta("MeteorAdjustGreenLow", data);
                break;
            }
            case 2576: {
                this.addMeta("Meteor Blue Low", data);
                break;
            }
            case 2577: {
                this.addMeta("MeteorAdjustRedHigh", data);
                break;
            }
            case 2578: {
                this.addMeta("MeteorAdjustGreenHigh", data);
                break;
            }
            case 2579: {
                this.addMeta("MeteorBlue High", data);
                break;
            }
            case 2582: {
                this.addMeta("CameraExposureTimeCalculationControl", data);
                break;
            }
            case 2585: {
                this.addMeta("AxioCamFadingCorrectionEnable", data);
                break;
            }
            case 2587: {
                this.addMeta("CameraLiveImage", data);
                break;
            }
            case 2588: {
                this.addMeta("CameraLiveEnabled", data);
                break;
            }
            case 2589: {
                this.addMeta("LiveImageSyncObjectName", data);
                break;
            }
            case 2590: {
                this.addMeta("CameraLiveSpeed", data);
                break;
            }
            case 2591: {
                this.addMeta("CameraImage", data);
                break;
            }
            case 2592: {
                this.addMeta("CameraImageWidth", data);
                break;
            }
            case 2593: {
                this.addMeta("CameraImageHeight", data);
                break;
            }
            case 2594: {
                this.addMeta("CameraImagePixelType", data);
                break;
            }
            case 2595: {
                this.addMeta("CameraImageShMemoryName", data);
                break;
            }
            case 2596: {
                this.addMeta("CameraLiveImageWidth", data);
                break;
            }
            case 2597: {
                this.addMeta("CameraLiveImageHeight", data);
                break;
            }
            case 2598: {
                this.addMeta("CameraLiveImagePixelType", data);
                break;
            }
            case 2599: {
                this.addMeta("CameraLiveImageShMemoryName", data);
                break;
            }
            case 2600: {
                this.addMeta("CameraLiveMaximumSpeed", data);
                break;
            }
            case 2601: {
                this.addMeta("CameraLiveBinning", data);
                break;
            }
            case 2602: {
                this.addMeta("CameraLiveGainValue", data);
                break;
            }
            case 2603: {
                this.addMeta("CameraLiveExposureTimeValue", data);
                break;
            }
            case 2604: {
                this.addMeta("CameraLiveScalingFactor", data);
                break;
            }
            case 2819: {
                this.addMeta("Image Index Z", data);
                this.zIndex = Integer.parseInt(DataTools.stripString(data));
                break;
            }
            case 2820: {
                this.addMeta("Image Channel Index", data);
                this.cIndex = Integer.parseInt(DataTools.stripString(data));
                break;
            }
            case 2821: {
                this.addMeta("Image Index T", data);
                this.tIndex = Integer.parseInt(DataTools.stripString(data));
                break;
            }
            case 2822: {
                this.addMeta("ImageTile Index", data);
                break;
            }
            case 2823: {
                this.addMeta("Image acquisition Index", data);
                break;
            }
            case 2827: {
                this.addMeta("Image IndexS", data);
                break;
            }
            case 2841: {
                this.addMeta("Original Stage Position X", data);
                break;
            }
            case 2842: {
                this.addMeta("Original Stage Position Y", data);
                break;
            }
            case 3088: {
                this.addMeta("LayerDrawFlags", data);
                break;
            }
            case 3334: {
                this.addMeta("RemainingTime", data);
                break;
            }
            case 3585: {
                this.addMeta("User Field 1", data);
                break;
            }
            case 3586: {
                this.addMeta("User Field 2", data);
                break;
            }
            case 3587: {
                this.addMeta("User Field 3", data);
                break;
            }
            case 3588: {
                this.addMeta("User Field 4", data);
                break;
            }
            case 3589: {
                this.addMeta("User Field 5", data);
                break;
            }
            case 3590: {
                this.addMeta("User Field 6", data);
                break;
            }
            case 3591: {
                this.addMeta("User Field 7", data);
                break;
            }
            case 3592: {
                this.addMeta("User Field 8", data);
                break;
            }
            case 3593: {
                this.addMeta("User Field 9", data);
                break;
            }
            case 3594: {
                this.addMeta("User Field 10", data);
                break;
            }
            case 3840: {
                this.addMeta("ID", data);
                break;
            }
            case 3841: {
                this.addMeta("Name", data);
                break;
            }
            case 3842: {
                this.addMeta("Value", data);
                break;
            }
            case 5501: {
                this.addMeta("PvCamClockingMode", data);
                break;
            }
            case 8193: {
                this.addMeta("Autofocus Status Report", data);
                break;
            }
            case 8194: {
                this.addMeta("Autofocus Position", data);
                break;
            }
            case 8195: {
                this.addMeta("Autofocus Position Offset", data);
                break;
            }
            case 8196: {
                this.addMeta("Autofocus Empty Field Threshold", data);
                break;
            }
            case 8197: {
                this.addMeta("Autofocus Calibration Name", data);
                break;
            }
            case 8198: {
                this.addMeta("Autofocus Current Calibration Item", data);
                break;
            }
            case 20478: {
                this.addMeta("tag_ID_20478", data);
                break;
            }
            case 65537: {
                this.addMeta("CameraFrameFullWidth", data);
                break;
            }
            case 65538: {
                this.addMeta("CameraFrameFullHeight", data);
                break;
            }
            case 65541: {
                this.addMeta("AxioCam Shutter Signal", data);
                break;
            }
            case 65542: {
                this.addMeta("AxioCam Delay Time", data);
                break;
            }
            case 65543: {
                this.addMeta("AxioCam Shutter Control", data);
                break;
            }
            case 65544: {
                this.addMeta("AxioCam BlackRefIsCalculated", data);
                break;
            }
            case 65545: {
                this.addMeta("AxioCam Black Reference", data);
                break;
            }
            case 65547: {
                this.addMeta("Camera Shading Correction", data);
                break;
            }
            case 65550: {
                this.addMeta("AxioCam Enhance Color", data);
                break;
            }
            case 65551: {
                this.addMeta("AxioCam NIR Mode", data);
                break;
            }
            case 65552: {
                this.addMeta("CameraShutterCloseDelay", data);
                break;
            }
            case 65553: {
                this.addMeta("CameraWhiteBalanceAutoCalculate", data);
                break;
            }
            case 65556: {
                this.addMeta("AxioCam NIR Mode Available", data);
                break;
            }
            case 65557: {
                this.addMeta("AxioCam Fading Correction Available", data);
                break;
            }
            case 65559: {
                this.addMeta("AxioCam Enhance Color Available", data);
                break;
            }
            case 65565: {
                this.addMeta("MeteorVideoNorm", data);
                break;
            }
            case 65566: {
                this.addMeta("MeteorAdjustWhiteReference", data);
                break;
            }
            case 65567: {
                this.addMeta("MeteorBlackReference", data);
                break;
            }
            case 65568: {
                this.addMeta("MeteorChannelInputCountMono", data);
                break;
            }
            case 65570: {
                this.addMeta("MeteorChannelInputCountRGB", data);
                break;
            }
            case 65571: {
                this.addMeta("MeteorEnableVCR", data);
                break;
            }
            case 65572: {
                this.addMeta("Meteor Brightness", data);
                break;
            }
            case 65573: {
                this.addMeta("Meteor Contrast", data);
                break;
            }
            case 65575: {
                this.addMeta("AxioCam Selector", data);
                break;
            }
            case 65576: {
                this.addMeta("AxioCam Type", data);
                break;
            }
            case 65577: {
                this.addMeta("AxioCam Info", data);
                break;
            }
            case 65580: {
                this.addMeta("AxioCam Resolution", data);
                break;
            }
            case 65581: {
                this.addMeta("AxioCam Color Model", data);
                break;
            }
            case 65582: {
                this.addMeta("AxioCam MicroScanning", data);
                break;
            }
            case 65585: {
                this.addMeta("Amplification Index", data);
                break;
            }
            case 65586: {
                this.addMeta("Device Command", data);
                break;
            }
            case 65587: {
                this.addMeta("BeamLocation", data);
                break;
            }
            case 65588: {
                this.addMeta("ComponentType", data);
                break;
            }
            case 65589: {
                this.addMeta("ControllerType", data);
                break;
            }
            case 65590: {
                this.addMeta("CameraWhiteBalanceCalculationRedPaint", data);
                break;
            }
            case 65591: {
                this.addMeta("CameraWhiteBalanceCalculationBluePaint", data);
                break;
            }
            case 65592: {
                this.addMeta("CameraWhiteBalanceSetRed", data);
                break;
            }
            case 65593: {
                this.addMeta("CameraWhiteBalanceSetGreen", data);
                break;
            }
            case 65594: {
                this.addMeta("CameraWhiteBalanceSetBlue", data);
                break;
            }
            case 65595: {
                this.addMeta("CameraWhiteBalanceSetTargetRed", data);
                break;
            }
            case 65596: {
                this.addMeta("CameraWhiteBalanceSetTargetGreen", data);
                break;
            }
            case 65597: {
                this.addMeta("CameraWhiteBalanceSetTargetBlue", data);
                break;
            }
            case 65598: {
                this.addMeta("ApotomeCamCalibrationMode", data);
                break;
            }
            case 65599: {
                this.addMeta("ApoTome Grid Position", data);
                break;
            }
            case 65600: {
                this.addMeta("ApotomeCamScannerPosition", data);
                break;
            }
            case 65601: {
                this.addMeta("ApoTome Full Phase Shift", data);
                break;
            }
            case 65602: {
                this.addMeta("ApoTome Grid Name", data);
                break;
            }
            case 65603: {
                this.addMeta("ApoTome Staining", data);
                break;
            }
            case 65604: {
                this.addMeta("ApoTome Processing Mode", data);
                break;
            }
            case 65605: {
                this.addMeta("ApotmeCamLiveCombineMode", data);
                break;
            }
            case 65606: {
                this.addMeta("ApoTome Filter Name", data);
                break;
            }
            case 65607: {
                this.addMeta("Apotome Filter Strength", data);
                break;
            }
            case 65608: {
                this.addMeta("ApotomeCamFilterHarmonics", data);
                break;
            }
            case 65609: {
                this.addMeta("ApoTome Grating Period", data);
                break;
            }
            case 65610: {
                this.addMeta("ApoTome Auto Shutter Used", data);
                break;
            }
            case 65611: {
                this.addMeta("Apotome Cam Status", data);
                break;
            }
            case 65612: {
                this.addMeta("ApotomeCamNormalize", data);
                break;
            }
            case 65613: {
                this.addMeta("ApotomeCamSettingsManager", data);
                break;
            }
            case 65614: {
                this.addMeta("DeepviewCamSupervisorMode", data);
                break;
            }
            case 65615: {
                this.addMeta("DeepView Processing", data);
                break;
            }
            case 65616: {
                this.addMeta("DeepviewCamFilterName", data);
                break;
            }
            case 65617: {
                this.addMeta("DeepviewCamStatus", data);
                break;
            }
            case 65618: {
                this.addMeta("DeepviewCamSettingsManager", data);
                break;
            }
            case 65619: {
                this.addMeta("DeviceScalingName", data);
                break;
            }
            case 65620: {
                this.addMeta("CameraShadingIsCalculated", data);
                break;
            }
            case 65621: {
                this.addMeta("CameraShadingCalculationName", data);
                break;
            }
            case 65622: {
                this.addMeta("CameraShadingAutoCalculate", data);
                break;
            }
            case 65623: {
                this.addMeta("CameraTriggerAvailable", data);
                break;
            }
            case 65626: {
                this.addMeta("CameraShutterAvailable", data);
                break;
            }
            case 65627: {
                this.addMeta("AxioCam ShutterMicroScanningEnable", data);
                break;
            }
            case 65628: {
                this.addMeta("ApotomeCamLiveFocus", data);
                break;
            }
            case 65629: {
                this.addMeta("DeviceInitStatus", data);
                break;
            }
            case 65630: {
                this.addMeta("DeviceErrorStatus", data);
                break;
            }
            case 65631: {
                this.addMeta("ApotomeCamSliderInGridPosition", data);
                break;
            }
            case 65632: {
                this.addMeta("Orca NIR Mode Used", data);
                break;
            }
            case 65633: {
                this.addMeta("Orca Analog Gain", data);
                break;
            }
            case 65634: {
                this.addMeta("Orca Analog Offset", data);
                break;
            }
            case 65635: {
                this.addMeta("Orca Binning", data);
                break;
            }
            case 65636: {
                this.addMeta("Orca Bit Depth", data);
                break;
            }
            case 65637: {
                this.addMeta("ApoTome Averaging Count", data);
                break;
            }
            case 65638: {
                this.addMeta("DeepView DoF", data);
                break;
            }
            case 65639: {
                this.addMeta("DeepView EDoF", data);
                break;
            }
            case 65643: {
                this.addMeta("DeepView Slider Name", data);
                break;
            }
            case 65655: {
                this.addMeta("DeepView Slider Name", data);
                break;
            }
            case 0x530003: {
                this.addMeta("Acquisition Sofware", data);
                break;
            }
            case 0x1000110: {
                this.addMeta("Excitation Wavelength", data);
                break;
            }
            case 0x1000111: {
                this.addMeta("Emission Wavelength", data);
                break;
            }
            case 101515267: {
                this.addMeta("File Name", data);
                break;
            }
            case 101253123: 
            case 101777411: {
                this.addMeta("Image Name", data);
                break;
            }
            default: {
                this.addMeta("" + tagID, data);
            }
        }
    }
}

