/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class VisitechReader
extends FormatReader {
    private Vector files;

    public VisitechReader() {
        super("Visitech XYS", new String[]{"xys", "html"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        int plane = this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        if (buf.length < plane) {
            throw new FormatException("Buffer too small.");
        }
        int fileIndex = no / (this.core.sizeZ[0] * this.core.sizeT[0]);
        int planeIndex = no % (this.core.sizeZ[0] * this.core.sizeT[0]);
        String file = (String)this.files.get(fileIndex);
        RandomAccessStream s = new RandomAccessStream(file);
        s.skipBytes(382 + (plane + 164) * planeIndex);
        s.read(buf);
        s.close();
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    public String[] getUsedFiles() {
        if (this.files == null) {
            return new String[0];
        }
        return this.files.toArray(new String[0]);
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        if (!id.toLowerCase().endsWith("html")) {
            Location file = new Location(id).getAbsoluteFile();
            String path = file.getPath();
            int ndx = path.lastIndexOf(File.separator);
            String base = path.substring(ndx + 1, path.indexOf(" ", ndx));
            this.currentId = null;
            this.initFile(new Location(file.getParent(), String.valueOf(base) + " Report.html").getAbsolutePath());
            return;
        }
        System.out.println(id);
        this.in = new RandomAccessStream(id);
        String s = this.in.readString((int)this.in.length());
        s = s.replaceAll("<[bB][rR]>", "\n");
        s = s.replaceAll("<[sS][tT][yY][lL][eE]\\p{ASCII}*?[sS][tT][yY][lL][eE]>", "");
        s = s.replaceAll("<[sS][cC][rR][iI][pP][tT]\\p{ASCII}*?[sS][cC][rR][iI][pP][tT]>", "");
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if ((!token.startsWith("<") || token.startsWith("</")) && token.indexOf("pixels") == -1) continue;
            int ndx = (token = token.replaceAll("<.*?>", "")).indexOf(":");
            if (ndx != -1) {
                this.addMeta(token.substring(0, ndx).trim(), token.substring(ndx + 1).trim());
            }
            if (token.indexOf("pixels") == -1) continue;
            this.core.sizeC[0] = this.core.sizeC[0] + 1;
            this.core.imageCount[0] = this.core.imageCount[0] + Integer.parseInt(token.substring(0, token.indexOf(" ")));
        }
        this.core.sizeZ[0] = Integer.parseInt((String)this.metadata.get("Number of steps"));
        this.core.sizeT[0] = this.core.imageCount[0] / (this.core.sizeZ[0] * this.core.sizeC[0]);
        int bits = Integer.parseInt((String)this.metadata.get("Image bit depth"));
        while (bits % 8 != 0) {
            ++bits;
        }
        switch (bits) {
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 32: {
                this.core.pixelType[0] = 5;
                break;
            }
            default: {
                this.core.pixelType[0] = 1;
            }
        }
        String xy = (String)this.metadata.get("Image dimensions");
        this.core.sizeX[0] = Integer.parseInt(xy.substring(1, xy.indexOf(",")).trim());
        this.core.sizeY[0] = Integer.parseInt(xy.substring(xy.indexOf(",") + 1, xy.length() - 1).trim());
        this.core.rgb[0] = false;
        this.core.currentOrder[0] = "XYZTC";
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = true;
        this.files = new Vector();
        Location file = new Location(id).getAbsoluteFile();
        String path = file.getPath();
        int ndx = path.lastIndexOf(File.separator);
        String base = path.substring(ndx + 1, path.indexOf(" ", ndx));
        int i = 0;
        while (i < this.core.sizeC[0]) {
            this.files.add(new Location(file.getParent(), String.valueOf(base) + " " + (i + 1) + ".xys").getAbsolutePath());
            ++i;
        }
        this.files.add(this.currentId);
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        int i2 = 0;
        while (i2 < this.core.sizeC[0]) {
            store.setLogicalChannel(i2, null, null, null, null, this.core.sizeC[0] == 1 ? "monochrome" : "RGB", null, null);
            ++i2;
        }
    }
}

