/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.in.BaseTiffReader;

public class TiffReader
extends BaseTiffReader {
    public TiffReader() {
        super("Tagged Image File Format", new String[]{"tif", "tiff"});
    }

    public boolean isMetadataComplete() {
        return true;
    }

    protected void setSizeZ(int zSize) {
        if (this.core.sizeZ == null) {
            this.core.sizeZ = new int[1];
        }
        this.core.sizeZ[0] = zSize;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        boolean ij;
        super.initStandardMetadata();
        String comment = (String)this.getMeta("Comment");
        this.status("Checking comment style");
        if (this.ifds.length > 1) {
            this.core.orderCertain[0] = false;
        }
        boolean bl = ij = comment != null && comment.startsWith("ImageJ=");
        if (ij) {
            int nl = comment.indexOf("\n");
            this.put("ImageJ", nl < 0 ? comment.substring(7) : comment.substring(7, nl));
            this.metadata.remove("Comment");
        }
        boolean metamorph = comment != null && this.getMeta("Software") != null && ((String)this.getMeta("Software")).indexOf("MetaMorph") != -1;
        this.put("MetaMorph", metamorph ? "yes" : "no");
        if (metamorph) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int colon = line.indexOf(":");
                if (colon < 0) {
                    this.addMeta("Comment", line);
                    continue;
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1);
                this.addMeta(key, value);
            }
        }
    }
}

