/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class TCSReader
extends BaseTiffReader {
    private String[] cNames;
    private int pixelSizeT;

    public TCSReader() {
        super("Leica TCS TIFF", new String[]{"tif", "tiff"});
    }

    public boolean isThisType(String name, boolean open) {
        String document;
        block6: {
            Hashtable ifd;
            block5: {
                if (!name.toLowerCase().endsWith("tif") && !name.toLowerCase().endsWith("tiff")) {
                    return false;
                }
                try {
                    RandomAccessStream ras = new RandomAccessStream(name);
                    ifd = TiffTools.getFirstIFD(ras);
                    ras.close();
                    if (ifd != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            document = (String)ifd.get(new Integer(269));
            if (document != null) break block6;
            return false;
        }
        return document.startsWith("CHANNEL");
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        int[] ch = new int[this.ifds.length];
        int[] idx = new int[this.ifds.length];
        long[] stamp = new long[this.ifds.length];
        int channelCount = 0;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss.SSS");
        int i = 0;
        while (i < this.ifds.length) {
            String document = (String)this.ifds[i].get(new Integer(269));
            int index = document.indexOf("INDEX");
            String c = document.substring(8, index).trim();
            ch[i] = Integer.parseInt(c);
            if (ch[i] > channelCount) {
                channelCount = ch[i];
            }
            String n = document.substring(index + 6, document.indexOf(" ", index + 6)).trim();
            idx[i] = Integer.parseInt(n);
            String date = document.substring(document.indexOf(" ", index + 6), document.indexOf("FORMAT")).trim();
            stamp[i] = fmt.parse(date, new ParsePosition(0)).getTime();
            ++i;
        }
        this.core.sizeT[0] = 0;
        this.core.currentOrder[0] = this.core.rgb[0] ? "XYC" : "XY";
        boolean unique = true;
        int i2 = 0;
        while (i2 < stamp.length) {
            int j = i2 + 1;
            while (j < stamp.length) {
                if (stamp[j] == stamp[i2]) {
                    unique = false;
                    break;
                }
                ++j;
            }
            if (unique) {
                this.core.sizeT[0] = this.core.sizeT[0] + 1;
                if (this.core.currentOrder[0].indexOf("T") < 0) {
                    this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "T";
                }
            } else if (i2 > 0) {
                if (ch[i2] != ch[i2 - 1] && this.core.currentOrder[0].indexOf("C") < 0) {
                    this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "C";
                } else if (this.core.currentOrder[0].indexOf("Z") < 0) {
                    this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "Z";
                }
            }
            unique = true;
            ++i2;
        }
        if (this.core.currentOrder[0].indexOf("Z") < 0) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "Z";
        }
        if (this.core.currentOrder[0].indexOf("C") < 0) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "C";
        }
        if (this.core.currentOrder[0].indexOf("T") < 0) {
            this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + "T";
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if (channelCount == 0) {
            channelCount = 1;
        }
        this.core.sizeZ[0] = this.ifds.length / (this.core.sizeT[0] * channelCount);
        this.core.sizeC[0] = this.core.sizeC[0] * channelCount;
        this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0] * channelCount;
        String comment = (String)this.getMeta("Comment");
        if (comment != null && comment.startsWith("[")) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("[")) continue;
                int eq = token.indexOf("=");
                String key = token.substring(0, eq);
                String value = token.substring(eq + 1);
                this.addMeta(key, value);
            }
            this.metadata.remove("Comment");
        }
    }
}

