/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.TiffReader;

public class PrairieReader
extends FormatReader {
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private String[] files;
    private TiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private boolean readXML = false;
    private boolean readCFG = false;

    public PrairieReader() {
        super("Prairie (TIFF)", new String[]{"tif", "tiff", "cfg", "xml"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        boolean little = block[0] == 73 && block[1] == 73;
        int ifdlocation = DataTools.bytesToInt(block, 4, little);
        if (ifdlocation < 0) {
            return false;
        }
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, little);
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, little);
            if (ifdtag == 33628 || ifdtag == 33629 || ifdtag == 33630) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return (id = id.toLowerCase()).endsWith(".cfg") || id.endsWith(".xml") ? 0 : 1;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        String[] s = new String[this.files.length + 2];
        System.arraycopy(this.files, 0, s, 0, this.files.length);
        s[this.files.length] = this.xmlFile;
        s[this.files.length + 1] = this.cfgFile;
        return s;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiff.setId(this.files[no]);
        return this.tiff.openBytes(0);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiff.setId(this.files[no]);
        this.tiff.openBytes(0, buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiff.setId(this.files[no]);
        return this.tiff.openImage(0);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly && this.tiff != null) {
            this.tiff.close(fileOnly);
        } else if (!fileOnly) {
            this.close();
        }
    }

    public boolean isThisType(String name, boolean open) {
        boolean xml;
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!this.isGroupFiles()) {
            return false;
        }
        Location f = new Location(name);
        f = f.getAbsoluteFile();
        Location parent = f.getParentFile();
        String[] listing = parent.list();
        int xmlCount = 0;
        int i = 0;
        while (i < listing.length) {
            if (listing[i].toLowerCase().endsWith(".xml")) {
                ++xmlCount;
            }
            ++i;
        }
        boolean bl = xml = xmlCount > 0;
        return open ? this.checkBytes(name, 524304) && xml : xml;
    }

    public void close() throws IOException {
        this.files = null;
        if (this.tiff != null) {
            this.tiff.close();
        }
        this.tiff = null;
        this.currentId = null;
        this.readXML = false;
        this.readCFG = false;
    }

    protected void initFile(String id) throws FormatException, IOException {
        block36: {
            block35: {
                if (debug) {
                    this.debug("PrairieReader.initFile(" + id + ")");
                }
                if (!id.endsWith("xml") && !id.endsWith("cfg")) break block35;
                this.status("Parsing XML");
                if (id.endsWith("xml")) {
                    super.initFile(id);
                    this.tiff = new TiffReader();
                    this.xmlFile = id;
                    this.readXML = true;
                } else if (id.endsWith("cfg")) {
                    if (this.metadata == null) {
                        this.metadata = new Hashtable();
                    }
                    if (this.core == null) {
                        this.core = new CoreMetadata(1);
                    }
                    this.cfgFile = id;
                    this.readCFG = true;
                }
                RandomAccessStream is = new RandomAccessStream(id);
                byte[] b = new byte[(int)is.length()];
                is.read(b);
                is.close();
                String s = new String(b);
                Vector<String> elements = new Vector<String>();
                while (s.length() > 0) {
                    int ndx = s.indexOf("<");
                    int val1 = s.indexOf(">", ndx);
                    if (val1 == -1 || val1 <= ndx) continue;
                    String sub = s.substring(ndx + 1, val1);
                    s = s.substring(val1 + 1);
                    elements.add(sub);
                }
                int zt = 0;
                boolean isZ = false;
                Vector<String> f = new Vector<String>();
                int fileIndex = 1;
                if (id.endsWith(".xml")) {
                    this.core.imageCount[0] = 0;
                }
                String pastPrefix = "";
                int i = 1;
                while (i < elements.size()) {
                    String el = (String)elements.get(i);
                    if (el.indexOf(" ") != -1) {
                        boolean closed = el.endsWith("/");
                        String prefix = el.substring(0, el.indexOf(" "));
                        if (prefix.equals("File")) {
                            this.core.imageCount[0] = this.core.imageCount[0] + 1;
                        }
                        if (prefix.equals("Frame")) {
                            ++zt;
                            fileIndex = 1;
                        }
                        if (!prefix.equals("Key") && !prefix.equals("Frame")) {
                            el = el.substring(el.indexOf(" ") + 1);
                            while (el.indexOf("=") != -1) {
                                int eq = el.indexOf("=");
                                String key = el.substring(0, eq);
                                String value = el.substring(eq + 2, el.indexOf("\"", eq + 2));
                                if (prefix.equals("File")) {
                                    this.addMeta(String.valueOf(pastPrefix) + " " + prefix + " " + fileIndex + " " + key, value);
                                    if (key.equals("filename")) {
                                        ++fileIndex;
                                    }
                                } else {
                                    this.addMeta(String.valueOf(pastPrefix) + " " + prefix + " " + key, value);
                                    if (pastPrefix.equals("PVScan") && prefix.equals("Sequence") && key.equals("type")) {
                                        isZ = value.equals("ZSeries");
                                    }
                                }
                                el = el.substring(el.indexOf("\"", eq + 2) + 1).trim();
                                if (!prefix.equals("File") || !key.equals("filename")) continue;
                                Location current = new Location(id);
                                current = current.getAbsoluteFile();
                                f.add(String.valueOf(current.getParent()) + "/" + value);
                            }
                        } else if (prefix.equals("Key")) {
                            int keyIndex = el.indexOf("key") + 5;
                            int valueIndex = el.indexOf("value") + 7;
                            String key = el.substring(keyIndex, el.indexOf("\"", keyIndex));
                            String value = el.substring(valueIndex, el.indexOf("\"", valueIndex));
                            this.addMeta(key, value);
                            if (key.equals("pixelsPerLine")) {
                                this.core.sizeX[0] = Integer.parseInt(value);
                            } else if (key.equals("linesPerFrame")) {
                                this.core.sizeY[0] = Integer.parseInt(value);
                            }
                        }
                        if (!closed) {
                            pastPrefix = prefix;
                            if (prefix.equals("Frame")) {
                                int index = el.indexOf("index") + 7;
                                String idx = el.substring(index, el.indexOf("\"", index));
                                pastPrefix = String.valueOf(pastPrefix) + " " + idx;
                            }
                        }
                    }
                    ++i;
                }
                if (id.endsWith("xml")) {
                    String laserPower;
                    this.files = new String[f.size()];
                    f.copyInto(this.files);
                    this.tiff.setId(this.files[0]);
                    this.status("Populating metadata");
                    if (zt == 0) {
                        zt = 1;
                    }
                    this.core.sizeZ[0] = isZ ? zt : 1;
                    this.core.sizeT[0] = isZ ? 1 : zt;
                    this.core.sizeC[0] = this.core.imageCount[0] / (this.core.sizeZ[0] * this.core.sizeT[0]);
                    this.core.currentOrder[0] = "XYC" + (isZ ? "ZT" : "TZ");
                    this.core.pixelType[0] = 3;
                    this.core.rgb[0] = false;
                    this.core.interleaved[0] = false;
                    this.core.littleEndian[0] = this.tiff.isLittleEndian();
                    String px = (String)this.getMeta("micronsPerPixel_XAxis");
                    String py = (String)this.getMeta("micronsPerPixel_YAxis");
                    float pixSizeX = px == null ? 0.0f : Float.parseFloat(px);
                    float pixSizeY = py == null ? 0.0f : Float.parseFloat(py);
                    MetadataStore store = this.getMetadataStore();
                    store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.isLittleEndian()), this.core.currentOrder[0], null, null);
                    store.setDimensions(new Float(pixSizeX), new Float(pixSizeY), null, null, null, null);
                    int i2 = 0;
                    while (i2 < this.core.sizeC[0]) {
                        store.setLogicalChannel(i2, null, null, null, null, null, null, null);
                        ++i2;
                    }
                    String date = (String)this.getMeta(" PVScan date");
                    if (date != null) {
                        SimpleDateFormat parse = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a");
                        Date d = parse.parse(date, new ParsePosition(0));
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                        date = fmt.format(d);
                        store.setImage(null, date, null, null);
                    }
                    store.setLaser(null, null, null, null, null, null, (laserPower = (String)this.getMeta("laserPower_0")) == null ? null : new Float(laserPower), null, null, null, null);
                    int i3 = 0;
                    while (i3 < 4) {
                        String gain = (String)this.getMeta("pmtGain_" + i3);
                        String offset = (String)this.getMeta("pmtOffset_" + i3);
                        store.setDetector(null, null, null, null, gain == null ? null : new Float(gain), null, offset == null ? null : new Float(offset), null, new Integer(i3));
                        ++i3;
                    }
                    String zoom = (String)this.getMeta("opticalZoom");
                    if (zoom != null) {
                        store.setDisplayOptions(new Float(zoom), new Boolean(this.core.sizeC[0] > 1), new Boolean(this.core.sizeC[0] > 1), new Boolean(this.core.sizeC[0] > 2), Boolean.FALSE, null, null, null, null, null, null, null, null, null, null, null);
                    }
                }
                if (this.readXML && this.readCFG) break block36;
                Location file = new Location(id);
                file = file.getAbsoluteFile();
                Location parent = file.getParentFile();
                String[] listing = parent.list();
                Location next = null;
                int i4 = 0;
                while (i4 < listing.length) {
                    String path = listing[i4].toLowerCase();
                    if (!this.readXML && path.endsWith(".xml") || this.readXML && path.endsWith(".cfg")) {
                        next = new Location(parent, path);
                    }
                    ++i4;
                }
                if (next == null) break block36;
                this.initFile(next.getAbsolutePath());
                break block36;
            }
            this.status("Finding XML file");
            Location f = new Location(id);
            f = f.getAbsoluteFile();
            Location parent = f.getParentFile();
            String[] listing = parent.list();
            int i = 0;
            while (i < listing.length) {
                String path = listing[i].toLowerCase();
                if (path.endsWith(".xml") || path.endsWith(".cfg")) {
                    this.initFile(new Location(path).getAbsolutePath());
                }
                ++i;
            }
        }
    }
}

