/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LegacyQTTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.PackbitsCodec;

public class PictReader
extends FormatReader {
    private static final int PICT_CLIP_RGN = 1;
    private static final int PICT_BITSRECT = 144;
    private static final int PICT_BITSRGN = 145;
    private static final int PICT_PACKBITSRECT = 152;
    private static final int PICT_PACKBITSRGN = 153;
    private static final int PICT_9A = 154;
    private static final int PICT_END = 255;
    private static final int PICT_LONGCOMMENT = 161;
    private static final int INITIAL = 1;
    private static final int STATE2 = 2;
    private static final int INFOAVAIL = 2;
    private static final int IMAGEAVAIL = 4;
    private static final byte[] EXPANSION_TABLE = new byte[2048];
    protected RandomAccessStream ras;
    protected byte[] bytes;
    protected int rowBytes;
    protected int state;
    protected int pictState;
    protected Vector strips;
    protected boolean versionOne;
    protected short[][] lookup;
    protected LegacyQTTools qtTools = new LegacyQTTools();

    static {
        int index = 0;
        int i = 0;
        while (i < 256) {
            PictReader.EXPANSION_TABLE[index++] = (i & 0x80) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 0x40) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 0x20) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 0x10) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 8) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 4) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 2) == 0 ? (byte)0 : 1;
            PictReader.EXPANSION_TABLE[index++] = (i & 1) == 0 ? (byte)0 : 1;
            ++i;
        }
    }

    public PictReader() {
        super("PICT", new String[]{"pict", "pct"});
    }

    public Dimension getDimensions(byte[] stuff) throws FormatException {
        if (stuff.length < 10) {
            throw new FormatException("Need 10 bytes to calculate dimension");
        }
        int w = DataTools.bytesToInt(stuff, 6, 2, this.core.littleEndian[0]);
        int h = DataTools.bytesToInt(stuff, 8, 2, this.core.littleEndian[0]);
        if (debug) {
            this.debug("getDimensions: " + w + " x " + h);
        }
        return new Dimension(h, w);
    }

    public BufferedImage open(byte[] pix) throws FormatException, IOException {
        if (debug) {
            this.debug("open");
        }
        if (this.core == null) {
            this.core = new CoreMetadata(1);
        }
        this.strips = new Vector();
        this.state = 0;
        this.pictState = 1;
        this.bytes = pix;
        this.ras = new RandomAccessStream(this.bytes);
        this.ras.order(false);
        try {
            while (this.driveDecoder()) {
            }
        }
        catch (FormatException exc) {
            this.trace(exc);
            return ImageTools.makeBuffered(this.qtTools.pictToImage(pix));
        }
        if (this.core.sizeY[0] * 4 < this.strips.size() && this.strips.size() / 3 % this.core.sizeY[0] != 0) {
            this.core.sizeY[0] = this.strips.size();
        }
        if (this.strips.size() == 0) {
            return ImageTools.makeBuffered(this.qtTools.pictToImage(pix));
        }
        if (this.lookup != null) {
            short[][] data = new short[3][this.core.sizeY[0] * this.core.sizeX[0]];
            int i = 0;
            while (i < this.core.sizeY[0]) {
                byte[] row = (byte[])this.strips.get(i);
                int j = 0;
                while (j < row.length) {
                    if (j < this.core.sizeX[0]) {
                        int ndx = row[j];
                        if (ndx < 0) {
                            ndx += this.lookup[0].length;
                        }
                        ndx %= this.lookup[0].length;
                        int outIndex = i * this.core.sizeX[0] + j;
                        if (outIndex >= data[0].length) {
                            outIndex = data[0].length - 1;
                        }
                        data[0][outIndex] = this.lookup[0][ndx];
                        data[1][outIndex] = this.lookup[1][ndx];
                        data[2][outIndex] = this.lookup[2][ndx];
                    } else {
                        j = row.length;
                    }
                    ++j;
                }
                ++i;
            }
            if (debug) {
                this.debug("openBytes: 8-bit data, " + this.core.sizeX[0] + " x " + this.core.sizeY[0] + ", length=" + data.length + "x" + data[0].length);
            }
            return ImageTools.makeImage(data, this.core.sizeX[0], this.core.sizeY[0]);
        }
        if (this.core.sizeY[0] * 3 == this.strips.size()) {
            byte[][] data = new byte[3][this.core.sizeX[0] * this.core.sizeY[0]];
            int outIndex = 0;
            int i = 0;
            while (i < 3 * this.core.sizeY[0]) {
                byte[] c0 = (byte[])this.strips.get(i);
                byte[] c1 = (byte[])this.strips.get(i + 1);
                byte[] c2 = (byte[])this.strips.get(i + 2);
                System.arraycopy(c0, 0, data[0], outIndex, c0.length);
                System.arraycopy(c1, 0, data[1], outIndex, c1.length);
                System.arraycopy(c2, 0, data[2], outIndex, c2.length);
                outIndex += this.core.sizeX[0];
                i += 3;
            }
            if (debug) {
                this.debug("openBytes: 24-bit data, " + this.core.sizeX[0] + " x " + this.core.sizeY[0] + ", length=" + data.length + "x" + data[0].length);
            }
            return ImageTools.makeImage(data, this.core.sizeX[0], this.core.sizeY[0]);
        }
        if (this.core.sizeY[0] * 4 == this.strips.size()) {
            byte[][] data = new byte[3][this.core.sizeX[0] * this.core.sizeY[0]];
            int outIndex = 0;
            int i = 0;
            while (i < 4 * this.core.sizeY[0]) {
                byte[] r = (byte[])this.strips.get(i + 1);
                byte[] g = (byte[])this.strips.get(i + 2);
                byte[] b = (byte[])this.strips.get(i + 3);
                System.arraycopy(r, 0, data[0], outIndex, r.length);
                System.arraycopy(g, 0, data[1], outIndex, g.length);
                System.arraycopy(b, 0, data[2], outIndex, b.length);
                outIndex += this.core.sizeX[0];
                i += 4;
            }
            if (debug) {
                this.debug("openBytes: 32-bit data, " + this.core.sizeX[0] + " x " + this.core.sizeY[0] + ", length=" + data.length + "x" + data[0].length);
            }
            return ImageTools.makeImage(data, this.core.sizeX[0], this.core.sizeY[0]);
        }
        short[] data = new short[3 * this.core.sizeY[0] * this.core.sizeX[0]];
        int outIndex = 0;
        int i = 0;
        while (i < this.core.sizeY[0]) {
            int[] row = (int[])this.strips.get(i);
            int j = 0;
            while (j < row.length) {
                if (j < this.core.sizeX[0]) {
                    if (outIndex >= data.length - 2) break;
                    int s0 = row[j] & 0x1F;
                    int s1 = (row[j] & 0x3E0) >> 5;
                    int s2 = (row[j] & 0x7C00) >> 10;
                    data[outIndex] = (short)s2;
                    data[outIndex + 1] = (short)s1;
                    data[outIndex + 2] = (short)s0;
                } else {
                    j = row.length;
                }
                ++j;
                outIndex += 3;
            }
            ++i;
        }
        if (debug) {
            this.debug("openBytes: 16-bit data, " + this.core.sizeX[0] + " x " + this.core.sizeY[0] + ", length=" + data.length);
        }
        return ImageTools.makeImage(data, this.core.sizeX[0], this.core.sizeY[0], 3, true);
    }

    public boolean isThisType(byte[] block) {
        return block.length >= 528;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.getBytes(this.openImage(no), false, no % 3);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        return this.open(this.bytes);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("PictReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Populating metadata");
        this.core.littleEndian[0] = false;
        int len = (int)(this.in.length() - 512L);
        this.bytes = new byte[len];
        this.in.seek(512L);
        this.in.read(this.bytes);
        byte[] b = new byte[20];
        this.in.seek(512L);
        this.in.read(b);
        Dimension d = this.getDimensions(b);
        this.core.sizeX[0] = d.width;
        while (this.core.sizeX[0] % 8 != 0) {
            this.core.sizeX[0] = this.core.sizeX[0] + 1;
        }
        this.core.sizeY[0] = d.height;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = 3;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCZT";
        this.core.rgb[0] = true;
        this.core.interleaved[0] = true;
        this.core.imageCount[0] = 1;
        MetadataStore store = this.getMetadataStore();
        this.core.pixelType[0] = 1;
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }

    private boolean driveDecoder() throws FormatException, IOException {
        if (debug) {
            this.debug("driveDecoder");
        }
        switch (this.pictState) {
            case 1: {
                this.ras.skipBytes(10);
                int verOpcode = this.ras.read();
                int verNumber = this.ras.read();
                if (verOpcode == 17 && verNumber == 1) {
                    this.versionOne = true;
                } else if (verOpcode == 0 && verNumber == 17) {
                    this.versionOne = false;
                    short verNumber2 = this.ras.readShort();
                    if (verNumber2 != 767) {
                        throw new FormatException("Invalid PICT file : " + verNumber2);
                    }
                    this.ras.skipBytes(26);
                } else {
                    throw new FormatException("Invalid PICT file");
                }
                this.pictState = 2;
                this.state |= 2;
                return true;
            }
            case 2: {
                int opcode;
                if (this.versionOne) {
                    opcode = this.ras.read();
                } else {
                    if ((this.ras.getFilePointer() & 1L) != 0L) {
                        this.ras.skipBytes(1);
                    }
                    opcode = this.ras.readShort();
                }
                return this.drivePictDecoder(opcode);
            }
        }
        return true;
    }

    private boolean drivePictDecoder(int opcode) throws FormatException, IOException {
        if (debug) {
            this.debug("drivePictDecoder");
        }
        switch (opcode) {
            case 144: 
            case 145: 
            case 152: 
            case 153: 
            case 154: {
                this.handlePackBits(opcode);
                break;
            }
            case 1: {
                short x = this.ras.readShort();
                this.ras.skipBytes(x - 2);
                break;
            }
            case 161: {
                this.ras.skipBytes(2);
                short x = this.ras.readShort();
                this.ras.skipBytes(x);
                break;
            }
            case 255: {
                this.state |= 4;
                return false;
            }
        }
        return this.ras.getFilePointer() < this.ras.length();
    }

    private void handlePackBits(int opcode) throws FormatException, IOException {
        if (debug) {
            this.debug("handlePackBits(" + opcode + ")");
        }
        if (opcode == 154) {
            this.handlePixmap(opcode);
        } else {
            this.rowBytes = this.ras.readShort();
            if (this.versionOne || (this.rowBytes & 0x8000) == 0) {
                this.handleBitmap(opcode);
            } else {
                this.handlePixmap(opcode);
            }
        }
    }

    private void handleBitmap(int opcode) throws FormatException, IOException {
        byte[] outBuf;
        byte[] uBuf;
        byte[] buf;
        if (debug) {
            this.debug("handleBitmap(" + opcode + ")");
        }
        this.rowBytes &= 0x3FFF;
        short tlY = this.ras.readShort();
        short tlX = this.ras.readShort();
        short brY = this.ras.readShort();
        short brX = this.ras.readShort();
        this.ras.skipBytes(18);
        this.core.sizeX[0] = brX - tlX;
        this.core.sizeY[0] = brY - tlY;
        try {
            buf = new byte[this.rowBytes + 1 + this.rowBytes / 128];
            uBuf = new byte[this.rowBytes];
            outBuf = new byte[this.core.sizeX[0]];
        }
        catch (NegativeArraySizeException n) {
            throw new FormatException("Sorry, vector data not supported.");
        }
        int row = 0;
        while (row < this.core.sizeY[0]) {
            if (this.rowBytes < 8) {
                this.ras.read(buf, 0, this.rowBytes);
                int j = buf.length;
                while (--j >= 0) {
                    buf[j] = ~buf[j];
                }
                this.expandPixels(1, buf, outBuf, outBuf.length);
            } else {
                int rawLen = this.rowBytes > 250 ? this.ras.readShort() : this.ras.read();
                try {
                    this.ras.read(buf, 0, rawLen);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new FormatException("Sorry, vector data not supported.");
                }
                PackbitsCodec c = new PackbitsCodec();
                uBuf = c.decompress(buf);
                int j = 0;
                while (j < uBuf.length) {
                    uBuf[j] = ~uBuf[j];
                    ++j;
                }
                this.expandPixels(1, uBuf, outBuf, outBuf.length);
            }
            this.strips.add(outBuf);
            ++row;
        }
    }

    private void handlePixmap(int opcode) throws FormatException, IOException {
        short compCount;
        short pixelSize;
        block9: {
            block8: {
                if (debug) {
                    this.debug("handlePixmap(" + opcode + ")");
                }
                if (opcode != 154) break block8;
                this.ras.skipBytes(6);
                short tlY = this.ras.readShort();
                short tlX = this.ras.readShort();
                short brY = this.ras.readShort();
                short brX = this.ras.readShort();
                this.ras.skipBytes(18);
                pixelSize = this.ras.readShort();
                compCount = this.ras.readShort();
                this.ras.skipBytes(14);
                this.core.sizeX[0] = brX - tlX;
                this.core.sizeY[0] = brY - tlY;
                switch (pixelSize) {
                    case 32: {
                        this.rowBytes = this.core.sizeX[0] * compCount;
                        break block9;
                    }
                    case 16: {
                        this.rowBytes = this.core.sizeX[0] * 2;
                        break block9;
                    }
                    default: {
                        throw new FormatException("Sorry, vector data not supported.");
                    }
                }
            }
            this.rowBytes &= 0x3FFF;
            short tlY = this.ras.readShort();
            short tlX = this.ras.readShort();
            short brY = this.ras.readShort();
            short brX = this.ras.readShort();
            this.ras.skipBytes(18);
            pixelSize = this.ras.readShort();
            compCount = this.ras.readShort();
            this.ras.skipBytes(14);
            this.ras.skipBytes(4);
            short flags = this.ras.readShort();
            int count = this.ras.readShort();
            this.lookup = new short[3][++count];
            int i = 0;
            while (i < count) {
                int index = this.ras.readShort();
                if ((flags & 0x8000) != 0) {
                    index = i;
                }
                this.lookup[0][index] = this.ras.readShort();
                this.lookup[1][index] = this.ras.readShort();
                this.lookup[2][index] = this.ras.readShort();
                ++i;
            }
            this.core.sizeX[0] = brX - tlX;
            this.core.sizeY[0] = brY - tlY;
        }
        this.ras.skipBytes(18);
        if (opcode == 145 || opcode == 153) {
            this.ras.skipBytes(2);
        }
        this.handlePixmap(this.rowBytes, pixelSize, compCount);
    }

    private void handlePixmap(int rBytes, int pixelSize, int compCount) throws FormatException, IOException {
        if (debug) {
            this.debug("handlePixmap(" + rBytes + ", " + pixelSize + ", " + compCount + ")");
        }
        byte[] uBuf = null;
        int[] uBufI = null;
        byte[] outBuf = null;
        boolean compressed = rBytes >= 8 || pixelSize == 32;
        int bufSize = rBytes;
        int outBufSize = this.core.sizeX[0];
        switch (pixelSize) {
            case 32: {
                if (!compressed) {
                    uBufI = new int[this.core.sizeX[0]];
                    break;
                }
                uBuf = new byte[bufSize];
                break;
            }
            case 16: {
                uBufI = new int[this.core.sizeX[0]];
                break;
            }
            case 8: {
                uBuf = new byte[bufSize];
                break;
            }
            default: {
                outBuf = new byte[outBufSize];
                uBuf = new byte[bufSize];
            }
        }
        if (!compressed) {
            if (debug) {
                this.debug("Pixel data is uncompressed (pixelSize=" + pixelSize + ").");
            }
            byte[] buf = new byte[bufSize];
            int row = 0;
            while (row < this.core.sizeY[0]) {
                this.ras.read(buf, 0, rBytes);
                switch (pixelSize) {
                    case 16: {
                        int i = 0;
                        while (i < this.core.sizeX[0]) {
                            uBufI[i] = ((buf[i * 2] & 0xFF) << 8) + (buf[i * 2 + 1] & 0xFF);
                            ++i;
                        }
                        this.strips.add(uBufI);
                        break;
                    }
                    case 8: {
                        this.strips.add(buf);
                        break;
                    }
                    default: {
                        this.expandPixels(pixelSize, buf, outBuf, outBuf.length);
                        this.strips.add(outBuf);
                    }
                }
                ++row;
            }
        } else {
            if (debug) {
                this.debug("Pixel data is compressed (pixelSize=" + pixelSize + "; compCount=" + compCount + ").");
            }
            byte[] buf = new byte[bufSize + 1 + bufSize / 128];
            int row = 0;
            while (row < this.core.sizeY[0]) {
                int rawLen = rBytes > 250 ? this.ras.readShort() : this.ras.read();
                if (rawLen > buf.length) {
                    rawLen = buf.length;
                }
                if (this.ras.length() - this.ras.getFilePointer() <= (long)rawLen) {
                    rawLen = (int)(this.ras.length() - this.ras.getFilePointer() - 1L);
                }
                if (rawLen < 0) {
                    rawLen = 0;
                    this.ras.seek(this.ras.length() - 1L);
                }
                this.ras.read(buf, 0, rawLen);
                if (pixelSize == 16) {
                    uBufI = new int[this.core.sizeX[0]];
                    this.unpackBits(buf, uBufI);
                    this.strips.add(uBufI);
                } else {
                    PackbitsCodec c = new PackbitsCodec();
                    uBuf = c.decompress(buf);
                }
                if (pixelSize < 8) {
                    this.expandPixels(pixelSize, uBuf, outBuf, outBuf.length);
                    this.strips.add(outBuf);
                } else if (pixelSize == 8) {
                    this.strips.add(uBuf);
                } else if (pixelSize == 24 || pixelSize == 32) {
                    byte[] newBuf = null;
                    int offset = 0;
                    if (compCount == 4) {
                        this.strips.add(newBuf);
                        offset += this.core.sizeX[0];
                    }
                    newBuf = new byte[this.core.sizeX[0]];
                    System.arraycopy(uBuf, offset, newBuf, 0, this.core.sizeX[0]);
                    this.strips.add(newBuf);
                    newBuf = new byte[this.core.sizeX[0]];
                    System.arraycopy(uBuf, offset += this.core.sizeX[0], newBuf, 0, this.core.sizeX[0]);
                    this.strips.add(newBuf);
                    newBuf = new byte[this.core.sizeX[0]];
                    System.arraycopy(uBuf, offset += this.core.sizeX[0], newBuf, 0, this.core.sizeX[0]);
                    this.strips.add(newBuf);
                }
                ++row;
            }
        }
    }

    private void expandPixels(int bitSize, byte[] ib, byte[] ob, int outLen) throws FormatException {
        if (debug) {
            this.debug("expandPixels(" + bitSize + ", " + ib.length + ", " + ob.length + ", " + outLen + ")");
        }
        if (bitSize == 1) {
            int remainder = outLen % 8;
            int max = outLen / 8;
            int i = 0;
            while (i < max) {
                if (i < ib.length) {
                    int look = (ib[i] & 0xFF) * 8;
                    System.arraycopy(EXPANSION_TABLE, look, ob, i * 8, 8);
                } else {
                    i = max;
                }
                ++i;
            }
            if (remainder != 0 && max < ib.length) {
                System.arraycopy(EXPANSION_TABLE, (ib[max] & 0xFF) * 8, ob, max * 8, remainder);
            }
            return;
        }
        int count = 8 / bitSize;
        int maskshift = bitSize;
        int pixelshift = 8 - bitSize;
        int tpixelshift = 0;
        int pixelshiftdelta = bitSize;
        int mask = 0;
        if (bitSize != 1 && bitSize != 2 && bitSize != 4) {
            throw new FormatException("Can only expand 1, 2, and 4 bit values");
        }
        switch (bitSize) {
            case 1: {
                mask = 128;
                break;
            }
            case 2: {
                mask = 192;
                break;
            }
            case 4: {
                mask = 240;
            }
        }
        int i = 0;
        int o = 0;
        while (o < ob.length) {
            int tmask = mask;
            tpixelshift = pixelshift;
            byte v = ib[i];
            int t = 0;
            while (t < count && o < ob.length) {
                ob[o] = (byte)((v & tmask) >>> tpixelshift & 0xFF);
                tmask = (byte)((tmask & 0xFF) >>> maskshift);
                tpixelshift -= pixelshiftdelta;
                ++t;
                ++o;
            }
            ++i;
        }
    }

    private void unpackBits(byte[] ib, int[] ob) {
        if (debug) {
            this.debug("unpackBits(" + ib + ", " + ob + ")");
        }
        int i = 0;
        int o = 0;
        o = 0;
        while (o < ob.length) {
            if (i + 1 < ib.length) {
                int end;
                int b;
                if ((b = ib[i++]) >= 0) {
                    end = o + ++b;
                    while (o < end) {
                        if (o < ob.length && i + 1 < ib.length) {
                            ob[o] = ((ib[i] & 0xFF) << 8) + (ib[i + 1] & 0xFF) & 0xFFFF;
                        } else {
                            o = end;
                        }
                        ++o;
                        i += 2;
                    }
                    continue;
                }
                if (b == -128) continue;
                int rep = ((ib[i] & 0xFF) << 8) + (ib[i + 1] & 0xFF) & 0xFFFF;
                i += 2;
                end = o - b + 1;
                while (o < end) {
                    if (o < ob.length) {
                        ob[o] = rep;
                    } else {
                        o = end;
                    }
                    ++o;
                }
                continue;
            }
            o = ob.length;
        }
    }
}

