/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.TiffReader;

public class PerkinElmerReader
extends FormatReader {
    protected TiffReader[] tiff;
    protected String[] files;
    private boolean isTiff = true;
    private Vector allFiles;
    private String details;
    private String sliceSpace;

    public PerkinElmerReader() {
        super("PerkinElmer", new String[]{"rec", "ano", "2", "3", "4", "csv", "htm", "tim", "zpo"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.isTiff) {
            this.tiff[no / this.core.sizeC[0]].setId(this.files[no / this.core.sizeC[0]]);
            return this.tiff[no / this.core.sizeC[0]].openBytes(0);
        }
        String file = this.files[no];
        RandomAccessStream ras = new RandomAccessStream(file);
        byte[] b = new byte[(int)ras.length() - 6];
        ras.skipBytes(6);
        ras.read(b);
        ras.close();
        return b;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (this.isTiff) {
            int idx = no / this.core.sizeC[0];
            this.tiff[idx].setId(this.files[idx]);
            return this.tiff[idx].openImage(0);
        }
        byte[] b = this.openBytes(no);
        int bpp = b.length / (this.core.sizeX[0] * this.core.sizeY[0]);
        return ImageTools.makeImage(b, this.core.sizeX[0], this.core.sizeY[0], 1, false, bpp, true);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.allFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.tiff != null) {
                int i = 0;
                while (i < this.tiff.length) {
                    if (this.tiff[i] != null) {
                        this.tiff[i].close(fileOnly);
                    }
                    ++i;
                }
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        this.currentId = null;
        this.files = null;
        if (this.tiff != null) {
            int i = 0;
            while (i < this.tiff.length) {
                if (this.tiff[i] != null) {
                    this.tiff[i].close();
                }
                ++i;
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        MetadataStore store;
        block117: {
            float spacing;
            RandomAccessStream read;
            int tNum;
            byte[] data;
            String ext;
            if (this.currentId != null && (id.equals(this.currentId) || this.isUsedFile(id))) {
                return;
            }
            this.status("Finding HTML companion file");
            if (debug) {
                this.debug("PerkinElmerReader.initFile(" + id + ")");
            }
            if (!id.toLowerCase().endsWith(".htm")) {
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                String[] ls = parent.list();
                int i = 0;
                while (i < ls.length) {
                    if (ls[i].toLowerCase().endsWith(".htm")) {
                        id = new Location(ls[i]).getAbsolutePath();
                        break;
                    }
                    ++i;
                }
            }
            super.initFile(id);
            this.allFiles = new Vector();
            Location tempFile = new Location(id).getAbsoluteFile();
            Location workingDir = tempFile.getParentFile();
            if (workingDir == null) {
                workingDir = new Location(".");
            }
            String workingDirPath = String.valueOf(workingDir.getPath()) + File.separator;
            String[] ls = workingDir.list();
            this.allFiles.add(id);
            this.status("Searching for all metadata companion files");
            int cfgPos = -1;
            int anoPos = -1;
            int recPos = -1;
            int timPos = -1;
            int csvPos = -1;
            int zpoPos = -1;
            int htmPos = -1;
            int filesPt = 0;
            this.files = new String[ls.length];
            String tempFileName = tempFile.getName();
            int dot = tempFileName.lastIndexOf(".");
            String check = dot < 0 ? tempFileName : tempFileName.substring(0, dot);
            String prefix = null;
            int i = 0;
            while (i < ls.length) {
                block115: {
                    int d = ls[i].lastIndexOf(".");
                    while (d == -1 && i < ls.length - 1) {
                        d = ls[++i].lastIndexOf(".");
                    }
                    String s = dot < 0 ? ls[i] : ls[i].substring(0, d);
                    String filename = ls[i].toLowerCase();
                    if (s.startsWith(check) || check.startsWith(s) || prefix != null && s.startsWith(prefix)) {
                        if (cfgPos == -1 && filename.endsWith(".cfg")) {
                            cfgPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (anoPos == -1 && filename.endsWith(".ano")) {
                            anoPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (recPos == -1 && filename.endsWith(".rec")) {
                            recPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (timPos == -1 && filename.endsWith(".tim")) {
                            timPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (csvPos == -1 && filename.endsWith(".csv")) {
                            csvPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (zpoPos == -1 && filename.endsWith(".zpo")) {
                            zpoPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (htmPos == -1 && filename.endsWith(".htm")) {
                            htmPos = i;
                            prefix = ls[i].substring(0, d);
                        }
                        if (filename.endsWith(".tif") || filename.endsWith(".tiff")) {
                            this.files[filesPt] = String.valueOf(workingDirPath) + ls[i];
                            ++filesPt;
                        }
                        try {
                            ext = filename.substring(filename.lastIndexOf(".") + 1);
                            int num = Integer.parseInt(ext);
                            this.isTiff = false;
                            this.files[filesPt] = String.valueOf(workingDirPath) + ls[i];
                            ++filesPt;
                        }
                        catch (NumberFormatException e) {
                            try {
                                String ext2 = filename.substring(filename.lastIndexOf(".") + 1);
                                int num = Integer.parseInt(ext2, 16);
                                this.isTiff = false;
                                this.files[filesPt] = String.valueOf(workingDirPath) + ls[i];
                                ++filesPt;
                            }
                            catch (NumberFormatException exc) {
                                if (!debug) break block115;
                                this.trace(exc);
                            }
                        }
                    }
                }
                ++i;
            }
            String[] tempFiles = this.files;
            this.files = new String[filesPt];
            this.status("Finding image files");
            int extCount = 0;
            Vector<String> foundExts = new Vector<String>();
            int i2 = 0;
            while (i2 < filesPt) {
                ext = tempFiles[i2].substring(tempFiles[i2].lastIndexOf(".") + 1);
                if (!foundExts.contains(ext)) {
                    ++extCount;
                    foundExts.add(ext);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < filesPt) {
                Vector<String> extSet = new Vector<String>();
                int j = 0;
                while (j < extCount) {
                    if (extSet.size() == 0) {
                        extSet.add(tempFiles[i2 + j]);
                    } else {
                        String ext3 = tempFiles[i2 + j].substring(tempFiles[i2 + j].lastIndexOf(".") + 1);
                        int extNum = Integer.parseInt(ext3, 16);
                        int insert = -1;
                        int pos = 0;
                        while (insert == -1 && pos < extSet.size()) {
                            String posString = (String)extSet.get(pos);
                            int posNum = Integer.parseInt(posString = posString.substring(posString.lastIndexOf(".") + 1), 16);
                            if (extNum < posNum) {
                                insert = pos;
                            }
                            ++pos;
                        }
                        if (insert == -1) {
                            extSet.add(tempFiles[i2 + j]);
                        } else {
                            extSet.add(insert, tempFiles[i2 + j]);
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < extCount) {
                    this.files[i2 + j] = (String)extSet.get(j);
                    ++j;
                }
                i2 += extCount;
            }
            i2 = 0;
            while (i2 < this.files.length) {
                this.allFiles.add(this.files[i2]);
                ++i2;
            }
            this.core.imageCount[0] = this.files.length;
            this.tiff = new TiffReader[this.core.imageCount[0]];
            int i3 = 0;
            while (i3 < this.tiff.length) {
                this.tiff[i3] = new TiffReader();
                if (i3 > 0) {
                    this.tiff[i3].setMetadataCollected(false);
                }
                ++i3;
            }
            this.status("Parsing metadata values");
            if (timPos != -1) {
                tempFile = new Location(workingDir, ls[timPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read2 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read2.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                tNum = 0;
                String[] hashKeys = new String[]{"Number of Wavelengths/Timepoints", "Zero 1", "Zero 2", "Number of slices", "Extra int", "Calibration Unit", "Pixel Size Y", "Pixel Size X", "Image Width", "Image Length", "Origin X", "SubfileType X", "Dimension Label X", "Origin Y", "SubfileType Y", "Dimension Label Y", "Origin Z", "SubfileType Z", "Dimension Label Z"};
                while (t.hasMoreTokens() && tNum < hashKeys.length) {
                    String token = t.nextToken();
                    while (!(tNum != 1 && tNum != 2 || token.trim().equals("0"))) {
                        ++tNum;
                    }
                    if (tNum == 4) {
                        try {
                            Integer.parseInt(token);
                        }
                        catch (NumberFormatException e) {
                            ++tNum;
                        }
                    }
                    this.addMeta(hashKeys[tNum], token);
                    if (hashKeys[tNum].equals("Image Width")) {
                        this.core.sizeX[0] = Integer.parseInt(token);
                    } else if (hashKeys[tNum].equals("Image Length")) {
                        this.core.sizeY[0] = Integer.parseInt(token);
                    } else if (hashKeys[tNum].equals("Number of slices")) {
                        this.core.sizeZ[0] = Integer.parseInt(token);
                    } else if (hashKeys[tNum].equals("Experiment details:")) {
                        this.details = token;
                    } else if (hashKeys[tNum].equals("Z slice space")) {
                        this.sliceSpace = token;
                    }
                    ++tNum;
                }
                read2.close();
            }
            if (csvPos != -1) {
                tempFile = new Location(workingDir, ls[csvPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read3 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read3.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                tNum = 0;
                String[] hashKeys = new String[]{"Calibration Unit", "Pixel Size X", "Pixel Size Y", "Z slice space"};
                int pt = 0;
                while (t.hasMoreTokens()) {
                    if (tNum < 7) {
                        t.nextToken();
                    } else if (tNum > 7 && tNum < 12 || tNum > 12 && tNum < 18 || tNum > 18 && tNum < 22) {
                        t.nextToken();
                    } else if (pt < hashKeys.length) {
                        String token = t.nextToken();
                        this.addMeta(hashKeys[pt], token);
                        if (hashKeys[pt].equals("Image Width")) {
                            this.core.sizeX[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Image Length")) {
                            this.core.sizeY[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Number of slices")) {
                            this.core.sizeZ[0] = Integer.parseInt(token);
                        } else if (hashKeys[pt].equals("Experiment details:")) {
                            this.details = token;
                        } else if (hashKeys[pt].equals("Z slice space")) {
                            this.sliceSpace = token;
                        }
                        ++pt;
                    } else {
                        String key = String.valueOf(t.nextToken()) + t.nextToken();
                        String value = t.nextToken();
                        this.addMeta(key, value);
                        if (key.equals("Image Width")) {
                            this.core.sizeX[0] = Integer.parseInt(value);
                        } else if (key.equals("Image Length")) {
                            this.core.sizeY[0] = Integer.parseInt(value);
                        } else if (key.equals("Number of slices")) {
                            this.core.sizeZ[0] = Integer.parseInt(value);
                        } else if (key.equals("Experiment details:")) {
                            this.details = value;
                        } else if (key.equals("Z slice space")) {
                            this.sliceSpace = value;
                        }
                    }
                    ++tNum;
                }
                read3.close();
            } else if (zpoPos != -1) {
                tempFile = new Location(workingDir, ls[zpoPos]);
                this.allFiles.add(tempFile.getAbsolutePath());
                RandomAccessStream read4 = new RandomAccessStream(tempFile.getAbsolutePath());
                data = new byte[(int)tempFile.length()];
                read4.read(data);
                StringTokenizer t = new StringTokenizer(new String(data));
                tNum = 0;
                while (t.hasMoreTokens()) {
                    this.addMeta("Z slice #" + tNum + " position", t.nextToken());
                    ++tNum;
                }
                read4.close();
            }
            if (htmPos != -1) {
                String[] tokens;
                block116: {
                    tempFile = new Location(workingDir, ls[htmPos]);
                    this.allFiles.add(tempFile.getAbsolutePath());
                    read = new RandomAccessStream(tempFile.getAbsolutePath());
                    data = new byte[(int)tempFile.length()];
                    read.read(data);
                    String regex = "<p>|</p>|<br>|<hr>|<b>|</b>|<HTML>|<HEAD>|</HTML>|</HEAD>|<h1>|</h1>|<HR>|</body>";
                    Class<String> c = String.class;
                    tokens = new String[]{};
                    try {
                        Method split = c.getMethod("split", c);
                        tokens = (String[])split.invoke((Object)new String(data), regex);
                    }
                    catch (Throwable th) {
                        if (!debug) break block116;
                        this.trace(th);
                    }
                }
                int j = 0;
                while (j < tokens.length) {
                    if (tokens[j].indexOf("<") != -1) {
                        tokens[j] = "";
                    }
                    ++j;
                }
                j = 0;
                while (j < tokens.length - 1) {
                    if (tokens[j].indexOf("Wavelength") != -1) {
                        this.addMeta("Camera Data " + tokens[j].charAt(13), tokens[j]);
                        --j;
                    } else if (!tokens[j].trim().equals("")) {
                        this.addMeta(tokens[j].trim(), tokens[j + 1].trim());
                        if (tokens[j].trim().equals("Image Width")) {
                            this.core.sizeX[0] = Integer.parseInt(tokens[j + 1].trim());
                        } else if (tokens[j].trim().equals("Image Length")) {
                            this.core.sizeY[0] = Integer.parseInt(tokens[j + 1].trim());
                        } else if (tokens[j].trim().equals("Number of slices")) {
                            this.core.sizeZ[0] = Integer.parseInt(tokens[j + 1].trim());
                        } else if (tokens[j].trim().equals("Experiment details:")) {
                            this.details = tokens[j + 1].trim();
                        } else if (tokens[j].trim().equals("Z slice space")) {
                            this.sliceSpace = tokens[j + 1].trim();
                        }
                    }
                    j += 2;
                }
            } else {
                throw new FormatException("Valid header files not found.");
            }
            read.close();
            String wavelengths = "1";
            if (this.details != null) {
                StringTokenizer t = new StringTokenizer(this.details);
                int tokenNum = 0;
                int numTokens = t.countTokens();
                boolean foundId = false;
                String prevToken = "";
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    foundId = token.equals("Wavelengths");
                    if (foundId) {
                        wavelengths = prevToken;
                    }
                    ++tokenNum;
                    prevToken = token;
                }
            }
            this.status("Populating metadata");
            this.core.sizeC[0] = Integer.parseInt(wavelengths);
            this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            if (this.isTiff) {
                this.tiff[0].setId(this.files[0]);
                this.core.pixelType[0] = this.tiff[0].getPixelType();
            } else {
                int bpp = this.openBytes(0).length / (this.core.sizeX[0] * this.core.sizeY[0]);
                switch (bpp) {
                    case 1: 
                    case 3: {
                        this.core.pixelType[0] = 1;
                        break;
                    }
                    case 2: {
                        this.core.pixelType[0] = 3;
                        break;
                    }
                    case 4: {
                        this.core.pixelType[0] = 5;
                    }
                }
            }
            this.core.currentOrder[0] = "XYC";
            if (this.core.sizeZ[0] <= 0) {
                this.core.sizeZ[0] = 1;
                this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            }
            if (this.core.sizeC[0] <= 0) {
                this.core.sizeC[0] = 1;
                this.core.sizeT[0] = this.getImageCount() / (this.core.sizeZ[0] * this.core.sizeC[0]);
            }
            if (this.core.sizeT[0] <= 0) {
                this.core.sizeT[0] = 1;
            }
            this.core.currentOrder[0] = this.sliceSpace != null ? ((spacing = Float.parseFloat(this.sliceSpace)) <= 1.0f ? String.valueOf(this.core.currentOrder[0]) + "TZ" : String.valueOf(this.core.currentOrder[0]) + "ZT") : String.valueOf(this.core.currentOrder[0]) + "ZT";
            this.core.rgb[0] = this.isTiff ? this.tiff[0].isRGB() : false;
            this.core.interleaved[0] = false;
            this.core.littleEndian[0] = this.isTiff ? this.tiff[0].isLittleEndian() : true;
            store = this.getMetadataStore();
            String pixelSizeX = (String)this.getMeta("Pixel Size X");
            String pixelSizeY = (String)this.getMeta("Pixel Size Y");
            store.setDimensions(pixelSizeX == null ? null : new Float(pixelSizeX), pixelSizeY == null ? null : new Float(pixelSizeY), null, null, null, null);
            String time = (String)this.getMeta("Finish Time:");
            if (time != null) {
                SimpleDateFormat parse = new SimpleDateFormat("HH:mm:ss (MM/dd/yyyy)");
                Date date = parse.parse(time, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                time = fmt.format(date);
                store.setImage(null, time, null, null);
            }
            store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
            String originX = (String)this.getMeta("Origin X");
            String originY = (String)this.getMeta("Origin Y");
            String originZ = (String)this.getMeta("Origin Z");
            try {
                store.setStageLabel(null, originX == null ? null : new Float(originX), originY == null ? null : new Float(originY), originZ == null ? null : new Float(originZ), null);
            }
            catch (NumberFormatException exc) {
                if (!debug) break block117;
                this.trace(exc);
            }
        }
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }
}

