/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.LZOCodec;
import loci.formats.in.PictReader;

public class OpenlabReader
extends FormatReader {
    private static final int MAC_1_BIT = 1;
    private static final int MAC_256_GREYS = 5;
    private static final int MAC_256_COLORS = 6;
    private static final int MAC_24_BIT = 8;
    private static final int GREY_16_BIT = 16;
    private static PictReader pict = new PictReader();
    private int version;
    private int numSeries;
    private Vector[] layerInfoList;
    private float xCal;
    private float yCal;
    private float zCal;
    private int bytesPerPixel;
    private int tag = 0;
    private int subTag = 0;
    private String fmt = "";

    public OpenlabReader() {
        super("Openlab LIFF", "liff");
    }

    public boolean isThisType(byte[] block) {
        return block.length >= 8 && block[0] == 0 && block[1] == 0 && block[2] == -1 && block[3] == -1 && block[4] == 105 && block[5] == 109 && block[6] == 112 && block[7] == 114;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] openBytes(int no) throws FormatException, IOException {
        block31: {
            block32: {
                FormatTools.assertId(this.currentId, true, 1);
                if (no < 0 || no >= this.getImageCount()) {
                    throw new FormatException("Invalid image number: " + no);
                }
                info = (LayerInfo)this.layerInfoList[this.series].get(no);
                this.in.seek(info.layerStart);
                this.readTagHeader();
                if (this.tag != 67 && this.tag != 68 || !this.fmt.equals("PICT") && !this.fmt.equals("RAWi")) {
                    throw new FormatException("Corrupt LIFF file.");
                }
                this.in.skipBytes(24);
                volumeType = this.in.readShort();
                this.in.skipBytes(272);
                if (this.version == 2) {
                    this.in.skipBytes(2);
                    top = this.in.readShort();
                    left = this.in.readShort();
                    bottom = this.in.readShort();
                    right = this.in.readShort();
                    if (this.core.sizeX[this.series] == 0) {
                        this.core.sizeX[this.series] = right - left;
                    }
                    if (this.core.sizeY[this.series] == 0) {
                        this.core.sizeY[this.series] = bottom - top;
                    }
                } else {
                    this.core.sizeX[this.series] = this.in.readInt();
                    this.core.sizeY[this.series] = this.in.readInt();
                }
                this.in.seek(info.layerStart);
                b = new byte[]{};
                if (this.version != 2) break block32;
                nextTag = this.readTagHeader();
                if (this.tag != 67 && this.tag != 68 || !this.fmt.equals("PICT")) {
                    throw new FormatException("Corrupt LIFF file.");
                }
                this.in.skipBytes(298);
                try {
                    b = new byte[(int)(nextTag - this.in.getFilePointer())];
                    this.in.read(b);
                    img = OpenlabReader.pict.open(b);
                    tmp = ImageTools.getBytes(img);
                    b = new byte[tmp.length * tmp[0].length];
                    i = 0;
                    while (i < tmp.length) {
                        System.arraycopy(tmp[i], 0, b, i * tmp[i].length, tmp[i].length);
                        ++i;
                    }
                    break block31;
                }
                catch (Exception exc) {
                    if (OpenlabReader.debug) {
                        this.trace(exc);
                    }
                    b = null;
                    this.in.seek(info.layerStart + 12);
                    blockSize = DataTools.read4SignedBytes(this.in, false);
                    toRead = (byte)this.in.read();
                    if (toRead == 1) {
                        this.in.skipBytes(128);
                    }
                    this.in.skipBytes(169);
                    q = new byte[blockSize];
                    this.in.read(q);
                    pixelData = new byte[blockSize];
                    pixPos = 0;
                    length = q.length;
                    totalBlocks = -1;
                    expectedBlock = 0;
                    pos = 0;
                    ** GOTO lbl87
                }
                {
                    ++pos;
                    do {
                        if (pos + 7 < length && (q[pos] != 73 || q[pos + 1] != 86 || q[pos + 2] != 69 || q[pos + 3] != 65 || q[pos + 4] != 100 || q[pos + 5] != 98 || q[pos + 6] != 112 || q[pos + 7] != 113)) continue block3;
                        num = DataTools.bytesToInt(q, pos += 8, 4, false);
                        if (num != expectedBlock) {
                            throw new FormatException("Expected iPic block not found");
                        }
                        ++expectedBlock;
                        if (totalBlocks == -1) {
                            totalBlocks = DataTools.bytesToInt(q, pos + 4, 4, false);
                        } else if (DataTools.bytesToInt(q, pos + 4, 4, false) != totalBlocks) {
                            throw new FormatException("Unexpected totalBlocks numbein.read");
                        }
                        size = DataTools.bytesToInt(q, pos += 16, 4, false);
                        System.arraycopy(q, pos += 8, pixelData, pixPos, size);
                        pixPos += size;
lbl87:
                        // 2 sources

                    } while (expectedBlock != totalBlocks);
                }
                System.gc();
                b = new byte[pixPos];
                System.arraycopy(pixelData, 0, b, 0, b.length);
                break block31;
            }
            this.readTagHeader();
            if (this.tag != 68 || !this.fmt.equals("RAWi")) {
                throw new FormatException("Corrupt LIFF file.");
            }
            if (this.subTag != 0) {
                throw new FormatException("Wrong compression type.");
            }
            this.in.skipBytes(24);
            volumeType = this.in.readShort();
            this.in.skipBytes(280);
            size = this.in.readInt();
            compressedSize = this.in.readInt();
            b = new byte[size];
            c = new byte[compressedSize];
            this.in.read(c);
            lzoc = new LZOCodec();
            b = lzoc.decompress(c);
            if (b.length != size) {
                LogTools.println("LZOCodec failed to predict image size");
                LogTools.println(String.valueOf(size) + " expected, got " + b.length + ". The image displayed may not be correct.");
            }
            if (volumeType == 8) {
                this.bytesPerPixel = b.length >= this.core.sizeX[this.series] * this.core.sizeY[this.series] * 4 ? 4 : 3;
                destRowBytes = this.core.sizeX[this.series] * this.bytesPerPixel;
                srcRowBytes = b.length / this.core.sizeY[this.series];
                tmp = new byte[destRowBytes * this.core.sizeY[this.series]];
                src = 0;
                dest = 0;
                y = 0;
                while (y < this.core.sizeY[this.series]) {
                    System.arraycopy(b, src, tmp, dest, destRowBytes);
                    src += srcRowBytes;
                    dest += destRowBytes;
                    ++y;
                }
                if (this.bytesPerPixel == 4) {
                    b = new byte[3 * tmp.length / 4];
                    dest = 0;
                    i = 0;
                    while (i < tmp.length) {
                        b[dest] = tmp[i + 1];
                        b[dest + b.length / 3] = tmp[i + 2];
                        b[dest + 2 * b.length / 3] = tmp[i + 3];
                        ++dest;
                        i += 4;
                    }
                    this.bytesPerPixel = 3;
                }
            } else if (volumeType == 5) {
                tmp = b;
                b = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series]];
                y = 0;
                while (y < this.core.sizeY[this.series]) {
                    System.arraycopy(tmp, y * (this.core.sizeX[this.series] + 16), b, y * this.core.sizeX[this.series], this.core.sizeX[this.series]);
                    ++y;
                }
            } else if (volumeType < 8) {
                throw new FormatException("Unsupported image type : " + volumeType);
            }
        }
        bpp = b.length / (this.core.sizeX[this.series] * this.core.sizeY[this.series]);
        expected = this.core.sizeX[this.series] * this.core.sizeY[this.series] * bpp;
        if (b.length > expected) {
            tmp = b;
            b = new byte[expected];
            System.arraycopy(tmp, 0, b, 0, b.length);
        }
        return b;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        byte[] b = this.openBytes(no);
        this.bytesPerPixel = b.length / (this.core.sizeX[this.series] * this.core.sizeY[this.series]);
        if (this.bytesPerPixel > 3) {
            this.bytesPerPixel = 3;
        }
        return ImageTools.makeImage(b, this.core.sizeX[this.series], this.core.sizeY[this.series], this.bytesPerPixel == 3 ? 3 : 1, false, this.bytesPerPixel == 3 ? 1 : this.bytesPerPixel, false);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (pict != null) {
                pict.close(fileOnly);
            }
        } else {
            this.close();
        }
    }

    public boolean isThisType(String name, boolean open) {
        if (super.isThisType(name, open)) {
            return true;
        }
        if (open) {
            byte[] b = new byte[8];
            try {
                this.in = new RandomAccessStream(name);
                this.in.read(b);
            }
            catch (IOException exc) {
                if (debug) {
                    this.trace(exc);
                }
                return false;
            }
            return this.isThisType(b);
        }
        return name.indexOf(".") < 0;
    }

    public void close() throws IOException {
        super.close();
        if (pict != null) {
            pict.close();
        }
        this.layerInfoList = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("OpenlabReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Openlab LIFF format");
        this.in.order(false);
        this.in.skipBytes(4);
        if (!this.in.readString(4).equals("impr")) {
            throw new FormatException("Invalid LIFF file.");
        }
        this.version = this.in.readInt();
        if (this.version != 2 && this.version != 5) {
            throw new FormatException("Invalid version : " + this.version);
        }
        this.in.skipBytes(4);
        int offset = this.in.readInt();
        this.in.seek(offset);
        this.status("Finding image offsets");
        this.layerInfoList = new Vector[2];
        int i = 0;
        while (i < this.layerInfoList.length) {
            this.layerInfoList[i] = new Vector();
            ++i;
        }
        this.zCal = 0.0f;
        this.yCal = 0.0f;
        this.xCal = 0.0f;
        while (this.in.getFilePointer() < this.in.length()) {
            long nextTag;
            long startPos;
            this.tag = 0;
            this.subTag = 0;
            try {
                startPos = this.in.getFilePointer();
                nextTag = this.readTagHeader();
            }
            catch (IOException exc) {
                if (debug) {
                    this.trace(exc);
                }
                if (this.in.getFilePointer() >= this.in.length()) break;
                throw new FormatException(exc.getMessage());
            }
            try {
                block57: {
                    block56: {
                        if (this.tag != 67 && this.tag != 68 && !this.fmt.equals("PICT") && !this.fmt.equals("RAWi")) break block56;
                        LayerInfo info = new LayerInfo();
                        info.layerStart = (int)startPos;
                        info.zPosition = -1;
                        info.wavelength = -1;
                        this.in.skipBytes(24);
                        short volumeType = this.in.readShort();
                        if (volumeType != 1 && volumeType != 5 && volumeType != 6 && (volumeType < 8 || volumeType > 16)) break block57;
                        this.in.skipBytes(16);
                        info.layerName = this.in.readString(128);
                        if (info.layerName.trim().equals("Original Image")) break block57;
                        info.timestamp = this.in.readLong();
                        this.layerInfoList[0].add(info);
                        break block57;
                    }
                    if (this.tag == 69) {
                        this.in.skipBytes(4);
                        short units = this.in.readShort();
                        this.in.skipBytes(12);
                        this.xCal = this.in.readFloat();
                        this.yCal = this.in.readFloat();
                    } else if (this.tag == 72 || this.fmt.equals("USER")) {
                        char aChar = (char)this.in.read();
                        StringBuffer sb = new StringBuffer();
                        while (aChar != '\u0000') {
                            sb = sb.append(aChar);
                            aChar = (char)this.in.read();
                        }
                        String className = sb.toString();
                        if (className.equals("CVariableList") && (aChar = (char)this.in.read()) == '\u0001') {
                            int numVars = this.in.readShort();
                            while (numVars > 0) {
                                aChar = (char)this.in.read();
                                sb = new StringBuffer();
                                while (aChar != '\u0000') {
                                    sb = sb.append(aChar);
                                    aChar = (char)this.in.read();
                                }
                                String varName = "";
                                String varStringValue = "";
                                double varNumValue = 0.0;
                                className = sb.toString();
                                int derivedClassVersion = this.in.read();
                                if (derivedClassVersion != 1) {
                                    throw new FormatException("Invalid revision.");
                                }
                                if (className.equals("CStringVariable")) {
                                    int strSize = this.in.readInt();
                                    varStringValue = this.in.readString(strSize);
                                    varNumValue = Float.parseFloat(varStringValue);
                                    this.in.skipBytes(1);
                                } else if (className.equals("CFloatVariable")) {
                                    varNumValue = this.in.readDouble();
                                    varStringValue = "" + varNumValue;
                                }
                                int baseClassVersion = this.in.read();
                                if (baseClassVersion != 1 && baseClassVersion != 2) {
                                    throw new FormatException("Invalid revision.");
                                }
                                int strSize = this.in.readInt();
                                varName = this.in.readString(strSize);
                                this.in.skipBytes(baseClassVersion == 1 ? 3 : 2);
                                this.addMeta(varName, varStringValue);
                                --numVars;
                            }
                        }
                    }
                }
                this.in.seek(nextTag);
            }
            catch (Exception exc) {
                if (debug) {
                    this.trace(exc);
                }
                this.in.seek(nextTag);
            }
        }
        Vector tmp = new Vector();
        int i2 = 0;
        while (i2 < this.layerInfoList[0].size()) {
            tmp.add(this.layerInfoList[0].get(i2));
            ++i2;
        }
        this.core = new CoreMetadata(2);
        this.core.imageCount[0] = tmp.size();
        this.status("Determining series count");
        int oldChannels = this.openBytes(0).length / (this.core.sizeX[0] * this.core.sizeY[0] * 3);
        int oldWidth = this.core.sizeX[0];
        boolean oldSize = false;
        int i3 = 0;
        while (i3 < tmp.size()) {
            LayerInfo layer = (LayerInfo)tmp.get(i3);
            this.in.seek(layer.layerStart);
            long nextTag = this.readTagHeader();
            if (this.fmt.equals("PICT")) {
                this.in.skipBytes(24);
                short volumeType = this.in.readShort();
                this.in.skipBytes(272);
                if (this.version == 2) {
                    this.in.skipBytes(2);
                    short top = this.in.readShort();
                    short left = this.in.readShort();
                    short bottom = this.in.readShort();
                    short right = this.in.readShort();
                    if (this.core.sizeX[this.series] == 0) {
                        this.core.sizeX[this.series] = right - left;
                    }
                    if (this.core.sizeY[this.series] == 0) {
                        this.core.sizeY[this.series] = bottom - top;
                    }
                } else {
                    this.core.sizeX[this.series] = this.in.readInt();
                    this.core.sizeY[this.series] = this.in.readInt();
                }
                this.in.seek(layer.layerStart);
                if (this.version == 2) {
                    nextTag = this.readTagHeader();
                    if (this.tag != 67 && this.tag != 68 || !this.fmt.equals("PICT")) {
                        throw new FormatException("Corrupt LIFF file.");
                    }
                    this.in.skipBytes(298);
                    try {
                        byte[] b = new byte[(int)(nextTag - this.in.getFilePointer())];
                        this.in.read(b);
                        BufferedImage img = pict.open(b);
                        if (img.getRaster().getNumBands() != oldChannels || img.getWidth() != oldWidth) {
                            this.layerInfoList[1].add(tmp.get(i3));
                            this.layerInfoList[0].remove(tmp.get(i3));
                        }
                    }
                    catch (FormatException formatException) {}
                }
            } else {
                this.in.skipBytes(24);
                short type = DataTools.read2SignedBytes(this.in, false);
                if (type == 8) {
                    this.layerInfoList[1].add(tmp.get(i3));
                    this.layerInfoList[0].remove(tmp.get(i3));
                }
            }
            ++i3;
        }
        if (this.layerInfoList[1].size() == 0 || this.layerInfoList[0].size() == 0) {
            int n = (this.core.sizeC = new int[1])[0] = this.layerInfoList[1].size() == 0 ? 1 : 3;
            if (this.core.sizeC[0] == 1 && oldChannels == 1) {
                this.core.sizeC[0] = 3;
            }
            int oldImages = this.core.imageCount[0];
            this.core.imageCount = new int[1];
            this.core.imageCount[0] = oldImages;
            if (this.layerInfoList[0].size() == 0) {
                this.layerInfoList[0] = this.layerInfoList[1];
            }
            int x = this.core.sizeX[0];
            this.core.sizeX = new int[1];
            this.core.sizeX[0] = x;
        } else {
            this.core.imageCount[0] = this.layerInfoList[0].size();
            this.core.imageCount[1] = this.layerInfoList[1].size();
            this.core.sizeC[0] = 1;
            this.core.sizeC[1] = 3;
            int oldW = this.core.sizeX[0];
            int oldH = this.core.sizeY[0];
            this.core.sizeX = new int[2];
            this.core.sizeY = new int[2];
            this.core.sizeX[0] = oldW;
            this.core.sizeX[1] = oldW;
            this.core.sizeY[0] = oldH;
            this.core.sizeY[1] = oldH;
        }
        this.status("Populating metadata");
        this.numSeries = this.core.imageCount.length;
        int[] bpp = new int[this.numSeries];
        Arrays.fill(this.core.orderCertain, true);
        int oldSeries = this.getSeries();
        int i4 = 0;
        while (i4 < bpp.length) {
            this.setSeries(i4);
            if (this.core.sizeC[i4] == 0) {
                this.core.sizeC[i4] = 1;
            }
            bpp[i4] = this.openBytes(0).length / (this.core.sizeX[i4] * this.core.sizeY[i4]);
            ++i4;
        }
        this.setSeries(oldSeries);
        if (this.bytesPerPixel == 3) {
            this.bytesPerPixel = 1;
        }
        if (this.bytesPerPixel == 0) {
            ++this.bytesPerPixel;
        }
        this.addMeta("Version", new Integer(this.version));
        this.addMeta("Number of Series", new Integer(this.numSeries));
        i4 = 0;
        while (i4 < this.numSeries) {
            this.addMeta("Width (Series " + i4 + ")", new Integer(this.core.sizeX[i4]));
            this.addMeta("Height (Series " + i4 + ")", new Integer(this.core.sizeY[i4]));
            this.addMeta("Bit depth (Series " + i4 + ")", new Integer(bpp[i4] * 8));
            this.addMeta("Number of channels (Series " + i4 + ")", new Integer(this.core.sizeC[i4]));
            this.addMeta("Number of images (Series " + i4 + ")", new Integer(this.core.imageCount[i4]));
            ++i4;
        }
        MetadataStore store = this.getMetadataStore();
        int i5 = 0;
        while (i5 < this.numSeries) {
            int n = i5;
            this.core.sizeT[n] = this.core.sizeT[n] + 1;
            this.core.sizeZ[i5] = this.core.imageCount[i5] / this.core.sizeT[i5];
            this.core.currentOrder[i5] = this.isRGB() ? "XYCZT" : "XYZCT";
            this.core.rgb[i5] = this.core.sizeC[i5] > 1;
            this.core.interleaved[i5] = true;
            this.core.littleEndian[i5] = false;
            try {
                if (i5 != 0 && bpp[i5] == bpp[0]) {
                    bpp[i5] = bpp[i5 + 1];
                }
            }
            catch (ArrayIndexOutOfBoundsException type) {
                // empty catch block
            }
            switch (bpp[i5]) {
                case 1: 
                case 3: {
                    this.core.pixelType[i5] = 1;
                    break;
                }
                case 2: 
                case 6: {
                    this.core.pixelType[i5] = 3;
                    break;
                }
                case 4: {
                    this.core.pixelType[i5] = 5;
                }
            }
            store.setImage("Series " + i5, null, null, new Integer(i5));
            store.setPixels(new Integer(this.core.sizeX[i5]), new Integer(this.core.sizeY[i5]), new Integer(this.core.sizeZ[i5]), new Integer(this.core.sizeC[i5]), new Integer(this.core.sizeT[i5]), new Integer(this.core.pixelType[i5]), new Boolean(!this.isLittleEndian()), this.core.currentOrder[i5], new Integer(i5), null);
            store.setDimensions(new Float(this.xCal), new Float(this.yCal), new Float(this.zCal), null, null, new Integer(i5));
            int j = 0;
            while (j < this.core.sizeC[0]) {
                store.setLogicalChannel(j, null, null, null, null, null, null, new Integer(i5));
                ++j;
            }
            ++i5;
        }
    }

    private long readTagHeader() throws IOException {
        this.tag = this.in.readShort();
        this.subTag = this.in.readShort();
        long nextTag = this.version == 2 ? (long)this.in.readInt() : this.in.readLong();
        byte[] b = new byte[4];
        this.in.read(b);
        this.fmt = new String(b);
        if (this.version == 2) {
            this.in.skipBytes(4);
        } else {
            this.in.skipBytes(8);
        }
        return nextTag;
    }

    protected class LayerInfo {
        protected int layerStart;
        protected int zPosition;
        protected int wavelength;
        protected String layerName;
        protected long timestamp;

        protected LayerInfo() {
        }
    }
}

