/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class OpenlabRawReader
extends FormatReader {
    protected int[] offsets;
    private int bytesPerPixel;

    public OpenlabRawReader() {
        super("Openlab RAW", "raw");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 79 && block[1] == 76 && block[2] == 82 && block[3] == 87;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel) {
            throw new FormatException("Buffer too small.");
        }
        this.in.seek(this.offsets[no / this.core.sizeC[0]] + 288);
        this.in.read(buf);
        if (this.bytesPerPixel == 1) {
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)(255 - buf[i]);
                ++i;
            }
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], false, this.bytesPerPixel, false);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("OpenlabRawReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Verifying Openlab RAW format");
        byte[] header = new byte[4];
        this.in.read(header);
        String check = new String(header);
        if (!check.equals("OLRW")) {
            throw new FormatException("Openlab RAW magic string not found.");
        }
        this.status("Populating metadata");
        int version = this.in.readInt();
        this.addMeta("Version", new Integer(version));
        this.core.imageCount[0] = this.in.readInt();
        this.offsets = new int[this.core.imageCount[0]];
        this.offsets[0] = 12;
        this.in.readLong();
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.in.read();
        this.core.sizeC[0] = this.in.read();
        this.bytesPerPixel = this.in.read();
        this.in.read();
        Date timestamp = new Date(this.in.readLong());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.addMeta("Timestamp", sdf.format(timestamp));
        this.in.skipBytes(4);
        byte[] s = new byte[256];
        this.in.read(s);
        int len = s[0] > 0 ? s[0] : s[0] + 256;
        this.addMeta("Image name", new String(s, 1, len).trim());
        this.core.sizeC[0] = this.core.sizeC[0] <= 1 ? 1 : 3;
        this.addMeta("Width", new Integer(this.core.sizeX[0]));
        this.addMeta("Height", new Integer(this.core.sizeY[0]));
        this.addMeta("Bytes per pixel", new Integer(this.bytesPerPixel));
        int plane = this.core.sizeX[0] * this.core.sizeY[0] * this.bytesPerPixel;
        int i = 1;
        while (i < this.core.imageCount[0]) {
            this.offsets[i] = this.offsets[i - 1] + 288 + plane;
            ++i;
        }
        this.core.sizeZ[0] = this.core.imageCount[0];
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = false;
        MetadataStore store = this.getMetadataStore();
        switch (this.bytesPerPixel) {
            case 1: 
            case 3: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
                break;
            }
            default: {
                this.core.pixelType[0] = 6;
            }
        }
        store.setImage((String)this.getMeta("Image name"), sdf.format(timestamp), null, null);
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.TRUE, this.core.currentOrder[0], null, null);
        int i2 = 0;
        while (i2 < this.core.sizeC[0]) {
            store.setLogicalChannel(i2, null, null, null, null, null, null, null);
            ++i2;
        }
    }
}

