/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.LogTools;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.codec.Base64Codec;
import loci.formats.codec.CBZip2InputStream;

public class OMEXMLReader
extends FormatReader {
    private static final String NO_OME_JAVA_MSG = "The Java OME-XML library is required to read OME-XML files. Please obtain ome-java.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noOME;
    protected int[] bpp;
    protected Vector[] offsets;
    protected String[] compression;

    static {
        block2: {
            noOME = false;
            try {
                Class.forName("org.openmicroscopy.xml.OMENode");
            }
            catch (Throwable t) {
                noOME = true;
                if (!debug) break block2;
                LogTools.trace(t);
            }
        }
    }

    public OMEXMLReader() {
        super("OME-XML", "ome");
    }

    public boolean isThisType(byte[] block) {
        return new String(block, 0, 5).equals("<?xml");
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[this.series]) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.in.seek(((Integer)this.offsets[this.series].get(no)).intValue());
        byte[] buf = no < this.getImageCount() - 1 ? new byte[(Integer)this.offsets[this.series].get(no + 1) - (Integer)this.offsets[this.series].get(no)] : new byte[(int)(this.in.length() - (long)((Integer)this.offsets[this.series].get(no)).intValue())];
        this.in.read(buf);
        String data = new String(buf);
        buf = null;
        int dataStart = data.indexOf(">") + 1;
        String pix = data.substring(dataStart);
        if (pix.indexOf("<") > 0) {
            pix = pix.substring(0, pix.indexOf("<"));
        }
        data = null;
        Base64Codec e = new Base64Codec();
        byte[] pixels = e.base64Decode(pix);
        pix = null;
        if (this.compression[this.series].equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream(bais);
            pixels = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.bpp[this.series]];
            int i = 0;
            while (i < pixels.length) {
                pixels[i] = (byte)bzip.read();
                ++i;
            }
            tempPixels = null;
            bais.close();
            bais = null;
            bzip = null;
        } else if (this.compression[this.series].equals("zlib")) {
            try {
                Inflater decompressor = new Inflater();
                decompressor.setInput(pixels, 0, pixels.length);
                pixels = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.bpp[this.series]];
                decompressor.inflate(pixels);
                decompressor.end();
            }
            catch (DataFormatException dfe) {
                throw new FormatException("Error uncompressing zlib data.");
            }
        }
        return pixels;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[this.series], this.core.sizeY[this.series], 1, false, this.bpp[this.series], this.core.littleEndian[this.series]);
    }

    /*
     * Unable to fully structure code
     */
    protected void initFile(String id) throws FormatException, IOException {
        if (OMEXMLReader.debug) {
            this.debug("OMEXMLReader.initFile(" + id + ")");
        }
        if (OMEXMLReader.noOME) {
            throw new FormatException("The Java OME-XML library is required to read OME-XML files. Please obtain ome-java.jar from http://loci.wisc.edu/ome/formats.html");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        r = new ReflectedUniverse();
        try {
            r.exec("import loci.formats.ome.OMEXMLMetadataStore");
            r.exec("import org.openmicroscopy.xml.OMENode");
            r.exec("omexml = new OMEXMLMetadataStore()");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        this.status("Determining endianness");
        this.in.skipBytes(200);
        numDatasets = 0;
        endianness = new Vector<Boolean>();
        bigEndianPos = new Vector<Long>();
        buf = new byte[1];
        while (this.in.getFilePointer() < this.in.length()) {
            buf = new byte[8192];
            found = false;
            while (!found) {
                if (this.in.getFilePointer() < this.in.length()) {
                    read = this.in.read(buf, 9, 8183);
                    test = new String(buf);
                    ndx = test.indexOf("BigEndian");
                    if (ndx == -1) continue;
                    found = true;
                    endian = test.substring(ndx + 11).trim();
                    if (endian.startsWith("\"")) {
                        endian = endian.substring(1);
                    }
                    endianness.add(new Boolean(endian.toLowerCase().startsWith("t") == false));
                    bigEndianPos.add(new Long(this.in.getFilePointer() - (long)read - 9L + (long)ndx));
                    ++numDatasets;
                    continue;
                }
                if (numDatasets == 0) {
                    throw new FormatException("Pixel data not found.");
                }
                found = true;
            }
        }
        this.offsets = new Vector[numDatasets];
        i = 0;
        while (i < numDatasets) {
            this.offsets[i] = new Vector<E>();
            ++i;
        }
        this.status("Finding image offsets");
        i = 0;
        while (i < numDatasets) {
            this.in.seek((Long)bigEndianPos.get(i));
            found = false;
            buf = new byte[8192];
            this.in.read(buf, 0, 14);
            while (!found) {
                block40: {
                    block41: {
                        if (this.in.getFilePointer() >= this.in.length()) break block40;
                        numRead = this.in.read(buf, 14, 8178);
                        test = new String(buf);
                        ndx = test.indexOf("<Bin");
                        if (ndx != -1) ** GOTO lbl73
                        b = buf;
                        System.arraycopy(b, 8177, buf, 0, 14);
                        break block41;
lbl-1000:
                        // 1 sources

                        {
                            ndx = test.indexOf("<Bin", ndx + 1);
lbl73:
                            // 2 sources

                            ** while (ndx == -1 || ndx == test.indexOf((String)"<Bin:External") || ndx == test.indexOf((String)"<Bin:BinaryFile"))
                        }
lbl74:
                        // 1 sources

                        found = true;
                        this.offsets[i].add(new Integer((int)this.in.getFilePointer() - ((numRead += 14) - ndx)));
                    }
                    test = null;
                    continue;
                }
                throw new FormatException("Pixel data not found");
            }
            ++i;
        }
        this.in.seek(0L);
        i = 0;
        while (i < numDatasets) {
            if (i == 0) {
                buf = new byte[((Integer)this.offsets[i].get(0)).intValue()];
            } else {
                found = false;
                buf = new byte[8192];
                this.in.read(buf, 0, 14);
                while (!found) {
                    if (this.in.getFilePointer() < this.in.length()) {
                        numRead = this.in.read(buf, 14, 8178);
                        test = new String(buf);
                        ndx = test.indexOf("<Image ");
                        if (ndx == -1) {
                            b = buf;
                            System.arraycopy(b, 8177, buf, 0, 14);
                            b = null;
                        } else {
                            found = true;
                            this.in.seek(this.in.getFilePointer() - (long)(8192 - ndx));
                        }
                        test = null;
                        continue;
                    }
                    throw new FormatException("Pixel data not found");
                }
                bufSize = (int)((Long)this.offsets[i].get(0) - this.in.getFilePointer());
                buf = new byte[bufSize];
            }
            this.in.read(buf);
            ++i;
        }
        buf = null;
        this.status("Populating metadata");
        r.setVar("ome", null);
        try {
            f = new File(Location.getMappedId(id));
            f = f.getAbsoluteFile();
            path = f.getPath().toLowerCase();
            if (f.exists() && path.endsWith(".ome")) {
                r.setVar("f", f);
                r.exec("ome = new OMENode(f)");
            } else {
                b = new byte[(int)this.in.length()];
                oldFp = this.in.getFilePointer();
                this.in.seek(0L);
                this.in.read(b);
                this.in.seek(oldFp);
                r.setVar("s", new String(b));
                r.exec("ome = new OMENode(s)");
                b = null;
            }
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        try {
            r.exec("omexml.setRoot(ome)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        this.core = new CoreMetadata(numDatasets);
        this.bpp = new int[numDatasets];
        this.compression = new String[numDatasets];
        oldSeries = this.getSeries();
        try {
            r.exec("omexml.setRoot(ome)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        i = 0;
        while (i < numDatasets) {
            this.setSeries(i);
            this.core.littleEndian[i] = (Boolean)endianness.get(i);
            ndx = new Integer(i);
            w = null;
            h = null;
            t = null;
            z = null;
            c = null;
            pixType = null;
            dimOrder = null;
            try {
                r.setVar("ndx", i);
                w = (Integer)r.exec("omexml.getSizeX(ndx)");
                h = (Integer)r.exec("omexml.getSizeY(ndx)");
                t = (Integer)r.exec("omexml.getSizeT(ndx)");
                z = (Integer)r.exec("omexml.getSizeZ(ndx)");
                c = (Integer)r.exec("omexml.getSizeC(ndx)");
                pixType = (String)r.exec("omexml.getPixelType(ndx)");
                this.core.currentOrder[i] = (String)r.exec("omexml.getDimensionOrder(ndx)");
            }
            catch (ReflectException exc) {
                throw new FormatException(exc);
            }
            this.core.sizeX[i] = w;
            this.core.sizeY[i] = h;
            this.core.sizeT[i] = t;
            this.core.sizeZ[i] = z;
            this.core.sizeC[i] = c;
            this.core.rgb[i] = false;
            this.core.interleaved[i] = false;
            type = pixType.toLowerCase();
            if (type.endsWith("16")) {
                this.bpp[i] = 2;
                this.core.pixelType[i] = 3;
            } else if (type.endsWith("32")) {
                this.bpp[i] = 4;
                this.core.pixelType[i] = 5;
            } else if (type.equals("float")) {
                this.bpp[i] = 4;
                this.core.pixelType[i] = 6;
            } else {
                this.bpp[i] = 1;
                this.core.pixelType[i] = 1;
            }
            expected = this.core.sizeX[i] * this.core.sizeY[i] * this.bpp[i];
            this.in.seek(((Integer)this.offsets[i].get(0)).intValue());
            buf = new byte[256];
            this.in.read(buf);
            data = new String(buf);
            compressionStart = data.indexOf("Compression") + 13;
            compressionEnd = data.indexOf("\"", compressionStart);
            this.compression[i] = compressionStart != -1 && compressionEnd != -1 ? data.substring(compressionStart, compressionEnd) : "none";
            this.in.seek(((Integer)this.offsets[i].get(0)).intValue());
            planes = this.core.sizeZ[i] * this.core.sizeC[i] * this.core.sizeT[i];
            this.searchForData(expected /= 2, planes);
            this.core.imageCount[i] = this.offsets[i].size();
            if (this.core.imageCount[i] < planes) {
                this.in.seek(((Integer)this.offsets[i].get(0)).intValue());
                this.searchForData(0, planes);
                this.core.imageCount[i] = this.offsets[i].size();
            }
            buf = null;
            ++i;
        }
        this.setSeries(oldSeries);
        Arrays.fill(this.core.orderCertain, true);
        store = this.getMetadataStore();
        i = 0;
        while (i < this.core.sizeC.length) {
            j = 0;
            while (j < this.core.sizeC[i]) {
                store.setLogicalChannel(j, null, null, null, null, null, null, new Integer(i));
                ++j;
            }
            ++i;
        }
        System.gc();
    }

    private void searchForData(int safe, int numPlanes) throws IOException {
        int iteration = 0;
        boolean found = false;
        if (this.offsets[this.series].size() > 1) {
            Object zeroth = this.offsets[this.series].get(0);
            this.offsets[this.series].clear();
            this.offsets[this.series].add(zeroth);
        }
        this.in.skipBytes(1);
        while (this.in.getFilePointer() + (long)safe < this.in.length() && this.offsets[this.series].size() < numPlanes) {
            this.in.skipBytes(safe);
            found = false;
            byte[] buf = new byte[8192];
            while (!found) {
                if (this.in.getFilePointer() < this.in.length()) {
                    int numRead = this.in.read(buf, 20, buf.length - 20);
                    String test = new String(buf);
                    int ndx = test.indexOf("<Bin");
                    while (ndx != -1) {
                        found = true;
                        if (numRead == buf.length - 20) {
                            numRead = buf.length;
                        }
                        this.offsets[this.series].add(new Integer((int)this.in.getFilePointer() - (numRead - ndx)));
                        ndx = test.indexOf("<Bin", ndx + 1);
                    }
                    test = null;
                    continue;
                }
                found = true;
            }
            buf = null;
            ++iteration;
        }
    }
}

