/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OMETiffReader
extends BaseTiffReader {
    public OMETiffReader() {
        super("OME-TIFF", new String[]{"tif", "tiff"});
    }

    public boolean isThisType(String name, boolean open) {
        String comment;
        block6: {
            Hashtable ifd;
            block5: {
                if (!name.toLowerCase().endsWith("tif") && !name.toLowerCase().endsWith("tiff")) {
                    return false;
                }
                try {
                    RandomAccessStream ras = new RandomAccessStream(name);
                    ifd = TiffTools.getFirstIFD(ras);
                    ras.close();
                    if (ifd != null) break block5;
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
            comment = (String)ifd.get(new Integer(270));
            if (comment != null) break block6;
            return false;
        }
        return comment.indexOf("ome.xsd") >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initStandardMetadata() throws FormatException, IOException {
        boolean isWiscScan;
        int j;
        int i;
        super.initStandardMetadata();
        String comment = (String)this.getMeta("Comment");
        ByteArrayInputStream is = new ByteArrayInputStream(comment.getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
        }
        catch (ParserConfigurationException builder) {
        }
        catch (SAXException builder) {
        }
        catch (IOException builder) {
            // empty catch block
        }
        Element[] pixels = null;
        Element[][] tiffData = null;
        if (doc != null) {
            NodeList pixelsList = doc.getElementsByTagName("Pixels");
            int numSeries = pixelsList.getLength();
            Vector<Node> v = new Vector<Node>();
            pixels = new Element[numSeries];
            tiffData = new Element[numSeries][];
            i = 0;
            while (i < numSeries) {
                pixels[i] = (Element)pixelsList.item(i);
                NodeList list = pixels[i].getChildNodes();
                int size = list.getLength();
                v.clear();
                j = 0;
                while (j < size) {
                    Node node = list.item(j);
                    if (node instanceof Element && "TiffData".equals(node.getNodeName())) {
                        v.add(node);
                    }
                    ++j;
                }
                tiffData[i] = new Element[v.size()];
                v.copyInto(tiffData[i]);
                ++i;
            }
        }
        String s = null;
        if (this.ifds.length > 1) {
            s = (String)TiffTools.getIFDValue(this.ifds[1], 270);
        }
        boolean bl = isWiscScan = s != null && s.indexOf("ome.xsd") != -1;
        if (tiffData != null) {
            boolean rgb = this.isRGB();
            this.core = new CoreMetadata(tiffData.length);
            Arrays.fill(this.core.orderCertain, true);
            i = 0;
            while (i < tiffData.length) {
                this.core.sizeX[i] = Integer.parseInt(pixels[i].getAttribute("SizeX"));
                this.core.sizeY[i] = Integer.parseInt(pixels[i].getAttribute("SizeY"));
                this.core.sizeZ[i] = Integer.parseInt(pixels[i].getAttribute("SizeZ"));
                this.core.sizeC[i] = Integer.parseInt(pixels[i].getAttribute("SizeC"));
                this.core.imageCount[i] = this.ifds.length;
                int sc = this.core.sizeC[i];
                if (rgb) {
                    sc /= 3;
                }
                this.core.sizeT[i] = Integer.parseInt(pixels[i].getAttribute("SizeT"));
                this.core.pixelType[i] = FormatTools.pixelTypeFromString(pixels[i].getAttribute("PixelType"));
                if (this.core.pixelType[i] == 0 || this.core.pixelType[i] == 2 || this.core.pixelType[i] == 4) {
                    int n = i;
                    this.core.pixelType[n] = this.core.pixelType[n] + 1;
                }
                if (isWiscScan) {
                    this.core.sizeT[i] = this.core.imageCount[0];
                }
                this.core.currentOrder[i] = pixels[i].getAttribute("DimensionOrder");
                this.core.orderCertain[i] = true;
                boolean[][][] zct = new boolean[this.core.sizeZ[i]][sc][this.core.sizeT[i]];
                j = 0;
                while (j < tiffData[i].length) {
                    int firstT;
                    String aIfd = tiffData[i][j].getAttribute("IFD");
                    String aFirstZ = tiffData[i][j].getAttribute("FirstZ");
                    String aFirstT = tiffData[i][j].getAttribute("FirstT");
                    String aFirstC = tiffData[i][j].getAttribute("FirstC");
                    String aNumPlanes = tiffData[i][j].getAttribute("NumPlanes");
                    boolean nullIfd = aIfd == null || aIfd.equals("");
                    boolean nullFirstZ = aFirstZ == null || aFirstZ.equals("");
                    boolean nullFirstC = aFirstC == null || aFirstC.equals("");
                    boolean nullFirstT = aFirstT == null || aFirstT.equals("");
                    boolean nullNumPlanes = aNumPlanes == null || aNumPlanes.equals("");
                    int ifd = nullIfd ? 0 : Integer.parseInt(aIfd);
                    int firstZ = nullFirstZ ? 0 : Integer.parseInt(aFirstZ);
                    int firstC = nullFirstC ? 0 : Integer.parseInt(aFirstC);
                    int n = firstT = nullFirstT ? 0 : Integer.parseInt(aFirstT);
                    int numPlanes = nullNumPlanes ? (nullIfd ? this.core.imageCount[0] : 1) : Integer.parseInt(aNumPlanes);
                    char d1st = this.core.currentOrder[i].charAt(2);
                    char d2nd = this.core.currentOrder[i].charAt(3);
                    int z = firstZ;
                    int t = firstT;
                    int c = firstC;
                    int k = 0;
                    while (k < numPlanes) {
                        zct[z][c][t] = true;
                        switch (d1st) {
                            case 'Z': {
                                if (++z < this.core.sizeZ[i]) break;
                                z = 0;
                                switch (d2nd) {
                                    case 'T': {
                                        if (++t < this.core.sizeT[i]) break;
                                        t = 0;
                                        ++c;
                                        break;
                                    }
                                    case 'C': {
                                        if (++c < sc) break;
                                        c = 0;
                                        ++t;
                                        break;
                                    }
                                }
                                break;
                            }
                            case 'T': {
                                if (++t < this.core.sizeT[i]) break;
                                t = 0;
                                switch (d2nd) {
                                    case 'Z': {
                                        if (++z < this.core.sizeZ[i]) break;
                                        z = 0;
                                        ++c;
                                        break;
                                    }
                                    case 'C': {
                                        if (++c < sc) break;
                                        c = 0;
                                        ++z;
                                        break;
                                    }
                                }
                                break;
                            }
                            case 'C': {
                                if (++c < sc) break;
                                c = 0;
                                switch (d2nd) {
                                    case 'Z': {
                                        if (++z < this.core.sizeZ[i]) break;
                                        z = 0;
                                        ++t;
                                        break;
                                    }
                                    case 'T': {
                                        if (++t < this.core.sizeT[i]) break;
                                        t = 0;
                                        ++z;
                                    }
                                }
                                break;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                boolean success = false;
                success = true;
                int z = 0;
                while (z < this.core.sizeZ[i] && success) {
                    int t = 0;
                    while (t < this.core.sizeT[i] && success) {
                        int c = 0;
                        while (c < sc && success) {
                            if (!zct[z][c][t]) {
                                success = false;
                            }
                            ++c;
                        }
                        ++t;
                    }
                    ++z;
                }
                if (!success) {
                    int c;
                    int t;
                    success = true;
                    int theZ = -1;
                    z = 0;
                    while (z < this.core.sizeT[i] && success) {
                        if (zct[z][0][0]) {
                            if (theZ < 0) {
                                theZ = z;
                            } else {
                                success = false;
                            }
                        }
                        boolean state = theZ == z;
                        t = 0;
                        while (t < this.core.sizeT[i] && success) {
                            c = 0;
                            while (c < sc && success) {
                                if (zct[z][c][t] != state) {
                                    success = false;
                                }
                                ++c;
                            }
                            ++t;
                        }
                        ++z;
                    }
                    if (success) {
                        this.core.sizeZ[i] = 1;
                    } else {
                        int z2;
                        success = true;
                        int theT = -1;
                        int t2 = 0;
                        while (t2 < this.core.sizeT[i] && success) {
                            if (zct[0][0][t2]) {
                                if (theT < 0) {
                                    theT = t2;
                                } else {
                                    success = false;
                                }
                            }
                            boolean state = theT == t2;
                            z2 = 0;
                            while (z2 < this.core.sizeZ[i] && success) {
                                c = 0;
                                while (c < sc && success) {
                                    if (zct[z2][c][t2] != state) {
                                        success = false;
                                    }
                                    ++c;
                                }
                                ++z2;
                            }
                            ++t2;
                        }
                        if (success) {
                            this.core.sizeT[i] = 1;
                        } else {
                            int t3;
                            success = true;
                            int theC = -1;
                            int c2 = 0;
                            while (c2 < sc && success) {
                                if (zct[0][c2][0]) {
                                    if (theC < 0) {
                                        theC = c2;
                                    } else {
                                        success = false;
                                    }
                                }
                                boolean state = theC == c2;
                                z2 = 0;
                                while (z2 < this.core.sizeZ[i] && success) {
                                    t3 = 0;
                                    while (t3 < this.core.sizeT[i] && success) {
                                        if (zct[z2][c2][t3] != state) {
                                            success = false;
                                        }
                                        ++t3;
                                    }
                                    ++z2;
                                }
                                ++c2;
                            }
                            if (success) {
                                this.core.sizeC[i] = 1;
                            } else {
                                boolean state;
                                success = true;
                                theZ = -1;
                                theT = -1;
                                z = 0;
                                while (z < this.core.sizeZ[i] && success) {
                                    int t4 = 0;
                                    while (t4 < this.core.sizeT[i] && success) {
                                        if (zct[z][0][t4]) {
                                            if (theZ < 0 && theT < 0) {
                                                theZ = z;
                                                theT = t4;
                                            } else {
                                                success = false;
                                            }
                                        }
                                        state = theZ == z && theT == t4;
                                        c = 0;
                                        while (c < sc && success) {
                                            if (zct[z][c][t4] != state) {
                                                success = false;
                                            }
                                            ++c;
                                        }
                                        ++t4;
                                    }
                                    ++z;
                                }
                                if (success) {
                                    this.core.sizeT[i] = 1;
                                    this.core.sizeZ[i] = 1;
                                } else {
                                    success = true;
                                    theZ = -1;
                                    theC = -1;
                                    z = 0;
                                    while (z < this.core.sizeZ[i] && success) {
                                        int c3 = 0;
                                        while (c3 < sc && success) {
                                            if (zct[z][c3][0]) {
                                                if (theZ < 0 && theC < 0) {
                                                    theZ = z;
                                                    theC = c3;
                                                } else {
                                                    success = false;
                                                }
                                            }
                                            state = theZ == z && theC == c3;
                                            t3 = 0;
                                            while (t3 < this.core.sizeT[i] && success) {
                                                if (zct[z][c3][t3] != state) {
                                                    success = false;
                                                }
                                                ++t3;
                                            }
                                            ++c3;
                                        }
                                        ++z;
                                    }
                                    if (success) {
                                        this.core.sizeC[i] = 1;
                                        this.core.sizeZ[i] = 1;
                                    } else {
                                        success = true;
                                        theT = -1;
                                        theC = -1;
                                        t2 = 0;
                                        while (t2 < this.core.sizeT[i] && success) {
                                            int c4 = 0;
                                            while (c4 < sc && success) {
                                                if (zct[0][c4][t2]) {
                                                    if (theC < 0 && theT < 0) {
                                                        theC = c4;
                                                        theT = t2;
                                                    } else {
                                                        success = false;
                                                    }
                                                }
                                                state = theC == c4 && theT == t2;
                                                int z3 = 0;
                                                while (z3 < this.core.sizeZ[i] && success) {
                                                    if (zct[z3][c4][t2] != state) {
                                                        success = false;
                                                    }
                                                    ++z3;
                                                }
                                                ++c4;
                                            }
                                            ++t2;
                                        }
                                        if (success) {
                                            this.core.sizeC[i] = 1;
                                            this.core.sizeT[i] = 1;
                                        } else {
                                            success = true;
                                            theZ = -1;
                                            theT = -1;
                                            theC = -1;
                                            int count = 0;
                                            int z4 = 0;
                                            while (z4 < this.core.sizeZ[i] && success) {
                                                t = 0;
                                                while (t < this.core.sizeT[i] && success) {
                                                    c = 0;
                                                    while (c < sc && success) {
                                                        if (zct[z4][c][t] && ++count > 1) {
                                                            success = false;
                                                        }
                                                        ++c;
                                                    }
                                                    ++t;
                                                }
                                                ++z4;
                                            }
                                            if (!success) {
                                                throw new FormatException("Unsupported ZCT index mapping");
                                            }
                                            this.core.sizeC[i] = 1;
                                            this.core.sizeT[i] = 1;
                                            this.core.sizeZ[i] = 1;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void initMetadataStore() {
        boolean isOMEXML;
        String comment = (String)this.getMeta("Comment");
        this.metadata.remove("Comment");
        try {
            Class<?> omexmlMeta = Class.forName("loci.formats.ome.OMEXMLMetadataStore");
            isOMEXML = omexmlMeta.isAssignableFrom(this.metadataStore.getClass());
        }
        catch (Throwable t) {
            isOMEXML = false;
        }
        if (isOMEXML) {
            ReflectedUniverse r = new ReflectedUniverse();
            try {
                r.exec("import loci.formats.ome.OMEXMLMetadataStore");
                r.setVar("xmlStore", this.metadataStore);
                r.setVar("comment", comment);
                r.exec("xmlStore.createRoot(comment)");
                return;
            }
            catch (ReflectException reflectException) {
                // empty catch block
            }
        }
    }
}

