/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.BMPReader;
import loci.formats.in.TiffReader;

public class OIFReader
extends FormatReader {
    protected Vector tiffs;
    protected TiffReader[] tiffReader;
    protected BMPReader thumbReader;
    protected Vector usedFiles;
    protected String[] size = new String[9];
    protected String[] code = new String[9];
    protected int imageDepth;

    public OIFReader() {
        super("Fluoview FV1000 OIF", new String[]{"oif", "roi", "pty", "lut", "bmp"});
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] b = this.tiffReader[no].openBytes(0);
        this.tiffReader[no].close();
        return b;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiffReader[no].openBytes(0, buf);
        this.tiffReader[no].close();
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        BufferedImage b = this.tiffReader[no].openImage(0);
        ColorModel cm = ImageTools.makeColorModel(b.getRaster().getNumBands(), b.getRaster().getTransferType(), null);
        b = ImageTools.makeBuffered(b, cm);
        this.tiffReader[no].close();
        return b;
    }

    public BufferedImage openThumbImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        String dir = this.currentId.substring(0, this.currentId.lastIndexOf(File.separator) + 1);
        dir = String.valueOf(dir) + this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1) + ".files" + File.separator;
        String thumbId = String.valueOf(dir) + this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1, this.currentId.lastIndexOf(".")) + "_Thumb.bmp";
        this.thumbReader.setId(thumbId);
        return this.thumbReader.openImage(0);
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.usedFiles.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (this.thumbReader != null) {
                this.thumbReader.close(fileOnly);
            }
            if (this.tiffReader != null) {
                int i = 0;
                while (i < this.tiffReader.length) {
                    if (this.tiffReader[i] != null) {
                        this.tiffReader[i].close(fileOnly);
                    }
                    ++i;
                }
            }
        } else {
            this.close();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.thumbReader != null) {
            this.thumbReader.close();
        }
        if (this.tiffReader != null) {
            int i = 0;
            while (i < this.tiffReader.length) {
                if (this.tiffReader[i] != null) {
                    this.tiffReader[i].close();
                }
                ++i;
            }
        }
        this.tiffs = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String num;
        if (debug) {
            this.debug("OIFReader.initFile(" + id + ")");
        }
        this.status("Finding metadata file");
        String oifFile = id;
        if (!id.toLowerCase().endsWith("oif")) {
            Location current = new Location(id);
            current = current.getAbsoluteFile();
            String parent = current.getParent();
            Location tmp = new Location(parent);
            parent = tmp.getParent();
            id = current.getPath();
            oifFile = id.substring(id.lastIndexOf(File.separator));
            oifFile = String.valueOf(parent) + oifFile.substring(0, oifFile.indexOf("_")) + ".oif";
            tmp = new Location(oifFile);
            if (!tmp.exists()) {
                tmp = new Location(oifFile = String.valueOf(oifFile.substring(0, oifFile.lastIndexOf("."))) + ".OIF");
                if (!tmp.exists()) {
                    throw new FormatException("OIF file not found");
                }
                this.currentId = oifFile;
            } else {
                this.currentId = oifFile;
            }
        }
        super.initFile(oifFile);
        this.in = new RandomAccessStream(oifFile);
        this.usedFiles = new Vector();
        this.usedFiles.add(new Location(oifFile).getAbsolutePath());
        int slash = oifFile.lastIndexOf(File.separator);
        String path = slash < 0 ? "." : oifFile.substring(0, slash);
        this.status("Parsing metadata values");
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        String s = new String(b);
        StringTokenizer st = new StringTokenizer(s, "\r\n");
        Hashtable<Integer, String> filenames = new Hashtable<Integer, String>();
        String prefix = "";
        while (st.hasMoreTokens()) {
            String line = DataTools.stripString(st.nextToken().trim());
            if (!line.startsWith("[") && line.indexOf("=") > 0) {
                String key = line.substring(0, line.indexOf("=")).trim();
                String value = line.substring(line.indexOf("=") + 1).trim();
                if (key.startsWith("IniFileName") && key.indexOf("Thumb") == -1) {
                    int pos = Integer.parseInt(key.substring(11));
                    filenames.put(new Integer(pos), value.trim());
                }
                this.addMeta(String.valueOf(prefix) + key, value);
                if (prefix.startsWith("[Axis ") && prefix.endsWith("Parameters Common] - ")) {
                    int ndx = Integer.parseInt(prefix.substring(6, prefix.indexOf("P")).trim());
                    if (key.equals("AxisCode")) {
                        this.code[ndx] = value;
                        continue;
                    }
                    if (!key.equals("MaxSize")) continue;
                    this.size[ndx] = value;
                    continue;
                }
                if ((String.valueOf(prefix) + key).equals("[Axis Parameter Common] - AxisOrder")) {
                    this.core.currentOrder[0] = value;
                    continue;
                }
                if (!(String.valueOf(prefix) + key).equals("[Reference Image Parameter] - ImageDepth")) continue;
                this.imageDepth = Integer.parseInt(value);
                continue;
            }
            if (line.length() <= 0) continue;
            if (line.indexOf("[") == 2) {
                line = line.substring(2, line.length());
            }
            prefix = String.valueOf(line) + " - ";
        }
        int reference = ((String)filenames.get(new Integer(0))).length();
        int numFiles = filenames.size();
        int i = 0;
        while (i < numFiles) {
            String value = (String)filenames.get(new Integer(i));
            if (value.length() > reference) {
                filenames.remove(new Integer(i));
            }
            ++i;
        }
        this.status("Initializing helper readers");
        this.thumbReader = new BMPReader();
        this.core.imageCount[0] = filenames.size();
        this.tiffs = new Vector(this.core.imageCount[0]);
        this.tiffReader = new TiffReader[this.core.imageCount[0]];
        i = 0;
        while (i < this.core.imageCount[0]) {
            this.tiffReader[i] = new TiffReader();
            if (i > 0) {
                this.tiffReader[i].setMetadataCollected(false);
            }
            ++i;
        }
        this.status("Reading additional metadata");
        String tiffPath = null;
        int i2 = 0;
        while (i2 < this.core.imageCount[0]) {
            String file = (String)filenames.get(new Integer(i2));
            file = file.substring(1, file.length() - 1);
            file = file.replace('\\', File.separatorChar);
            file = file.replace('/', File.separatorChar);
            file = String.valueOf(path) + File.separator + file;
            tiffPath = file.substring(0, file.lastIndexOf(File.separator));
            RandomAccessStream ptyReader = new RandomAccessStream(file);
            b = new byte[(int)ptyReader.length()];
            ptyReader.read(b);
            s = new String(b);
            st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken().trim();
                if (line.startsWith("[") || line.indexOf("=") <= 0) continue;
                String key = line.substring(0, line.indexOf("=") - 1).trim();
                String value = line.substring(line.indexOf("=") + 1).trim();
                key = DataTools.stripString(key);
                value = DataTools.stripString(value);
                if (key.equals("DataName") && (value = value.substring(1, value.length() - 1)).indexOf("-R") == -1) {
                    this.tiffs.add(i2, String.valueOf(tiffPath) + File.separator + value);
                    this.tiffReader[i2].setId((String)this.tiffs.get(i2));
                }
                this.addMeta("Image " + i2 + " : " + key, value);
            }
            ptyReader.close();
            ++i2;
        }
        if (tiffPath != null) {
            Location dir = new Location(tiffPath);
            String[] list = dir.list();
            int i3 = 0;
            while (i3 < list.length) {
                this.usedFiles.add(new Location(tiffPath, list[i3]).getAbsolutePath());
                ++i3;
            }
        }
        this.status("Populating metadata");
        i = 0;
        while (i < 9) {
            int ss = Integer.parseInt(this.size[i]);
            if (this.code[i].equals("\"X\"")) {
                this.core.sizeX[0] = ss;
            } else if (this.code[i].equals("\"Y\"")) {
                this.core.sizeY[0] = ss;
            } else if (this.code[i].equals("\"C\"")) {
                this.core.sizeC[0] = ss;
            } else if (this.code[i].equals("\"T\"")) {
                this.core.sizeT[0] = ss;
            } else if (this.code[i].equals("\"Z\"")) {
                this.core.sizeZ[0] = ss;
            }
            ++i;
        }
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * this.getEffectiveSizeC()) {
            if (this.core.sizeZ[0] == 1) {
                this.core.sizeT[0] = this.core.sizeT[0] + 1;
                continue;
            }
            if (this.core.sizeT[0] != 1) continue;
            this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
        }
        this.core.currentOrder[0] = this.core.currentOrder[0].substring(1, this.core.currentOrder[0].length() - 1);
        if (this.core.currentOrder[0] == null) {
            this.core.currentOrder[0] = "XYZTC";
        } else {
            String[] names = new String[]{"X", "Y", "Z", "C", "T"};
            if (this.core.currentOrder[0].length() < 5) {
                int i4 = 0;
                while (i4 < names.length) {
                    if (this.core.currentOrder[0].indexOf(names[i4]) == -1) {
                        this.core.currentOrder[0] = String.valueOf(this.core.currentOrder[0]) + names[i4];
                    }
                    ++i4;
                }
            }
        }
        BufferedImage thumbImage = this.openThumbImage(0);
        this.core.thumbSizeX[0] = thumbImage.getWidth();
        this.core.thumbSizeY[0] = thumbImage.getHeight();
        MetadataStore store = this.getMetadataStore();
        switch (this.imageDepth) {
            case 1: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 2: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 4: {
                this.core.pixelType[0] = 5;
                break;
            }
            default: {
                throw new RuntimeException("Unknown matching for pixel depth of: " + this.imageDepth);
            }
        }
        this.core.rgb[0] = this.tiffReader[0].isRGB();
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = false;
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), Boolean.FALSE, "XYZTC", null, null);
        prefix = "[Reference Image Parameter] - ";
        String px = (String)this.getMeta(String.valueOf(prefix) + "WidthConvertValue");
        String py = (String)this.getMeta(String.valueOf(prefix) + "HeightConvertValue");
        Float pixX = null;
        Float pixY = null;
        if (px != null) {
            pixX = new Float(px);
        }
        if (py != null) {
            pixY = new Float(py);
        }
        store.setDimensions(pixX, pixY, null, null, null, null);
        int i5 = 0;
        while (i5 < this.core.sizeC[0]) {
            prefix = "[Channel " + (i5 + 1) + " Parameters] - ";
            String name = (String)this.getMeta(String.valueOf(prefix) + "CH Name");
            String emWave = (String)this.getMeta(String.valueOf(prefix) + "EmissionWavelength");
            String exWave = (String)this.getMeta(String.valueOf(prefix) + "ExcitationWavelength");
            store.setLogicalChannel(i5, name, null, emWave == null ? null : new Integer(emWave), exWave == null ? null : new Integer(exWave), null, null, null);
            ++i5;
        }
        i5 = 0;
        while (i5 < this.core.sizeC[0]) {
            prefix = "[Channel " + (i5 + 1) + " Parameters] - ";
            String gain = (String)this.getMeta(String.valueOf(prefix) + "CountingPMTGain");
            String voltage = (String)this.getMeta(String.valueOf(prefix) + "CountingPMTVoltage");
            String offset = (String)this.getMeta(String.valueOf(prefix) + "CountingPMTOffset");
            if (gain != null) {
                gain.replaceAll("\"", "");
            }
            if (voltage != null) {
                voltage.replaceAll("\"", "");
            }
            if (offset != null) {
                offset.replaceAll("\"", "");
            }
            if (gain != null || voltage != null || offset != null) {
                store.setDetector(null, null, null, null, new Float(gain), new Float(voltage), new Float(offset), null, new Integer(i5));
            }
            ++i5;
        }
        String mag = (String)this.getMeta("Image 0 : Magnification");
        if (mag != null) {
            store.setObjective(null, null, null, null, new Float(mag), null, null);
        }
        if ((num = (String)this.getMeta("[Acquisition Parameters Common] - Number of use Laser")) != null) {
            int numLasers = Integer.parseInt(num);
            int i6 = 0;
            while (i6 < numLasers) {
                String wave = (String)this.getMeta("[Acquisition Parameters Common] - LaserWavelength0" + (i6 + 1));
                if (wave != null) {
                    store.setLaser(null, null, new Integer(wave), null, null, null, null, null, null, null, new Integer(i6));
                }
                ++i6;
            }
        }
    }
}

