/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import loci.formats.TiffTools;

public class OIBReader
extends FormatReader {
    private static final String NO_POI_MSG = "Jakarta POI is required to read OIB files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noPOI = false;
    private static ReflectedUniverse r = OIBReader.createReflectedUniverse();
    private Vector nImages;
    private Vector width;
    private Vector height;
    private Vector nChannels;
    private Vector tSize;
    private Vector zSize;
    private Vector bpp;
    private int thumbWidth;
    private int thumbHeight;
    private Vector pixels;
    private Vector names;
    private Vector[] zIndices;
    private Vector[] cIndices;
    private Vector[] tIndices;
    private Vector rgb;
    private String[] labels = new String[9];
    private String[] dims = new String[9];
    private String[] starts = new String[9];
    private String[] stops = new String[9];

    private static ReflectedUniverse createReflectedUniverse() {
        r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import org.apache.poi.poifs.filesystem.POIFSFileSystem");
            r.exec("import org.apache.poi.poifs.filesystem.DirectoryEntry");
            r.exec("import org.apache.poi.poifs.filesystem.DocumentEntry");
            r.exec("import org.apache.poi.poifs.filesystem.DocumentInputStream");
            r.exec("import java.util.Iterator");
        }
        catch (ReflectException exc) {
            noPOI = true;
        }
        return r;
    }

    public OIBReader() {
        super("Fluoview FV1000 OIB", "oib");
    }

    public boolean isThisType(byte[] block) {
        return block[0] == 208 && block[1] == 207 && block[2] == 17 && block[3] == 224;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        byte[] b = this.openBytes(no);
        int bytes = b.length / (this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.getRGBChannelCount());
        return ImageTools.makeImage(b, this.core.sizeX[this.series], this.core.sizeY[this.series], this.getRGBChannelCount(), false, bytes, this.core.littleEndian[this.series]);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[this.series] * this.core.sizeY[this.series] * this.getRGBChannelCount() * FormatTools.getBytesPerPixel(this.core.pixelType[this.series])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        try {
            Integer ii = new Integer(no);
            String directory = (String)((Hashtable)this.pixels.get(this.series)).get(ii);
            String name = (String)((Hashtable)this.names.get(this.series)).get(ii);
            r.setVar("dirName", directory);
            r.exec("root = fs.getRoot()");
            r.exec("dir = root.getEntry(dirName)");
            r.setVar("entryName", name);
            r.exec("document = dir.getEntry(entryName)");
            r.exec("dis = new DocumentInputStream(document)");
            r.exec("numBytes = dis.available()");
            int numBytes = (Integer)r.getVar("numBytes");
            byte[] b = new byte[numBytes + 4];
            r.setVar("data", b);
            r.exec("dis.read(data)");
            RandomAccessStream stream = new RandomAccessStream(b);
            Hashtable[] ifds = TiffTools.getIFDs(stream);
            TiffTools.getSamples(ifds[0], stream, buf);
            stream.close();
            return buf;
        }
        catch (ReflectException e) {
            throw new FormatException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        String[] vars = new String[]{"dirName", "root", "dir", "document", "dis", "numBytes", "data", "fis", "fs", "iter", "isInstance", "isDocument", "entry", "documentName", "entryName"};
        int i = 0;
        while (i < vars.length) {
            r.setVar(vars[i], null);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void initFile(String id) throws FormatException, IOException {
        block46: {
            if (OIBReader.debug) {
                this.debug("OIBReader.initFile(" + id + ")");
            }
            if (OIBReader.noPOI) {
                throw new FormatException("Jakarta POI is required to read OIB files. Please obtain poi-loci.jar from http://loci.wisc.edu/ome/formats.html");
            }
            super.initFile(id);
            this.zIndices = new Vector[]{new Vector<E>()};
            this.cIndices = new Vector[]{new Vector<E>()};
            this.tIndices = new Vector[]{new Vector<E>()};
            this.width = new Vector<E>();
            this.height = new Vector<E>();
            this.nChannels = new Vector<E>();
            this.zSize = new Vector<E>();
            this.tSize = new Vector<E>();
            this.pixels = new Vector<E>();
            this.names = new Vector<E>();
            this.nImages = new Vector<E>();
            this.bpp = new Vector<E>();
            this.bpp.add(new Integer(0));
            this.rgb = new Vector<E>();
            try {
                this.in = new RandomAccessStream(id);
                if (this.in.length() % 4096L != 0L) {
                    this.in.setExtend(4096 - (int)(this.in.length() % 4096L));
                }
                OIBReader.r.setVar("fis", this.in);
                OIBReader.r.exec("fs = new POIFSFileSystem(fis)");
                OIBReader.r.exec("dir = fs.getRoot()");
                this.parseDir(0, OIBReader.r.getVar("dir"));
                numSeries = this.width.size();
                this.status("Sorting images");
                i = 0;
                while (i < numSeries) {
                    newKeys = new Vector<String>();
                    comps = new Vector<Integer>();
                    keys = ((Hashtable)this.names.get(i)).keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        value = (String)((Hashtable)this.names.get(i)).get(key);
                        comp = Integer.parseInt(value.substring(value.indexOf("0")));
                        size = newKeys.size();
                        j = 0;
                        while (j < size) {
                            if (comp < (Integer)comps.get(j)) {
                                newKeys.add(j, value);
                                comps.add(j, new Integer(comp));
                                j = size;
                            } else if (j == size - 1) {
                                newKeys.add(value);
                                comps.add(new Integer(comp));
                                j = size;
                            }
                            ++j;
                        }
                        if (newKeys.size() != 0) continue;
                        newKeys.add(value);
                        comps.add(new Integer(comp));
                    }
                    newNames = new Hashtable<Integer, E>();
                    j = 0;
                    while (j < newKeys.size()) {
                        newNames.put(new Integer(j), newKeys.get(j));
                        ++j;
                    }
                    this.names.setElementAt(newNames, i);
                    ++i;
                }
                this.status("Populating metadata");
                i = 0;
                while (i < this.labels.length) {
                    if (this.labels[i] == null) {
                        this.labels[i] = "";
                    }
                    if (this.dims[i] == null) {
                        this.dims[i] = "0";
                    }
                    if (this.starts[i] == null) {
                        this.starts[i] = "0";
                    }
                    if (this.stops[i] == null) {
                        this.stops[i] = "0";
                    }
                    ++i;
                }
                i = 0;
                while (i < this.labels.length) {
                    if (!this.labels[i].equals("\"X\"") && !this.labels[i].equals("\"Y\"")) {
                        if (this.labels[i].equals("\"C\"")) {
                            if (!this.starts[i].equals(this.stops[i])) {
                                this.nChannels.add(new Integer(this.dims[i]));
                            } else {
                                this.nChannels.add(new Integer(1));
                            }
                        } else if (this.labels[i].equals("\"Z\"")) {
                            if (!this.starts[i].equals(this.stops[i])) {
                                this.zSize.add(new Integer(this.dims[i]));
                            } else {
                                this.zSize.add(new Integer(1));
                            }
                        } else if (this.labels[i].equals("\"T\"")) {
                            if (!this.starts[i].equals(this.stops[i])) {
                                this.tSize.add(new Integer(this.dims[i]));
                            } else {
                                this.tSize.add(new Integer(1));
                            }
                        } else if (!this.dims[i].equals("0")) {
                            if (this.nChannels.size() > 0) {
                                ch = (Integer)this.nChannels.get(this.nChannels.size() - 1);
                                this.nChannels.setElementAt(new Integer(ch *= Integer.parseInt(this.dims[i])), this.nChannels.size() - 1);
                            } else {
                                this.nChannels.add(new Integer(this.dims[i]));
                            }
                        }
                    }
                    ++i;
                }
                this.core = new CoreMetadata(numSeries);
                i = 0;
                while (i < numSeries) {
                    block47: {
                        block49: {
                            block48: {
                                this.core.sizeX[i] = (Integer)this.width.get(i);
                                this.core.sizeY[i] = (Integer)this.height.get(i);
                                this.core.sizeZ[i] = i < this.zSize.size() ? (Integer)this.zSize.get(i) : 1;
                                this.core.sizeC[i] = i < this.nChannels.size() ? (Integer)this.nChannels.get(i) : 1;
                                this.core.sizeT[i] = i < this.tSize.size() ? (Integer)this.tSize.get(i) : 1;
                                if (this.core.sizeZ[i] == 0) {
                                    v0 = i;
                                    this.core.sizeZ[v0] = this.core.sizeZ[v0] + 1;
                                }
                                if (this.core.sizeT[i] == 0) {
                                    v1 = i;
                                    this.core.sizeT[v1] = this.core.sizeT[v1] + 1;
                                }
                                this.core.currentOrder[i] = this.core.sizeZ[i] > this.core.sizeT[i] ? "XYCZT" : "XYCTZ";
                                this.core.imageCount[i] = (Integer)this.nImages.get(i);
                                if (this.core.imageCount[i] <= this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) break block47;
                                diff = this.core.imageCount[i] - this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i];
                                if (diff % this.core.sizeZ[i] != 0 || this.core.sizeZ[i] <= 1) break block48;
                                while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) {
                                    v2 = i;
                                    this.core.sizeT[v2] = this.core.sizeT[v2] + 1;
                                }
                                break block47;
                            }
                            if (diff % this.core.sizeT[i] != 0 || this.core.sizeT[i] <= 1) break block49;
                            while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeT[i] * this.core.sizeC[i]) {
                                v3 = i;
                                this.core.sizeZ[v3] = this.core.sizeZ[v3] + 1;
                            }
                            break block47;
                        }
                        if (diff % this.core.sizeC[i] != 0) break block47;
                        if (this.core.sizeZ[i] <= this.core.sizeT[i]) ** GOTO lbl164
                        while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeC[i] * this.core.sizeT[i]) {
                            v4 = i;
                            this.core.sizeZ[v4] = this.core.sizeZ[v4] + 1;
                        }
                        break block47;
lbl-1000:
                        // 1 sources

                        {
                            v5 = i;
                            this.core.sizeT[v5] = this.core.sizeT[v5] + 1;
lbl164:
                            // 2 sources

                            ** while (this.core.imageCount[i] > this.core.sizeZ[i] * this.core.sizeC[i] * this.core.sizeT[i])
                        }
                    }
                    oldSeries = this.getSeries();
                    this.setSeries(i);
                    while (this.core.imageCount[i] < this.core.sizeZ[i] * this.core.sizeT[i] * this.getEffectiveSizeC()) {
                        v6 = i;
                        this.core.imageCount[v6] = this.core.imageCount[v6] + 1;
                    }
                    this.nImages.setElementAt(new Integer(this.core.imageCount[i]), i);
                    this.setSeries(oldSeries);
                    this.core.rgb[i] = (Boolean)this.rgb.get(i);
                    this.core.interleaved[i] = false;
                    ++i;
                }
                ii = new Integer(0);
                directory = (String)((Hashtable)this.pixels.get(this.series)).get(ii);
                name = (String)((Hashtable)this.names.get(this.series)).get(ii);
                OIBReader.r.setVar("dirName", directory);
                OIBReader.r.exec("root = fs.getRoot()");
                OIBReader.r.exec("dir = root.getEntry(dirName)");
                OIBReader.r.setVar("entryName", name);
                OIBReader.r.exec("document = dir.getEntry(entryName)");
                OIBReader.r.exec("dis = new DocumentInputStream(document)");
                OIBReader.r.exec("numBytes = dis.available()");
                numBytes = (Integer)OIBReader.r.getVar("numBytes");
                b = new byte[numBytes + 4];
                OIBReader.r.setVar("data", b);
                OIBReader.r.exec("dis.read(data)");
                stream = new RandomAccessStream(b);
                ifds = TiffTools.getIFDs(stream);
                Arrays.fill(this.core.littleEndian, TiffTools.isLittleEndian(ifds[0]) == false);
            }
            catch (ReflectException e) {
                throw new FormatException(e);
            }
            try {
                this.initMetadata();
            }
            catch (FormatException exc) {
                if (OIBReader.debug) {
                    this.trace(exc);
                }
            }
            catch (IOException exc) {
                if (!OIBReader.debug) break block46;
                this.trace(exc);
            }
        }
    }

    private void initMetadata() throws FormatException, IOException {
        MetadataStore store = this.getMetadataStore();
        store.setImage((String)this.getMeta("DataName"), null, null, null);
        int i = 0;
        while (i < this.width.size()) {
            switch ((Integer)this.bpp.get(0) % 3) {
                case 2: {
                    this.core.pixelType[i] = 3;
                    break;
                }
                default: {
                    this.core.pixelType[i] = 1;
                }
            }
            String acquisition = "[Acquisition Parameters Common] - ";
            String stamp = (String)this.getMeta(String.valueOf(acquisition) + "ImageCaputreDate");
            if (stamp != null) {
                stamp = stamp.substring(1, stamp.length() - 1);
                SimpleDateFormat parse = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = parse.parse(stamp, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                stamp = fmt.format(date);
            }
            store.setImage(null, stamp, null, null);
            store.setPixels(new Integer(this.core.sizeX[i]), new Integer(this.core.sizeY[i]), new Integer(this.core.sizeZ[i]), new Integer(this.core.sizeC[i]), new Integer(this.core.sizeT[i]), new Integer(this.core.pixelType[i]), new Boolean(false), this.core.currentOrder[i], new Integer(i), null);
            String pre = "[Reference Image Parameter] - ";
            String x = (String)this.getMeta(String.valueOf(pre) + "WidthConvertValue");
            String y = (String)this.getMeta(String.valueOf(pre) + "HeightConvertValue");
            store.setDimensions(x == null ? null : new Float(x), y == null ? null : new Float(y), null, null, null, new Integer(i));
            int j = 0;
            while (j < this.core.sizeC[0]) {
                store.setLogicalChannel(j, null, null, null, null, null, null, new Integer(i));
                String prefix = "[Channel " + (j + 1) + " Parameters] - ";
                String gain = (String)this.getMeta(String.valueOf(prefix) + "AnalogPMTGain");
                String offset = (String)this.getMeta(String.valueOf(prefix) + "AnalogPMTOffset");
                String voltage = (String)this.getMeta(String.valueOf(prefix) + "AnalogPMTVoltage");
                store.setDetector(null, null, null, null, gain == null ? null : new Float(gain), voltage == null ? null : new Float(voltage), offset == null ? null : new Float(offset), null, new Integer(j));
                ++j;
            }
            String laserCount = (String)this.getMeta(String.valueOf(acquisition) + "Number of use Laser");
            int numLasers = laserCount == null ? 0 : Integer.parseInt(laserCount);
            int j2 = 0;
            while (j2 < numLasers) {
                String wave = (String)this.getMeta(String.valueOf(acquisition) + "LaserWavelength0" + (j2 + 1));
                if (wave == null) {
                    wave = "0";
                }
                store.setLaser(null, null, new Integer(wave), null, null, null, null, null, null, null, new Integer(j2));
                ++j2;
            }
            ++i;
        }
    }

    protected void parseDir(int depth, Object dir) throws IOException, FormatException, ReflectException {
        r.setVar("dir", dir);
        r.exec("dirName = dir.getName()");
        r.setVar("depth", depth);
        r.exec("iter = dir.getEntries()");
        Iterator iter = (Iterator)r.getVar("iter");
        while (iter.hasNext()) {
            r.setVar("entry", iter.next());
            r.exec("isInstance = entry.isDirectoryEntry()");
            r.exec("isDocument = entry.isDocumentEntry()");
            boolean isInstance = (Boolean)r.getVar("isInstance");
            boolean isDocument = (Boolean)r.getVar("isDocument");
            r.setVar("dir", dir);
            r.exec("dirName = dir.getName()");
            if (isInstance) {
                this.status("Parsing embedded folder (" + (depth + 1) + ")");
                this.parseDir(depth + 1, r.getVar("entry"));
                continue;
            }
            if (!isDocument) continue;
            this.status("Parsing embedded file (" + depth + ")");
            r.exec("entryName = entry.getName()");
            if (debug) {
                this.print(depth + 1, "Found document: " + r.getVar("entryName"));
            }
            r.exec("dis = new DocumentInputStream(entry)");
            r.exec("numBytes = dis.available()");
            int numbytes = (Integer)r.getVar("numBytes");
            byte[] data = new byte[numbytes + 4];
            r.setVar("data", data);
            r.exec("dis.read(data)");
            String entryName = (String)r.getVar("entryName");
            String dirName = (String)r.getVar("dirName");
            boolean isContents = entryName.toUpperCase().equals("CONTENTS");
            Object directory = r.getVar("dir");
            boolean pt = false;
            byte[] b = new byte[]{data[0], data[1], data[2], data[3]};
            if (data[0] != 66 || data[1] != 77) {
                if (TiffTools.checkHeader(b) != null) {
                    boolean isRGB;
                    RandomAccessStream ras = new RandomAccessStream(data);
                    Hashtable ifd = TiffTools.getIFDs(ras)[0];
                    ras.close();
                    int w = (int)TiffTools.getImageWidth(ifd);
                    int h = (int)TiffTools.getImageLength(ifd);
                    boolean bl = isRGB = TiffTools.getSamplesPerPixel(ifd) > 1;
                    if (!isRGB) {
                        int p = TiffTools.getPhotometricInterpretation(ifd);
                        isRGB = p == 3 || p == -32733 || p == 2;
                    }
                    boolean added = false;
                    int i = 0;
                    while (i < this.width.size()) {
                        if ((Integer)this.width.get(i) == w && (Integer)this.height.get(i) == h) {
                            int num = (Integer)this.nImages.get(i);
                            ((Hashtable)this.pixels.get(i)).put(new Integer(num), dirName);
                            ((Hashtable)this.names.get(i)).put(new Integer(num), entryName);
                            this.nImages.setElementAt(new Integer(++num), i);
                            added = true;
                        }
                        ++i;
                    }
                    if (!added) {
                        Hashtable<Integer, String> ht = new Hashtable<Integer, String>();
                        ht.put(new Integer(0), dirName);
                        this.pixels.add(ht);
                        ht = new Hashtable();
                        ht.put(new Integer(0), entryName);
                        this.names.add(ht);
                        this.nImages.add(new Integer(1));
                        this.width.add(new Integer(w));
                        this.height.add(new Integer(h));
                        this.rgb.add(new Boolean(isRGB));
                    }
                } else if (!entryName.equals("OibInfo.txt")) {
                    String ini = DataTools.stripString(new String(data));
                    StringTokenizer st = new StringTokenizer(ini, "\n");
                    String prefix = "";
                    while (st.hasMoreTokens()) {
                        String line = st.nextToken().trim();
                        if (!line.startsWith("[") && line.indexOf("=") > 0) {
                            String key = line.substring(0, line.indexOf("=")).trim();
                            String value = line.substring(line.indexOf("=") + 1).trim();
                            if (prefix.equals("[FileInformation] - ") && key.equals("Resolution")) {
                                int max = Integer.parseInt(value);
                                int bytes = (Integer)this.bpp.get(0);
                                while (Math.pow(2.0, bytes) < (double)max) {
                                    ++bytes;
                                }
                                bytes /= 8;
                                int i = 0;
                                while (i < this.bpp.size()) {
                                    this.bpp.setElementAt(new Integer(bytes), i);
                                    ++i;
                                }
                            }
                            if (prefix.indexOf("Red") != -1 || prefix.indexOf("Green") != -1 || prefix.indexOf("Blue") != -1) continue;
                            this.addMeta(String.valueOf(prefix) + key, value);
                            if (!prefix.startsWith("[Axis ") || !prefix.endsWith("Parameters Common] - ")) continue;
                            int ndx = Integer.parseInt(prefix.substring(6, prefix.indexOf("P")).trim());
                            if (key.equals("AxisCode")) {
                                this.labels[ndx] = value;
                                continue;
                            }
                            if (key.equals("MaxSize")) {
                                this.dims[ndx] = value;
                                continue;
                            }
                            if (key.equals("StartPosition")) {
                                this.starts[ndx] = value;
                                continue;
                            }
                            if (!key.equals("EndPosition")) continue;
                            this.stops[ndx] = value;
                            continue;
                        }
                        if (line.indexOf("[") == 2) {
                            line = line.substring(2, line.length());
                        }
                        prefix = String.valueOf(line) + " - ";
                    }
                    data = null;
                }
            }
            r.exec("dis.close()");
        }
    }

    protected void print(int depth, String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < depth) {
            sb.append("  ");
            ++i;
        }
        sb.append(s);
        this.debug(sb.toString());
    }
}

