/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class NRRDReader
extends FormatReader {
    private ImageReader helper;
    private String dataFile;
    private String encoding;
    private String min;
    private String max;
    private long offset;

    public NRRDReader() {
        super("NRRD", new String[]{"nrrd", "nhdr"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 4) {
            return false;
        }
        return new String(block).startsWith("NRRD");
    }

    public String[] getUsedFiles() {
        if (this.dataFile == null) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.dataFile};
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])) {
            throw new FormatException("Buffer too small.");
        }
        if (this.dataFile == null) {
            if (this.encoding.equals("raw")) {
                this.in.seek(this.offset + (long)(no * buf.length));
                this.in.read(buf);
                return buf;
            }
            throw new FormatException("Unsupported encoding: " + this.encoding);
        }
        return this.helper.openBytes(no, buf);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.core.pixelType[0] == 6) {
            byte[] b = this.openBytes(no);
            float[] f = new float[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0]];
            int i = 0;
            while (i < f.length) {
                f[i] = Float.intBitsToFloat(DataTools.bytesToInt(b, i * 4, 4, this.core.littleEndian[0]));
                ++i;
            }
            if (this.normalizeData) {
                f = DataTools.normalizeFloats(f);
            }
            return ImageTools.makeImage(f, this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0]);
        }
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
    }

    public void close() throws IOException {
        super.close();
        if (this.helper != null) {
            this.helper.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.helper = new ImageReader();
        boolean finished = false;
        int numDimensions = 0;
        this.core.sizeX[0] = 1;
        this.core.sizeY[0] = 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCZT";
        while (!finished) {
            String line = this.in.readLine().trim();
            if (!line.startsWith("#") && line.length() > 0 && !line.startsWith("NRRD")) {
                String key = line.substring(0, line.indexOf(":")).trim();
                String v = line.substring(line.indexOf(":") + 1).trim();
                this.addMeta(key, v);
                if (key.equals("type")) {
                    if (v.indexOf("char") != -1 || v.indexOf("8") != -1) {
                        this.core.pixelType[0] = 1;
                    } else if (v.indexOf("short") != -1 || v.indexOf("16") != -1) {
                        this.core.pixelType[0] = 3;
                    } else if (v.equals("int") || v.equals("signed int") || v.equals("int32") || v.equals("int32_t") || v.equals("uint") || v.equals("unsigned int") || v.equals("uint32") || v.equals("uint32_t")) {
                        this.core.pixelType[0] = 5;
                    } else if (v.equals("float")) {
                        this.core.pixelType[0] = 6;
                    } else {
                        if (!v.equals("double")) throw new FormatException("Unsupported data type: " + v);
                        this.core.pixelType[0] = 7;
                    }
                } else if (key.equals("dimension")) {
                    numDimensions = Integer.parseInt(v);
                } else if (key.equals("sizes")) {
                    StringTokenizer tokens = new StringTokenizer(v, " ");
                    i = 0;
                    while (i < numDimensions) {
                        String t = tokens.nextToken();
                        int size = Integer.parseInt(t);
                        if (numDimensions >= 3 && i == 0 && size > 1 && size <= 4) {
                            this.core.sizeC[0] = size;
                        } else if (i == 0 || this.core.sizeC[0] > 1 && i == 1) {
                            this.core.sizeX[0] = size;
                        } else if (i == 1 || this.core.sizeC[0] > 1 && i == 2) {
                            this.core.sizeY[0] = size;
                        } else if (i == 2 || this.core.sizeC[0] > 1 && i == 3) {
                            this.core.sizeZ[0] = size;
                        } else if (i == 3 || this.core.sizeC[0] > 1 && i == 4) {
                            this.core.sizeT[0] = size;
                        }
                        ++i;
                    }
                } else if (key.equals("data file") || key.equals("datafile")) {
                    this.dataFile = v;
                } else if (key.equals("encoding")) {
                    this.encoding = v;
                } else if (key.equals("endian")) {
                    this.core.littleEndian[0] = v.equals("little");
                } else if (key.equals("min")) {
                    this.min = v;
                } else if (key.equals("max")) {
                    this.max = v;
                }
            }
            if (line.length() == 0 && this.dataFile == null || line == null) {
                finished = true;
            }
            if (this.dataFile == null || this.in.length() - this.in.getFilePointer() >= 2L) continue;
            finished = true;
        }
        if (this.dataFile == null) {
            this.offset = this.in.getFilePointer();
        } else {
            this.helper.setId(this.dataFile);
        }
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.interleaved[0] = true;
        this.core.imageCount[0] = this.core.sizeZ[0] * this.core.sizeT[0];
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, this.core.sizeC[0] == 1 ? "monochrome" : "RGB", null, null);
            ++i;
        }
    }
}

