/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LogTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ND2Reader
extends FormatReader {
    private static final String NO_J2K_MSG = "The JAI Image I/O Tools are required to read ND2 files. Please obtain jai_imageio.jar from http://loci.wisc.edu/ome/formats.html";
    private static final String J2K_READER = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader";
    public static final SAXParserFactory SAX_FACTORY = SAXParserFactory.newInstance();
    private static boolean noJ2k = false;
    private static ReflectedUniverse r = ND2Reader.createReflectedUniverse();
    private long[] offsets;
    private boolean isJPEG;
    private Vector zs = new Vector();
    private Vector ts = new Vector();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse ru;
        block8: {
            ru = null;
            try {
                String j2kReaderSpi = "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderSpi";
                Class<?> j2kSpiClass = null;
                try {
                    j2kSpiClass = Class.forName(j2kReaderSpi);
                }
                catch (ClassNotFoundException exc) {
                    if (debug) {
                        LogTools.trace(exc);
                    }
                    noJ2k = true;
                }
                catch (NoClassDefFoundError err) {
                    if (debug) {
                        LogTools.trace(err);
                    }
                    noJ2k = true;
                }
                IIORegistry registry = IIORegistry.getDefaultInstance();
                if (j2kSpiClass != null) {
                    Iterator<?> providers = ServiceRegistry.lookupProviders(j2kSpiClass);
                    registry.registerServiceProviders(providers);
                }
                Object j2kSpi = registry.getServiceProviderByClass(j2kSpiClass);
                ru = new ReflectedUniverse();
                ru.exec("import jj2000.j2k.fileformat.reader.FileFormatReader");
                ru.exec("import jj2000.j2k.io.BEBufferedRandomAccessFile");
                ru.exec("import jj2000.j2k.util.ISRandomAccessIO");
                ru.exec("import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader");
                ru.setVar("j2kSpi", j2kSpi);
                ru.exec("j2kReader = new J2KImageReader(j2kSpi)");
            }
            catch (Throwable t) {
                noJ2k = true;
                if (!debug) break block8;
                LogTools.trace(t);
            }
        }
        return ru;
    }

    public ND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 8) {
            return false;
        }
        return block[4] == 106 && block[5] == 80 && block[6] == 32 && block[7] == 32;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        byte[] b = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])];
        return this.openBytes(no, b);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.core.imageCount[0]) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.core.sizeC[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0])) {
            throw new FormatException("Buffer too small.");
        }
        this.in.seek(this.offsets[no]);
        if (this.isJPEG) {
            byte[][] pixels = ImageTools.getPixelBytes(this.openImage(no), false);
            int i = 0;
            while (i < this.core.sizeC[0]) {
                System.arraycopy(pixels[i], 0, buf, i * pixels[i].length, pixels[i].length);
                ++i;
            }
            pixels = null;
        } else {
            this.in.read(buf);
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        if (!this.isJPEG) {
            return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], this.core.sizeC[0], this.core.interleaved[0], FormatTools.getBytesPerPixel(this.core.pixelType[0]), this.core.littleEndian[0]);
        }
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.in.seek(this.offsets[no]);
        long len = no < this.core.imageCount[0] - 1 ? this.offsets[no + 1] - this.offsets[no] : this.in.length() - this.offsets[no];
        byte[] b = new byte[(int)len];
        this.in.readFully(b);
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(bis);
        BufferedImage img = null;
        try {
            r.setVar("mciis", mciis);
            r.exec("j2kReader.setInput(mciis)");
            r.setVar("zero", 0);
            r.setVar("param", null);
            img = (BufferedImage)r.exec("j2kReader.read(zero, param)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        bis.close();
        mciis.close();
        b = null;
        return img;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ND2Reader.initFile(" + id + ")");
        }
        if (noJ2k) {
            throw new FormatException(NO_J2K_MSG);
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        if (this.in.read() == -38 && this.in.read() == -50) {
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            while (this.in.getFilePointer() < this.in.length()) {
                if (this.in.read() != -38 || this.in.read() != -50 || this.in.read() != -66 || this.in.read() != 10) continue;
                int len = this.in.readInt() + this.in.readInt();
                this.in.skipBytes(4);
                byte[] b = new byte[len];
                this.in.read(b);
                String s = new String(b);
                if (s.startsWith("ImageDataSeq")) {
                    int ndx = Integer.parseInt(s.substring(13, s.indexOf("!")));
                    if (this.core.sizeC[0] == 0) {
                        this.core.sizeC[0] = len / (this.core.sizeX[0] * this.core.sizeY[0] * FormatTools.getBytesPerPixel(this.core.pixelType[0]));
                    }
                    this.offsets[ndx] = this.in.getFilePointer() - (long)len + (long)s.indexOf("!") + 9L;
                } else if (s.startsWith("Image")) {
                    ND2Handler handler = new ND2Handler();
                    s = s.substring(s.indexOf("!") + 1);
                    int i = 0;
                    while (i < s.length()) {
                        char c = s.charAt(i);
                        if (Character.isISOControl(c) || !Character.isDefined(c)) {
                            s = s.replace(c, ' ');
                        }
                        ++i;
                    }
                    try {
                        SAXParser parser = SAX_FACTORY.newSAXParser();
                        parser.parse((InputStream)new ByteArrayInputStream(s.getBytes()), (DefaultHandler)handler);
                    }
                    catch (ParserConfigurationException exc) {
                        throw new FormatException(exc);
                    }
                    catch (SAXException exc) {
                        throw new FormatException(exc);
                    }
                }
                if (this.core.imageCount[0] > 0 && this.offsets == null) {
                    this.offsets = new long[this.core.imageCount[0]];
                }
                if (this.in.getFilePointer() >= this.in.length() - 1L) continue;
                if (this.in.read() != -38) {
                    this.in.skipBytes(15);
                    continue;
                }
                this.in.seek(this.in.getFilePointer() - 1L);
            }
            this.core.sizeC[0] = 1;
            this.core.currentOrder[0] = "XYCZT";
            this.core.rgb[0] = false;
            this.core.littleEndian[0] = true;
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        this.status("Calculating image offsets");
        Vector<Long> vs = new Vector<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            if (pos + (long)(length = this.in.readInt()) >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(new Long(this.in.getFilePointer()));
            }
            if (lastBoxFound) continue;
            this.in.seek(pos + (long)length);
        }
        this.offsets = new long[vs.size()];
        int i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = (Long)vs.get(i);
            ++i;
        }
        vs.clear();
        vs = null;
        this.status("Finding XML metadata");
        this.core.imageCount[0] = this.offsets.length;
        this.core.pixelType[0] = 1;
        this.in.seek(this.offsets[this.offsets.length - 1]);
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[2048];
        block12: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == this.offsets[this.offsets.length - 1]) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            int i2 = 0;
            while (i2 < read + 9) {
                if (buf[i2] == -1 && buf[i2 + 1] == -39) {
                    found = true;
                    off = this.in.getFilePointer() - (long)(read + 10) + (long)i2;
                    i2 = buf.length;
                    continue block12;
                }
                ++i2;
            }
        }
        buf = null;
        this.status("Parsing XML");
        if (off > 0L && off < this.in.length() - 5L) {
            this.in.seek(off + 5L);
            byte[] b = new byte[(int)(this.in.length() - off - 5L)];
            this.in.readFully(b);
            String xml = new String(b);
            xml = xml.substring(0, xml.lastIndexOf("</MetadataSeq>") + 14);
            xml = xml.replaceAll("<!--*-->", "");
            StringTokenizer st = new StringTokenizer(xml, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.indexOf("<") == -1) continue;
                String prefix = token.substring(1, token.indexOf(">")).trim();
                token = token.substring(token.indexOf(">") + 1);
                while (token.indexOf("<") != -1) {
                    int start = token.indexOf("<");
                    String s = token.substring(start + 1, token.indexOf(">", start));
                    token = token.substring(token.indexOf(">", start));
                    if (s.indexOf(" ") == -1) continue;
                    String pre = s.substring(0, s.indexOf(" ")).trim();
                    s = s.substring(s.indexOf(" ") + 1);
                    while (s.indexOf("=") != -1) {
                        int eq = s.indexOf("=");
                        String key = s.substring(0, eq).trim();
                        String value = s.substring(eq + 2, s.indexOf("\"", eq + 2)).trim();
                        if (key.indexOf("runtype") == -1) {
                            String effectiveKey;
                            if (prefix.startsWith("Metadata_V1.2")) {
                                prefix = "";
                            }
                            if (!this.metadata.containsKey(effectiveKey = String.valueOf(prefix) + " " + pre + " " + key)) {
                                long v;
                                this.addMeta(effectiveKey, value);
                                if (effectiveKey.equals("MetadataSeq _SEQUENCE_INDEX=\"0\" uiCompCount value")) {
                                    if (value != null) {
                                        this.core.sizeC[0] = Integer.parseInt(value);
                                    }
                                } else if (effectiveKey.endsWith("dTimeAbsolute value")) {
                                    long v2 = (long)Double.parseDouble(value);
                                    if (!this.ts.contains(new Long(v2))) {
                                        this.core.sizeT[0] = this.core.sizeT[0] + 1;
                                        this.ts.add(new Long(v2));
                                    }
                                } else if (effectiveKey.endsWith("dZPos value") && !this.zs.contains(new Long(v = (long)Double.parseDouble(value)))) {
                                    this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
                                    this.zs.add(new Long(v));
                                }
                            } else {
                                boolean parse;
                                String v = (String)this.getMeta(effectiveKey);
                                boolean bl = parse = v != null;
                                if (parse) {
                                    int i3 = 0;
                                    while (i3 < v.length()) {
                                        if (Character.isLetter(v.charAt(i3)) || Character.isWhitespace(v.charAt(i3))) {
                                            parse = false;
                                            break;
                                        }
                                        ++i3;
                                    }
                                }
                                if (parse) {
                                    this.addMeta(effectiveKey, value);
                                }
                            }
                        }
                        s = s.substring(s.indexOf("\"", eq + 2) + 1);
                    }
                }
            }
            b = null;
            xml = null;
            st = null;
        }
        this.status("Populating metadata");
        BufferedImage img = this.openImage(0);
        this.core.sizeX[0] = img.getWidth();
        this.core.sizeY[0] = img.getHeight();
        this.core.sizeC[0] = img.getRaster().getNumBands();
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        int numInvalid = 0;
        int i4 = 1;
        while (i4 < this.offsets.length) {
            if (this.offsets[i4] - this.offsets[i4 - 1] < (long)(this.core.sizeX[0] * this.core.sizeY[0] / 3)) {
                this.offsets[i4 - 1] = 0L;
                ++numInvalid;
            }
            ++i4;
        }
        long[] tempOffsets = new long[this.core.imageCount[0] - numInvalid];
        int pt = 0;
        int i5 = 0;
        while (i5 < this.offsets.length) {
            if (this.offsets[i5] != 0L) {
                tempOffsets[pt] = this.offsets[i5];
                ++pt;
            }
            ++i5;
        }
        this.offsets = tempOffsets;
        this.core.imageCount[0] = this.offsets.length;
        String sigBits = (String)this.getMeta("AdvancedImageAttributes SignificantBits value");
        int bits = 0;
        if (sigBits != null && sigBits.length() > 0) {
            bits = Integer.parseInt(sigBits.trim());
        }
        String pixX = (String)this.getMeta("CalibrationSeq _SEQUENCE_INDEX=\"0\" dCalibration value");
        String pixZ = (String)this.getMeta("CalibrationSeq _SEQUENCE_INDEX=\"0\" dAspect value");
        float pixSizeX = 0.0f;
        float pixSizeZ = 0.0f;
        if (pixX != null && pixX.length() > 0) {
            pixSizeX = Float.parseFloat(pixX.trim());
        }
        if (pixZ != null && pixZ.length() > 0) {
            pixSizeZ = Float.parseFloat(pixZ.trim());
        }
        if (this.core.sizeC[0] == 2) {
            this.core.sizeC[0] = 1;
        }
        this.core.currentOrder[0] = "XY";
        long deltaT = this.ts.size() > 1 ? (Long)this.ts.get(1) - (Long)this.ts.get(0) : 1L;
        long deltaZ = this.zs.size() > 1 ? (Long)this.zs.get(1) - (Long)this.zs.get(0) : 1L;
        this.core.currentOrder[0] = deltaT < deltaZ || deltaZ == 0L ? String.valueOf(this.core.currentOrder[0]) + "CTZ" : String.valueOf(this.core.currentOrder[0]) + "CZT";
        int effectiveC = (this.core.sizeC[0] - 1) / 3 + 1;
        if (this.core.imageCount[0] < this.core.sizeZ[0] * this.core.sizeT[0]) {
            if (this.core.sizeT[0] == this.core.imageCount[0]) {
                this.core.sizeT[0] = this.core.sizeT[0] / (this.core.sizeZ[0] * effectiveC);
                while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                    this.core.sizeT[0] = this.core.sizeT[0] + 1;
                }
            } else if (this.core.sizeZ[0] == this.core.imageCount[0]) {
                this.core.sizeZ[0] = this.core.sizeZ[0] / (this.core.sizeT[0] * effectiveC);
                while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                    this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
                }
            }
            if (this.core.imageCount[0] < this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                if (this.core.sizeZ[0] < this.core.sizeT[0]) {
                    this.core.sizeZ[0] = this.core.sizeZ[0] - 1;
                    while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                        this.core.sizeT[0] = this.core.sizeT[0] + 1;
                    }
                    while (this.core.imageCount[0] < this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                        this.core.sizeT[0] = this.core.sizeT[0] - 1;
                    }
                } else {
                    this.core.sizeT[0] = this.core.sizeT[0] - 1;
                    while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                        this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
                    }
                    if (this.core.imageCount[0] < this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                        this.core.sizeZ[0] = this.core.sizeZ[0] - 1;
                    }
                }
                while (this.core.imageCount[0] > this.core.sizeZ[0] * this.core.sizeT[0] * effectiveC) {
                    this.core.imageCount[0] = this.core.imageCount[0] - 1;
                }
            }
        }
        if (bits == 0) {
            this.core.pixelType[0] = 1;
        } else {
            int bpp = bits;
            while (bpp % 8 != 0) {
                ++bpp;
            }
            switch (bpp) {
                case 8: {
                    this.core.pixelType[0] = 1;
                    break;
                }
                case 16: {
                    this.core.pixelType[0] = 3;
                    break;
                }
                case 32: {
                    this.core.pixelType[0] = 5;
                    break;
                }
                default: {
                    throw new FormatException("Unsupported bits per pixel: " + bpp);
                }
            }
        }
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if (this.core.imageCount[0] < this.core.sizeZ[0] * this.core.sizeT[0] * this.core.sizeC[0]) {
            this.core.sizeT[0] = this.core.imageCount[0];
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeZ[0] * this.core.sizeT[0] * this.core.sizeC[0] < this.core.imageCount[0]) {
            this.core.sizeT[0] = 1;
            this.core.sizeZ[0] = this.core.imageCount[0];
        }
        this.core.rgb[0] = this.core.sizeC[0] == 3;
        this.core.interleaved[0] = true;
        this.core.littleEndian[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.isLittleEndian()), this.core.currentOrder[0], null, null);
        store.setDimensions(new Float(pixSizeX), new Float(pixSizeX), new Float(pixSizeZ), null, null, null);
        int i6 = 0;
        while (i6 < this.core.sizeC[0]) {
            store.setLogicalChannel(i6, null, null, null, null, null, null, null);
            ++i6;
        }
        String prefix = "MetadataSeq _SEQUENCE_INDEX=\"0\" ";
        String gain = (String)this.getMeta(String.valueOf(prefix) + "dGain value");
        String voltage = (String)this.getMeta(String.valueOf(prefix) + "dLampVoltage value");
        String mag = (String)this.getMeta(String.valueOf(prefix) + "dObjectiveMag value");
        String na = (String)this.getMeta(String.valueOf(prefix) + "dObjectiveNA value");
        store.setDetector(null, null, null, null, gain == null ? null : new Float(gain), voltage == null ? null : new Float(voltage), null, null, null);
        store.setObjective(null, null, null, na == null ? null : new Float(na), mag == null ? null : new Float(mag), null, null);
    }

    class ND2Handler
    extends DefaultHandler {
        ND2Handler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("uiWidth")) {
                ((ND2Reader)ND2Reader.this).core.sizeX[0] = Integer.parseInt(attributes.getValue("value"));
            } else if (qName.equals("uiWidthBytes")) {
                int bytes = Integer.parseInt(attributes.getValue("value")) / ((ND2Reader)ND2Reader.this).core.sizeX[0];
                switch (bytes) {
                    case 2: {
                        ((ND2Reader)ND2Reader.this).core.pixelType[0] = 3;
                        break;
                    }
                    case 4: {
                        ((ND2Reader)ND2Reader.this).core.pixelType[0] = 5;
                        break;
                    }
                    default: {
                        ((ND2Reader)ND2Reader.this).core.pixelType[0] = 1;
                        break;
                    }
                }
            } else if (qName.equals("uiHeight")) {
                ((ND2Reader)ND2Reader.this).core.sizeY[0] = Integer.parseInt(attributes.getValue("value"));
            } else if (qName.equals("uiCount")) {
                int n = Integer.parseInt(attributes.getValue("value"));
                if (((ND2Reader)ND2Reader.this).core.imageCount[0] == 0) {
                    ((ND2Reader)ND2Reader.this).core.imageCount[0] = n;
                    ((ND2Reader)ND2Reader.this).core.sizeZ[0] = n;
                }
                ((ND2Reader)ND2Reader.this).core.sizeT[0] = 1;
            } else {
                ND2Reader.this.addMeta(qName, attributes.getValue("value"));
            }
        }
    }
}

