/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.in.TiffReader;

public class MicromanagerReader
extends FormatReader {
    private static final String METADATA = "metadata.txt";
    private TiffReader tiffReader;
    private Vector tiffs;

    public MicromanagerReader() {
        super("Micro-Manager", new String[]{"tif", "tiff", "txt"});
    }

    public boolean isThisType(byte[] b) {
        return this.tiffReader.isThisType(b);
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiffReader.setId((String)this.tiffs.get(no));
        return this.tiffReader.openBytes(0);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiffReader.setId((String)this.tiffs.get(no));
        return this.tiffReader.openBytes(0, buf);
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiffReader.setId((String)this.tiffs.get(no));
        return this.tiffReader.openImage(0);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.tiffReader != null) {
                this.tiffReader.close(fileOnly);
            }
        } else {
            this.close();
        }
    }

    public boolean isThisType(String name, boolean open) {
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        String[] list = parent.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].endsWith(METADATA)) {
                return super.isThisType(name, open);
            }
            ++i;
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        if (this.tiffReader != null) {
            this.tiffReader.close();
        }
        this.tiffReader = null;
        this.tiffs = null;
    }

    public void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.tiffReader = new TiffReader();
        this.status("Reading metadata file");
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        this.in = new RandomAccessStream(new Location(parent, METADATA).getAbsolutePath());
        byte[] meta = new byte[(int)this.in.length()];
        this.in.read(meta);
        String s = new String(meta);
        meta = null;
        this.status("Finding image file names");
        this.tiffs = new Vector();
        int pos = 0;
        while ((pos = s.indexOf("FileName", pos)) != -1 && (long)pos < this.in.length()) {
            String name = s.substring(s.indexOf(":", pos), s.indexOf(",", pos));
            this.tiffs.add(0, name.substring(3, name.length() - 1));
            ++pos;
        }
        this.status("Populating metadata");
        int start = s.indexOf("Summary");
        int end = s.indexOf("}", start);
        if (start != -1 && end > start) {
            s = s.substring(s.indexOf("\n", start), end).trim();
        }
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            String value;
            boolean closed;
            String token = st.nextToken();
            boolean open = token.indexOf("[") != -1;
            boolean bl = closed = token.indexOf("]") != -1;
            if (!open && (open || closed)) continue;
            int quote = token.indexOf("\"") + 1;
            String key = token.substring(quote, token.indexOf("\"", quote));
            if (!open && !closed) {
                value = token.substring(token.indexOf(":") + 1).trim();
                value = value.substring(0, value.length() - 1);
                this.addMeta(key, value);
                if (!key.equals("Channels")) continue;
                this.core.sizeC[0] = Integer.parseInt(value);
                continue;
            }
            if (!closed) {
                StringBuffer valueBuffer = new StringBuffer();
                while (!closed) {
                    token = st.nextToken();
                    closed = token.indexOf("]") != -1;
                    valueBuffer.append(token);
                }
                String value2 = valueBuffer.toString();
                value2.replaceAll("\n", "").trim();
                value2 = value2.substring(0, value2.length() - 1);
                this.addMeta(key, value2);
                if (!key.equals("Channels")) continue;
                this.core.sizeC[0] = Integer.parseInt(value2);
                continue;
            }
            value = token.substring(token.indexOf("[") + 1, token.indexOf("]")).trim();
            value = value.substring(0, value.length() - 1);
            this.addMeta(key, value);
            if (!key.equals("Channels")) continue;
            this.core.sizeC[0] = Integer.parseInt(value);
        }
        this.tiffReader.setId((String)this.tiffs.get(0));
        String z = (String)this.metadata.get("Slices");
        this.core.sizeZ[0] = z != null ? Integer.parseInt(z) : 1;
        String t = (String)this.metadata.get("Frames");
        this.core.sizeT[0] = t != null ? Integer.parseInt(t) : this.tiffs.size() / this.core.sizeC[0];
        this.core.sizeX[0] = this.tiffReader.getSizeX();
        this.core.sizeY[0] = this.tiffReader.getSizeY();
        this.core.currentOrder[0] = "XYZCT";
        this.core.pixelType[0] = this.tiffReader.getPixelType();
        this.core.rgb[0] = this.tiffReader.isRGB();
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = this.tiffReader.isLittleEndian();
        this.core.imageCount[0] = this.tiffs.size();
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        int i = 0;
        while (i < this.core.sizeC[0]) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null);
            ++i;
        }
    }
}

