/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.Location;
import loci.formats.RandomAccessStream;
import loci.formats.TiffIFDEntry;
import loci.formats.TiffRational;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class MetamorphReader
extends BaseTiffReader {
    private static final int METAMORPH_ID = 33628;
    private static final int UIC1TAG = 33628;
    private static final int UIC2TAG = 33629;
    private static final int UIC3TAG = 33630;
    private static final int UIC4TAG = 33631;
    private String imageName;
    private String imageCreationDate;
    private long[] emWavelength;
    private int mmPlanes;
    private String[] stks;

    public MetamorphReader() {
        super("Metamorph STK", new String[]{"stk", "nd"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3) {
            return false;
        }
        if (block[0] != 73) {
            return false;
        }
        if (block[1] != 73) {
            return false;
        }
        if (block[2] != 42) {
            return false;
        }
        if (block.length < 8) {
            return true;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation + 1 > block.length) {
            return true;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return true;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag == 33628) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMetadataComplete() {
        return true;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        if (id.toLowerCase().endsWith(".nd")) {
            return 0;
        }
        Location l = new Location(id).getAbsoluteFile();
        String[] files = l.getParentFile().list();
        int i = 0;
        while (i < files.length) {
            String s = files[i].toLowerCase();
            if (s.endsWith(".nd") && id.startsWith(files[i].substring(0, s.lastIndexOf(".")))) {
                return 1;
            }
            ++i;
        }
        return 2;
    }

    public String[] getUsedFiles() {
        return this.stks == null ? super.getUsedFiles() : this.stks;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null || this.stks.length == 1) {
            return super.openBytes(no, buf);
        }
        int[] coords = FormatTools.getZCTCoords(this, no);
        int ndx = coords[1] * this.getEffectiveSizeC() + coords[2] * this.core.sizeT[0];
        RandomAccessStream tmp = new RandomAccessStream(this.stks[ndx]);
        Hashtable[] fds = TiffTools.getIFDs(tmp);
        TiffTools.getSamples(fds[coords[0]], tmp, buf);
        tmp.close();
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.stks == null || this.stks.length == 1) {
            return super.openImage(no);
        }
        int[] coords = FormatTools.getZCTCoords(this, no);
        int ndx = no / this.core.sizeZ[0];
        this.initFile(this.stks[ndx]);
        return TiffTools.getImage(this.ifds[coords[0]], this.in);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (id.toLowerCase().endsWith(".nd")) {
            if (this.currentId != null) {
                String[] s = this.getUsedFiles();
                int i = 0;
                while (i < s.length) {
                    if (id.equals(s[i])) {
                        return;
                    }
                    ++i;
                }
            }
            this.close();
            this.currentId = id;
            this.metadata = new Hashtable();
            this.core = new CoreMetadata(1);
            Arrays.fill(this.core.orderCertain, true);
            this.getMetadataStore().createRoot();
            String stkFile = id.substring(0, id.lastIndexOf("."));
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            String[] dirList = parent.list();
            int i = 0;
            while (i < dirList.length) {
                String s = dirList[i].toLowerCase();
                if (s.endsWith(".stk") && dirList[i].indexOf(String.valueOf(stkFile.substring(stkFile.lastIndexOf(File.separator) + 1)) + "_w") != -1) {
                    stkFile = new Location(parent.getPath(), dirList[i]).getAbsolutePath();
                    break;
                }
                ++i;
            }
            super.initFile(stkFile);
        } else {
            super.initFile(id);
        }
        Location ndfile = null;
        if (!id.toLowerCase().endsWith(".nd")) {
            Location abs = new Location(this.currentId).getAbsoluteFile();
            String absPath = abs.getPath().substring(abs.getPath().lastIndexOf(File.separator));
            int idx = id.indexOf("_");
            if (idx == -1) {
                idx = id.lastIndexOf(".");
            }
            if (!(ndfile = new Location(abs.getParent(), String.valueOf(id.substring(0, idx)) + ".nd")).exists()) {
                ndfile = new Location(ndfile.getAbsolutePath().replaceAll(".nd", ".ND"));
            }
        } else {
            ndfile = new Location(id);
        }
        if (ndfile.exists() && (this.fileGroupOption(id) == 0 || this.isGroupFiles())) {
            RandomAccessStream ndStream = new RandomAccessStream(ndfile.getAbsolutePath());
            String line = ndStream.readLine().trim();
            while (!line.equals("\"EndFile\"")) {
                String key = line.substring(1, line.indexOf(",") - 1).trim();
                String value = line.substring(line.indexOf(",") + 1).trim();
                this.addMeta(key, value);
                line = ndStream.readLine().trim();
            }
            String z = (String)this.getMeta("NZSteps");
            String c = (String)this.getMeta("NWavelengths");
            String t = (String)this.getMeta("NTimePoints");
            int zc = this.core.sizeZ[0];
            int cc = this.core.sizeC[0];
            int tc = this.core.sizeT[0];
            if (z != null) {
                zc = Integer.parseInt(z);
            }
            if (c != null) {
                cc = Integer.parseInt(c);
            }
            if (t != null) {
                tc = Integer.parseInt(t);
            }
            int numFiles = cc * tc;
            this.stks = new String[numFiles];
            String prefix = ndfile.getPath();
            prefix = prefix.substring(prefix.lastIndexOf(File.separator) + 1, prefix.lastIndexOf("."));
            int pt = 0;
            int i = 0;
            while (i < tc) {
                int j = 0;
                while (j < cc) {
                    String chName = (String)this.getMeta("WaveName" + (j + 1));
                    chName = chName.substring(1, chName.length() - 1);
                    this.stks[pt] = String.valueOf(prefix) + "_w" + (j + 1) + chName + "_t" + (i + 1) + ".STK";
                    ++pt;
                    ++j;
                }
                ++i;
            }
            ndfile = ndfile.getAbsoluteFile();
            i = 0;
            while (i < numFiles) {
                Location l = new Location(ndfile.getParent(), this.stks[i]);
                if (!l.exists()) {
                    this.stks = null;
                    return;
                }
                this.stks[i] = l.getAbsolutePath();
                ++i;
            }
            this.core.sizeZ[0] = zc;
            this.core.sizeC[0] = cc;
            this.core.sizeT[0] = tc;
            this.core.imageCount[0] = zc * tc * cc;
            this.core.currentOrder[0] = "XYZCT";
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        block25: {
            block24: {
                super.initStandardMetadata();
                try {
                    int planes;
                    TiffIFDEntry uic1tagEntry = TiffTools.getFirstIFDEntry(this.in, 33628);
                    TiffIFDEntry uic2tagEntry = TiffTools.getFirstIFDEntry(this.in, 33629);
                    TiffIFDEntry uic3tagEntry = TiffTools.getFirstIFDEntry(this.in, 33630);
                    TiffIFDEntry uic4tagEntry = TiffTools.getFirstIFDEntry(this.in, 33631);
                    this.mmPlanes = planes = uic4tagEntry.getValueCount();
                    this.parseUIC2Tags(uic2tagEntry.getValueOffset());
                    this.parseUIC4Tags(uic4tagEntry.getValueOffset());
                    this.parseUIC1Tags(uic1tagEntry.getValueOffset(), uic1tagEntry.getValueCount());
                    this.in.seek(uic4tagEntry.getValueOffset());
                    long[] uic2 = TiffTools.getIFDLongArray(this.ifds[0], 33629, true);
                    this.core.imageCount[0] = uic2.length;
                    long[] uic3 = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    int i = 0;
                    while (i < uic3.length) {
                        this.in.seek(uic3[i]);
                        this.put("Wavelength [" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readLong() / this.in.readLong());
                        ++i;
                    }
                    Hashtable[] tempIFDs = new Hashtable[this.core.imageCount[0]];
                    long[] oldOffsets = TiffTools.getIFDLongArray(this.ifds[0], 273, true);
                    long[] stripByteCounts = TiffTools.getIFDLongArray(this.ifds[0], 279, true);
                    int stripsPerImage = oldOffsets.length;
                    int check = TiffTools.getIFDIntValue(this.ifds[0], 262);
                    if (check == 3) {
                        TiffTools.putIFDValue(this.ifds[0], 262, 1);
                    }
                    this.emWavelength = TiffTools.getIFDLongArray(this.ifds[0], 33630, true);
                    int pointer = 0;
                    int i2 = 0;
                    while (i2 < this.core.imageCount[0]) {
                        Hashtable<Integer, Object> temp = new Hashtable<Integer, Object>();
                        temp.put(new Integer(0), this.ifds[0].get(new Integer(0)));
                        temp.put(new Integer(256), this.ifds[0].get(new Integer(256)));
                        temp.put(new Integer(257), this.ifds[0].get(new Integer(257)));
                        temp.put(new Integer(258), this.ifds[0].get(new Integer(258)));
                        temp.put(new Integer(259), this.ifds[0].get(new Integer(259)));
                        temp.put(new Integer(262), this.ifds[0].get(new Integer(262)));
                        temp.put(new Integer(279), this.ifds[0].get(new Integer(279)));
                        temp.put(new Integer(278), this.ifds[0].get(new Integer(278)));
                        temp.put(new Integer(282), this.ifds[0].get(new Integer(282)));
                        temp.put(new Integer(283), this.ifds[0].get(new Integer(283)));
                        temp.put(new Integer(296), this.ifds[0].get(new Integer(296)));
                        temp.put(new Integer(317), this.ifds[0].get(new Integer(317)));
                        long planeOffset = (long)i2 * (oldOffsets[stripsPerImage - 1] + stripByteCounts[stripsPerImage - 1] - oldOffsets[0]);
                        long[] newOffsets = new long[oldOffsets.length];
                        newOffsets[0] = planeOffset + oldOffsets[0];
                        int j = 1;
                        while (j < newOffsets.length) {
                            newOffsets[j] = newOffsets[j - 1] + stripByteCounts[0];
                            ++j;
                        }
                        temp.put(new Integer(273), newOffsets);
                        tempIFDs[pointer] = temp;
                        ++pointer;
                        ++i2;
                    }
                    this.ifds = tempIFDs;
                }
                catch (NullPointerException exc) {
                    this.trace(exc);
                }
                catch (IOException exc) {
                    this.trace(exc);
                }
                catch (FormatException exc) {
                    this.trace(exc);
                }
                try {
                    super.initStandardMetadata();
                }
                catch (FormatException exc) {
                    if (debug) {
                        this.trace(exc);
                    }
                }
                catch (IOException exc) {
                    if (!debug) break block24;
                    this.trace(exc);
                }
            }
            String descr = (String)this.getMeta("Comment");
            if (descr != null) {
                StringTokenizer st = new StringTokenizer(descr, "\n");
                StringBuffer sb = new StringBuffer();
                boolean first = true;
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    int colon = line.indexOf(": ");
                    if (colon < 0) {
                        if (line.trim().length() > 0) {
                            sb.append(line);
                            if (!line.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        first = false;
                        continue;
                    }
                    if (first) {
                        int dot = line.lastIndexOf(".", colon);
                        if (dot >= 0) {
                            String s = line.substring(0, dot + 1);
                            sb.append(s);
                            if (!s.endsWith(".")) {
                                sb.append(".");
                            }
                            sb.append("  ");
                        }
                        line = line.substring(dot + 1);
                        colon -= dot + 1;
                        first = false;
                    }
                    String key = line.substring(0, colon);
                    String value = line.substring(colon + 2);
                    this.put(key, value);
                }
                descr = sb.toString().trim();
                if (descr.equals("")) {
                    this.metadata.remove("Comment");
                } else {
                    this.put("Comment", descr);
                }
            }
            try {
                this.core.sizeZ[0] = TiffTools.getIFDLongArray(this.ifds[0], 33629, true).length;
                this.core.sizeT[0] = this.getImageCount() / this.core.sizeZ[0];
            }
            catch (FormatException exc) {
                if (!debug) break block25;
                this.trace(exc);
            }
        }
    }

    protected String getImageName() {
        if (this.imageName == null) {
            return super.getImageName();
        }
        return this.imageName;
    }

    protected String getImageCreationDate() {
        if (this.imageCreationDate == null) {
            return super.getImageCreationDate();
        }
        return this.imageCreationDate;
    }

    Integer getEmWave(int i) {
        if (this.emWavelength[i] == 0L) {
            return null;
        }
        return new Integer((int)this.emWavelength[i]);
    }

    void parseUIC2Tags(long uic2offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic2offset);
        int i = 0;
        while (i < this.mmPlanes) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int num = this.in.readInt();
            int den = this.in.readInt();
            double zDistance = (double)num / (double)den;
            this.put("zDistance[" + iAsString + "]", zDistance);
            int cDate = this.in.readInt();
            this.put("creationDate[" + iAsString + "]", MetamorphReader.decodeDate(cDate));
            int cTime = this.in.readInt();
            this.put("creationTime[" + iAsString + "]", MetamorphReader.decodeTime(cTime));
            this.in.skip(8L);
            ++i;
        }
        this.in.seek(saveLoc);
    }

    private void parseUIC4Tags(long uic4offset) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic4offset);
        boolean end = false;
        while (!end) {
            short id = this.in.readShort();
            switch (id) {
                case 0: {
                    end = true;
                    break;
                }
                case 28: {
                    this.readStagePositions();
                    break;
                }
                case 29: {
                    this.readCameraChipOffsets();
                    break;
                }
                case 37: {
                    this.readStageLabels();
                    break;
                }
                case 40: {
                    this.readAbsoluteZ();
                    break;
                }
                case 41: {
                    this.readAbsoluteZValid();
                    break;
                }
            }
        }
        this.in.seek(saveLoc);
    }

    void readStagePositions() throws IOException {
        int i = 0;
        while (i < this.mmPlanes) {
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double xPosition = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double yPosition = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            this.put("stageX[" + iAsString + "]", xPosition);
            this.put("stageY[" + iAsString + "]", yPosition);
            ++i;
        }
    }

    void readCameraChipOffsets() throws IOException {
        int i = 0;
        while (i < this.mmPlanes) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int nx = this.in.readInt();
            int dx = this.in.readInt();
            int ny = this.in.readInt();
            int dy = this.in.readInt();
            double cameraXChipOffset = dx == 0 ? Double.NaN : (double)nx / (double)dx;
            double cameraYChipOffset = dy == 0 ? Double.NaN : (double)ny / (double)dy;
            this.put("cameraXChipOffset[" + iAsString + "]", cameraXChipOffset);
            this.put("cameraYChipOffset[" + iAsString + "]", cameraYChipOffset);
            ++i;
        }
    }

    void readStageLabels() throws IOException {
        int i = 0;
        while (i < this.mmPlanes) {
            String iAsString = MetamorphReader.intFormatMax(i, this.mmPlanes);
            int strlen = this.in.readInt();
            byte[] curlabel = new byte[strlen];
            this.in.read(curlabel);
            this.put("stageLabel[" + iAsString + "]", new String(curlabel));
            ++i;
        }
    }

    void readAbsoluteZ() throws IOException {
        int i = 0;
        while (i < this.mmPlanes) {
            int nz = this.in.readInt();
            int dz = this.in.readInt();
            double absoluteZ = dz == 0 ? Double.NaN : (double)nz / (double)dz;
            this.put("absoluteZ[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", absoluteZ);
            ++i;
        }
    }

    void readAbsoluteZValid() throws IOException {
        int i = 0;
        while (i < this.mmPlanes) {
            this.put("absoluteZValid[" + MetamorphReader.intFormatMax(i, this.mmPlanes) + "]", this.in.readInt());
            ++i;
        }
    }

    private void parseUIC1Tags(long uic1offset, int uic1count) throws IOException {
        long saveLoc = this.in.getFilePointer();
        this.in.seek(uic1offset);
        int i = 0;
        while (i < uic1count) {
            int currentID = this.in.readInt();
            int valOrOffset = this.in.readInt();
            switch (currentID) {
                case 1: {
                    this.put("MinScale", valOrOffset);
                    break;
                }
                case 2: {
                    this.put("MaxScale", valOrOffset);
                    break;
                }
                case 3: {
                    int calib = valOrOffset;
                    String calibration = calib != 0 ? "on" : "off";
                    this.put("Spatial Calibration", calibration);
                    break;
                }
                case 4: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("XCalibration", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 5: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("YCalibration", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 6: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    this.put("CalibrationUnits", new String(toread));
                    this.in.seek(lastOffset);
                    break;
                }
                case 7: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    String name = new String(toread);
                    this.put("Name", name);
                    this.imageName = name;
                    this.in.seek(lastOffset);
                    break;
                }
                case 8: {
                    int thresh = valOrOffset;
                    String threshState = "off";
                    if (thresh == 1) {
                        threshState = "inside";
                    } else if (thresh == 2) {
                        threshState = "outside";
                    }
                    this.put("ThreshState", threshState);
                    break;
                }
                case 9: {
                    this.put("ThreshStateRed", valOrOffset);
                    break;
                }
                case 11: {
                    this.put("ThreshStateGreen", valOrOffset);
                    break;
                }
                case 12: {
                    this.put("ThreshStateBlue", valOrOffset);
                    break;
                }
                case 13: {
                    this.put("ThreshStateLo", valOrOffset);
                    break;
                }
                case 14: {
                    this.put("ThreshStateHi", valOrOffset);
                    break;
                }
                case 15: {
                    int zoom = valOrOffset;
                    this.put("Zoom", zoom);
                    break;
                }
                case 16: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.put("DateTime", String.valueOf(thedate) + " " + thetime);
                    this.imageCreationDate = String.valueOf(thedate) + " " + thetime;
                    this.in.seek(lastOffset);
                    break;
                }
                case 17: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    String thedate = MetamorphReader.decodeDate(this.in.readInt());
                    String thetime = MetamorphReader.decodeTime(this.in.readInt());
                    this.put("LastSavedTime", String.valueOf(thedate) + " " + thetime);
                    this.in.seek(lastOffset);
                    break;
                }
                case 18: {
                    this.put("currentBuffer", valOrOffset);
                    break;
                }
                case 19: {
                    this.put("grayFit", valOrOffset);
                    break;
                }
                case 20: {
                    this.put("grayPointCount", valOrOffset);
                    break;
                }
                case 21: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayX", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 22: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("gray", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 23: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayMin", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 24: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("grayMax", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 25: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    byte[] toread = new byte[num];
                    this.in.read(toread);
                    this.put("grayUnitName", new String(toread));
                    this.in.seek(lastOffset);
                    break;
                }
                case 26: {
                    String standLUT;
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int standardLUT = this.in.readInt();
                    this.in.seek(lastOffset);
                    switch (standardLUT) {
                        case 0: {
                            standLUT = "monochrome";
                            break;
                        }
                        case 1: {
                            standLUT = "pseudocolor";
                            break;
                        }
                        case 2: {
                            standLUT = "Red";
                            break;
                        }
                        case 3: {
                            standLUT = "Green";
                            break;
                        }
                        case 4: {
                            standLUT = "Blue";
                            break;
                        }
                        case 5: {
                            standLUT = "user-defined";
                            break;
                        }
                        default: {
                            standLUT = "monochrome";
                        }
                    }
                    this.put("StandardLUT", standLUT);
                    break;
                }
                case 27: {
                    this.put("Wavelength", valOrOffset);
                    break;
                }
                case 30: {
                    this.put("OverlayMask", valOrOffset);
                    break;
                }
                case 31: {
                    this.put("OverlayCompress", valOrOffset);
                    break;
                }
                case 32: {
                    this.put("Overlay", valOrOffset);
                    break;
                }
                case 33: {
                    this.put("SpecialOverlayMask", valOrOffset);
                    break;
                }
                case 34: {
                    this.put("SpecialOverlayCompress", this.in.readInt());
                    break;
                }
                case 35: {
                    this.put("SpecialOverlay", valOrOffset);
                    break;
                }
                case 36: {
                    this.put("ImageProperty", valOrOffset);
                    break;
                }
                case 38: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("AutoScaleLoInfo", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 39: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int num = this.in.readInt();
                    int denom = this.in.readInt();
                    this.put("AutoScaleHiInfo", new TiffRational(num, denom));
                    this.in.seek(lastOffset);
                    break;
                }
                case 42: {
                    this.put("Gamma", valOrOffset);
                    break;
                }
                case 43: {
                    this.put("GammaRed", valOrOffset);
                    break;
                }
                case 44: {
                    this.put("GammaGreen", valOrOffset);
                    break;
                }
                case 45: {
                    this.put("GammaBlue", valOrOffset);
                    break;
                }
                case 46: {
                    long lastOffset = this.in.getFilePointer();
                    this.in.seek(valOrOffset);
                    int xBin = this.in.readInt();
                    int yBin = this.in.readInt();
                    this.put("CameraBin", new String("(" + xBin + "," + yBin + ")"));
                    this.in.seek(lastOffset);
                    break;
                }
            }
            ++i;
        }
        this.in.seek(saveLoc);
    }

    public static String decodeDate(int julian) {
        long a;
        long z = julian + 1;
        if (z < 2299161L) {
            a = z;
        } else {
            long alpha = (long)(((double)z - 1867216.25) / 36524.25);
            a = z + 1L + alpha - alpha / 4L;
        }
        long b = a > 1721423L ? a + 1524L : a + 1158L;
        long c = (long)(((double)b - 122.1) / 365.25);
        long d = (long)(365.25 * (double)c);
        long e = (long)((double)(b - d) / 30.6001);
        short day = (short)(b - d - (long)(30.6001 * (double)e));
        short month = (short)((double)e < 13.5 ? e - 1L : e - 13L);
        short year = (short)((double)month > 2.5 ? c - 4716L : c - 4715L);
        return String.valueOf(day) + "/" + month + "/" + year;
    }

    public static String decodeTime(int millis) {
        int ms = millis % 1000;
        millis -= ms;
        int seconds = (millis /= 1000) % 60;
        millis -= seconds;
        int minutes = (millis /= 60) % 60;
        millis -= minutes;
        int hours = millis /= 60;
        return String.valueOf(MetamorphReader.intFormat(hours, 2)) + ":" + MetamorphReader.intFormat(minutes, 2) + ":" + MetamorphReader.intFormat(seconds, 2) + "." + MetamorphReader.intFormat(ms, 3);
    }

    public static String intFormat(int myint, int digits) {
        String formatstring = "0";
        while (formatstring.length() < digits) {
            formatstring = String.valueOf(formatstring) + "0";
        }
        DecimalFormat df = new DecimalFormat(formatstring);
        return df.format(myint);
    }

    public static String intFormatMax(int myint, int maxint) {
        return MetamorphReader.intFormat(myint, new Integer(maxint).toString().length());
    }
}

