/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class MRCReader
extends FormatReader {
    private int bpp = 0;
    private int extHeaderSize = 0;
    private boolean isFloat = false;

    public MRCReader() {
        super("Medical Research Council (MRC)", "mrc");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        byte[] buf = new byte[this.core.sizeX[0] * this.core.sizeY[0] * this.bpp];
        return this.openBytes(no, buf);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        if (buf.length < this.core.sizeX[0] * this.core.sizeY[0] * this.bpp) {
            throw new FormatException("Buffer too small.");
        }
        this.in.seek(1024 + this.extHeaderSize + no * this.core.sizeX[0] * this.core.sizeY[0] * this.bpp);
        this.in.read(buf);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        return ImageTools.makeImage(this.openBytes(no), this.core.sizeX[0], this.core.sizeY[0], 1, true, this.bpp, this.core.littleEndian[0]);
    }

    public void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MRCReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Reading header");
        this.in.seek(213L);
        this.core.littleEndian[0] = this.in.read() == 68;
        this.in.seek(0L);
        this.in.order(this.core.littleEndian[0]);
        this.core.sizeX[0] = this.in.readInt();
        this.core.sizeY[0] = this.in.readInt();
        this.core.sizeZ[0] = this.in.readInt();
        this.core.sizeC[0] = 1;
        int mode = this.in.readInt();
        switch (mode) {
            case 0: {
                this.bpp = 1;
                this.core.pixelType[0] = 1;
                break;
            }
            case 1: 
            case 6: {
                this.bpp = 2;
                this.core.pixelType[0] = 3;
                break;
            }
            case 2: {
                this.bpp = 4;
                this.isFloat = true;
                this.core.pixelType[0] = 6;
                break;
            }
            case 3: {
                this.bpp = 4;
                this.core.pixelType[0] = 5;
                break;
            }
            case 4: {
                this.bpp = 8;
                this.isFloat = true;
                this.core.pixelType[0] = 7;
                break;
            }
            case 16: {
                this.bpp = 2;
                this.core.sizeC[0] = 3;
                this.core.pixelType[0] = 3;
            }
        }
        int thumbX = this.in.readInt();
        int thumbY = this.in.readInt();
        int thumbZ = this.in.readInt();
        int mx = this.in.readInt();
        int my = this.in.readInt();
        int mz = this.in.readInt();
        float xlen = this.in.readFloat();
        float ylen = this.in.readFloat();
        float zlen = this.in.readFloat();
        this.addMeta("Pixel size (X)", "" + xlen / (float)mx);
        this.addMeta("Pixel size (Y)", "" + ylen / (float)my);
        this.addMeta("Pixel size (Z)", "" + zlen / (float)mz);
        this.addMeta("Alpha angle", "" + this.in.readFloat());
        this.addMeta("Beta angle", "" + this.in.readFloat());
        this.addMeta("Gamma angle", "" + this.in.readFloat());
        this.in.skipBytes(12);
        this.addMeta("Minimum pixel value", "" + this.in.readFloat());
        this.addMeta("Maximum pixel value", "" + this.in.readFloat());
        this.addMeta("Mean pixel value", "" + this.in.readFloat());
        this.in.skipBytes(4);
        this.extHeaderSize = this.in.readInt();
        this.in.skipBytes(64);
        short idtype = this.in.readShort();
        String[] types = new String[]{"mono", "tilt", "tilts", "lina", "lins"};
        String type = idtype >= 0 && idtype < types.length ? types[idtype] : "unknown";
        this.addMeta("Series type", type);
        this.addMeta("Lens", "" + this.in.readShort());
        this.addMeta("ND1", "" + this.in.readShort());
        this.addMeta("ND2", "" + this.in.readShort());
        this.addMeta("VD1", "" + this.in.readShort());
        this.addMeta("VD2", "" + this.in.readShort());
        float[] angles = new float[6];
        int i = 0;
        while (i < angles.length) {
            angles[i] = this.in.readFloat();
            this.addMeta("Angle " + (i + 1), "" + angles[i]);
            ++i;
        }
        this.in.skipBytes(24);
        int nUsefulLabels = this.in.readInt();
        this.addMeta("Number of useful labels", "" + nUsefulLabels);
        int i2 = 0;
        while (i2 < 10) {
            this.addMeta("Label " + (i2 + 1), this.in.readString(80));
            ++i2;
        }
        this.in.skipBytes(this.extHeaderSize);
        this.status("Populating metadata");
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYZTC";
        this.core.imageCount[0] = this.core.sizeZ[0];
        this.core.rgb[0] = false;
        this.core.interleaved[0] = true;
        MetadataStore store = this.getMetadataStore();
        store.setPixels(new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), new Integer(this.core.sizeZ[0]), new Integer(this.core.sizeC[0]), new Integer(this.core.sizeT[0]), new Integer(this.core.pixelType[0]), new Boolean(!this.core.littleEndian[0]), this.core.currentOrder[0], null, null);
        store.setDimensions(new Float(xlen / (float)mx), new Float(ylen / (float)my), new Float(zlen / (float)mz), null, null, null);
        int i3 = 0;
        while (i3 < this.core.sizeC[0]) {
            store.setLogicalChannel(i3, null, null, null, null, null, null, null);
            ++i3;
        }
    }
}

