/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Hashtable;
import java.util.List;
import loci.formats.FormatException;
import loci.formats.LogTools;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;

public final class MDBParser {
    private static final String NO_MDB_MSG = "The Java port of MDB tools is required to read MDB files. Please obtain mdbtools-java.jar from http://loci.wisc.edu/ome/formats.html";
    private static boolean noMDB = false;
    private static ReflectedUniverse r = MDBParser.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        r = null;
        try {
            r = new ReflectedUniverse();
            r.exec("import java.util.Vector");
            r.exec("import mdbtools.jdbc2.File");
            r.exec("import mdbtools.libmdb.Catalog");
            r.exec("import mdbtools.libmdb.Constants");
            r.exec("import mdbtools.libmdb.Data");
            r.exec("import mdbtools.libmdb.Holder");
            r.exec("import mdbtools.libmdb.MdbCatalogEntry");
            r.exec("import mdbtools.libmdb.MdbColumn");
            r.exec("import mdbtools.libmdb.MdbHandle");
            r.exec("import mdbtools.libmdb.MdbTableDef");
            r.exec("import mdbtools.libmdb.Table");
            r.exec("import mdbtools.libmdb.file");
            r.exec("import mdbtools.libmdb.mem");
        }
        catch (Throwable t) {
            noMDB = true;
        }
        return r;
    }

    private MDBParser() {
    }

    public static void parseDatabase(String filename, Hashtable h) throws FormatException {
        if (noMDB) {
            throw new FormatException(NO_MDB_MSG);
        }
        try {
            r.setVar("twoFiveSix", 256);
            r.exec("boundValues = new Vector()");
            r.setVar("delimiter", ",");
            r.exec("mem.mdb_init()");
            r.setVar("filename", filename);
            r.exec("dbfile = new File(filename)");
            r.exec("mdb = file.mdb_open(dbfile)");
            r.exec("Catalog.mdb_read_catalog(mdb, Constants.MDB_TABLE)");
            int num = (Integer)r.getVar("mdb.num_catalog");
            int i = 0;
            while (i < num) {
                r.setVar("c", (List)r.getVar("mdb.catalog"));
                r.setVar("i", i);
                r.exec("entry = c.get(i)");
                r.setVar("objType", (Integer)r.getVar("entry.object_type"));
                r.setVar("objName", (String)r.getVar("entry.object_name"));
                int objType = (Integer)r.getVar("objType");
                int tableType = (Integer)r.getVar("Constants.MDB_TABLE");
                boolean isTable = objType == tableType;
                String objName = (String)r.getVar("objName");
                if (isTable && !objName.startsWith("MSys")) {
                    r.exec("table = Table.mdb_read_table(entry)");
                    try {
                        r.exec("Table.mdb_read_columns(table)");
                    }
                    catch (ReflectException e) {
                        break;
                    }
                    r.exec("Data.mdb_rewind_table(table)");
                    r.setVar("numCols", (Integer)r.getVar("table.num_cols"));
                    int numCols = (Integer)r.getVar("numCols");
                    int j = 0;
                    while (j < numCols) {
                        r.setVar("j", j);
                        r.exec("blah = new Holder()");
                        r.setVar("l", j + 1);
                        r.exec("Data.mdb_bind_column(table, l, blah)");
                        r.exec("boundValues.add(blah)");
                        ++j;
                    }
                    StringBuffer[] sbs = new StringBuffer[numCols];
                    int j2 = 0;
                    while (j2 < sbs.length) {
                        sbs[j2] = new StringBuffer();
                        ++j2;
                    }
                    boolean moreRows = true;
                    try {
                        r.exec("moreRows = Data.mdb_fetch_row(table)");
                        moreRows = (Boolean)r.getVar("moreRows");
                    }
                    catch (ReflectException e) {
                        moreRows = false;
                    }
                    while (moreRows) {
                        int j3 = 0;
                        while (j3 < numCols) {
                            r.setVar("j", j3);
                            r.setVar("columns", (List)r.getVar("table.columns"));
                            r.exec("col = columns.get(j)");
                            if (sbs[j3].length() > 0) {
                                sbs[j3].append(",");
                            }
                            r.exec("blah = boundValues.get(j)");
                            sbs[j3].append((String)r.getVar("blah.s"));
                            ++j3;
                        }
                        try {
                            r.exec("moreRows = Data.mdb_fetch_row(table)");
                            moreRows = (Boolean)r.getVar("moreRows");
                        }
                        catch (ReflectException e) {
                            moreRows = false;
                        }
                    }
                    int j4 = 0;
                    while (j4 < sbs.length) {
                        r.setVar("j", j4);
                        r.setVar("columns", (List)r.getVar("table.columns"));
                        r.exec("col = columns.get(j)");
                        h.put(String.valueOf(objName) + " - " + (String)r.getVar("col.name"), sbs[j4].toString());
                        ++j4;
                    }
                }
                ++i;
            }
        }
        catch (ReflectException exc) {
            LogTools.trace(exc);
        }
    }
}

