/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.CoreMetadata;
import loci.formats.DataTools;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.TiffTools;
import loci.formats.in.TiffReader;

public class LeicaReader
extends FormatReader {
    private static final int LEICA_MAGIC_TAG = 33923;
    protected Hashtable[] ifds;
    protected Hashtable[] headerIFDs;
    protected TiffReader[][] tiff;
    protected Vector[] files;
    private int numSeries;
    private int[][] validBits;
    private int[] channelIndices;
    private String leiFilename;
    private int bpp;
    private Vector seriesNames;

    public LeicaReader() {
        super("Leica", new String[]{"lei", "tif", "tiff"});
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 4) {
            return false;
        }
        if (block.length < 8) {
            return block[0] == 73 && block[1] == 73 && block[2] == 73 && block[3] == 73 || block[0] == 77 && block[1] == 77 && block[2] == 77 && block[3] == 77;
        }
        int ifdlocation = DataTools.bytesToInt(block, 4, true);
        if (ifdlocation < 0 || ifdlocation + 1 > block.length) {
            return false;
        }
        int ifdnumber = DataTools.bytesToInt(block, ifdlocation, 2, true);
        int i = 0;
        while (i < ifdnumber) {
            if (ifdlocation + 3 + i * 12 > block.length) {
                return false;
            }
            int ifdtag = DataTools.bytesToInt(block, ifdlocation + 2 + i * 12, 2, true);
            if (ifdtag == 33923) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isMetadataComplete() {
        return true;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return id.toLowerCase().endsWith(".lei") ? 0 : 1;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        int ndx = no % this.channelIndices.length;
        this.tiff[this.series][no].setId((String)this.files[this.series].get(no));
        byte[] b = this.tiff[this.series][no].openBytes(0);
        int c = b.length / (this.core.sizeX[this.series] * this.core.sizeY[this.series] * FormatTools.getBytesPerPixel(this.core.pixelType[this.series]));
        b = ImageTools.splitChannels(b, c, FormatTools.getBytesPerPixel(this.core.pixelType[this.series]), false, this.isInterleaved())[this.channelIndices[ndx]];
        this.tiff[this.series][no].close();
        return b;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiff[this.series][no].setId((String)this.files[this.series].get(no));
        this.tiff[this.series][no].openBytes(0, buf);
        this.tiff[this.series][no].close();
        int ndx = no % this.channelIndices.length;
        int c = buf.length / (this.core.sizeX[this.series] * this.core.sizeY[this.series] * FormatTools.getBytesPerPixel(this.core.pixelType[this.series]));
        buf = ImageTools.splitChannels(buf, c, FormatTools.getBytesPerPixel(this.core.pixelType[this.series]), false, this.isInterleaved())[this.channelIndices[ndx]];
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (no < 0 || no >= this.getImageCount()) {
            throw new FormatException("Invalid image number: " + no);
        }
        this.tiff[this.series][no].setId((String)this.files[this.series].get(no));
        BufferedImage b = this.tiff[this.series][no].openImage(0);
        int ndx = no % this.channelIndices.length;
        b = ImageTools.splitChannels(b)[this.channelIndices[ndx]];
        this.tiff[this.series][no].close();
        return b;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> v = new Vector<String>();
        v.add(this.leiFilename);
        int i = 0;
        while (i < this.files.length) {
            int j = 0;
            while (j < this.files[i].size()) {
                v.add((String)this.files[i].get(j));
                ++j;
            }
            ++i;
        }
        return v.toArray(new String[0]);
    }

    public void close(boolean fileOnly) throws IOException {
        if (fileOnly) {
            if (this.in != null) {
                this.in.close();
            }
            if (this.tiff != null) {
                int i = 0;
                while (i < this.tiff.length) {
                    if (this.tiff[i] != null) {
                        int j = 0;
                        while (j < this.tiff[i].length) {
                            if (this.tiff[i][j] != null) {
                                this.tiff[i][j].close(fileOnly);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isThisType(String name, boolean open) {
        String lname = name.toLowerCase();
        if (lname.endsWith(".lei")) {
            return true;
        }
        if (!lname.endsWith(".tif") && !lname.endsWith(".tiff")) {
            return false;
        }
        if (!open) {
            return true;
        }
        if (!this.isGroupFiles()) {
            return false;
        }
        Location file = new Location(name);
        if (!file.exists()) {
            return false;
        }
        long len = file.length();
        if (len < 4L) {
            return false;
        }
        try {
            int ndx;
            RandomAccessStream ras = new RandomAccessStream(name);
            Hashtable ifd = TiffTools.getFirstIFD(ras);
            ras.close();
            if (ifd == null) {
                return false;
            }
            String descr = (String)ifd.get(new Integer(270));
            if (descr == null) {
                return false;
            }
            int n = ndx = descr.indexOf("Series Name");
            if (ndx == -1) {
                return false;
            }
            String dir = new Location(name).getAbsoluteFile().getParent();
            String[] listing = new Location(dir).list();
            int i = 0;
            while (true) {
                if (i >= listing.length) {
                    return false;
                }
                if (listing[i].toLowerCase().endsWith(".lei")) {
                    return true;
                }
                ++i;
            }
        }
        catch (IOException exc) {
            if (!debug) return false;
            this.trace(exc);
            return false;
        }
        catch (ClassCastException exc) {
            if (!debug) return false;
            this.trace(exc);
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.leiFilename = null;
        this.files = null;
        if (this.tiff != null) {
            int i = 0;
            while (i < this.tiff.length) {
                if (this.tiff[i] != null) {
                    int j = 0;
                    while (j < this.tiff[i].length) {
                        if (this.tiff[i][j] != null) {
                            this.tiff[i][j].close();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LeicaReader.initFile(" + id + ")");
        }
        String idLow = id.toLowerCase();
        this.close();
        if (idLow.endsWith("tif") || idLow.endsWith("tiff")) {
            String lei;
            if (this.ifds == null) {
                super.initFile(id);
            }
            this.in = new RandomAccessStream(id);
            if (this.in.readShort() == 18761) {
                this.in.order(true);
            }
            this.in.seek(0L);
            this.status("Finding companion file name");
            this.ifds = TiffTools.getIFDs(this.in);
            if (this.ifds == null) {
                throw new FormatException("No IFDs found");
            }
            String descr = (String)TiffTools.getIFDValue(this.ifds[0], 270);
            int ndx = descr.indexOf("Series Name");
            if (ndx == -1) {
                throw new FormatException("LEI file not found");
            }
            int newLineNdx = (lei = descr.substring(descr.indexOf("=", ndx) + 1)).indexOf("\n");
            lei = lei.substring(0, newLineNdx == -1 ? lei.length() : newLineNdx);
            lei = lei.trim();
            String dir = id.substring(0, id.lastIndexOf("/") + 1);
            lei = String.valueOf(dir) + lei;
            while (descr.indexOf("[") != -1) {
                String first = descr.substring(0, descr.indexOf("["));
                String last = descr.substring(descr.indexOf("\n", descr.indexOf("[")));
                descr = String.valueOf(first) + last;
            }
            int eqIndex = descr.indexOf("=");
            while (eqIndex != -1) {
                String key = descr.substring(0, eqIndex);
                newLineNdx = descr.indexOf("\n", eqIndex);
                if (newLineNdx == -1) {
                    newLineNdx = descr.length();
                }
                String value = descr.substring(eqIndex + 1, newLineNdx);
                this.addMeta(key.trim(), value.trim());
                newLineNdx = descr.indexOf("\n", eqIndex);
                if (newLineNdx == -1) {
                    newLineNdx = descr.length();
                }
                descr = descr.substring(newLineNdx);
                eqIndex = descr.indexOf("=");
            }
            Location l = new Location(lei);
            if (l.getAbsoluteFile().exists()) {
                this.initFile(lei);
            } else {
                l = l.getAbsoluteFile().getParentFile();
                String[] list = l.list();
                int i = 0;
                while (i < list.length) {
                    if (list[i].toLowerCase().endsWith("lei")) {
                        this.initFile(list[i]);
                        return;
                    }
                    ++i;
                }
            }
        } else {
            super.initFile(id);
            this.leiFilename = id;
            this.in = new RandomAccessStream(id);
            this.seriesNames = new Vector();
            byte[] fourBytes = new byte[4];
            this.in.read(fourBytes);
            this.core.littleEndian[0] = fourBytes[0] == 73 && fourBytes[1] == 73 && fourBytes[2] == 73 && fourBytes[3] == 73;
            this.in.order(this.core.littleEndian[0]);
            this.status("Reading metadata blocks");
            this.in.skipBytes(8);
            int addr = this.in.readInt();
            Vector v = new Vector();
            while (addr != 0) {
                ++this.numSeries;
                Hashtable<Integer, byte[]> ifd = new Hashtable<Integer, byte[]>();
                v.add(ifd);
                this.in.seek(addr + 4);
                int tag = this.in.readInt();
                while (tag != 0) {
                    int offset = this.in.readInt();
                    long pos = this.in.getFilePointer();
                    this.in.seek(offset + 12);
                    int size = this.in.readInt();
                    byte[] data = new byte[size];
                    this.in.read(data);
                    ifd.put(new Integer(tag), data);
                    this.in.seek(pos);
                    tag = this.in.readInt();
                }
                addr = this.in.readInt();
            }
            if (v.size() < this.numSeries) {
                this.numSeries = v.size();
            }
            this.core = new CoreMetadata(this.numSeries);
            this.headerIFDs = new Hashtable[this.numSeries];
            this.files = new Vector[this.numSeries];
            v.copyInto(this.headerIFDs);
            int nameLength = 0;
            int maxPlanes = 0;
            this.status("Parsing metadata blocks");
            this.core.littleEndian[0] = !this.core.littleEndian[0];
            int i = 0;
            while (i < this.headerIFDs.length) {
                if (this.headerIFDs[i].get(new Integer(10)) != null) {
                    byte[] temp = (byte[])this.headerIFDs[i].get(new Integer(10));
                    nameLength = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                }
                Vector<String> f = new Vector<String>();
                byte[] tempData = (byte[])this.headerIFDs[i].get(new Integer(15));
                int tempImages = DataTools.bytesToInt(tempData, 0, 4, this.core.littleEndian[0]);
                String dirPrefix = new Location(id).getAbsoluteFile().getParent();
                dirPrefix = dirPrefix == null ? "" : String.valueOf(dirPrefix) + File.separator;
                Object[] listing = new Location(dirPrefix).list();
                Vector<String> list = new Vector<String>();
                int k = 0;
                while (k < listing.length) {
                    if (listing[k].toLowerCase().endsWith(".tif") || listing[k].toLowerCase().endsWith(".tiff")) {
                        list.add(listing[k]);
                    }
                    ++k;
                }
                listing = list.toArray(new String[0]);
                boolean tiffsExist = true;
                String prefix = "";
                int j = 0;
                while (j < tempImages) {
                    String s;
                    prefix = DataTools.stripString(new String(tempData, 20 + 2 * (j * nameLength), 2 * nameLength));
                    f.add(String.valueOf(dirPrefix) + prefix);
                    Location test = new Location((String)f.get(f.size() - 1));
                    if (tiffsExist) {
                        tiffsExist = test.exists();
                    }
                    int firstUnderscore = prefix.indexOf("_") + 1;
                    int secondUnderscore = prefix.indexOf("_", firstUnderscore);
                    if (firstUnderscore != -1 && secondUnderscore != -1 && !this.seriesNames.contains(s = prefix.substring(firstUnderscore, secondUnderscore))) {
                        this.seriesNames.add(s);
                    }
                    ++j;
                }
                if (!tiffsExist) {
                    this.status("Handling renamed TIFF files");
                    Hashtable<Object, String> leiMapping = new Hashtable<Object, String>();
                    int numLeis = 0;
                    int j2 = 0;
                    while (j2 < listing.length) {
                        RandomAccessStream ras = new RandomAccessStream(new Location(dirPrefix, listing[j2]).getAbsolutePath());
                        Hashtable ifd = TiffTools.getFirstIFD(ras);
                        ras.close();
                        String descr = (String)ifd.get(new Integer(270));
                        int ndx = descr.indexOf("=", descr.indexOf("Series Name"));
                        String leiFile = descr.substring(ndx + 1, descr.indexOf("\n", ndx));
                        leiFile = leiFile.trim();
                        if (!leiMapping.contains(leiFile)) {
                            ++numLeis;
                        }
                        leiMapping.put(listing[j2], leiFile);
                        ++j2;
                    }
                    f.clear();
                    String[] keys = leiMapping.keySet().toArray(new String[0]);
                    int j3 = 0;
                    while (j3 < keys.length) {
                        String lei = (String)leiMapping.get(keys[j3]);
                        if (DataTools.samePrefix(lei, prefix)) {
                            f.add(keys[j3]);
                        }
                        ++j3;
                    }
                    String[] usedFiles = null;
                    int j4 = 0;
                    while (j4 < f.size()) {
                        if (usedFiles != null) {
                            int k2 = 0;
                            while (k2 < usedFiles.length) {
                                if (usedFiles[k2].equals((String)f.get(j4)) || this.usedFile((String)f.get(j4))) {
                                    k2 = 0;
                                    ++j4;
                                }
                                ++k2;
                            }
                        }
                        if (j4 >= f.size()) break;
                        FilePattern fp = new FilePattern(new Location((String)f.get(j4)));
                        if (fp != null) {
                            usedFiles = fp.getFiles();
                        }
                        if (usedFiles != null && usedFiles.length == tempImages) {
                            this.files[i] = new Vector();
                            int k3 = 0;
                            while (k3 < usedFiles.length) {
                                this.files[i].add(new Location(usedFiles[k3]).getAbsolutePath());
                                ++k3;
                            }
                            break;
                        }
                        ++j4;
                    }
                    if (this.files[i] == null || this.files[i].size() == 0) {
                        this.files[i] = new Vector();
                        Hashtable<String, Object> h = new Hashtable<String, Object>();
                        int j5 = 0;
                        while (j5 < listing.length) {
                            RandomAccessStream ras = new RandomAccessStream(new Location(dirPrefix, (String)listing[j5]).getAbsolutePath());
                            Hashtable fd = TiffTools.getFirstIFD(ras);
                            String stamp = (String)TiffTools.getIFDValue(fd, 306);
                            if (h.size() == tempImages) {
                                Object[] ks = h.keySet().toArray(new String[0]);
                                Arrays.sort(ks);
                                int k4 = 0;
                                while (k4 < ks.length) {
                                    this.files[i].add(new Location(dirPrefix, (String)h.get(ks[k4])).getAbsolutePath());
                                    ++k4;
                                }
                                h.clear();
                                break;
                            }
                            if (!h.contains(stamp)) {
                                h.put(stamp, listing[j5]);
                            } else {
                                h.clear();
                                h.put(stamp, listing[j5]);
                            }
                            ras.close();
                            ++j5;
                        }
                        if (h.size() == tempImages) {
                            Object[] ks = h.keySet().toArray(new String[0]);
                            Arrays.sort(ks);
                            int k5 = 0;
                            while (k5 < ks.length) {
                                this.files[i].add(new Location(dirPrefix, (String)h.get(ks[k5])).getAbsolutePath());
                                ++k5;
                            }
                        }
                    }
                    if (this.files[i] == null || this.files[i].size() == 0) {
                        if (debug) {
                            this.debug("File ordering is not obvious.");
                        }
                        this.files[i] = new Vector();
                        Arrays.sort(listing);
                        int ndx = 0;
                        int j6 = 0;
                        while (j6 < i) {
                            ndx += this.files[j6].size();
                            ++j6;
                        }
                        j6 = ndx;
                        while (j6 < ndx + tempImages) {
                            this.files[i].add(new Location(dirPrefix, (String)listing[j6]).getAbsolutePath());
                            ++j6;
                        }
                    }
                } else {
                    this.files[i] = f;
                }
                this.core.imageCount[i] = this.files[i].size();
                if (this.core.imageCount[i] > maxPlanes) {
                    maxPlanes = this.core.imageCount[i];
                }
                ++i;
            }
            this.tiff = new TiffReader[this.numSeries][maxPlanes];
            i = 0;
            while (i < this.tiff.length) {
                int j = 0;
                while (j < this.tiff[i].length) {
                    this.tiff[i][j] = new TiffReader();
                    if (j > 0) {
                        this.tiff[i][j].setMetadataCollected(false);
                    }
                    ++j;
                }
                ++i;
            }
            this.status("Populating metadata");
            this.initMetadata();
        }
    }

    protected void initMetadata() throws FormatException, IOException {
        Integer v;
        if (this.headerIFDs == null) {
            this.headerIFDs = this.ifds;
        }
        int i = 0;
        while (i < this.headerIFDs.length) {
            int v2;
            int j;
            byte[] temp = (byte[])this.headerIFDs[i].get(new Integer(10));
            if (temp != null) {
                this.addMeta("Version", new Integer(DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0])));
                this.addMeta("Number of Series", new Integer(DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0])));
                this.addMeta("Length of filename", new Integer(DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0])));
                Integer fileExtLen = new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0]));
                this.addMeta("Length of file extension", fileExtLen);
                this.addMeta("Image file extension", DataTools.stripString(new String(temp, 16, (int)fileExtLen)));
            }
            if ((temp = (byte[])this.headerIFDs[i].get(new Integer(15))) != null) {
                this.core.sizeZ[i] = DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0]);
                this.core.sizeX[i] = DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0]);
                this.core.sizeY[i] = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                this.addMeta("Number of images", new Integer(this.core.sizeZ[i]));
                this.addMeta("Image width", new Integer(this.core.sizeX[i]));
                this.addMeta("Image height", new Integer(this.core.sizeY[i]));
                this.addMeta("Bits per Sample", new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0])));
                this.addMeta("Samples per pixel", new Integer(DataTools.bytesToInt(temp, 16, 4, this.core.littleEndian[0])));
            }
            if ((temp = (byte[])this.headerIFDs[i].get(new Integer(20))) != null) {
                int pt = 0;
                this.addMeta("Voxel Version", new Integer(DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0])));
                int voxelType = DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0]);
                String type = "";
                switch (voxelType) {
                    case 0: {
                        type = "undefined";
                        break;
                    }
                    case 10: {
                        type = "gray normal";
                        break;
                    }
                    case 20: {
                        type = "RGB";
                    }
                }
                this.addMeta("VoxelType", type);
                this.bpp = DataTools.bytesToInt(temp, 8, 4, this.core.littleEndian[0]);
                this.addMeta("Bytes per pixel", new Integer(this.bpp));
                this.addMeta("Real world resolution", new Integer(DataTools.bytesToInt(temp, 12, 4, this.core.littleEndian[0])));
                int length = DataTools.bytesToInt(temp, 16, 4, this.core.littleEndian[0]);
                this.addMeta("Maximum voxel intensity", DataTools.stripString(new String(temp, 20, length)));
                pt = 20 + length;
                this.addMeta("Minimum voxel intensity", DataTools.stripString(new String(temp, pt += 4, length)));
                pt += length;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4 + length + 4;
                length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                j = 0;
                while (j < length) {
                    int dimId = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    String dimType = "";
                    switch (dimId) {
                        case 0: {
                            dimType = "undefined";
                            break;
                        }
                        case 120: {
                            dimType = "x";
                            break;
                        }
                        case 121: {
                            dimType = "y";
                            break;
                        }
                        case 122: {
                            dimType = "z";
                            break;
                        }
                        case 116: {
                            dimType = "t";
                            break;
                        }
                        case 6815843: {
                            dimType = "channel";
                            break;
                        }
                        case 6357100: {
                            dimType = "wave length";
                            break;
                        }
                        case 7602290: {
                            dimType = "rotation";
                            break;
                        }
                        case 0x770078: {
                            dimType = "x-wide for the motorized xy-stage";
                            break;
                        }
                        case 0x770079: {
                            dimType = "y-wide for the motorized xy-stage";
                            break;
                        }
                        case 0x77007A: {
                            dimType = "z-wide for the z-stage-drive";
                            break;
                        }
                        case 4259957: {
                            dimType = "user1 - unspecified";
                            break;
                        }
                        case 4325493: {
                            dimType = "user2 - unspecified";
                            break;
                        }
                        case 4391029: {
                            dimType = "user3 - unspecified";
                            break;
                        }
                        case 6357095: {
                            dimType = "graylevel";
                            break;
                        }
                        case 6422631: {
                            dimType = "graylevel1";
                            break;
                        }
                        case 6488167: {
                            dimType = "graylevel2";
                            break;
                        }
                        case 6553703: {
                            dimType = "graylevel3";
                            break;
                        }
                        case 7864398: {
                            dimType = "logical x";
                            break;
                        }
                        case 7929934: {
                            dimType = "logical y";
                            break;
                        }
                        case 7995470: {
                            dimType = "logical z";
                            break;
                        }
                        case 7602254: {
                            dimType = "logical t";
                            break;
                        }
                        case 7077966: {
                            dimType = "logical lambda";
                            break;
                        }
                        case 7471182: {
                            dimType = "logical rotation";
                            break;
                        }
                        case 5767246: {
                            dimType = "logical x-wide";
                            break;
                        }
                        case 5832782: {
                            dimType = "logical y-wide";
                            break;
                        }
                        case 5898318: {
                            dimType = "logical z-wide";
                        }
                    }
                    this.addMeta("Dim" + j + " type", dimType);
                    this.addMeta("Dim" + j + " size", new Integer(DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0])));
                    int dist = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " distance between sub-dimensions", new Integer(dist));
                    int len = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " physical length", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " physical origin", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " name", DataTools.stripString(new String(temp, pt += 4, len)));
                    pt += len;
                    len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dim" + j + " description", DataTools.stripString(new String(temp, pt += 4, len)));
                    ++j;
                }
            }
            temp = (byte[])this.headerIFDs[i].get(new Integer(30));
            temp = (byte[])this.headerIFDs[i].get(new Integer(40));
            if (temp != null) {
                int nDims = DataTools.bytesToInt(temp, 0, 4, this.core.littleEndian[0]);
                this.addMeta("Number of time-stamped dimensions", new Integer(nDims));
                this.addMeta("Time-stamped dimension", new Integer(DataTools.bytesToInt(temp, 4, 4, this.core.littleEndian[0])));
                int pt = 8;
                int j2 = 0;
                while (j2 < nDims) {
                    v2 = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " ID", new Integer(v2));
                    v2 = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " size", new Integer(v2));
                    v2 = DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0]);
                    this.addMeta("Dimension " + j2 + " distance between dimensions", new Integer(v2));
                    pt += 4;
                    ++j2;
                }
                int numStamps = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4;
                this.addMeta("Number of time-stamps", new Integer(numStamps));
                int j3 = 0;
                while (j3 < numStamps) {
                    this.addMeta("Timestamp " + j3, DataTools.stripString(new String(temp, pt, 64)));
                    pt += 64;
                    ++j3;
                }
                int numTMs = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                pt += 4;
                this.addMeta("Number of time-markers", new Integer(numTMs));
                j = 0;
                while (j < numTMs) {
                    int numDims = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    pt += 4;
                    int k = 0;
                    while (k < numDims) {
                        int v3 = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                        this.addMeta("Time-marker " + j + " Dimension " + k + " coordinate", new Integer(v3));
                        pt += 4;
                        ++k;
                    }
                    this.addMeta("Time-marker " + j, DataTools.stripString(new String(temp, pt, 64)));
                    pt += 64;
                    ++j;
                }
            }
            temp = (byte[])this.headerIFDs[i].get(new Integer(50));
            temp = (byte[])this.headerIFDs[i].get(new Integer(60));
            if (temp != null) {
                int pt = 8;
                int len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Image Description", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Main file extension", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Single image format identifier", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
                pt += 2 * len;
                len = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Single image extension", DataTools.stripString(new String(temp, pt += 4, 2 * len)));
            }
            if ((temp = (byte[])this.headerIFDs[i].get(new Integer(70))) != null) {
                int pt = 0;
                int nChannels = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                this.addMeta("Number of LUT channels", new Integer(nChannels));
                this.addMeta("ID of colored dimension", new Integer(DataTools.bytesToInt(temp, pt += 4, 4, this.core.littleEndian[0])));
                pt += 4;
                if (nChannels > 4) {
                    nChannels = 3;
                }
                this.core.sizeC[i] = nChannels;
                this.channelIndices = new int[nChannels];
                int j4 = 0;
                while (j4 < nChannels) {
                    v2 = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("LUT Channel " + j4 + " version", new Integer(v2));
                    int invert = DataTools.bytesToInt(temp, pt += 4, 1, this.core.littleEndian[0]);
                    boolean inverted = invert == 1;
                    this.addMeta("LUT Channel " + j4 + " inverted?", new Boolean(inverted).toString());
                    int length = DataTools.bytesToInt(temp, ++pt, 4, this.core.littleEndian[0]);
                    this.addMeta("LUT Channel " + j4 + " description", DataTools.stripString(new String(temp, pt += 4, length)));
                    pt += length;
                    length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    this.addMeta("LUT Channel " + j4 + " filename", DataTools.stripString(new String(temp, pt += 4, length)));
                    pt += length;
                    length = DataTools.bytesToInt(temp, pt, 4, this.core.littleEndian[0]);
                    String name = DataTools.stripString(new String(temp, pt += 4, length));
                    if (name.equals("Red")) {
                        this.channelIndices[j4] = 0;
                    } else if (name.equals("Green")) {
                        this.channelIndices[j4] = 1;
                    } else if (name.equals("Blue")) {
                        this.channelIndices[j4] = 2;
                    } else if (name.equals("Gray")) {
                        this.channelIndices[j4] = 0;
                    } else if (name.equals("Yellow")) {
                        this.channelIndices[j4] = 0;
                    } else if (name.equals("Geo (L&S)")) {
                        this.channelIndices[j4] = 0;
                    }
                    this.addMeta("LUT Channel " + j4 + " name", name);
                    pt += length;
                    pt += 8;
                    ++j4;
                }
            }
            ++i;
        }
        Arrays.fill(this.core.orderCertain, true);
        if (this.core.sizeC != null) {
            int oldSeries = this.getSeries();
            int i2 = 0;
            while (i2 < this.core.sizeC.length) {
                this.setSeries(i2);
                int n = i2;
                this.core.sizeZ[n] = this.core.sizeZ[n] / this.core.sizeC[i2];
                ++i2;
            }
            this.setSeries(oldSeries);
        }
        if ((v = (Integer)this.getMeta("Real world resolution")) != null) {
            this.validBits = new int[this.core.sizeC.length][];
            int i3 = 0;
            while (i3 < this.validBits.length) {
                this.validBits[i3] = new int[this.core.sizeC[i3] == 2 ? 3 : this.core.sizeC[i3]];
                int j = 0;
                while (j < this.validBits[i3].length) {
                    this.validBits[i3][j] = v;
                    ++j;
                }
                ++i3;
            }
        } else {
            this.validBits = null;
        }
        MetadataStore store = this.getMetadataStore();
        byte[] f = new byte[4];
        int i4 = 0;
        while (i4 < this.numSeries) {
            this.core.orderCertain[i4] = true;
            this.core.interleaved[i4] = true;
            this.in.seek(0L);
            this.in.read(f);
            boolean bl = this.core.littleEndian[i4] = f[0] == 73 && f[1] == 73 && f[2] == 73 && f[3] == 73;
            if (this.core.sizeC[i4] == 0) {
                this.core.sizeC[i4] = 1;
            }
            int n = i4;
            this.core.sizeT[n] = this.core.sizeT[n] + 1;
            String string = this.core.currentOrder[i4] = this.core.sizeC[i4] == 1 ? "XYZTC" : "XYCZT";
            if (this.core.sizeZ[i4] == 0) {
                this.core.sizeZ[i4] = 1;
            }
            switch (this.bpp) {
                case 1: {
                    this.core.pixelType[i4] = 1;
                    break;
                }
                case 2: {
                    this.core.pixelType[i4] = 3;
                    break;
                }
                case 3: {
                    this.core.pixelType[i4] = 1;
                    break;
                }
                case 4: {
                    this.core.pixelType[i4] = 4;
                    break;
                }
                case 6: {
                    this.core.pixelType[i4] = 2;
                    break;
                }
                case 8: {
                    this.core.pixelType[i4] = 7;
                }
            }
            this.core.rgb[i4] = this.core.imageCount[i4] != this.core.sizeC[i4] * this.core.sizeZ[i4] * this.core.sizeT[i4];
            Integer ii = new Integer(i4);
            store.setPixels(new Integer(this.core.sizeX[i4]), new Integer(this.core.sizeY[i4]), new Integer(this.core.sizeZ[i4]), new Integer(this.core.sizeC[i4] == 0 ? 1 : this.core.sizeC[i4]), new Integer(this.core.sizeT[i4]), new Integer(this.core.pixelType[i4]), new Boolean(!this.core.littleEndian[i4]), this.core.currentOrder[i4], ii, null);
            String timestamp = (String)this.getMeta("Timestamp " + (i4 + 1));
            String description = (String)this.getMeta("Image Description");
            if (timestamp != null) {
                SimpleDateFormat parse = new SimpleDateFormat("yyyy:MM:dd,HH:mm:ss:SSS");
                Date date = parse.parse(timestamp, new ParsePosition(0));
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                timestamp = fmt.format(date);
            }
            store.setImage((String)this.seriesNames.get(i4), timestamp, description, ii);
            int j = 0;
            while (j < this.core.sizeC[i4]) {
                store.setLogicalChannel(j, null, null, null, null, null, null, ii);
                ++j;
            }
            ++i4;
        }
    }

    private boolean usedFile(String s) {
        if (this.files == null) {
            return false;
        }
        int i = 0;
        while (i < this.files.length) {
            if (this.files[i] != null) {
                int j = 0;
                while (j < this.files[i].size()) {
                    if (((String)this.files[i].get(j)).endsWith(s)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }
}

